/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public class ChunkGeneratorStructureState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomState randomState;
    private final WorldChunkManager biomeSource;
    private final long levelSeed;
    private final long concentricRingsSeed;
    private final Map<Structure, List<StructurePlacement>> placementsForStructure = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> ringPositions = new Object2ObjectArrayMap();
    private boolean hasGeneratedPositions;
    private final List<Holder<StructureSet>> possibleStructureSets;

    public static ChunkGeneratorStructureState createForFlat(RandomState randomstate, long i2, WorldChunkManager worldchunkmanager, Stream<Holder<StructureSet>> stream, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = stream.filter(holder -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)holder.value(), worldchunkmanager)).toList();
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i2, 0L, ChunkGeneratorStructureState.injectSpigot(list, conf));
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState randomstate, long i2, WorldChunkManager worldchunkmanager, HolderLookup<StructureSet> holderlookup, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = holderlookup.listElements().filter(holder_c -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)holder_c.value(), worldchunkmanager)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i2, i2, ChunkGeneratorStructureState.injectSpigot(list, conf));
    }

    private static List<Holder<StructureSet>> injectSpigot(List<Holder<StructureSet>> list, SpigotWorldConfig conf) {
        return list.stream().map(holder -> {
            StructureSet structureset = (StructureSet)holder.value();
            StructurePlacement patt0$temp = structureset.placement();
            if (patt0$temp instanceof RandomSpreadStructurePlacement) {
                RandomSpreadStructurePlacement randomConfig = (RandomSpreadStructurePlacement)patt0$temp;
                String name = holder.unwrapKey().orElseThrow().location().getPath();
                int seed = randomConfig.salt;
                switch (name) {
                    case "desert_pyramids": {
                        seed = conf.desertSeed;
                        break;
                    }
                    case "end_cities": {
                        seed = conf.endCitySeed;
                        break;
                    }
                    case "nether_complexes": {
                        seed = conf.netherSeed;
                        break;
                    }
                    case "igloos": {
                        seed = conf.iglooSeed;
                        break;
                    }
                    case "jungle_temples": {
                        seed = conf.jungleSeed;
                        break;
                    }
                    case "woodland_mansions": {
                        seed = conf.mansionSeed;
                        break;
                    }
                    case "ocean_monuments": {
                        seed = conf.monumentSeed;
                        break;
                    }
                    case "nether_fossils": {
                        seed = conf.fossilSeed;
                        break;
                    }
                    case "ocean_ruins": {
                        seed = conf.oceanSeed;
                        break;
                    }
                    case "pillager_outposts": {
                        seed = conf.outpostSeed;
                        break;
                    }
                    case "ruined_portals": {
                        seed = conf.portalSeed;
                        break;
                    }
                    case "shipwrecks": {
                        seed = conf.shipwreckSeed;
                        break;
                    }
                    case "swamp_huts": {
                        seed = conf.swampSeed;
                        break;
                    }
                    case "villages": {
                        seed = conf.villageSeed;
                    }
                }
                structureset = new StructureSet(structureset.structures(), (StructurePlacement)new RandomSpreadStructurePlacement(randomConfig.locateOffset, randomConfig.frequencyReductionMethod, randomConfig.frequency, seed, randomConfig.exclusionZone, randomConfig.spacing(), randomConfig.separation(), randomConfig.spreadType()));
            }
            return Holder.direct(structureset);
        }).collect(Collectors.toUnmodifiableList());
    }

    private static boolean hasBiomesForStructureSet(StructureSet structureset, WorldChunkManager worldchunkmanager) {
        Stream stream = structureset.structures().stream().flatMap(structureset_a -> {
            Structure structure = structureset_a.structure().value();
            return structure.biomes().stream();
        });
        Set<Holder<BiomeBase>> set = worldchunkmanager.possibleBiomes();
        Objects.requireNonNull(set);
        return stream.anyMatch(set::contains);
    }

    private ChunkGeneratorStructureState(RandomState randomstate, WorldChunkManager worldchunkmanager, long i2, long j2, List<Holder<StructureSet>> list) {
        this.randomState = randomstate;
        this.levelSeed = i2;
        this.biomeSource = worldchunkmanager;
        this.concentricRingsSeed = j2;
        this.possibleStructureSets = list;
    }

    public List<Holder<StructureSet>> possibleStructureSets() {
        return this.possibleStructureSets;
    }

    private void generatePositions() {
        Set<Holder<BiomeBase>> set = this.biomeSource.possibleBiomes();
        this.possibleStructureSets().forEach(holder -> {
            StructurePlacement structureplacement;
            StructureSet structureset = (StructureSet)holder.value();
            boolean flag = false;
            for (StructureSet.a structureset_a : structureset.structures()) {
                Structure structure = structureset_a.structure().value();
                Stream<Holder<BiomeBase>> stream = structure.biomes().stream();
                Objects.requireNonNull(set);
                if (!stream.anyMatch(set::contains)) continue;
                this.placementsForStructure.computeIfAbsent(structure, structure1 -> new ArrayList()).add(structureset.placement());
                flag = true;
            }
            if (flag && (structureplacement = structureset.placement()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                this.ringPositions.put(concentricringsstructureplacement, this.generateRingPositions((Holder<StructureSet>)holder, concentricringsstructureplacement));
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> generateRingPositions(Holder<StructureSet> holder, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        if (concentricringsstructureplacement.count() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.TICKER);
        int i2 = concentricringsstructureplacement.distance();
        int j2 = concentricringsstructureplacement.count();
        ArrayList<CompletableFuture<ChunkCoordIntPair>> list = new ArrayList<CompletableFuture<ChunkCoordIntPair>>(j2);
        int k2 = concentricringsstructureplacement.spread();
        HolderSet<BiomeBase> holderset = concentricringsstructureplacement.preferredBiomes();
        RandomSource randomsource = RandomSource.create();
        randomsource.setSeed(this.concentricRingsSeed);
        double d0 = randomsource.nextDouble() * Math.PI * 2.0;
        int l2 = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < j2; ++j1) {
            double d1 = (double)(4 * i2 + i2 * i1 * 6) + (randomsource.nextDouble() - 0.5) * (double)i2 * 2.5;
            int k1 = (int)Math.round(Math.cos(d0) * d1);
            int l1 = (int)Math.round(Math.sin(d0) * d1);
            RandomSource randomsource1 = randomsource.fork();
            list.add(CompletableFuture.supplyAsync(() -> {
                WorldChunkManager worldchunkmanager = this.biomeSource;
                int i2 = SectionPosition.sectionToBlockCoord(k1, 8);
                int j2 = SectionPosition.sectionToBlockCoord(l1, 8);
                Objects.requireNonNull(holderset);
                Pair<BlockPosition, Holder<BiomeBase>> pair = worldchunkmanager.findBiomeHorizontal(i2, 0, j2, 112, holderset::contains, randomsource1, this.randomState.sampler());
                if (pair != null) {
                    BlockPosition blockposition = (BlockPosition)pair.getFirst();
                    return new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(blockposition.getX()), SectionPosition.blockToSectionCoord(blockposition.getZ()));
                }
                return new ChunkCoordIntPair(k1, l1);
            }, SystemUtils.backgroundExecutor()));
            d0 += Math.PI * 2 / (double)k2;
            if (++l2 != k2) continue;
            l2 = 0;
            k2 += 2 * k2 / (++i1 + 1);
            k2 = Math.min(k2, j2 - j1);
            d0 += randomsource.nextDouble() * Math.PI * 2.0;
        }
        return SystemUtils.sequence(list).thenApply(list1 -> {
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            LOGGER.debug("Calculation for {} took {}s", (Object)holder, (Object)d2);
            return list1;
        });
    }

    public void ensureStructuresGenerated() {
        if (!this.hasGeneratedPositions) {
            this.generatePositions();
            this.hasGeneratedPositions = true;
        }
    }

    @Nullable
    public List<ChunkCoordIntPair> getRingPositionsFor(ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        this.ensureStructuresGenerated();
        CompletableFuture<List<ChunkCoordIntPair>> completablefuture = this.ringPositions.get(concentricringsstructureplacement);
        return completablefuture != null ? completablefuture.join() : null;
    }

    public List<StructurePlacement> getPlacementsForStructure(Holder<Structure> holder) {
        this.ensureStructuresGenerated();
        return this.placementsForStructure.getOrDefault(holder.value(), List.of());
    }

    public RandomState randomState() {
        return this.randomState;
    }

    public boolean hasStructureChunkInRange(Holder<StructureSet> holder, int i2, int j2, int k2) {
        StructurePlacement structureplacement = holder.value().placement();
        for (int l2 = i2 - k2; l2 <= i2 + k2; ++l2) {
            for (int i1 = j2 - k2; i1 <= j2 + k2; ++i1) {
                if (!structureplacement.isStructureChunk(this, l2, i1)) continue;
                return true;
            }
        }
        return false;
    }

    public long getLevelSeed() {
        return this.levelSeed;
    }
}

