/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.material.Fluid;

public class ChunkSection {
    public static final int SECTION_WIDTH = 16;
    public static final int SECTION_HEIGHT = 16;
    public static final int SECTION_SIZE = 4096;
    public static final int BIOME_CONTAINER_BITS = 2;
    private short nonEmptyBlockCount;
    private short tickingBlockCount;
    private short tickingFluidCount;
    private final DataPaletteBlock<IBlockData> states;
    private DataPaletteBlock<Holder<BiomeBase>> biomes;

    public ChunkSection(DataPaletteBlock<IBlockData> datapaletteblock, DataPaletteBlock<Holder<BiomeBase>> palettedcontainerro) {
        this.states = datapaletteblock;
        this.biomes = palettedcontainerro;
        this.recalcBlockCounts();
    }

    public ChunkSection(IRegistry<BiomeBase> iregistry) {
        this.states = new DataPaletteBlock<IBlockData>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), DataPaletteBlock.d.SECTION_STATES);
        this.biomes = new DataPaletteBlock<Holder.c<BiomeBase>>(iregistry.asHolderIdMap(), iregistry.getHolderOrThrow(Biomes.PLAINS), DataPaletteBlock.d.SECTION_BIOMES);
    }

    public IBlockData getBlockState(int i2, int j2, int k2) {
        return this.states.get(i2, j2, k2);
    }

    public Fluid getFluidState(int i2, int j2, int k2) {
        return this.states.get(i2, j2, k2).getFluidState();
    }

    public void acquire() {
        this.states.acquire();
    }

    public void release() {
        this.states.release();
    }

    public IBlockData setBlockState(int i2, int j2, int k2, IBlockData iblockdata) {
        return this.setBlockState(i2, j2, k2, iblockdata, true);
    }

    public IBlockData setBlockState(int i2, int j2, int k2, IBlockData iblockdata, boolean flag) {
        IBlockData iblockdata1 = flag ? this.states.getAndSet(i2, j2, k2, iblockdata) : this.states.getAndSetUnchecked(i2, j2, k2, iblockdata);
        Fluid fluid = iblockdata1.getFluidState();
        Fluid fluid1 = iblockdata.getFluidState();
        if (!iblockdata1.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount - 1);
            if (iblockdata1.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount - 1);
            }
        }
        if (!fluid.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount - 1);
        }
        if (!iblockdata.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + 1);
            if (iblockdata.isRandomlyTicking()) {
                this.tickingBlockCount = (short)(this.tickingBlockCount + 1);
            }
        }
        if (!fluid1.isEmpty()) {
            this.tickingFluidCount = (short)(this.tickingFluidCount + 1);
        }
        return iblockdata1;
    }

    public boolean hasOnlyAir() {
        return this.nonEmptyBlockCount == 0;
    }

    public boolean isRandomlyTicking() {
        return this.isRandomlyTickingBlocks() || this.isRandomlyTickingFluids();
    }

    public boolean isRandomlyTickingBlocks() {
        return this.tickingBlockCount > 0;
    }

    public boolean isRandomlyTickingFluids() {
        return this.tickingFluidCount > 0;
    }

    public void recalcBlockCounts() {
        class A
        implements DataPaletteBlock.b<IBlockData> {
            public int nonEmptyBlockCount;
            public int tickingBlockCount;
            public int tickingFluidCount;

            A(ChunkSection this$0, ChunkSection chunksection) {
            }

            @Override
            public void accept(IBlockData iblockdata, int i2) {
                Fluid fluid = iblockdata.getFluidState();
                if (!iblockdata.isAir()) {
                    this.nonEmptyBlockCount += i2;
                    if (iblockdata.isRandomlyTicking()) {
                        this.tickingBlockCount += i2;
                    }
                }
                if (!fluid.isEmpty()) {
                    this.nonEmptyBlockCount += i2;
                    if (fluid.isRandomlyTicking()) {
                        this.tickingFluidCount += i2;
                    }
                }
            }
        }
        A a0 = new A(this, this);
        this.states.count(a0);
        this.nonEmptyBlockCount = (short)a0.nonEmptyBlockCount;
        this.tickingBlockCount = (short)a0.tickingBlockCount;
        this.tickingFluidCount = (short)a0.tickingFluidCount;
    }

    public DataPaletteBlock<IBlockData> getStates() {
        return this.states;
    }

    public PalettedContainerRO<Holder<BiomeBase>> getBiomes() {
        return this.biomes;
    }

    public void read(PacketDataSerializer packetdataserializer) {
        this.nonEmptyBlockCount = packetdataserializer.readShort();
        this.states.read(packetdataserializer);
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.recreate();
        datapaletteblock.read(packetdataserializer);
        this.biomes = datapaletteblock;
    }

    public void readBiomes(PacketDataSerializer packetdataserializer) {
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.recreate();
        datapaletteblock.read(packetdataserializer);
        this.biomes = datapaletteblock;
    }

    public void write(PacketDataSerializer packetdataserializer) {
        packetdataserializer.writeShort(this.nonEmptyBlockCount);
        this.states.write(packetdataserializer);
        this.biomes.write(packetdataserializer);
    }

    public int getSerializedSize() {
        return 2 + this.states.getSerializedSize() + this.biomes.getSerializedSize();
    }

    public boolean maybeHas(Predicate<IBlockData> predicate) {
        return this.states.maybeHas(predicate);
    }

    public Holder<BiomeBase> getNoiseBiome(int i2, int j2, int k2) {
        return this.biomes.get(i2, j2, k2);
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        this.biomes.set(i2, j2, k2, biome);
    }

    public void fillBiomesFromNoise(BiomeResolver biomeresolver, Climate.Sampler climate_sampler, int i2, int j2, int k2) {
        DataPaletteBlock<Holder<BiomeBase>> datapaletteblock = this.biomes.recreate();
        boolean flag = true;
        for (int l2 = 0; l2 < 4; ++l2) {
            for (int i1 = 0; i1 < 4; ++i1) {
                for (int j1 = 0; j1 < 4; ++j1) {
                    datapaletteblock.getAndSetUnchecked(l2, i1, j1, biomeresolver.getNoiseBiome(i2 + l2, j2 + i1, k2 + j1, climate_sampler));
                }
            }
        }
        this.biomes = datapaletteblock;
    }
}

