/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R1.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements IBlockAccess,
BiomeManager.Provider,
LightChunk,
StructureAccess {
    public static final int NO_FILLED_SECTION = -1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LongSet EMPTY_REFERENCE_SET = new LongOpenHashSet();
    protected final ShortList[] postProcessing;
    protected volatile boolean unsaved;
    private volatile boolean isLightCorrect;
    protected final ChunkCoordIntPair chunkPos;
    private long inhabitedTime;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration carverBiomeSettings;
    @Nullable
    protected NoiseChunk noiseChunk;
    protected final ChunkConverter upgradeData;
    @Nullable
    protected BlendingData blendingData;
    public final Map<HeightMap.Type, HeightMap> heightmaps = Maps.newEnumMap(HeightMap.Type.class);
    protected ChunkSkyLightSources skyLightSources;
    private final Map<Structure, StructureStart> structureStarts = Maps.newHashMap();
    private final Map<Structure, LongSet> structuresRefences = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> pendingBlockEntities = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> blockEntities = new Object2ObjectOpenHashMap();
    protected final LevelHeightAccessor levelHeightAccessor;
    protected final ChunkSection[] sections;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public final IRegistry<BiomeBase> biomeRegistry;

    public IChunkAccess(ChunkCoordIntPair chunkcoordintpair, ChunkConverter chunkconverter, LevelHeightAccessor levelheightaccessor, IRegistry<BiomeBase> iregistry, long i2, @Nullable ChunkSection[] achunksection, @Nullable BlendingData blendingdata) {
        this.chunkPos = chunkcoordintpair;
        this.upgradeData = chunkconverter;
        this.levelHeightAccessor = levelheightaccessor;
        this.sections = new ChunkSection[levelheightaccessor.getSectionsCount()];
        this.inhabitedTime = i2;
        this.postProcessing = new ShortList[levelheightaccessor.getSectionsCount()];
        this.blendingData = blendingdata;
        this.skyLightSources = new ChunkSkyLightSources(levelheightaccessor);
        if (achunksection != null) {
            if (this.sections.length == achunksection.length) {
                System.arraycopy(achunksection, 0, this.sections, 0, this.sections.length);
            } else {
                LOGGER.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)achunksection.length, (Object)this.sections.length);
            }
        }
        IChunkAccess.replaceMissingSections(iregistry, this.sections);
        this.biomeRegistry = iregistry;
    }

    private static void replaceMissingSections(IRegistry<BiomeBase> iregistry, ChunkSection[] achunksection) {
        for (int i2 = 0; i2 < achunksection.length; ++i2) {
            if (achunksection[i2] != null) continue;
            achunksection[i2] = new ChunkSection(iregistry);
        }
    }

    public GameEventListenerRegistry getListenerRegistry(int i2) {
        return GameEventListenerRegistry.NOOP;
    }

    @Nullable
    public abstract IBlockData setBlockState(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void setBlockEntity(TileEntity var1);

    public abstract void addEntity(Entity var1);

    public int getHighestFilledSectionIndex() {
        ChunkSection[] achunksection = this.getSections();
        for (int i2 = achunksection.length - 1; i2 >= 0; --i2) {
            ChunkSection chunksection = achunksection[i2];
            if (chunksection.hasOnlyAir()) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int getHighestSectionPosition() {
        int i2 = this.getHighestFilledSectionIndex();
        return i2 == -1 ? this.getMinBuildHeight() : SectionPosition.sectionToBlockCoord(this.getSectionYFromSectionIndex(i2));
    }

    public Set<BlockPosition> getBlockEntitiesPos() {
        HashSet set = Sets.newHashSet(this.pendingBlockEntities.keySet());
        set.addAll(this.blockEntities.keySet());
        return set;
    }

    public ChunkSection[] getSections() {
        return this.sections;
    }

    public ChunkSection getSection(int i2) {
        return this.getSections()[i2];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> getHeightmaps() {
        return Collections.unmodifiableSet(this.heightmaps.entrySet());
    }

    public void setHeightmap(HeightMap.Type heightmap_type, long[] along) {
        this.getOrCreateHeightmapUnprimed(heightmap_type).setRawData(this, heightmap_type, along);
    }

    public HeightMap getOrCreateHeightmapUnprimed(HeightMap.Type heightmap_type) {
        return this.heightmaps.computeIfAbsent(heightmap_type, heightmap_type1 -> new HeightMap(this, (HeightMap.Type)heightmap_type1));
    }

    public boolean hasPrimedHeightmap(HeightMap.Type heightmap_type) {
        return this.heightmaps.get(heightmap_type) != null;
    }

    public int getHeight(HeightMap.Type heightmap_type, int i2, int j2) {
        HeightMap heightmap = this.heightmaps.get(heightmap_type);
        if (heightmap == null) {
            if (SharedConstants.IS_RUNNING_IN_IDE && this instanceof Chunk) {
                LOGGER.error("Unprimed heightmap: " + String.valueOf(heightmap_type) + " " + i2 + " " + j2);
            }
            HeightMap.primeHeightmaps(this, EnumSet.of(heightmap_type));
            heightmap = this.heightmaps.get(heightmap_type);
        }
        return heightmap.getFirstAvailable(i2 & 0xF, j2 & 0xF) - 1;
    }

    public ChunkCoordIntPair getPos() {
        return this.chunkPos;
    }

    @Override
    @Nullable
    public StructureStart getStartForStructure(Structure structure) {
        return this.structureStarts.get(structure);
    }

    @Override
    public void setStartForStructure(Structure structure, StructureStart structurestart) {
        this.structureStarts.put(structure, structurestart);
        this.unsaved = true;
    }

    public Map<Structure, StructureStart> getAllStarts() {
        return Collections.unmodifiableMap(this.structureStarts);
    }

    public void setAllStarts(Map<Structure, StructureStart> map) {
        this.structureStarts.clear();
        this.structureStarts.putAll(map);
        this.unsaved = true;
    }

    @Override
    public LongSet getReferencesForStructure(Structure structure) {
        return this.structuresRefences.getOrDefault(structure, EMPTY_REFERENCE_SET);
    }

    @Override
    public void addReferenceForStructure(Structure structure, long i2) {
        this.structuresRefences.computeIfAbsent(structure, structure1 -> new LongOpenHashSet()).add(i2);
        this.unsaved = true;
    }

    @Override
    public Map<Structure, LongSet> getAllReferences() {
        return Collections.unmodifiableMap(this.structuresRefences);
    }

    @Override
    public void setAllReferences(Map<Structure, LongSet> map) {
        this.structuresRefences.clear();
        this.structuresRefences.putAll(map);
        this.unsaved = true;
    }

    public boolean isYSpaceEmpty(int i2, int j2) {
        if (i2 < this.getMinBuildHeight()) {
            i2 = this.getMinBuildHeight();
        }
        if (j2 >= this.getMaxBuildHeight()) {
            j2 = this.getMaxBuildHeight() - 1;
        }
        for (int k2 = i2; k2 <= j2; k2 += 16) {
            if (this.getSection(this.getSectionIndex(k2)).hasOnlyAir()) continue;
            return false;
        }
        return true;
    }

    public boolean isSectionEmpty(int i2) {
        return this.getSection(this.getSectionIndexFromSectionY(i2)).hasOnlyAir();
    }

    public void setUnsaved(boolean flag) {
        this.unsaved = flag;
        if (!flag) {
            this.persistentDataContainer.dirty(false);
        }
    }

    public boolean isUnsaved() {
        return this.unsaved || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus getPersistedStatus();

    public ChunkStatus getHighestGeneratedStatus() {
        ChunkStatus chunkstatus = this.getPersistedStatus();
        BelowZeroRetrogen belowzeroretrogen = this.getBelowZeroRetrogen();
        if (belowzeroretrogen != null) {
            ChunkStatus chunkstatus1 = belowzeroretrogen.targetStatus();
            return ChunkStatus.max(chunkstatus1, chunkstatus);
        }
        return chunkstatus;
    }

    public abstract void removeBlockEntity(BlockPosition var1);

    public void markPosForPostprocessing(BlockPosition blockposition) {
        LOGGER.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)blockposition);
    }

    public ShortList[] getPostProcessing() {
        return this.postProcessing;
    }

    public void addPackedPostProcess(short short0, int i2) {
        IChunkAccess.getOrCreateOffsetList(this.getPostProcessing(), i2).add(short0);
    }

    public void setBlockEntityNbt(NBTTagCompound nbttagcompound) {
        this.pendingBlockEntities.put(TileEntity.getPosFromTag(nbttagcompound), nbttagcompound);
    }

    @Nullable
    public NBTTagCompound getBlockEntityNbt(BlockPosition blockposition) {
        return this.pendingBlockEntities.get(blockposition);
    }

    @Nullable
    public abstract NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var1, HolderLookup.a var2);

    @Override
    public final void findBlockLightSources(BiConsumer<BlockPosition, IBlockData> biconsumer) {
        this.findBlocks(iblockdata -> iblockdata.getLightEmission() != 0, biconsumer);
    }

    public void findBlocks(Predicate<IBlockData> predicate, BiConsumer<BlockPosition, IBlockData> biconsumer) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = this.getMinSection(); i2 < this.getMaxSection(); ++i2) {
            ChunkSection chunksection = this.getSection(this.getSectionIndexFromSectionY(i2));
            if (!chunksection.maybeHas(predicate)) continue;
            BlockPosition blockposition = SectionPosition.of(this.chunkPos, i2).origin();
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int l2 = 0; l2 < 16; ++l2) {
                        IBlockData iblockdata = chunksection.getBlockState(l2, j2, k2);
                        if (!predicate.test(iblockdata)) continue;
                        biconsumer.accept(blockposition_mutableblockposition.setWithOffset(blockposition, l2, j2, k2), iblockdata);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> getBlockTicks();

    public abstract TickContainerAccess<FluidType> getFluidTicks();

    public abstract a getTicksForSerialization();

    public ChunkConverter getUpgradeData() {
        return this.upgradeData;
    }

    public boolean isOldNoiseGeneration() {
        return this.blendingData != null;
    }

    @Nullable
    public BlendingData getBlendingData() {
        return this.blendingData;
    }

    public void setBlendingData(BlendingData blendingdata) {
        this.blendingData = blendingdata;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public void incrementInhabitedTime(long i2) {
        this.inhabitedTime += i2;
    }

    public void setInhabitedTime(long i2) {
        this.inhabitedTime = i2;
    }

    public static ShortList getOrCreateOffsetList(ShortList[] ashortlist, int i2) {
        if (ashortlist[i2] == null) {
            ashortlist[i2] = new ShortArrayList();
        }
        return ashortlist[i2];
    }

    public boolean isLightCorrect() {
        return this.isLightCorrect;
    }

    public void setLightCorrect(boolean flag) {
        this.isLightCorrect = flag;
        this.setUnsaved(true);
    }

    @Override
    public int getMinBuildHeight() {
        return this.levelHeightAccessor.getMinBuildHeight();
    }

    @Override
    public int getHeight() {
        return this.levelHeightAccessor.getHeight();
    }

    public NoiseChunk getOrCreateNoiseChunk(Function<IChunkAccess, NoiseChunk> function) {
        if (this.noiseChunk == null) {
            this.noiseChunk = function.apply(this);
        }
        return this.noiseChunk;
    }

    @Deprecated
    public BiomeSettingsGeneration carverBiome(Supplier<BiomeSettingsGeneration> supplier) {
        if (this.carverBiomeSettings == null) {
            this.carverBiomeSettings = supplier.get();
        }
        return this.carverBiomeSettings;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int i2, int j2, int k2) {
        try {
            int l2 = QuartPos.fromBlock(this.getMinBuildHeight());
            int i1 = l2 + QuartPos.fromBlock(this.getHeight()) - 1;
            int j1 = MathHelper.clamp(j2, l2, i1);
            int k1 = this.getSectionIndex(QuartPos.toBlock(j1));
            return this.sections[k1].getNoiseBiome(i2 & 3, j1 & 3, k2 & 3);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Getting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Biome being got");
            crashreportsystemdetails.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void setBiome(int i2, int j2, int k2, Holder<BiomeBase> biome) {
        try {
            int l2 = QuartPos.fromBlock(this.getMinBuildHeight());
            int i1 = l2 + QuartPos.fromBlock(this.getHeight()) - 1;
            int j1 = MathHelper.clamp(j2, l2, i1);
            int k1 = this.getSectionIndex(QuartPos.toBlock(j1));
            this.sections[k1].setBiome(i2 & 3, j1 & 3, k2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Setting biome");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Biome being set");
            crashreportsystemdetails.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, i2, j2, k2));
            throw new ReportedException(crashreport);
        }
    }

    public void fillBiomesFromNoise(BiomeResolver biomeresolver, Climate.Sampler climate_sampler) {
        ChunkCoordIntPair chunkcoordintpair = this.getPos();
        int i2 = QuartPos.fromBlock(chunkcoordintpair.getMinBlockX());
        int j2 = QuartPos.fromBlock(chunkcoordintpair.getMinBlockZ());
        LevelHeightAccessor levelheightaccessor = this.getHeightAccessorForGeneration();
        for (int k2 = levelheightaccessor.getMinSection(); k2 < levelheightaccessor.getMaxSection(); ++k2) {
            ChunkSection chunksection = this.getSection(this.getSectionIndexFromSectionY(k2));
            int l2 = QuartPos.fromSection(k2);
            chunksection.fillBiomesFromNoise(biomeresolver, climate_sampler, i2, l2, j2);
        }
    }

    public boolean hasAnyStructureReferences() {
        return !this.getAllReferences().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen getBelowZeroRetrogen() {
        return null;
    }

    public boolean isUpgrading() {
        return this.getBelowZeroRetrogen() != null;
    }

    public LevelHeightAccessor getHeightAccessorForGeneration() {
        return this;
    }

    public void initializeLightSources() {
        this.skyLightSources.fillFrom(this);
    }

    @Override
    public ChunkSkyLightSources getSkyLightSources() {
        return this.skyLightSources;
    }

    public record a(SerializableTickContainer<Block> blocks, SerializableTickContainer<FluidType> fluids) {
    }
}

