/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.VisibleForDebug;

public class NibbleArray {
    public static final int LAYER_COUNT = 16;
    public static final int LAYER_SIZE = 128;
    public static final int SIZE = 2048;
    private static final int NIBBLE_SIZE = 4;
    @Nullable
    protected byte[] data;
    private int defaultValue;

    public NibbleArray() {
        this(0);
    }

    public NibbleArray(int i2) {
        this.defaultValue = i2;
    }

    public NibbleArray(byte[] abyte) {
        this.data = abyte;
        this.defaultValue = 0;
        if (abyte.length != 2048) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("DataLayer should be 2048 bytes not: " + abyte.length));
        }
    }

    public int get(int i2, int j2, int k2) {
        return this.get(NibbleArray.getIndex(i2, j2, k2));
    }

    public void set(int i2, int j2, int k2, int l2) {
        this.set(NibbleArray.getIndex(i2, j2, k2), l2);
    }

    private static int getIndex(int i2, int j2, int k2) {
        return j2 << 8 | k2 << 4 | i2;
    }

    private int get(int i2) {
        if (this.data == null) {
            return this.defaultValue;
        }
        int j2 = NibbleArray.getByteIndex(i2);
        int k2 = NibbleArray.getNibbleIndex(i2);
        return this.data[j2] >> 4 * k2 & 0xF;
    }

    private void set(int i2, int j2) {
        byte[] abyte = this.getData();
        int k2 = NibbleArray.getByteIndex(i2);
        int l2 = NibbleArray.getNibbleIndex(i2);
        int i1 = ~(15 << 4 * l2);
        int j1 = (j2 & 0xF) << 4 * l2;
        abyte[k2] = (byte)(abyte[k2] & i1 | j1);
    }

    private static int getNibbleIndex(int i2) {
        return i2 & 1;
    }

    private static int getByteIndex(int i2) {
        return i2 >> 1;
    }

    public void fill(int i2) {
        this.defaultValue = i2;
        this.data = null;
    }

    private static byte packFilled(int i2) {
        byte b0 = (byte)i2;
        for (int j2 = 4; j2 < 8; j2 += 4) {
            b0 = (byte)(b0 | i2 << j2);
        }
        return b0;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = new byte[2048];
            if (this.defaultValue != 0) {
                Arrays.fill(this.data, NibbleArray.packFilled(this.defaultValue));
            }
        }
        return this.data;
    }

    public NibbleArray copy() {
        return this.data == null ? new NibbleArray(this.defaultValue) : new NibbleArray((byte[])this.data.clone());
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        for (int i2 = 0; i2 < 4096; ++i2) {
            stringbuilder.append(Integer.toHexString(this.get(i2)));
            if ((i2 & 0xF) == 15) {
                stringbuilder.append("\n");
            }
            if ((i2 & 0xFF) != 255) continue;
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    @VisibleForDebug
    public String layerToString(int i2) {
        StringBuilder stringbuilder = new StringBuilder();
        for (int j2 = 0; j2 < 256; ++j2) {
            stringbuilder.append(Integer.toHexString(this.get(j2)));
            if ((j2 & 0xF) != 15) continue;
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    public boolean isDefinitelyHomogenous() {
        return this.data == null;
    }

    public boolean isDefinitelyFilledWith(int i2) {
        return this.data == null && this.defaultValue == i2;
    }

    public boolean isEmpty() {
        return this.data == null && this.defaultValue == 0;
    }
}

