/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class ChunkDependencies {
    private final ImmutableList<ChunkStatus> dependencyByRadius;
    private final int[] radiusByDependency;

    public ChunkDependencies(ImmutableList<ChunkStatus> var0) {
        this.dependencyByRadius = var0;
        int var1 = var0.isEmpty() ? 0 : ((ChunkStatus)var0.getFirst()).getIndex() + 1;
        this.radiusByDependency = new int[var1];
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            ChunkStatus var3 = (ChunkStatus)var0.get(var2);
            int var4 = var3.getIndex();
            for (int var5 = 0; var5 <= var4; ++var5) {
                this.radiusByDependency[var5] = var2;
            }
        }
    }

    @VisibleForTesting
    public ImmutableList<ChunkStatus> asList() {
        return this.dependencyByRadius;
    }

    public int size() {
        return this.dependencyByRadius.size();
    }

    public int getRadiusOf(ChunkStatus var0) {
        int var1 = var0.getIndex();
        if (var1 >= this.radiusByDependency.length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Requesting a ChunkStatus(%s) outside of dependency range(%s)", var0, this.dependencyByRadius));
        }
        return this.radiusByDependency[var1];
    }

    public int getRadius() {
        return Math.max(0, this.dependencyByRadius.size() - 1);
    }

    public ChunkStatus get(int var0) {
        return (ChunkStatus)this.dependencyByRadius.get(var0);
    }

    public String toString() {
        return this.dependencyByRadius.toString();
    }
}

