/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import org.slf4j.Logger;

public class ChunkRegionLoader {
    public static final Codec<DataPaletteBlock<IBlockData>> BLOCK_STATE_CODEC = DataPaletteBlock.codecRW(Block.BLOCK_STATE_REGISTRY, IBlockData.CODEC, DataPaletteBlock.d.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static ProtoChunk read(WorldServer worldserver, VillagePlace villageplace, RegionStorageInfo regionstorageinfo, ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        int i1;
        NBTTagList nbttaglist2;
        IChunkAccess object1;
        BlendingData blendingdata;
        ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(nbttagcompound.getInt(X_POS_TAG), nbttagcompound.getInt(Z_POS_TAG));
        if (!Objects.equals(chunkcoordintpair, chunkcoordintpair1)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{chunkcoordintpair, chunkcoordintpair, chunkcoordintpair1});
            worldserver.getServer().reportMisplacedChunk(chunkcoordintpair1, chunkcoordintpair, regionstorageinfo);
        }
        ChunkConverter chunkconverter = nbttagcompound.contains(TAG_UPGRADE_DATA, 10) ? new ChunkConverter(nbttagcompound.getCompound(TAG_UPGRADE_DATA), worldserver) : ChunkConverter.EMPTY;
        boolean flag = nbttagcompound.getBoolean(IS_LIGHT_ON_TAG);
        NBTTagList nbttaglist = nbttagcompound.getList(SECTIONS_TAG, 10);
        int i2 = worldserver.getSectionsCount();
        ChunkSection[] achunksection = new ChunkSection[i2];
        boolean flag1 = worldserver.dimensionType().hasSkyLight();
        ChunkProviderServer chunkproviderserver = worldserver.getChunkSource();
        LightEngineThreaded levellightengine = chunkproviderserver.getLightEngine();
        IRegistry<BiomeBase> iregistry = worldserver.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> codec = ChunkRegionLoader.makeBiomeCodecRW(iregistry);
        boolean flag2 = false;
        for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
            boolean flag4;
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompound(j2);
            byte b0 = nbttagcompound1.getByte("Y");
            int k2 = worldserver.getSectionIndexFromSectionY(b0);
            if (k2 >= 0 && k2 < achunksection.length) {
                ChunkSection chunksection;
                DataPaletteBlock datapaletteblock = nbttagcompound1.contains("block_states", 10) ? (DataPaletteBlock)BLOCK_STATE_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound1.getCompound("block_states")).promotePartial(s2 -> ChunkRegionLoader.logErrors(chunkcoordintpair, b0, s2)).getOrThrow(a::new) : new DataPaletteBlock(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), DataPaletteBlock.d.SECTION_STATES);
                DataPaletteBlock object = nbttagcompound1.contains("biomes", 10) ? (DataPaletteBlock)codec.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound1.getCompound("biomes")).promotePartial(s2 -> ChunkRegionLoader.logErrors(chunkcoordintpair, b0, s2)).getOrThrow(a::new) : new DataPaletteBlock(iregistry.asHolderIdMap(), iregistry.getHolderOrThrow(Biomes.PLAINS), DataPaletteBlock.d.SECTION_BIOMES);
                achunksection[k2] = chunksection = new ChunkSection(datapaletteblock, object);
                SectionPosition sectionposition = SectionPosition.of(chunkcoordintpair, b0);
                villageplace.checkConsistencyWithBlocks(sectionposition, chunksection);
            }
            boolean flag3 = nbttagcompound1.contains(BLOCK_LIGHT_TAG, 7);
            boolean bl = flag4 = flag1 && nbttagcompound1.contains(SKY_LIGHT_TAG, 7);
            if (!flag3 && !flag4) continue;
            if (!flag2) {
                ((LevelLightEngine)levellightengine).retainData(chunkcoordintpair, true);
                flag2 = true;
            }
            if (flag3) {
                ((LevelLightEngine)levellightengine).queueSectionData(EnumSkyBlock.BLOCK, SectionPosition.of(chunkcoordintpair, b0), new NibbleArray(nbttagcompound1.getByteArray(BLOCK_LIGHT_TAG)));
            }
            if (!flag4) continue;
            ((LevelLightEngine)levellightengine).queueSectionData(EnumSkyBlock.SKY, SectionPosition.of(chunkcoordintpair, b0), new NibbleArray(nbttagcompound1.getByteArray(SKY_LIGHT_TAG)));
        }
        long l2 = nbttagcompound.getLong("InhabitedTime");
        ChunkType chunktype = ChunkRegionLoader.getChunkTypeFromTag(nbttagcompound);
        if (nbttagcompound.contains("blending_data", 10)) {
            DataResult dataresult = BlendingData.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.getCompound("blending_data")));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            blendingdata = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(null);
        } else {
            blendingdata = null;
        }
        if (chunktype == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> levelchunkticks = LevelChunkTicks.load(nbttagcompound.getList(BLOCK_TICKS_TAG, 10), s2 -> BuiltInRegistries.BLOCK.getOptional(MinecraftKey.tryParse(s2)), chunkcoordintpair);
            LevelChunkTicks<FluidType> levelchunkticks1 = LevelChunkTicks.load(nbttagcompound.getList(FLUID_TICKS_TAG, 10), s2 -> BuiltInRegistries.FLUID.getOptional(MinecraftKey.tryParse(s2)), chunkcoordintpair);
            object1 = new Chunk(worldserver.getLevel(), chunkcoordintpair, chunkconverter, levelchunkticks, levelchunkticks1, l2, achunksection, ChunkRegionLoader.postLoadChunk(worldserver, nbttagcompound), blendingdata);
        } else {
            ProtoChunkTickList<Block> protochunkticklist = ProtoChunkTickList.load(nbttagcompound.getList(BLOCK_TICKS_TAG, 10), s2 -> BuiltInRegistries.BLOCK.getOptional(MinecraftKey.tryParse(s2)), chunkcoordintpair);
            ProtoChunkTickList<FluidType> protochunkticklist1 = ProtoChunkTickList.load(nbttagcompound.getList(FLUID_TICKS_TAG, 10), s2 -> BuiltInRegistries.FLUID.getOptional(MinecraftKey.tryParse(s2)), chunkcoordintpair);
            ProtoChunk protochunk = new ProtoChunk(chunkcoordintpair, chunkconverter, achunksection, protochunkticklist, protochunkticklist1, worldserver, iregistry, blendingdata);
            object1 = protochunk;
            protochunk.setInhabitedTime(l2);
            if (nbttagcompound.contains("below_zero_retrogen", 10)) {
                DataResult dataresult = BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.getCompound("below_zero_retrogen")));
                Logger logger = LOGGER;
                Objects.requireNonNull(logger);
                Optional optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                Objects.requireNonNull(protochunk);
                optional.ifPresent(protochunk::setBelowZeroRetrogen);
            }
            ChunkStatus chunkstatus = ChunkStatus.byName(nbttagcompound.getString("Status"));
            protochunk.setPersistedStatus(chunkstatus);
            if (chunkstatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                protochunk.setLightEngine(levellightengine);
            }
        }
        NBTBase persistentBase = nbttagcompound.get("ChunkBukkitValues");
        if (persistentBase instanceof NBTTagCompound) {
            ((IChunkAccess)object1).persistentDataContainer.putAll((NBTTagCompound)persistentBase);
        }
        ((IChunkAccess)object1).setLightCorrect(flag);
        NBTTagCompound nbttagcompound2 = nbttagcompound.getCompound(HEIGHTMAPS_TAG);
        EnumSet<HeightMap.Type> enumset = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type heightmap_type : ((IChunkAccess)object1).getPersistedStatus().heightmapsAfter()) {
            String s3 = heightmap_type.getSerializationKey();
            if (nbttagcompound2.contains(s3, 12)) {
                ((IChunkAccess)object1).setHeightmap(heightmap_type, nbttagcompound2.getLongArray(s3));
                continue;
            }
            enumset.add(heightmap_type);
        }
        HeightMap.primeHeightmaps(object1, enumset);
        NBTTagCompound nbttagcompound3 = nbttagcompound.getCompound("structures");
        ((IChunkAccess)object1).setAllStarts(ChunkRegionLoader.unpackStructureStart(StructurePieceSerializationContext.fromLevel(worldserver), nbttagcompound3, worldserver.getSeed()));
        ((IChunkAccess)object1).setAllReferences(ChunkRegionLoader.unpackStructureReferences(worldserver.registryAccess(), chunkcoordintpair, nbttagcompound3));
        if (nbttagcompound.getBoolean("shouldSave")) {
            ((IChunkAccess)object1).setUnsaved(true);
        }
        NBTTagList nbttaglist1 = nbttagcompound.getList("PostProcessing", 9);
        for (int j1 = 0; j1 < nbttaglist1.size(); ++j1) {
            nbttaglist2 = nbttaglist1.getList(j1);
            for (i1 = 0; i1 < nbttaglist2.size(); ++i1) {
                ((IChunkAccess)object1).addPackedPostProcess(nbttaglist2.getShort(i1), j1);
            }
        }
        if (chunktype == ChunkType.LEVELCHUNK) {
            return new ProtoChunkExtension((Chunk)object1, false);
        }
        IChunkAccess protochunk1 = object1;
        nbttaglist2 = nbttagcompound.getList("entities", 10);
        for (i1 = 0; i1 < nbttaglist2.size(); ++i1) {
            ((ProtoChunk)protochunk1).addEntity(nbttaglist2.getCompound(i1));
        }
        NBTTagList nbttaglist3 = nbttagcompound.getList("block_entities", 10);
        for (int k1 = 0; k1 < nbttaglist3.size(); ++k1) {
            NBTTagCompound nbttagcompound4 = nbttaglist3.getCompound(k1);
            object1.setBlockEntityNbt(nbttagcompound4);
        }
        NBTTagCompound nbttagcompound5 = nbttagcompound.getCompound("CarvingMasks");
        for (String s1 : nbttagcompound5.getAllKeys()) {
            WorldGenStage.Features worldgenstage_features = WorldGenStage.Features.valueOf(s1);
            ((ProtoChunk)protochunk1).setCarvingMask(worldgenstage_features, new CarvingMask(nbttagcompound5.getLongArray(s1), object1.getMinBuildHeight()));
        }
        return protochunk1;
    }

    private static void logErrors(ChunkCoordIntPair chunkcoordintpair, int i2, String s2) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkcoordintpair.x, i2, chunkcoordintpair.z, s2});
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> makeBiomeCodec(IRegistry<BiomeBase> iregistry) {
        return DataPaletteBlock.codecRO(iregistry.asHolderIdMap(), iregistry.holderByNameCodec(), DataPaletteBlock.d.SECTION_BIOMES, iregistry.getHolderOrThrow(Biomes.PLAINS));
    }

    private static Codec<DataPaletteBlock<Holder<BiomeBase>>> makeBiomeCodecRW(IRegistry<BiomeBase> iregistry) {
        return DataPaletteBlock.codecRW(iregistry.asHolderIdMap(), iregistry.holderByNameCodec(), DataPaletteBlock.d.SECTION_BIOMES, iregistry.getHolderOrThrow(Biomes.PLAINS));
    }

    public static NBTTagCompound write(WorldServer worldserver, IChunkAccess ichunkaccess) {
        ChunkConverter chunkconverter;
        BelowZeroRetrogen belowzeroretrogen;
        Logger logger;
        DataResult dataresult;
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.getPos();
        NBTTagCompound nbttagcompound = GameProfileSerializer.addCurrentDataVersion(new NBTTagCompound());
        nbttagcompound.putInt(X_POS_TAG, chunkcoordintpair.x);
        nbttagcompound.putInt("yPos", ichunkaccess.getMinSection());
        nbttagcompound.putInt(Z_POS_TAG, chunkcoordintpair.z);
        nbttagcompound.putLong("LastUpdate", worldserver.getGameTime());
        nbttagcompound.putLong("InhabitedTime", ichunkaccess.getInhabitedTime());
        nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ichunkaccess.getPersistedStatus()).toString());
        BlendingData blendingdata = ichunkaccess.getBlendingData();
        if (blendingdata != null) {
            dataresult = BlendingData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)blendingdata);
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("blending_data", (NBTBase)nbtbase));
        }
        if ((belowzeroretrogen = ichunkaccess.getBelowZeroRetrogen()) != null) {
            dataresult = BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)belowzeroretrogen);
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("below_zero_retrogen", (NBTBase)nbtbase));
        }
        if (!(chunkconverter = ichunkaccess.getUpgradeData()).isEmpty()) {
            nbttagcompound.put(TAG_UPGRADE_DATA, chunkconverter.write());
        }
        ChunkSection[] achunksection = ichunkaccess.getSections();
        NBTTagList nbttaglist = new NBTTagList();
        LightEngineThreaded lightenginethreaded = worldserver.getChunkSource().getLightEngine();
        IRegistry<BiomeBase> iregistry = worldserver.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<BiomeBase>>> codec = ChunkRegionLoader.makeBiomeCodec(iregistry);
        boolean flag = ichunkaccess.isLightCorrect();
        for (int i2 = lightenginethreaded.getMinLightSection(); i2 < lightenginethreaded.getMaxLightSection(); ++i2) {
            int j2 = ichunkaccess.getSectionIndexFromSectionY(i2);
            boolean flag1 = j2 >= 0 && j2 < achunksection.length;
            NibbleArray nibblearray = lightenginethreaded.getLayerListener(EnumSkyBlock.BLOCK).getDataLayerData(SectionPosition.of(chunkcoordintpair, i2));
            NibbleArray nibblearray1 = lightenginethreaded.getLayerListener(EnumSkyBlock.SKY).getDataLayerData(SectionPosition.of(chunkcoordintpair, i2));
            if (!flag1 && nibblearray == null && nibblearray1 == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (flag1) {
                ChunkSection chunksection = achunksection[j2];
                nbttagcompound1.put("block_states", (NBTBase)BLOCK_STATE_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, chunksection.getStates()).getOrThrow());
                nbttagcompound1.put("biomes", (NBTBase)codec.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, chunksection.getBiomes()).getOrThrow());
            }
            if (nibblearray != null && !nibblearray.isEmpty()) {
                nbttagcompound1.putByteArray(BLOCK_LIGHT_TAG, nibblearray.getData());
            }
            if (nibblearray1 != null && !nibblearray1.isEmpty()) {
                nbttagcompound1.putByteArray(SKY_LIGHT_TAG, nibblearray1.getData());
            }
            if (nbttagcompound1.isEmpty()) continue;
            nbttagcompound1.putByte("Y", (byte)i2);
            nbttaglist.add(nbttagcompound1);
        }
        nbttagcompound.put(SECTIONS_TAG, nbttaglist);
        if (flag) {
            nbttagcompound.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        for (BlockPosition blockposition : ichunkaccess.getBlockEntitiesPos()) {
            NBTTagCompound nbttagcompound2 = ichunkaccess.getBlockEntityNbtForSaving(blockposition, worldserver.registryAccess());
            if (nbttagcompound2 == null) continue;
            nbttaglist1.add(nbttagcompound2);
        }
        nbttagcompound.put("block_entities", nbttaglist1);
        if (ichunkaccess.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            NBTTagList nbttaglist2 = new NBTTagList();
            nbttaglist2.addAll(protochunk.getEntities());
            nbttagcompound.put("entities", nbttaglist2);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            for (WorldGenStage.Features worldgenstage_features : WorldGenStage.Features.values()) {
                CarvingMask carvingmask = protochunk.getCarvingMask(worldgenstage_features);
                if (carvingmask == null) continue;
                nbttagcompound2.putLongArray(worldgenstage_features.toString(), carvingmask.toArray());
            }
            nbttagcompound.put("CarvingMasks", nbttagcompound2);
        }
        ChunkRegionLoader.saveTicks(worldserver, nbttagcompound, ichunkaccess.getTicksForSerialization());
        nbttagcompound.put("PostProcessing", ChunkRegionLoader.packOffsets(ichunkaccess.getPostProcessing()));
        NBTTagCompound nbttagcompound3 = new NBTTagCompound();
        for (Map.Entry<HeightMap.Type, HeightMap> entry : ichunkaccess.getHeightmaps()) {
            if (!ichunkaccess.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            nbttagcompound3.put(entry.getKey().getSerializationKey(), new NBTTagLongArray(entry.getValue().getRawData()));
        }
        nbttagcompound.put(HEIGHTMAPS_TAG, nbttagcompound3);
        nbttagcompound.put("structures", ChunkRegionLoader.packStructureData(StructurePieceSerializationContext.fromLevel(worldserver), chunkcoordintpair, ichunkaccess.getAllStarts(), ichunkaccess.getAllReferences()));
        if (!ichunkaccess.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("ChunkBukkitValues", ichunkaccess.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    private static void saveTicks(WorldServer worldserver, NBTTagCompound nbttagcompound, IChunkAccess.a ichunkaccess_a) {
        long i2 = worldserver.getLevelData().getGameTime();
        nbttagcompound.put(BLOCK_TICKS_TAG, ichunkaccess_a.blocks().save(i2, block -> BuiltInRegistries.BLOCK.getKey((Block)block).toString()));
        nbttagcompound.put(FLUID_TICKS_TAG, ichunkaccess_a.fluids().save(i2, fluidtype -> BuiltInRegistries.FLUID.getKey((FluidType)fluidtype).toString()));
    }

    public static ChunkType getChunkTypeFromTag(@Nullable NBTTagCompound nbttagcompound) {
        return nbttagcompound != null ? ChunkStatus.byName(nbttagcompound.getString("Status")).getChunkType() : ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static Chunk.c postLoadChunk(WorldServer worldserver, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = ChunkRegionLoader.getListOfCompoundsOrNull(nbttagcompound, "entities");
        NBTTagList nbttaglist1 = ChunkRegionLoader.getListOfCompoundsOrNull(nbttagcompound, "block_entities");
        return nbttaglist == null && nbttaglist1 == null ? null : chunk -> {
            worldserver.timings.syncChunkLoadEntitiesTimer.startTiming();
            if (nbttaglist != null) {
                worldserver.addLegacyChunkEntities(EntityTypes.loadEntitiesRecursive(nbttaglist, worldserver));
            }
            worldserver.timings.syncChunkLoadEntitiesTimer.stopTiming();
            worldserver.timings.syncChunkLoadTileEntitiesTimer.startTiming();
            if (nbttaglist1 != null) {
                for (int i2 = 0; i2 < nbttaglist1.size(); ++i2) {
                    NBTTagCompound nbttagcompound1 = nbttaglist1.getCompound(i2);
                    boolean flag = nbttagcompound1.getBoolean("keepPacked");
                    if (flag) {
                        chunk.setBlockEntityNbt(nbttagcompound1);
                        continue;
                    }
                    BlockPosition blockposition = TileEntity.getPosFromTag(nbttagcompound1);
                    TileEntity tileentity = TileEntity.loadStatic(blockposition, chunk.getBlockState(blockposition), nbttagcompound1, worldserver.registryAccess());
                    if (tileentity == null) continue;
                    chunk.setBlockEntity(tileentity);
                }
            }
            worldserver.timings.syncChunkLoadTileEntitiesTimer.stopTiming();
        };
    }

    @Nullable
    private static NBTTagList getListOfCompoundsOrNull(NBTTagCompound nbttagcompound, String s2) {
        NBTTagList nbttaglist = nbttagcompound.getList(s2, 10);
        return nbttaglist.isEmpty() ? null : nbttaglist;
    }

    private static NBTTagCompound packStructureData(StructurePieceSerializationContext structurepieceserializationcontext, ChunkCoordIntPair chunkcoordintpair, Map<Structure, StructureStart> map, Map<Structure, LongSet> map1) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        IRegistry<Structure> iregistry = structurepieceserializationcontext.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> entry : map.entrySet()) {
            MinecraftKey minecraftkey = iregistry.getKey(entry.getKey());
            nbttagcompound1.put(minecraftkey.toString(), entry.getValue().createTag(structurepieceserializationcontext, chunkcoordintpair));
        }
        nbttagcompound.put("starts", nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> entry1 : map1.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            MinecraftKey minecraftkey1 = iregistry.getKey(entry1.getKey());
            nbttagcompound2.put(minecraftkey1.toString(), new NBTTagLongArray(entry1.getValue()));
        }
        nbttagcompound.put("References", nbttagcompound2);
        return nbttagcompound;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound, long i2) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = structurepieceserializationcontext.registryAccess().registryOrThrow(Registries.STRUCTURE);
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("starts");
        for (String s2 : nbttagcompound1.getAllKeys()) {
            MinecraftKey minecraftkey = MinecraftKey.tryParse(s2);
            Structure structure = iregistry.get(minecraftkey);
            if (structure == null) {
                LOGGER.error("Unknown structure start: {}", (Object)minecraftkey);
                continue;
            }
            StructureStart structurestart = StructureStart.loadStaticStart(structurepieceserializationcontext, nbttagcompound1.getCompound(s2), i2);
            if (structurestart == null) continue;
            NBTBase persistentBase = nbttagcompound1.getCompound(s2).get("StructureBukkitValues");
            if (persistentBase instanceof NBTTagCompound) {
                structurestart.persistentDataContainer.putAll((NBTTagCompound)persistentBase);
            }
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(IRegistryCustom iregistrycustom, ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> iregistry = iregistrycustom.registryOrThrow(Registries.STRUCTURE);
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("References");
        for (String s2 : nbttagcompound1.getAllKeys()) {
            MinecraftKey minecraftkey = MinecraftKey.tryParse(s2);
            Structure structure = iregistry.get(minecraftkey);
            if (structure == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)minecraftkey, (Object)chunkcoordintpair);
                continue;
            }
            long[] along = nbttagcompound1.getLongArray(s2);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(i2 -> {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(i2);
                if (chunkcoordintpair1.getChessboardDistance(chunkcoordintpair) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{minecraftkey, chunkcoordintpair1, chunkcoordintpair});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static NBTTagList packOffsets(ShortList[] ashortlist) {
        NBTTagList nbttaglist = new NBTTagList();
        ShortList[] ashortlist1 = ashortlist;
        int i2 = ashortlist.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            ShortList shortlist = ashortlist1[j2];
            NBTTagList nbttaglist1 = new NBTTagList();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    nbttaglist1.add(NBTTagShort.valueOf(oshort));
                }
            }
            nbttaglist.add(nbttaglist1);
        }
        return nbttaglist;
    }

    public static class a
    extends NbtException {
        public a(String s2) {
            super(s2);
        }
    }
}

