/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.MapCodec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.Bukkit;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable {
    public static final int LAST_MONOLYTH_STRUCTURE_DATA_VERSION = 1493;
    private final IOWorker worker;
    protected final DataFixer fixerUpper;
    @Nullable
    private volatile PersistentStructureLegacy legacyStructureHandler;

    public IChunkLoader(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag) {
        this.fixerUpper = datafixer;
        this.worker = new IOWorker(regionstorageinfo, path, flag);
    }

    public boolean isOldChunkAround(ChunkCoordIntPair chunkcoordintpair, int i2) {
        return this.worker.isOldChunkAround(chunkcoordintpair, i2);
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) {
        NBTTagCompound nbt;
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x2, z2);
        if (cps != null) {
            Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"primary thread");
            if (cps.hasChunk(x2, z2)) {
                return true;
            }
        }
        try {
            nbt = this.read(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            NBTTagCompound level = nbt.getCompound("Level");
            if (level.getBoolean("TerrainPopulated")) {
                return true;
            }
            ChunkStatus status = ChunkStatus.byName(level.getString("Status"));
            if (status != null && status.isOrAfter(ChunkStatus.FEATURES)) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier, NBTTagCompound nbttagcompound, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) {
        int i2 = IChunkLoader.getVersion(nbttagcompound);
        if (i2 == SharedConstants.getCurrentVersion().getDataVersion().getVersion()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            NBTTagCompound level;
            if (i2 < 1466 && (level = nbttagcompound.getCompound("Level")).getBoolean("TerrainPopulated") && !level.getBoolean("LightPopulated")) {
                ChunkProviderServer cps;
                ChunkProviderServer chunkProviderServer = cps = generatoraccess == null ? null : ((WorldServer)generatoraccess).getChunkSource();
                if (this.check(cps, pos.x - 1, pos.z) && this.check(cps, pos.x - 1, pos.z - 1) && this.check(cps, pos.x, pos.z - 1)) {
                    level.putBoolean("LightPopulated", true);
                }
            }
            if (i2 < 1493 && (nbttagcompound = DataFixTypes.CHUNK.update(this.fixerUpper, nbttagcompound, i2, 1493)).getCompound("Level").getBoolean("hasLegacyStructureData")) {
                PersistentStructureLegacy persistentstructurelegacy = this.getLegacyStructureHandler(resourcekey, supplier);
                nbttagcompound = persistentstructurelegacy.updateFromLegacy(nbttagcompound);
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.getCompound("Level").getString("Status"));
            }
            IChunkLoader.injectDatafixingContext(nbttagcompound, resourcekey, optional);
            nbttagcompound = DataFixTypes.CHUNK.updateToCurrentVersion(this.fixerUpper, nbttagcompound, Math.max(1493, i2));
            if (stopBelowZero) {
                nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            IChunkLoader.removeDatafixingContext(nbttagcompound);
            GameProfileSerializer.addCurrentDataVersion(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Updated chunk");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Updated chunk details");
            crashreportsystemdetails.setDetail("Data version", i2);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy getLegacyStructureHandler(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier) {
        PersistentStructureLegacy persistentstructurelegacy = this.legacyStructureHandler;
        if (persistentstructurelegacy == null) {
            IChunkLoader iChunkLoader = this;
            synchronized (iChunkLoader) {
                persistentstructurelegacy = this.legacyStructureHandler;
                if (persistentstructurelegacy == null) {
                    this.legacyStructureHandler = persistentstructurelegacy = PersistentStructureLegacy.getLegacyStructureHandler(resourcekey, supplier.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void injectDatafixingContext(NBTTagCompound nbttagcompound, ResourceKey<WorldDimension> resourcekey, Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> optional) {
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.putString("dimension", resourcekey.location().toString());
        optional.ifPresent(resourcekey1 -> nbttagcompound1.putString("generator", resourcekey1.location().toString()));
        nbttagcompound.put("__context", nbttagcompound1);
    }

    private static void removeDatafixingContext(NBTTagCompound nbttagcompound) {
        nbttagcompound.remove("__context");
    }

    public static int getVersion(NBTTagCompound nbttagcompound) {
        return GameProfileSerializer.getDataVersion(nbttagcompound, -1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> read(ChunkCoordIntPair chunkcoordintpair) {
        return this.worker.loadAsync(chunkcoordintpair);
    }

    public CompletableFuture<Void> write(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) {
        this.handleLegacyStructureIndex(chunkcoordintpair);
        return this.worker.store(chunkcoordintpair, nbttagcompound);
    }

    protected void handleLegacyStructureIndex(ChunkCoordIntPair chunkcoordintpair) {
        if (this.legacyStructureHandler != null) {
            this.legacyStructureHandler.removeIndex(chunkcoordintpair.toLong());
        }
    }

    public void flushWorker() {
        this.worker.synchronize(true).join();
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }

    public ChunkScanAccess chunkScanner() {
        return this.worker;
    }

    protected RegionStorageInfo storageInfo() {
        return this.worker.storageInfo();
    }
}

