/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionSuppressor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public final class RegionFileCache
implements AutoCloseable {
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo info;
    private final Path folder;
    private final boolean sync;

    RegionFileCache(RegionStorageInfo regionstorageinfo, Path path, boolean flag) {
        this.folder = path;
        this.sync = flag;
        this.info = regionstorageinfo;
    }

    private RegionFile getRegionFile(ChunkCoordIntPair chunkcoordintpair, boolean existingOnly) throws IOException {
        long i2 = ChunkCoordIntPair.asLong(chunkcoordintpair.getRegionX(), chunkcoordintpair.getRegionZ());
        RegionFile regionfile = (RegionFile)this.regionCache.getAndMoveToFirst(i2);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.regionCache.size() >= 256) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        FileUtils.createDirectoriesSafe(this.folder);
        Path path = this.folder;
        int j2 = chunkcoordintpair.getRegionX();
        Path path1 = path.resolve("r." + j2 + "." + chunkcoordintpair.getRegionZ() + ANVIL_EXTENSION);
        if (existingOnly && !Files.exists(path1, new LinkOption[0])) {
            return null;
        }
        RegionFile regionfile1 = new RegionFile(this.info, path1, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(i2, (Object)regionfile1);
        return regionfile1;
    }

    @Nullable
    public NBTTagCompound read(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        NBTTagCompound nbttagcompound;
        block8: {
            NBTTagCompound nbttagcompound2;
            RegionFile regionfile = this.getRegionFile(chunkcoordintpair, true);
            if (regionfile == null) {
                return null;
            }
            try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkcoordintpair);){
                if (datainputstream != null) {
                    nbttagcompound = NBTCompressedStreamTools.read(datainputstream);
                    break block8;
                }
                nbttagcompound2 = null;
            }
            return nbttagcompound2;
        }
        return nbttagcompound;
    }

    public void scanChunk(ChunkCoordIntPair chunkcoordintpair, StreamTagVisitor streamtagvisitor) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkcoordintpair, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkcoordintpair);){
            if (datainputstream != null) {
                NBTCompressedStreamTools.parse(datainputstream, streamtagvisitor, NBTReadLimiter.unlimitedHeap());
            }
        }
    }

    protected void write(ChunkCoordIntPair chunkcoordintpair, @Nullable NBTTagCompound nbttagcompound) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkcoordintpair, false);
        if (nbttagcompound == null) {
            regionfile.clear(chunkcoordintpair);
        } else {
            try (DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(chunkcoordintpair);){
                NBTCompressedStreamTools.write(nbttagcompound, dataoutputstream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionSuppressor<IOException> exceptionsuppressor = new ExceptionSuppressor<IOException>();
        for (RegionFile regionfile : this.regionCache.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptionsuppressor.add(ioexception);
            }
        }
        exceptionsuppressor.throwIfPresent();
    }

    public void flush() throws IOException {
        for (RegionFile regionfile : this.regionCache.values()) {
            regionfile.flush();
        }
    }

    public RegionStorageInfo info() {
        return this.info;
    }
}

