/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class EnderDragonBattle {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_DRAGON_RESPAWN = 1200;
    private static final int TIME_BETWEEN_CRYSTAL_SCANS = 100;
    public static final int TIME_BETWEEN_PLAYER_SCANS = 20;
    private static final int ARENA_SIZE_CHUNKS = 8;
    public static final int ARENA_TICKET_LEVEL = 9;
    private static final int GATEWAY_COUNT = 20;
    private static final int GATEWAY_DISTANCE = 96;
    public static final int DRAGON_SPAWN_Y = 128;
    private final Predicate<Entity> validPlayer;
    public final BossBattleServer dragonEvent = (BossBattleServer)new BossBattleServer(IChatBaseComponent.translatable("entity.minecraft.ender_dragon"), BossBattle.BarColor.PINK, BossBattle.BarStyle.PROGRESS).setPlayBossMusic(true).setCreateWorldFog(true);
    public final WorldServer level;
    private final BlockPosition origin;
    private final ObjectArrayList<Integer> gateways = new ObjectArrayList();
    private final ShapeDetector exitPortalPattern;
    private int ticksSinceDragonSeen;
    private int crystalsAlive;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan = 21;
    private boolean dragonKilled;
    public boolean previouslyKilled;
    private boolean skipArenaLoadedCheck = false;
    @Nullable
    public UUID dragonUUID;
    private boolean needsStateScanning = true;
    @Nullable
    public BlockPosition portalLocation;
    @Nullable
    public EnumDragonRespawn respawnStage;
    private int respawnTime;
    @Nullable
    private List<EntityEnderCrystal> respawnCrystals;

    public EnderDragonBattle(WorldServer worldserver, long i2, a enderdragonbattle_a) {
        this(worldserver, i2, enderdragonbattle_a, BlockPosition.ZERO);
    }

    public EnderDragonBattle(WorldServer worldserver, long i2, a enderdragonbattle_a, BlockPosition blockposition) {
        this.level = worldserver;
        this.origin = blockposition;
        this.validPlayer = IEntitySelector.ENTITY_STILL_ALIVE.and(IEntitySelector.withinDistance(blockposition.getX(), 128 + blockposition.getY(), blockposition.getZ(), 192.0));
        this.needsStateScanning = enderdragonbattle_a.needsStateScanning;
        this.dragonUUID = enderdragonbattle_a.dragonUUID.orElse(null);
        this.dragonKilled = enderdragonbattle_a.dragonKilled;
        this.previouslyKilled = enderdragonbattle_a.previouslyKilled;
        if (enderdragonbattle_a.isRespawning) {
            this.respawnStage = EnumDragonRespawn.START;
        }
        this.portalLocation = enderdragonbattle_a.exitPortalLocation.orElse(null);
        this.gateways.addAll((Collection)enderdragonbattle_a.gateways.orElseGet(() -> {
            ObjectArrayList objectarraylist = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            SystemUtils.shuffle(objectarraylist, RandomSource.create(i2));
            return objectarraylist;
        }));
        this.exitPortalPattern = ShapeDetectorBuilder.start().aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").aisle("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").where('#', ShapeDetectorBlock.hasState(BlockPredicate.forBlock(Blocks.BEDROCK))).build();
    }

    @Deprecated
    @VisibleForTesting
    public void skipArenaLoadedCheck() {
        this.skipArenaLoadedCheck = true;
    }

    public a saveData() {
        return new a(this.needsStateScanning, this.dragonKilled, this.previouslyKilled, false, Optional.ofNullable(this.dragonUUID), Optional.ofNullable(this.portalLocation), Optional.of(this.gateways));
    }

    public void tick() {
        this.dragonEvent.setVisible(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.dragonEvent.getPlayers().isEmpty()) {
            this.level.getChunkSource().addRegionTicket(TicketType.DRAGON, new ChunkCoordIntPair(0, 0), 9, Unit.INSTANCE);
            boolean flag = this.isArenaLoaded();
            if (this.needsStateScanning && flag) {
                this.scanState();
                this.needsStateScanning = false;
            }
            if (this.respawnStage != null) {
                if (this.respawnCrystals == null && flag) {
                    this.respawnStage = null;
                    this.tryRespawn();
                }
                this.respawnStage.tick(this.level, this, this.respawnCrystals, this.respawnTime++, this.portalLocation);
            }
            if (!this.dragonKilled) {
                if ((this.dragonUUID == null || ++this.ticksSinceDragonSeen >= 1200) && flag) {
                    this.findOrCreateDragon();
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && flag) {
                    this.updateCrystalCount();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            this.level.getChunkSource().removeRegionTicket(TicketType.DRAGON, new ChunkCoordIntPair(0, 0), 9, Unit.INSTANCE);
        }
    }

    private void scanState() {
        LOGGER.info("Scanning for legacy world dragon fight...");
        boolean flag = this.hasActiveExitPortal();
        if (flag) {
            LOGGER.info("Found that the dragon has been killed in this world already.");
            this.previouslyKilled = true;
        } else {
            LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.previouslyKilled = false;
            if (this.findExitPortal() == null) {
                this.spawnExitPortal(false);
            }
        }
        List<? extends EntityEnderDragon> list = this.level.getDragons();
        if (list.isEmpty()) {
            this.dragonKilled = true;
        } else {
            EntityEnderDragon entityenderdragon = list.get(0);
            this.dragonUUID = entityenderdragon.getUUID();
            LOGGER.info("Found that there's a dragon still alive ({})", (Object)entityenderdragon);
            this.dragonKilled = false;
            if (!flag) {
                LOGGER.info("But we didn't have a portal, let's remove it.");
                entityenderdragon.discard(null);
                this.dragonUUID = null;
            }
        }
        if (!this.previouslyKilled && this.dragonKilled) {
            this.dragonKilled = false;
        }
    }

    private void findOrCreateDragon() {
        List<? extends EntityEnderDragon> list = this.level.getDragons();
        if (list.isEmpty()) {
            LOGGER.debug("Haven't seen the dragon, respawning it");
            this.createNewDragon();
        } else {
            LOGGER.debug("Haven't seen our dragon, but found another one to use.");
            this.dragonUUID = list.get(0).getUUID();
        }
    }

    public void setRespawnStage(EnumDragonRespawn enumdragonrespawn) {
        if (this.respawnStage == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnTime = 0;
        if (enumdragonrespawn == EnumDragonRespawn.END) {
            this.respawnStage = null;
            this.dragonKilled = false;
            EntityEnderDragon entityenderdragon = this.createNewDragon();
            if (entityenderdragon != null) {
                for (EntityPlayer entityplayer : this.dragonEvent.getPlayers()) {
                    CriterionTriggers.SUMMONED_ENTITY.trigger(entityplayer, entityenderdragon);
                }
            }
        } else {
            this.respawnStage = enumdragonrespawn;
        }
    }

    private boolean hasActiveExitPortal() {
        for (int i2 = -8; i2 <= 8; ++i2) {
            block1: for (int j2 = -8; j2 <= 8; ++j2) {
                TileEntity tileentity;
                Chunk chunk = this.level.getChunk(i2, j2);
                Iterator<TileEntity> iterator = chunk.getBlockEntities().values().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    continue block1;
                } while (!((tileentity = iterator.next()) instanceof TileEntityEnderPortal));
                return true;
            }
        }
        return false;
    }

    @Nullable
    public ShapeDetector.ShapeDetectorCollection findExitPortal() {
        int i2;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(this.origin);
        for (int j2 = -8 + chunkcoordintpair.x; j2 <= 8 + chunkcoordintpair.x; ++j2) {
            for (i2 = -8 + chunkcoordintpair.z; i2 <= 8 + chunkcoordintpair.z; ++i2) {
                Chunk chunk = this.level.getChunk(j2, i2);
                for (TileEntity tileentity : chunk.getBlockEntities().values()) {
                    ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection;
                    if (!(tileentity instanceof TileEntityEnderPortal) || (shapedetector_shapedetectorcollection = this.exitPortalPattern.find(this.level, tileentity.getBlockPos())) == null) continue;
                    BlockPosition blockposition = shapedetector_shapedetectorcollection.getBlock(3, 3, 3).getPos();
                    if (this.portalLocation == null) {
                        this.portalLocation = blockposition;
                    }
                    return shapedetector_shapedetectorcollection;
                }
            }
        }
        BlockPosition blockposition1 = WorldGenEndTrophy.getLocation(this.origin);
        for (int k2 = i2 = this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, blockposition1).getY(); k2 >= this.level.getMinBuildHeight(); --k2) {
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection1 = this.exitPortalPattern.find(this.level, new BlockPosition(blockposition1.getX(), k2, blockposition1.getZ()));
            if (shapedetector_shapedetectorcollection1 == null) continue;
            if (this.portalLocation == null) {
                this.portalLocation = shapedetector_shapedetectorcollection1.getBlock(3, 3, 3).getPos();
            }
            return shapedetector_shapedetectorcollection1;
        }
        return null;
    }

    private boolean isArenaLoaded() {
        if (this.skipArenaLoadedCheck) {
            return true;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(this.origin);
        for (int i2 = -8 + chunkcoordintpair.x; i2 <= 8 + chunkcoordintpair.x; ++i2) {
            for (int j2 = 8 + chunkcoordintpair.z; j2 <= 8 + chunkcoordintpair.z; ++j2) {
                IChunkAccess ichunkaccess = this.level.getChunk(i2, j2, ChunkStatus.FULL, false);
                if (!(ichunkaccess instanceof Chunk)) {
                    return false;
                }
                FullChunkStatus fullchunkstatus = ((Chunk)ichunkaccess).getFullStatus();
                if (fullchunkstatus.isOrAfter(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (EntityPlayer entityplayer : this.level.getPlayers(this.validPlayer)) {
            this.dragonEvent.addPlayer(entityplayer);
            set.add(entityplayer);
        }
        HashSet set1 = Sets.newHashSet(this.dragonEvent.getPlayers());
        set1.removeAll(set);
        for (EntityPlayer entityplayer1 : set1) {
            this.dragonEvent.removePlayer(entityplayer1);
        }
    }

    private void updateCrystalCount() {
        this.ticksSinceCrystalsScanned = 0;
        this.crystalsAlive = 0;
        for (WorldGenEnder.Spike worldgenender_spike : WorldGenEnder.getSpikesForLevel(this.level)) {
            this.crystalsAlive += this.level.getEntitiesOfClass(EntityEnderCrystal.class, worldgenender_spike.getTopBoundingBox()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", (Object)this.crystalsAlive);
    }

    public void setDragonKilled(EntityEnderDragon entityenderdragon) {
        if (entityenderdragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.spawnExitPortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.level.setBlockAndUpdate(this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, WorldGenEndTrophy.getLocation(this.origin)), Blocks.DRAGON_EGG.defaultBlockState());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void removeAllGateways() {
        this.gateways.clear();
    }

    private void spawnNewGateway() {
        if (!this.gateways.isEmpty()) {
            int i2 = (Integer)this.gateways.remove(this.gateways.size() - 1);
            int j2 = MathHelper.floor(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            int k2 = MathHelper.floor(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            this.spawnNewGateway(new BlockPosition(j2, 75, k2));
        }
    }

    private void spawnNewGateway(BlockPosition blockposition) {
        this.level.levelEvent(3000, blockposition, 0);
        this.level.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.getHolder(EndFeatures.END_GATEWAY_DELAYED)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.value()).place(this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), blockposition));
    }

    public void spawnExitPortal(boolean flag) {
        WorldGenEndTrophy worldgenendtrophy = new WorldGenEndTrophy(flag);
        if (this.portalLocation == null) {
            this.portalLocation = this.level.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, WorldGenEndTrophy.getLocation(this.origin)).below();
            while (this.level.getBlockState(this.portalLocation).is(Blocks.BEDROCK) && this.portalLocation.getY() > this.level.getSeaLevel()) {
                this.portalLocation = this.portalLocation.below();
            }
        }
        if (worldgenendtrophy.place(WorldGenFeatureConfiguration.NONE, this.level, this.level.getChunkSource().getGenerator(), RandomSource.create(), this.portalLocation)) {
            int i2 = MathHelper.positiveCeilDiv(4, 16);
            this.level.getChunkSource().chunkMap.waitForLightBeforeSending(new ChunkCoordIntPair(this.portalLocation), i2);
        }
    }

    @Nullable
    private EntityEnderDragon createNewDragon() {
        this.level.getChunkAt(new BlockPosition(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ()));
        EntityEnderDragon entityenderdragon = EntityTypes.ENDER_DRAGON.create(this.level);
        if (entityenderdragon != null) {
            entityenderdragon.setDragonFight(this);
            entityenderdragon.setFightOrigin(this.origin);
            entityenderdragon.getPhaseManager().setPhase(DragonControllerPhase.HOLDING_PATTERN);
            entityenderdragon.moveTo(this.origin.getX(), 128 + this.origin.getY(), this.origin.getZ(), this.level.random.nextFloat() * 360.0f, 0.0f);
            this.level.addFreshEntity(entityenderdragon);
            this.dragonUUID = entityenderdragon.getUUID();
        }
        return entityenderdragon;
    }

    public void updateDragon(EntityEnderDragon entityenderdragon) {
        if (entityenderdragon.getUUID().equals(this.dragonUUID)) {
            this.dragonEvent.setProgress(entityenderdragon.getHealth() / entityenderdragon.getMaxHealth());
            this.ticksSinceDragonSeen = 0;
            if (entityenderdragon.hasCustomName()) {
                this.dragonEvent.setName(entityenderdragon.getDisplayName());
            }
        }
    }

    public int getCrystalsAlive() {
        return this.crystalsAlive;
    }

    public void onCrystalDestroyed(EntityEnderCrystal entityendercrystal, DamageSource damagesource) {
        if (this.respawnStage != null && this.respawnCrystals.contains(entityendercrystal)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnStage = null;
            this.respawnTime = 0;
            this.resetSpikeCrystals();
            this.spawnExitPortal(true);
        } else {
            this.updateCrystalCount();
            Entity entity = this.level.getEntity(this.dragonUUID);
            if (entity instanceof EntityEnderDragon) {
                ((EntityEnderDragon)entity).onCrystalDestroyed(entityendercrystal, entityendercrystal.blockPosition(), damagesource);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public boolean tryRespawn() {
        if (this.dragonKilled && this.respawnStage == null) {
            BlockPosition blockposition = this.portalLocation;
            if (blockposition == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = this.findExitPortal();
                if (shapedetector_shapedetectorcollection == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.spawnExitPortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & saved its location for next time.");
                }
                blockposition = this.portalLocation;
            }
            ArrayList list = Lists.newArrayList();
            BlockPosition blockposition1 = blockposition.above(1);
            for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                List<EntityEnderCrystal> list1 = this.level.getEntitiesOfClass(EntityEnderCrystal.class, new AxisAlignedBB(blockposition1.relative(enumdirection, 2)));
                if (list1.isEmpty()) {
                    return false;
                }
                list.addAll(list1);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            return this.respawnDragon(list);
        }
        return false;
    }

    public boolean respawnDragon(List<EntityEnderCrystal> list) {
        if (this.dragonKilled && this.respawnStage == null) {
            ShapeDetector.ShapeDetectorCollection shapedetector_shapedetectorcollection = this.findExitPortal();
            while (shapedetector_shapedetectorcollection != null) {
                for (int i2 = 0; i2 < this.exitPortalPattern.getWidth(); ++i2) {
                    for (int j2 = 0; j2 < this.exitPortalPattern.getHeight(); ++j2) {
                        for (int k2 = 0; k2 < this.exitPortalPattern.getDepth(); ++k2) {
                            ShapeDetectorBlock shapedetectorblock = shapedetector_shapedetectorcollection.getBlock(i2, j2, k2);
                            if (!shapedetectorblock.getState().is(Blocks.BEDROCK) && !shapedetectorblock.getState().is(Blocks.END_PORTAL)) continue;
                            this.level.setBlockAndUpdate(shapedetectorblock.getPos(), Blocks.END_STONE.defaultBlockState());
                        }
                    }
                }
                shapedetector_shapedetectorcollection = this.findExitPortal();
            }
            this.respawnStage = EnumDragonRespawn.START;
            this.respawnTime = 0;
            this.spawnExitPortal(false);
            this.respawnCrystals = list;
            return true;
        }
        return false;
    }

    public void resetSpikeCrystals() {
        for (WorldGenEnder.Spike worldgenender_spike : WorldGenEnder.getSpikesForLevel(this.level)) {
            List<EntityEnderCrystal> list = this.level.getEntitiesOfClass(EntityEnderCrystal.class, worldgenender_spike.getTopBoundingBox());
            for (EntityEnderCrystal entityendercrystal : list) {
                entityendercrystal.setInvulnerable(false);
                entityendercrystal.setBeamTarget(null);
            }
        }
    }

    @Nullable
    public UUID getDragonUUID() {
        return this.dragonUUID;
    }

    public record a(boolean needsStateScanning, boolean dragonKilled, boolean previouslyKilled, boolean isRespawning, Optional<UUID> dragonUUID, Optional<BlockPosition> exitPortalLocation, Optional<List<Integer>> gateways) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(a::needsStateScanning), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(a::dragonKilled), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(a::previouslyKilled), (App)Codec.BOOL.lenientOptionalFieldOf("IsRespawning", (Object)false).forGetter(a::isRespawning), (App)UUIDUtil.CODEC.lenientOptionalFieldOf("Dragon").forGetter(a::dragonUUID), (App)BlockPosition.CODEC.lenientOptionalFieldOf("ExitPortalLocation").forGetter(a::exitPortalLocation), (App)Codec.list((Codec)Codec.INT).lenientOptionalFieldOf("Gateways").forGetter(a::gateways)).apply((Applicative)instance, a::new));
        public static final a DEFAULT = new a(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());
    }
}

