/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEndSpikeConfiguration;
import org.bukkit.event.entity.EntityRemoveEvent;

public enum EnumDragonRespawn {
    START{

        @Override
        public void tick(WorldServer worldserver, EnderDragonBattle enderdragonbattle, List<EntityEnderCrystal> list, int i2, BlockPosition blockposition) {
            BlockPosition blockposition1 = new BlockPosition(0, 128, 0);
            for (EntityEnderCrystal entityendercrystal : list) {
                entityendercrystal.setBeamTarget(blockposition1);
            }
            enderdragonbattle.setRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void tick(WorldServer worldserver, EnderDragonBattle enderdragonbattle, List<EntityEnderCrystal> list, int i2, BlockPosition blockposition) {
            if (i2 < 100) {
                if (i2 == 0 || i2 == 50 || i2 == 51 || i2 == 52 || i2 >= 95) {
                    worldserver.levelEvent(3001, new BlockPosition(0, 128, 0), 0);
                }
            } else {
                enderdragonbattle.setRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void tick(WorldServer worldserver, EnderDragonBattle enderdragonbattle, List<EntityEnderCrystal> list, int i2, BlockPosition blockposition) {
            boolean flag2;
            boolean flag = true;
            boolean flag1 = i2 % 40 == 0;
            boolean bl = flag2 = i2 % 40 == 39;
            if (flag1 || flag2) {
                int j2 = i2 / 40;
                List<WorldGenEnder.Spike> list1 = WorldGenEnder.getSpikesForLevel(worldserver);
                if (j2 < list1.size()) {
                    WorldGenEnder.Spike worldgenender_spike = list1.get(j2);
                    if (flag1) {
                        for (EntityEnderCrystal entityendercrystal : list) {
                            entityendercrystal.setBeamTarget(new BlockPosition(worldgenender_spike.getCenterX(), worldgenender_spike.getHeight() + 1, worldgenender_spike.getCenterZ()));
                        }
                    } else {
                        boolean flag3 = true;
                        for (BlockPosition blockposition1 : BlockPosition.betweenClosed(new BlockPosition(worldgenender_spike.getCenterX() - 10, worldgenender_spike.getHeight() - 10, worldgenender_spike.getCenterZ() - 10), new BlockPosition(worldgenender_spike.getCenterX() + 10, worldgenender_spike.getHeight() + 10, worldgenender_spike.getCenterZ() + 10))) {
                            worldserver.removeBlock(blockposition1, false);
                        }
                        worldserver.explode(null, (float)worldgenender_spike.getCenterX() + 0.5f, worldgenender_spike.getHeight(), (float)worldgenender_spike.getCenterZ() + 0.5f, 5.0f, World.a.BLOCK);
                        WorldGenFeatureEndSpikeConfiguration worldgenfeatureendspikeconfiguration = new WorldGenFeatureEndSpikeConfiguration(true, (List<WorldGenEnder.Spike>)ImmutableList.of((Object)worldgenender_spike), new BlockPosition(0, 128, 0));
                        WorldGenerator.END_SPIKE.place(worldgenfeatureendspikeconfiguration, worldserver, worldserver.getChunkSource().getGenerator(), RandomSource.create(), new BlockPosition(worldgenender_spike.getCenterX(), 45, worldgenender_spike.getCenterZ()));
                    }
                } else if (flag1) {
                    enderdragonbattle.setRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON{

        @Override
        public void tick(WorldServer worldserver, EnderDragonBattle enderdragonbattle, List<EntityEnderCrystal> list, int i2, BlockPosition blockposition) {
            if (i2 >= 100) {
                enderdragonbattle.setRespawnStage(END);
                enderdragonbattle.resetSpikeCrystals();
                for (EntityEnderCrystal entityendercrystal : list) {
                    entityendercrystal.setBeamTarget(null);
                    worldserver.explode(entityendercrystal, entityendercrystal.getX(), entityendercrystal.getY(), entityendercrystal.getZ(), 6.0f, World.a.NONE);
                    entityendercrystal.discard(EntityRemoveEvent.Cause.EXPLODE);
                }
            } else if (i2 >= 80) {
                worldserver.levelEvent(3001, new BlockPosition(0, 128, 0), 0);
            } else if (i2 == 0) {
                for (EntityEnderCrystal entityendercrystal : list) {
                    entityendercrystal.setBeamTarget(new BlockPosition(0, 128, 0));
                }
            } else if (i2 < 5) {
                worldserver.levelEvent(3001, new BlockPosition(0, 128, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void tick(WorldServer worldserver, EnderDragonBattle enderdragonbattle, List<EntityEnderCrystal> list, int i2, BlockPosition blockposition) {
        }
    };


    public abstract void tick(WorldServer var1, EnderDragonBattle var2, List<EntityEnderCrystal> var3, int var4, BlockPosition var5);
}

