/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    final Set<UUID> knownUuids = Sets.newHashSet();
    final LevelCallback<T> callbacks;
    public final EntityPersistentStorage<T> permanentStorage;
    private final EntityLookup<T> visibleEntityStorage = new EntityLookup();
    final EntitySectionStorage<T> sectionStorage;
    private final LevelEntityGetter<T> entityGetter;
    private final Long2ObjectMap<Visibility> chunkVisibility = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<b> chunkLoadStatuses = new Long2ObjectOpenHashMap();
    private final LongSet chunksToUnload = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> loadingInbox = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> oclass, LevelCallback<T> levelcallback, EntityPersistentStorage<T> entitypersistentstorage) {
        this.sectionStorage = new EntitySectionStorage<T>(oclass, (Long2ObjectFunction<Visibility>)this.chunkVisibility);
        this.chunkVisibility.defaultReturnValue((Object)Visibility.HIDDEN);
        this.chunkLoadStatuses.defaultReturnValue((Object)b.FRESH);
        this.callbacks = levelcallback;
        this.permanentStorage = entitypersistentstorage;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.visibleEntityStorage, this.sectionStorage);
    }

    public List<Entity> getEntities(ChunkCoordIntPair chunkCoordIntPair) {
        return this.sectionStorage.getExistingSectionsInChunk(chunkCoordIntPair.toLong()).flatMap(EntitySection::getEntities).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.chunkLoadStatuses.get(pair) == b.PENDING;
    }

    void removeSectionIfEmpty(long i2, EntitySection<T> entitysection) {
        if (entitysection.isEmpty()) {
            this.sectionStorage.remove(i2);
        }
    }

    private boolean addEntityUuid(T t0) {
        if (!this.knownUuids.add(t0.getUUID())) {
            LOGGER.warn("UUID of added entity already exists: {}", t0);
            return false;
        }
        return true;
    }

    public boolean addNewEntity(T t0) {
        return this.addEntity(t0, false);
    }

    private boolean addEntity(T t0, boolean flag) {
        Visibility visibility;
        if (!this.addEntityUuid(t0)) {
            return false;
        }
        long i2 = SectionPosition.asLong(t0.blockPosition());
        EntitySection<T> entitysection = this.sectionStorage.getOrCreateSection(i2);
        entitysection.add(t0);
        t0.setLevelCallback(new a((EntityAccess)t0, i2, entitysection));
        if (!flag) {
            this.callbacks.onCreated(t0);
        }
        if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(t0, entitysection.getStatus())).isAccessible()) {
            this.startTracking(t0);
        }
        if (visibility.isTicking()) {
            this.startTicking(t0);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility getEffectiveStatus(T t0, Visibility visibility) {
        return t0.isAlwaysTicking() ? Visibility.TICKING : visibility;
    }

    public void addLegacyChunkEntities(Stream<T> stream) {
        stream.forEach(entityaccess -> this.addEntity(entityaccess, true));
    }

    public void addWorldGenChunkEntities(Stream<T> stream) {
        stream.forEach(entityaccess -> this.addEntity(entityaccess, false));
    }

    void startTicking(T t0) {
        this.callbacks.onTickingStart(t0);
    }

    void stopTicking(T t0) {
        this.callbacks.onTickingEnd(t0);
    }

    void startTracking(T t0) {
        this.visibleEntityStorage.add(t0);
        this.callbacks.onTrackingStart(t0);
    }

    void stopTracking(T t0) {
        this.callbacks.onTrackingEnd(t0);
        this.visibleEntityStorage.remove(t0);
    }

    public void updateChunkStatus(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        Visibility visibility = Visibility.fromFullChunkStatus(fullchunkstatus);
        this.updateChunkStatus(chunkcoordintpair, visibility);
    }

    public void updateChunkStatus(ChunkCoordIntPair chunkcoordintpair, Visibility visibility) {
        long i2 = chunkcoordintpair.toLong();
        if (visibility == Visibility.HIDDEN) {
            this.chunkVisibility.remove(i2);
            this.chunksToUnload.add(i2);
        } else {
            this.chunkVisibility.put(i2, (Object)visibility);
            this.chunksToUnload.remove(i2);
            this.ensureChunkQueuedForLoad(i2);
        }
        this.sectionStorage.getExistingSectionsInChunk(i2).forEach(entitysection -> {
            Visibility visibility1 = entitysection.updateChunkStatus(visibility);
            boolean flag = visibility1.isAccessible();
            boolean flag1 = visibility.isAccessible();
            boolean flag2 = visibility1.isTicking();
            boolean flag3 = visibility.isTicking();
            if (flag2 && !flag3) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::stopTicking);
            }
            if (flag && !flag1) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::stopTracking);
            } else if (!flag && flag1) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::startTracking);
            }
            if (!flag2 && flag3) {
                entitysection.getEntities().filter(entityaccess -> !entityaccess.isAlwaysTicking()).forEach(this::startTicking);
            }
        });
    }

    public void ensureChunkQueuedForLoad(long i2) {
        b persistententitysectionmanager_b = (b)((Object)this.chunkLoadStatuses.get(i2));
        if (persistententitysectionmanager_b == b.FRESH) {
            this.requestChunkLoad(i2);
        }
    }

    private boolean storeChunkSections(long i2, Consumer<T> consumer) {
        return this.storeChunkSections(i2, consumer, false);
    }

    private boolean storeChunkSections(long i2, Consumer<T> consumer, boolean callEvent) {
        b persistententitysectionmanager_b = (b)((Object)this.chunkLoadStatuses.get(i2));
        if (persistententitysectionmanager_b == b.PENDING) {
            return false;
        }
        List<T> list = this.sectionStorage.getExistingSectionsInChunk(i2).flatMap(entitysection -> entitysection.getEntities().filter(EntityAccess::shouldBeSaved)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (persistententitysectionmanager_b == b.LOADED) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkCoordIntPair(i2), (List<Entity>)ImmutableList.of());
                }
                this.permanentStorage.storeEntities(new ChunkEntities(new ChunkCoordIntPair(i2), ImmutableList.of()));
            }
            return true;
        }
        if (persistententitysectionmanager_b == b.FRESH) {
            this.requestChunkLoad(i2);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.permanentStorage).level, new ChunkCoordIntPair(i2), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.permanentStorage.storeEntities(new ChunkEntities(new ChunkCoordIntPair(i2), list));
        list.forEach(consumer);
        return true;
    }

    private void requestChunkLoad(long i2) {
        this.chunkLoadStatuses.put(i2, (Object)b.PENDING);
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
        CompletableFuture<ChunkEntities<T>> completablefuture = this.permanentStorage.loadEntities(chunkcoordintpair);
        Queue<ChunkEntities<T>> queue = this.loadingInbox;
        Objects.requireNonNull(this.loadingInbox);
        ((CompletableFuture)completablefuture.thenAccept(queue::add)).exceptionally(throwable -> {
            LOGGER.error("Failed to read chunk {}", (Object)chunkcoordintpair, throwable);
            return null;
        });
    }

    private boolean processChunkUnload(long i2) {
        boolean flag = this.storeChunkSections(i2, entityaccess -> entityaccess.getPassengersAndSelf().forEach(this::unloadEntity), true);
        if (!flag) {
            return false;
        }
        this.chunkLoadStatuses.remove(i2);
        return true;
    }

    private void unloadEntity(EntityAccess entityaccess) {
        entityaccess.setRemoved(Entity.RemovalReason.UNLOADED_TO_CHUNK, EntityRemoveEvent.Cause.UNLOAD);
        entityaccess.setLevelCallback(EntityInLevelCallback.NULL);
    }

    private void processUnloads() {
        this.chunksToUnload.removeIf(i2 -> this.chunkVisibility.get(i2) != Visibility.HIDDEN ? true : this.processChunkUnload(i2));
    }

    private void processPendingLoads() {
        ChunkEntities<T> chunkentities;
        while ((chunkentities = this.loadingInbox.poll()) != null) {
            chunkentities.getEntities().forEach(entityaccess -> this.addEntity(entityaccess, true));
            this.chunkLoadStatuses.put(chunkentities.getPos().toLong(), (Object)b.LOADED);
            List<Entity> entities = this.getEntities(chunkentities.getPos());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.permanentStorage).level, chunkentities.getPos(), entities);
        }
    }

    public void tick() {
        this.processPendingLoads();
        this.processUnloads();
    }

    private LongSet getAllChunksToSave() {
        LongSet longset = this.sectionStorage.getAllChunksWithExistingSections();
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.chunkLoadStatuses)) {
            if (entry.getValue() != b.LOADED) continue;
            longset.add(entry.getLongKey());
        }
        return longset;
    }

    public void autoSave() {
        this.getAllChunksToSave().forEach(i2 -> {
            boolean flag;
            boolean bl = flag = this.chunkVisibility.get(i2) == Visibility.HIDDEN;
            if (flag) {
                this.processChunkUnload(i2);
            } else {
                this.storeChunkSections(i2, entityaccess -> {});
            }
        });
    }

    public void saveAll() {
        LongSet longset = this.getAllChunksToSave();
        while (!longset.isEmpty()) {
            this.permanentStorage.flush(false);
            this.processPendingLoads();
            longset.removeIf(i2 -> {
                boolean flag = this.chunkVisibility.get(i2) == Visibility.HIDDEN;
                return flag ? this.processChunkUnload(i2) : this.storeChunkSections(i2, entityaccess -> {});
            });
        }
        this.permanentStorage.flush(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.saveAll();
        }
        this.permanentStorage.close();
    }

    public boolean isLoaded(UUID uuid) {
        return this.knownUuids.contains(uuid);
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public boolean canPositionTick(BlockPosition blockposition) {
        return ((Visibility)((Object)this.chunkVisibility.get(ChunkCoordIntPair.asLong(blockposition)))).isTicking();
    }

    public boolean canPositionTick(ChunkCoordIntPair chunkcoordintpair) {
        return ((Visibility)((Object)this.chunkVisibility.get(chunkcoordintpair.toLong()))).isTicking();
    }

    public boolean areEntitiesLoaded(long i2) {
        return this.chunkLoadStatuses.get(i2) == b.LOADED;
    }

    public void dumpSections(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.builder().addColumn("x").addColumn("y").addColumn("z").addColumn("visibility").addColumn("load_status").addColumn("entity_count").build(writer);
        this.sectionStorage.getAllChunksWithExistingSections().forEach(i2 -> {
            b persistententitysectionmanager_b = (b)((Object)((Object)this.chunkLoadStatuses.get(i2)));
            this.sectionStorage.getExistingSectionPositionsInChunk(i2).forEach(j2 -> {
                EntitySection<T> entitysection = this.sectionStorage.getSection(j2);
                if (entitysection != null) {
                    try {
                        csvwriter.writeRow(new Object[]{SectionPosition.x(j2), SectionPosition.y(j2), SectionPosition.z(j2), entitysection.getStatus(), persistententitysectionmanager_b, entitysection.size()});
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException(ioexception);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String gatherStats() {
        int i2 = this.knownUuids.size();
        return i2 + "," + this.visibleEntityStorage.count() + "," + this.sectionStorage.count() + "," + this.chunkLoadStatuses.size() + "," + this.chunkVisibility.size() + "," + this.loadingInbox.size() + "," + this.chunksToUnload.size();
    }

    @VisibleForDebug
    public int count() {
        return this.visibleEntityStorage.count();
    }

    private static enum b {
        FRESH,
        PENDING,
        LOADED;

    }

    private class a
    implements EntityInLevelCallback {
        private final T entity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;

        a(EntityAccess entityaccess, long i2, EntitySection entitysection) {
            this.entity = entityaccess;
            this.currentSectionKey = i2;
            this.currentSection = entitysection;
        }

        @Override
        public void onMove() {
            BlockPosition blockposition = this.entity.blockPosition();
            long i2 = SectionPosition.asLong(blockposition);
            if (i2 != this.currentSectionKey) {
                Visibility visibility = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPosition.of(this.currentSectionKey), i2});
                }
                PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection entitysection = PersistentEntitySectionManager.this.sectionStorage.getOrCreateSection(i2);
                entitysection.add(this.entity);
                this.currentSection = entitysection;
                this.currentSectionKey = i2;
                this.updateStatus(visibility, entitysection.getStatus());
            }
        }

        private void updateStatus(Visibility visibility, Visibility visibility1) {
            Visibility visibility3;
            Visibility visibility2 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, visibility);
            if (visibility2 == (visibility3 = PersistentEntitySectionManager.getEffectiveStatus(this.entity, visibility1))) {
                if (visibility3.isAccessible()) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
            } else {
                boolean flag = visibility2.isAccessible();
                boolean flag1 = visibility3.isAccessible();
                if (flag && !flag1) {
                    PersistentEntitySectionManager.this.stopTracking(this.entity);
                } else if (!flag && flag1) {
                    PersistentEntitySectionManager.this.startTracking(this.entity);
                }
                boolean flag2 = visibility2.isTicking();
                boolean flag3 = visibility3.isTicking();
                if (flag2 && !flag3) {
                    PersistentEntitySectionManager.this.stopTicking(this.entity);
                } else if (!flag2 && flag3) {
                    PersistentEntitySectionManager.this.startTicking(this.entity);
                }
                if (flag1) {
                    PersistentEntitySectionManager.this.callbacks.onSectionChange(this.entity);
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason entity_removalreason) {
            Visibility visibility;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPosition.of(this.currentSectionKey), entity_removalreason});
            }
            if ((visibility = PersistentEntitySectionManager.getEffectiveStatus(this.entity, this.currentSection.getStatus())).isTicking()) {
                PersistentEntitySectionManager.this.stopTicking(this.entity);
            }
            if (visibility.isAccessible()) {
                PersistentEntitySectionManager.this.stopTracking(this.entity);
            }
            if (entity_removalreason.shouldDestroy()) {
                PersistentEntitySectionManager.this.callbacks.onDestroyed(this.entity);
            }
            PersistentEntitySectionManager.this.knownUuids.remove(this.entity.getUUID());
            this.entity.setLevelCallback(NULL);
            PersistentEntitySectionManager.this.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

