/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.GenericGameEvent;

public class GameEventDispatcher {
    private final WorldServer level;

    public GameEventDispatcher(WorldServer worldserver) {
        this.level = worldserver;
    }

    public void post(Holder<GameEvent> holder, Vec3D vec3d, GameEvent.a gameevent_a) {
        int i2 = holder.value().notificationRadius();
        BlockPosition blockposition = BlockPosition.containing(vec3d);
        GenericGameEvent event = new GenericGameEvent(CraftGameEvent.minecraftToBukkit(holder.value()), CraftLocation.toBukkit(blockposition, (World)this.level.getWorld()), (Entity)(gameevent_a.sourceEntity() == null ? null : gameevent_a.sourceEntity().getBukkitEntity()), i2, !Bukkit.isPrimaryThread());
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        i2 = event.getRadius();
        int j2 = SectionPosition.blockToSectionCoord(blockposition.getX() - i2);
        int k2 = SectionPosition.blockToSectionCoord(blockposition.getY() - i2);
        int l2 = SectionPosition.blockToSectionCoord(blockposition.getZ() - i2);
        int i1 = SectionPosition.blockToSectionCoord(blockposition.getX() + i2);
        int j1 = SectionPosition.blockToSectionCoord(blockposition.getY() + i2);
        int k1 = SectionPosition.blockToSectionCoord(blockposition.getZ() + i2);
        ArrayList<GameEvent.b> list = new ArrayList<GameEvent.b>();
        GameEventListenerRegistry.a gameeventlistenerregistry_a = (gameeventlistener, vec3d1) -> {
            if (gameeventlistener.getDeliveryMode() == GameEventListener.a.BY_DISTANCE) {
                list.add(new GameEvent.b(holder, vec3d, gameevent_a, gameeventlistener, vec3d1));
            } else {
                gameeventlistener.handleGameEvent(this.level, holder, gameevent_a, vec3d);
            }
        };
        boolean flag = false;
        for (int l1 = j2; l1 <= i1; ++l1) {
            for (int i22 = l2; i22 <= k1; ++i22) {
                Chunk chunk = this.level.getChunkSource().getChunkNow(l1, i22);
                if (chunk == null) continue;
                for (int j22 = k2; j22 <= j1; ++j22) {
                    flag |= chunk.getListenerRegistry(j22).visitInRangeListeners(holder, vec3d, gameevent_a, gameeventlistenerregistry_a);
                }
            }
        }
        if (!list.isEmpty()) {
            this.handleGameEventMessagesInQueue(list);
        }
        if (flag) {
            PacketDebug.sendGameEventInfo(this.level, holder, vec3d);
        }
    }

    private void handleGameEventMessagesInQueue(List<GameEvent.b> list) {
        Collections.sort(list);
        for (GameEvent.b gameevent_b : list) {
            GameEventListener gameeventlistener = gameevent_b.recipient();
            gameeventlistener.handleGameEvent(this.level, gameevent_b.gameEvent(), gameevent_b.context(), gameevent_b.source());
        }
    }
}

