/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class MobSpawnerPhantom
implements MobSpawner {
    private int nextTick;

    @Override
    public int tick(WorldServer worldserver, boolean flag, boolean flag1) {
        if (!flag) {
            return 0;
        }
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return 0;
        }
        RandomSource randomsource = worldserver.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += (60 + randomsource.nextInt(60)) * 20;
        if (worldserver.getSkyDarken() < 5 && worldserver.dimensionType().hasSkyLight()) {
            return 0;
        }
        int i2 = 0;
        for (EntityPlayer entityplayer : worldserver.players()) {
            Fluid fluid;
            IBlockData iblockdata;
            BlockPosition blockposition1;
            DifficultyDamageScaler difficultydamagescaler;
            if (entityplayer.isSpectator()) continue;
            BlockPosition blockposition = entityplayer.blockPosition();
            if (worldserver.dimensionType().hasSkyLight() && (blockposition.getY() < worldserver.getSeaLevel() || !worldserver.canSeeSky(blockposition)) || !(difficultydamagescaler = worldserver.getCurrentDifficultyAt(blockposition)).isHarderThan(randomsource.nextFloat() * 3.0f)) continue;
            ServerStatisticManager serverstatisticmanager = entityplayer.getStats();
            int j2 = MathHelper.clamp(serverstatisticmanager.getValue(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            boolean flag2 = true;
            if (randomsource.nextInt(j2) < 72000 || !SpawnerCreature.isValidEmptySpawnBlock(worldserver, blockposition1 = blockposition.above(20 + randomsource.nextInt(15)).east(-10 + randomsource.nextInt(21)).south(-10 + randomsource.nextInt(21)), iblockdata = worldserver.getBlockState(blockposition1), fluid = worldserver.getFluidState(blockposition1), EntityTypes.PHANTOM)) continue;
            GroupDataEntity groupdataentity = null;
            int k2 = 1 + randomsource.nextInt(difficultydamagescaler.getDifficulty().getId() + 1);
            for (int l2 = 0; l2 < k2; ++l2) {
                EntityPhantom entityphantom = EntityTypes.PHANTOM.create(worldserver);
                if (entityphantom == null) continue;
                entityphantom.moveTo(blockposition1, 0.0f, 0.0f);
                groupdataentity = entityphantom.finalizeSpawn(worldserver, difficultydamagescaler, EnumMobSpawn.NATURAL, groupdataentity);
                worldserver.addFreshEntityWithPassengers(entityphantom, CreatureSpawnEvent.SpawnReason.NATURAL);
                ++i2;
            }
        }
        return i2;
    }
}

