/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.storage.WorldDataServer;

public record WorldDimensions(Map<ResourceKey<WorldDimension>, WorldDimension> dimensions) {
    public static final MapCodec<WorldDimensions> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.unboundedMap(ResourceKey.codec(Registries.LEVEL_STEM), WorldDimension.CODEC).fieldOf("dimensions").forGetter(WorldDimensions::dimensions)).apply((Applicative)var0, var0.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<WorldDimension>> BUILTIN_ORDER = ImmutableSet.of(WorldDimension.OVERWORLD, WorldDimension.NETHER, WorldDimension.END);
    private static final int VANILLA_DIMENSION_COUNT = BUILTIN_ORDER.size();

    public WorldDimensions {
        WorldDimension var1 = var0.get(WorldDimension.OVERWORLD);
        if (var1 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public WorldDimensions(IRegistry<WorldDimension> var0) {
        this(var0.holders().collect(Collectors.toMap(Holder.c::key, Holder.c::value)));
    }

    public static Stream<ResourceKey<WorldDimension>> keysInOrder(Stream<ResourceKey<WorldDimension>> var02) {
        return Stream.concat(BUILTIN_ORDER.stream(), var02.filter(var0 -> !BUILTIN_ORDER.contains(var0)));
    }

    public WorldDimensions replaceOverworldGenerator(IRegistryCustom var0, ChunkGenerator var1) {
        IRegistry<DimensionManager> var2 = var0.registryOrThrow(Registries.DIMENSION_TYPE);
        Map<ResourceKey<WorldDimension>, WorldDimension> var3 = WorldDimensions.withOverworld(var2, this.dimensions, var1);
        return new WorldDimensions(var3);
    }

    public static Map<ResourceKey<WorldDimension>, WorldDimension> withOverworld(IRegistry<DimensionManager> var0, Map<ResourceKey<WorldDimension>, WorldDimension> var1, ChunkGenerator var2) {
        WorldDimension var3 = var1.get(WorldDimension.OVERWORLD);
        Holder<DimensionManager> var4 = var3 == null ? var0.getHolderOrThrow(BuiltinDimensionTypes.OVERWORLD) : var3.type();
        return WorldDimensions.withOverworld(var1, var4, var2);
    }

    public static Map<ResourceKey<WorldDimension>, WorldDimension> withOverworld(Map<ResourceKey<WorldDimension>, WorldDimension> var0, Holder<DimensionManager> var1, ChunkGenerator var2) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var3.putAll(var0);
        var3.put(WorldDimension.OVERWORLD, (Object)new WorldDimension(var1, var2));
        return var3.buildKeepingLast();
    }

    public ChunkGenerator overworld() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return var0.generator();
    }

    public Optional<WorldDimension> get(ResourceKey<WorldDimension> var0) {
        return Optional.ofNullable(this.dimensions.get(var0));
    }

    public ImmutableSet<ResourceKey<World>> levels() {
        return (ImmutableSet)this.dimensions().keySet().stream().map(Registries::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public boolean isDebug() {
        return this.overworld() instanceof ChunkProviderDebug;
    }

    private static WorldDataServer.a specialWorldProperty(IRegistry<WorldDimension> var02) {
        return var02.getOptional(WorldDimension.OVERWORLD).map(var0 -> {
            ChunkGenerator var1 = var0.generator();
            if (var1 instanceof ChunkProviderDebug) {
                return WorldDataServer.a.DEBUG;
            }
            if (var1 instanceof ChunkProviderFlat) {
                return WorldDataServer.a.FLAT;
            }
            return WorldDataServer.a.NONE;
        }).orElse(WorldDataServer.a.NONE);
    }

    static Lifecycle checkStability(ResourceKey<WorldDimension> var0, WorldDimension var1) {
        return WorldDimensions.isVanillaLike(var0, var1) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean isVanillaLike(ResourceKey<WorldDimension> var0, WorldDimension var1) {
        if (var0 == WorldDimension.OVERWORLD) {
            return WorldDimensions.isStableOverworld(var1);
        }
        if (var0 == WorldDimension.NETHER) {
            return WorldDimensions.isStableNether(var1);
        }
        if (var0 == WorldDimension.END) {
            return WorldDimensions.isStableEnd(var1);
        }
        return false;
    }

    private static boolean isStableOverworld(WorldDimension var0) {
        WorldChunkManagerMultiNoise var2;
        Holder<DimensionManager> var1 = var0.type();
        if (!var1.is(BuiltinDimensionTypes.OVERWORLD) && !var1.is(BuiltinDimensionTypes.OVERWORLD_CAVES)) {
            return false;
        }
        WorldChunkManager worldChunkManager = var0.generator().getBiomeSource();
        return !(worldChunkManager instanceof WorldChunkManagerMultiNoise) || (var2 = (WorldChunkManagerMultiNoise)worldChunkManager).stable(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
    }

    private static boolean isStableNether(WorldDimension var0) {
        WorldChunkManagerMultiNoise var1;
        ChunkGeneratorAbstract var2;
        Object object;
        return var0.type().is(BuiltinDimensionTypes.NETHER) && (object = var0.generator()) instanceof ChunkGeneratorAbstract && (var2 = (ChunkGeneratorAbstract)object).stable(GeneratorSettingBase.NETHER) && (object = var2.getBiomeSource()) instanceof WorldChunkManagerMultiNoise && (var1 = (WorldChunkManagerMultiNoise)object).stable(MultiNoiseBiomeSourceParameterLists.NETHER);
    }

    private static boolean isStableEnd(WorldDimension var0) {
        ChunkGeneratorAbstract var1;
        ChunkGenerator chunkGenerator;
        return var0.type().is(BuiltinDimensionTypes.END) && (chunkGenerator = var0.generator()) instanceof ChunkGeneratorAbstract && (var1 = (ChunkGeneratorAbstract)chunkGenerator).stable(GeneratorSettingBase.END) && var1.getBiomeSource() instanceof WorldChunkManagerTheEnd;
    }

    public b bake(IRegistry<WorldDimension> var0) {
        final class A
        extends Record {
            final ResourceKey<WorldDimension> key;
            final WorldDimension value;

            A(ResourceKey<WorldDimension> var0, WorldDimension var1) {
                this.key = var0;
                this.value = var1;
            }

            RegistrationInfo registrationInfo() {
                return new RegistrationInfo(Optional.empty(), WorldDimensions.checkStability(this.key, this.value));
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "key;value", "key", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "key;value", "key", "value"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "key;value", "key", "value"}, this, var0);
            }

            public ResourceKey<WorldDimension> key() {
                return this.key;
            }

            public WorldDimension value() {
                return this.value;
            }
        }
        Stream<ResourceKey<WorldDimension>> var12 = Stream.concat(var0.registryKeySet().stream(), this.dimensions.keySet().stream()).distinct();
        ArrayList var2 = new ArrayList();
        WorldDimensions.keysInOrder(var12).forEach(var22 -> var0.getOptional((ResourceKey<WorldDimension>)var22).or(() -> Optional.ofNullable(this.dimensions.get(var22))).ifPresent(var2 -> var2.add(new A((ResourceKey<WorldDimension>)var22, (WorldDimension)var2))));
        Lifecycle var3 = var2.size() == VANILLA_DIMENSION_COUNT ? Lifecycle.stable() : Lifecycle.experimental();
        RegistryMaterials<WorldDimension> var4 = new RegistryMaterials<WorldDimension>(Registries.LEVEL_STEM, var3);
        var2.forEach(var1 -> var4.register(var1.key, var1.value, var1.registrationInfo()));
        IRegistry<WorldDimension> var5 = var4.freeze();
        WorldDataServer.a var6 = WorldDimensions.specialWorldProperty(var5);
        return new b(var5.freeze(), var6);
    }

    public record b(IRegistry<WorldDimension> dimensions, WorldDataServer.a specialWorldProperty) {
        public Lifecycle lifecycle() {
            return this.dimensions.registryLifecycle();
        }

        public IRegistryCustom.Dimension dimensionsRegistryAccess() {
            return new IRegistryCustom.c(List.of(this.dimensions)).freeze();
        }
    }
}

