/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;

public class DripstoneUtils {
    protected static double getDripstoneHeight(double var0, double var2, double var4, double var6) {
        if (var0 < var6) {
            var0 = var6;
        }
        double var8 = 0.384;
        double var10 = var0 / var2 * 0.384;
        double var12 = 0.75 * Math.pow(var10, 1.3333333333333333);
        double var14 = Math.pow(var10, 0.6666666666666666);
        double var16 = 0.3333333333333333 * Math.log(var10);
        double var18 = var4 * (var12 - var14 - var16);
        var18 = Math.max(var18, 0.0);
        return var18 / 0.384 * var2;
    }

    protected static boolean isCircleMostlyEmbeddedInStone(GeneratorAccessSeed var0, BlockPosition var1, int var2) {
        if (DripstoneUtils.isEmptyOrWaterOrLava(var0, var1)) {
            return false;
        }
        float var3 = 6.0f;
        float var4 = 6.0f / (float)var2;
        for (float var5 = 0.0f; var5 < (float)Math.PI * 2; var5 += var4) {
            int var7;
            int var6 = (int)(MathHelper.cos(var5) * (float)var2);
            if (!DripstoneUtils.isEmptyOrWaterOrLava(var0, var1.offset(var6, 0, var7 = (int)(MathHelper.sin(var5) * (float)var2)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isEmptyOrWater(GeneratorAccess var0, BlockPosition var1) {
        return var0.isStateAtPosition(var1, DripstoneUtils::isEmptyOrWater);
    }

    protected static boolean isEmptyOrWaterOrLava(GeneratorAccess var0, BlockPosition var1) {
        return var0.isStateAtPosition(var1, DripstoneUtils::isEmptyOrWaterOrLava);
    }

    protected static void buildBaseToTipColumn(EnumDirection var0, int var1, boolean var2, Consumer<IBlockData> var3) {
        if (var1 >= 3) {
            var3.accept(DripstoneUtils.createPointedDripstone(var0, DripstoneThickness.BASE));
            for (int var4 = 0; var4 < var1 - 3; ++var4) {
                var3.accept(DripstoneUtils.createPointedDripstone(var0, DripstoneThickness.MIDDLE));
            }
        }
        if (var1 >= 2) {
            var3.accept(DripstoneUtils.createPointedDripstone(var0, DripstoneThickness.FRUSTUM));
        }
        if (var1 >= 1) {
            var3.accept(DripstoneUtils.createPointedDripstone(var0, var2 ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void growPointedDripstone(GeneratorAccess var0, BlockPosition var1, EnumDirection var2, int var32, boolean var4) {
        if (!DripstoneUtils.isDripstoneBase(var0.getBlockState(var1.relative(var2.getOpposite())))) {
            return;
        }
        BlockPosition.MutableBlockPosition var5 = var1.mutable();
        DripstoneUtils.buildBaseToTipColumn(var2, var32, var4, var3 -> {
            if (var3.is(Blocks.POINTED_DRIPSTONE)) {
                var3 = (IBlockData)var3.setValue(PointedDripstoneBlock.WATERLOGGED, var0.isWaterAt(var5));
            }
            var0.setBlock(var5, (IBlockData)var3, 2);
            var5.move(var2);
        });
    }

    protected static boolean placeDripstoneBlockIfPossible(GeneratorAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.is(TagsBlock.DRIPSTONE_REPLACEABLE)) {
            var0.setBlock(var1, Blocks.DRIPSTONE_BLOCK.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    private static IBlockData createPointedDripstone(EnumDirection var0, DripstoneThickness var1) {
        return (IBlockData)((IBlockData)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue(PointedDripstoneBlock.TIP_DIRECTION, var0)).setValue(PointedDripstoneBlock.THICKNESS, var1);
    }

    public static boolean isDripstoneBaseOrLava(IBlockData var0) {
        return DripstoneUtils.isDripstoneBase(var0) || var0.is(Blocks.LAVA);
    }

    public static boolean isDripstoneBase(IBlockData var0) {
        return var0.is(Blocks.DRIPSTONE_BLOCK) || var0.is(TagsBlock.DRIPSTONE_REPLACEABLE);
    }

    public static boolean isEmptyOrWater(IBlockData var0) {
        return var0.isAir() || var0.is(Blocks.WATER);
    }

    public static boolean isNeitherEmptyNorWater(IBlockData var0) {
        return !var0.isAir() && !var0.is(Blocks.WATER);
    }

    public static boolean isEmptyOrWaterOrLava(IBlockData var0) {
        return var0.isAir() || var0.is(Blocks.WATER) || var0.is(Blocks.LAVA);
    }
}

