/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBasaltColumnsConfiguration;

public class WorldGenFeatureBasaltColumns
extends WorldGenerator<WorldGenFeatureBasaltColumnsConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.LAVA, (Object)Blocks.BEDROCK, (Object)Blocks.MAGMA_BLOCK, (Object)Blocks.SOUL_SAND, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final int CLUSTERED_REACH = 5;
    private static final int CLUSTERED_SIZE = 50;
    private static final int UNCLUSTERED_REACH = 8;
    private static final int UNCLUSTERED_SIZE = 15;

    public WorldGenFeatureBasaltColumns(Codec<WorldGenFeatureBasaltColumnsConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureBasaltColumnsConfiguration> var0) {
        int var1 = var0.chunkGenerator().getSeaLevel();
        BlockPosition var2 = var0.origin();
        GeneratorAccessSeed var3 = var0.level();
        RandomSource var4 = var0.random();
        WorldGenFeatureBasaltColumnsConfiguration var5 = var0.config();
        if (!WorldGenFeatureBasaltColumns.canPlaceAt(var3, var1, var2.mutable())) {
            return false;
        }
        int var6 = var5.height().sample(var4);
        boolean var7 = var4.nextFloat() < 0.9f;
        int var8 = Math.min(var6, var7 ? 5 : 8);
        int var9 = var7 ? 50 : 15;
        boolean var10 = false;
        for (BlockPosition var12 : BlockPosition.randomBetweenClosed(var4, var9, var2.getX() - var8, var2.getY(), var2.getZ() - var8, var2.getX() + var8, var2.getY(), var2.getZ() + var8)) {
            int var13 = var6 - var12.distManhattan(var2);
            if (var13 < 0) continue;
            var10 |= this.placeColumn(var3, var1, var12, var13, var5.reach().sample(var4));
        }
        return var10;
    }

    private boolean placeColumn(GeneratorAccess var0, int var1, BlockPosition var2, int var3, int var4) {
        boolean var5 = false;
        block0: for (BlockPosition var7 : BlockPosition.betweenClosed(var2.getX() - var4, var2.getY(), var2.getZ() - var4, var2.getX() + var4, var2.getY(), var2.getZ() + var4)) {
            BlockPosition var9;
            int var8 = var7.distManhattan(var2);
            BlockPosition blockPosition = var9 = WorldGenFeatureBasaltColumns.isAirOrLavaOcean(var0, var1, var7) ? WorldGenFeatureBasaltColumns.findSurface(var0, var1, var7.mutable(), var8) : WorldGenFeatureBasaltColumns.findAir(var0, var7.mutable(), var8);
            if (var9 == null) continue;
            BlockPosition.MutableBlockPosition var11 = var9.mutable();
            for (int var10 = var3 - var8 / 2; var10 >= 0; --var10) {
                if (WorldGenFeatureBasaltColumns.isAirOrLavaOcean(var0, var1, var11)) {
                    this.setBlock(var0, var11, Blocks.BASALT.defaultBlockState());
                    var11.move(EnumDirection.UP);
                    var5 = true;
                    continue;
                }
                if (!var0.getBlockState(var11).is(Blocks.BASALT)) continue block0;
                var11.move(EnumDirection.UP);
            }
        }
        return var5;
    }

    @Nullable
    private static BlockPosition findSurface(GeneratorAccess var0, int var1, BlockPosition.MutableBlockPosition var2, int var3) {
        while (var2.getY() > var0.getMinBuildHeight() + 1 && var3 > 0) {
            --var3;
            if (WorldGenFeatureBasaltColumns.canPlaceAt(var0, var1, var2)) {
                return var2;
            }
            var2.move(EnumDirection.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(GeneratorAccess var0, int var1, BlockPosition.MutableBlockPosition var2) {
        if (WorldGenFeatureBasaltColumns.isAirOrLavaOcean(var0, var1, var2)) {
            IBlockData var3 = var0.getBlockState(var2.move(EnumDirection.DOWN));
            var2.move(EnumDirection.UP);
            return !var3.isAir() && !CANNOT_PLACE_ON.contains((Object)var3.getBlock());
        }
        return false;
    }

    @Nullable
    private static BlockPosition findAir(GeneratorAccess var0, BlockPosition.MutableBlockPosition var1, int var2) {
        while (var1.getY() < var0.getMaxBuildHeight() && var2 > 0) {
            --var2;
            IBlockData var3 = var0.getBlockState(var1);
            if (CANNOT_PLACE_ON.contains((Object)var3.getBlock())) {
                return null;
            }
            if (var3.isAir()) {
                return var1;
            }
            var1.move(EnumDirection.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(GeneratorAccess var0, int var1, BlockPosition var2) {
        IBlockData var3 = var0.getBlockState(var2);
        return var3.isAir() || var3.is(Blocks.LAVA) && var2.getY() <= var1;
    }
}

