/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;

public class WorldGenFeatureTwistingVines
extends WorldGenerator<TwistingVinesConfig> {
    public WorldGenFeatureTwistingVines(Codec<TwistingVinesConfig> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<TwistingVinesConfig> var0) {
        BlockPosition var2;
        GeneratorAccessSeed var1 = var0.level();
        if (WorldGenFeatureTwistingVines.isInvalidPlacementLocation(var1, var2 = var0.origin())) {
            return false;
        }
        RandomSource var3 = var0.random();
        TwistingVinesConfig var4 = var0.config();
        int var5 = var4.spreadWidth();
        int var6 = var4.spreadHeight();
        int var7 = var4.maxHeight();
        BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
        for (int var9 = 0; var9 < var5 * var5; ++var9) {
            var8.set(var2).move(MathHelper.nextInt(var3, -var5, var5), MathHelper.nextInt(var3, -var6, var6), MathHelper.nextInt(var3, -var5, var5));
            if (!WorldGenFeatureTwistingVines.findFirstAirBlockAboveGround(var1, var8) || WorldGenFeatureTwistingVines.isInvalidPlacementLocation(var1, var8)) continue;
            int var10 = MathHelper.nextInt(var3, 1, var7);
            if (var3.nextInt(6) == 0) {
                var10 *= 2;
            }
            if (var3.nextInt(5) == 0) {
                var10 = 1;
            }
            int var11 = 17;
            int var12 = 25;
            WorldGenFeatureTwistingVines.placeWeepingVinesColumn(var1, var3, var8, var10, 17, 25);
        }
        return true;
    }

    private static boolean findFirstAirBlockAboveGround(GeneratorAccess var0, BlockPosition.MutableBlockPosition var1) {
        do {
            var1.move(0, -1, 0);
            if (!var0.isOutsideBuildHeight(var1)) continue;
            return false;
        } while (var0.getBlockState(var1).isAir());
        var1.move(0, 1, 0);
        return true;
    }

    public static void placeWeepingVinesColumn(GeneratorAccess var0, RandomSource var1, BlockPosition.MutableBlockPosition var2, int var3, int var4, int var5) {
        for (int var6 = 1; var6 <= var3; ++var6) {
            if (var0.isEmptyBlock(var2)) {
                if (var6 == var3 || !var0.isEmptyBlock((BlockPosition)var2.above())) {
                    var0.setBlock(var2, (IBlockData)Blocks.TWISTING_VINES.defaultBlockState().setValue(BlockGrowingTop.AGE, MathHelper.nextInt(var1, var4, var5)), 2);
                    break;
                }
                var0.setBlock(var2, Blocks.TWISTING_VINES_PLANT.defaultBlockState(), 2);
            }
            var2.move(EnumDirection.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(GeneratorAccess var0, BlockPosition var1) {
        if (!var0.isEmptyBlock(var1)) {
            return true;
        }
        IBlockData var2 = var0.getBlockState(var1.below());
        return !var2.is(Blocks.NETHERRACK) && !var2.is(Blocks.WARPED_NYLIUM) && !var2.is(Blocks.WARPED_WART_BLOCK);
    }
}

