/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public class WorldGenPackedIce2
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenPackedIce2(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        int var8;
        int var6;
        BlockPosition var1 = var0.origin();
        RandomSource var2 = var0.random();
        GeneratorAccessSeed var3 = var0.level();
        while (var3.isEmptyBlock(var1) && var1.getY() > var3.getMinBuildHeight() + 2) {
            var1 = var1.below();
        }
        if (!var3.getBlockState(var1).is(Blocks.SNOW_BLOCK)) {
            return false;
        }
        var1 = var1.above(var2.nextInt(4));
        int var4 = var2.nextInt(4) + 7;
        int var5 = var4 / 4 + var2.nextInt(2);
        if (var5 > 1 && var2.nextInt(60) == 0) {
            var1 = var1.above(10 + var2.nextInt(30));
        }
        for (var6 = 0; var6 < var4; ++var6) {
            float var7 = (1.0f - (float)var6 / (float)var4) * (float)var5;
            var8 = MathHelper.ceil(var7);
            for (int var9 = -var8; var9 <= var8; ++var9) {
                float var10 = (float)MathHelper.abs(var9) - 0.25f;
                for (int var11 = -var8; var11 <= var8; ++var11) {
                    float var12 = (float)MathHelper.abs(var11) - 0.25f;
                    if ((var9 != 0 || var11 != 0) && var10 * var10 + var12 * var12 > var7 * var7 || (var9 == -var8 || var9 == var8 || var11 == -var8 || var11 == var8) && var2.nextFloat() > 0.75f) continue;
                    IBlockData var13 = var3.getBlockState(var1.offset(var9, var6, var11));
                    if (var13.isAir() || WorldGenPackedIce2.isDirt(var13) || var13.is(Blocks.SNOW_BLOCK) || var13.is(Blocks.ICE)) {
                        this.setBlock(var3, var1.offset(var9, var6, var11), Blocks.PACKED_ICE.defaultBlockState());
                    }
                    if (var6 == 0 || var8 <= 1 || !(var13 = var3.getBlockState(var1.offset(var9, -var6, var11))).isAir() && !WorldGenPackedIce2.isDirt(var13) && !var13.is(Blocks.SNOW_BLOCK) && !var13.is(Blocks.ICE)) continue;
                    this.setBlock(var3, var1.offset(var9, -var6, var11), Blocks.PACKED_ICE.defaultBlockState());
                }
            }
        }
        var6 = var5 - 1;
        if (var6 < 0) {
            var6 = 0;
        } else if (var6 > 1) {
            var6 = 1;
        }
        for (int var7 = -var6; var7 <= var6; ++var7) {
            for (var8 = -var6; var8 <= var6; ++var8) {
                IBlockData var11;
                BlockPosition var9 = var1.offset(var7, -1, var8);
                int var10 = 50;
                if (Math.abs(var7) == 1 && Math.abs(var8) == 1) {
                    var10 = var2.nextInt(5);
                }
                while (var9.getY() > 50 && ((var11 = var3.getBlockState(var9)).isAir() || WorldGenPackedIce2.isDirt(var11) || var11.is(Blocks.SNOW_BLOCK) || var11.is(Blocks.ICE) || var11.is(Blocks.PACKED_ICE))) {
                    this.setBlock(var3, var9, Blocks.PACKED_ICE.defaultBlockState());
                    var9 = var9.below();
                    if (--var10 > 0) continue;
                    var9 = var9.below(var2.nextInt(5) + 1);
                    var10 = var2.nextInt(5);
                }
            }
        }
        return true;
    }
}

