/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> CURRENT_TO_LEGACY_MAP = SystemUtils.make(Maps.newHashMap(), hashmap -> {
        hashmap.put("Village", "Village");
        hashmap.put("Mineshaft", "Mineshaft");
        hashmap.put("Mansion", "Mansion");
        hashmap.put("Igloo", "Temple");
        hashmap.put("Desert_Pyramid", "Temple");
        hashmap.put("Jungle_Pyramid", "Temple");
        hashmap.put("Swamp_Hut", "Temple");
        hashmap.put("Stronghold", "Stronghold");
        hashmap.put("Monument", "Monument");
        hashmap.put("Fortress", "Fortress");
        hashmap.put("EndCity", "EndCity");
    });
    private static final Map<String, String> LEGACY_TO_CURRENT_MAP = SystemUtils.make(Maps.newHashMap(), hashmap -> {
        hashmap.put("Iglu", "Igloo");
        hashmap.put("TeDP", "Desert_Pyramid");
        hashmap.put("TeJP", "Jungle_Pyramid");
        hashmap.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> OLD_STRUCTURE_REGISTRY_KEYS = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean hasLegacyData;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> dataMap = Maps.newHashMap();
    private final Map<String, PersistentIndexed> indexMap = Maps.newHashMap();
    private final List<String> legacyKeys;
    private final List<String> currentKeys;

    public PersistentStructureLegacy(@Nullable WorldPersistentData worldpersistentdata, List<String> list, List<String> list1) {
        this.legacyKeys = list;
        this.currentKeys = list1;
        this.populateCaches(worldpersistentdata);
        boolean flag = false;
        for (String s2 : this.currentKeys) {
            flag |= this.dataMap.get(s2) != null;
        }
        this.hasLegacyData = flag;
    }

    public void removeIndex(long i2) {
        for (String s2 : this.legacyKeys) {
            PersistentIndexed persistentindexed = this.indexMap.get(s2);
            if (persistentindexed == null || !persistentindexed.hasUnhandledIndex(i2)) continue;
            persistentindexed.removeIndex(i2);
            persistentindexed.setDirty();
        }
    }

    public NBTTagCompound updateFromLegacy(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Level");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound1.getInt("xPos"), nbttagcompound1.getInt("zPos"));
        if (this.isUnhandledStructureStart(chunkcoordintpair.x, chunkcoordintpair.z)) {
            nbttagcompound = this.updateStructureStart(nbttagcompound, chunkcoordintpair);
        }
        NBTTagCompound nbttagcompound2 = nbttagcompound1.getCompound("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.getCompound("References");
        for (String s2 : this.currentKeys) {
            boolean flag = OLD_STRUCTURE_REGISTRY_KEYS.contains(s2.toLowerCase(Locale.ROOT));
            if (nbttagcompound3.contains(s2, 12) || !flag) continue;
            boolean flag1 = true;
            LongArrayList longarraylist = new LongArrayList();
            for (int i2 = chunkcoordintpair.x - 8; i2 <= chunkcoordintpair.x + 8; ++i2) {
                for (int j2 = chunkcoordintpair.z - 8; j2 <= chunkcoordintpair.z + 8; ++j2) {
                    if (!this.hasLegacyStart(i2, j2, s2)) continue;
                    longarraylist.add(ChunkCoordIntPair.asLong(i2, j2));
                }
            }
            nbttagcompound3.putLongArray(s2, (List<Long>)longarraylist);
        }
        nbttagcompound2.put("References", nbttagcompound3);
        nbttagcompound1.put("Structures", nbttagcompound2);
        nbttagcompound.put("Level", nbttagcompound1);
        return nbttagcompound;
    }

    private boolean hasLegacyStart(int i2, int j2, String s2) {
        return !this.hasLegacyData ? false : this.dataMap.get(s2) != null && this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s2)).hasStartIndex(ChunkCoordIntPair.asLong(i2, j2));
    }

    private boolean isUnhandledStructureStart(int i2, int j2) {
        String s2;
        if (!this.hasLegacyData) {
            return false;
        }
        Iterator<String> iterator = this.currentKeys.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (this.dataMap.get(s2 = iterator.next()) == null || !this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s2)).hasUnhandledIndex(ChunkCoordIntPair.asLong(i2, j2)));
        return true;
    }

    private NBTTagCompound updateStructureStart(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound("Level");
        NBTTagCompound nbttagcompound2 = nbttagcompound1.getCompound("Structures");
        NBTTagCompound nbttagcompound3 = nbttagcompound2.getCompound("Starts");
        for (String s2 : this.currentKeys) {
            NBTTagCompound nbttagcompound4;
            Long2ObjectMap<NBTTagCompound> long2objectmap = this.dataMap.get(s2);
            if (long2objectmap == null) continue;
            long i2 = chunkcoordintpair.toLong();
            if (!this.indexMap.get(CURRENT_TO_LEGACY_MAP.get(s2)).hasUnhandledIndex(i2) || (nbttagcompound4 = (NBTTagCompound)long2objectmap.get(i2)) == null) continue;
            nbttagcompound3.put(s2, nbttagcompound4);
        }
        nbttagcompound2.put("Starts", nbttagcompound3);
        nbttagcompound1.put("Structures", nbttagcompound2);
        nbttagcompound.put("Level", nbttagcompound1);
        return nbttagcompound;
    }

    private void populateCaches(@Nullable WorldPersistentData worldpersistentdata) {
        if (worldpersistentdata != null) {
            for (String s2 : this.legacyKeys) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    nbttagcompound = worldpersistentdata.readTagFromDisk(s2, DataFixTypes.SAVED_DATA_STRUCTURE_FEATURE_INDICES, 1493).getCompound("data").getCompound("Features");
                    if (nbttagcompound.isEmpty()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (String s1 : nbttagcompound.getAllKeys()) {
                    String s22;
                    String s3;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound(s1);
                    long i2 = ChunkCoordIntPair.asLong(nbttagcompound1.getInt("ChunkX"), nbttagcompound1.getInt("ChunkZ"));
                    NBTTagList nbttaglist = nbttagcompound1.getList("Children", 10);
                    if (!nbttaglist.isEmpty() && (s3 = LEGACY_TO_CURRENT_MAP.get(s22 = nbttaglist.getCompound(0).getString("id"))) != null) {
                        nbttagcompound1.putString("id", s3);
                    }
                    s22 = nbttagcompound1.getString("id");
                    this.dataMap.computeIfAbsent(s22, s4 -> new Long2ObjectOpenHashMap()).put(i2, (Object)nbttagcompound1);
                }
                String s42 = s2 + "_index";
                PersistentIndexed persistentindexed = worldpersistentdata.computeIfAbsent(PersistentIndexed.factory(), s42);
                if (!persistentindexed.getAll().isEmpty()) {
                    this.indexMap.put(s2, persistentindexed);
                    continue;
                }
                PersistentIndexed persistentindexed1 = new PersistentIndexed();
                this.indexMap.put(s2, persistentindexed1);
                for (String s5 : nbttagcompound.getAllKeys()) {
                    NBTTagCompound nbttagcompound2 = nbttagcompound.getCompound(s5);
                    persistentindexed1.addIndex(ChunkCoordIntPair.asLong(nbttagcompound2.getInt("ChunkX"), nbttagcompound2.getInt("ChunkZ")));
                }
                persistentindexed1.setDirty();
            }
        }
    }

    public static PersistentStructureLegacy getLegacyStructureHandler(ResourceKey<WorldDimension> resourcekey, @Nullable WorldPersistentData worldpersistentdata) {
        if (resourcekey == WorldDimension.OVERWORLD) {
            return new PersistentStructureLegacy(worldpersistentdata, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (resourcekey == WorldDimension.NETHER) {
            ImmutableList immutablelist = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(worldpersistentdata, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        if (resourcekey == WorldDimension.END) {
            ImmutableList immutablelist = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(worldpersistentdata, (List<String>)immutablelist, (List<String>)immutablelist);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", resourcekey));
    }
}

