/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R1.util.TransformerGeneratorAccess;
import org.bukkit.entity.EntityType;
import org.slf4j.Logger;

public abstract class StructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final IBlockData CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected StructureBoundingBox boundingBox;
    @Nullable
    private EnumDirection orientation;
    private EnumBlockMirror mirror;
    private EnumBlockRotation rotation;
    protected int genDepth;
    private final WorldGenFeatureStructurePieceType type;
    public static final Set<Block> SHAPE_CHECK_BLOCKS = ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.IRON_BARS).build();

    protected StructurePiece(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, StructureBoundingBox structureboundingbox) {
        this.type = worldgenfeaturestructurepiecetype;
        this.genDepth = i2;
        this.boundingBox = structureboundingbox;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
        this(worldgenfeaturestructurepiecetype, nbttagcompound.getInt("GD"), (StructureBoundingBox)StructureBoundingBox.CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get("BB")).getOrThrow(s2 -> new IllegalArgumentException("Invalid boundingbox: " + s2)));
        int i2 = nbttagcompound.getInt("O");
        this.setOrientation(i2 == -1 ? null : EnumDirection.from2DDataValue(i2));
    }

    protected static StructureBoundingBox makeBoundingBox(int i2, int j2, int k2, EnumDirection enumdirection, int l2, int i1, int j1) {
        return enumdirection.getAxis() == EnumDirection.EnumAxis.Z ? new StructureBoundingBox(i2, j2, k2, i2 + l2 - 1, j2 + i1 - 1, k2 + j1 - 1) : new StructureBoundingBox(i2, j2, k2, i2 + j1 - 1, j2 + i1 - 1, k2 + l2 - 1);
    }

    protected static EnumDirection getRandomHorizontalDirection(RandomSource randomsource) {
        return EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(randomsource);
    }

    public final NBTTagCompound createTag(StructurePieceSerializationContext structurepieceserializationcontext) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.putString("id", BuiltInRegistries.STRUCTURE_PIECE.getKey(this.getType()).toString());
        StructureBoundingBox.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.boundingBox).resultOrPartial(arg_0 -> ((Logger)Objects.requireNonNull(LOGGER)).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("BB", (NBTBase)nbtbase));
        EnumDirection enumdirection = this.getOrientation();
        nbttagcompound.putInt("O", enumdirection == null ? -1 : enumdirection.get2DDataValue());
        nbttagcompound.putInt("GD", this.genDepth);
        this.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
        return nbttagcompound;
    }

    protected abstract void addAdditionalSaveData(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
    }

    public abstract void postProcess(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getGenDepth() {
        return this.genDepth;
    }

    public void setGenDepth(int i2) {
        this.genDepth = i2;
    }

    public boolean isCloseToChunk(ChunkCoordIntPair chunkcoordintpair, int i2) {
        int j2 = chunkcoordintpair.getMinBlockX();
        int k2 = chunkcoordintpair.getMinBlockZ();
        return this.boundingBox.intersects(j2 - i2, k2 - i2, j2 + 15 + i2, k2 + 15 + i2);
    }

    public BlockPosition getLocatorPosition() {
        return new BlockPosition(this.boundingBox.getCenter());
    }

    protected BlockPosition.MutableBlockPosition getWorldPos(int i2, int j2, int k2) {
        return new BlockPosition.MutableBlockPosition(this.getWorldX(i2, k2), this.getWorldY(j2), this.getWorldZ(i2, k2));
    }

    protected int getWorldX(int i2, int j2) {
        EnumDirection enumdirection = this.getOrientation();
        if (enumdirection == null) {
            return i2;
        }
        switch (enumdirection) {
            case NORTH: 
            case SOUTH: {
                return this.boundingBox.minX() + i2;
            }
            case WEST: {
                return this.boundingBox.maxX() - j2;
            }
            case EAST: {
                return this.boundingBox.minX() + j2;
            }
        }
        return i2;
    }

    protected int getWorldY(int i2) {
        return this.getOrientation() == null ? i2 : i2 + this.boundingBox.minY();
    }

    protected int getWorldZ(int i2, int j2) {
        EnumDirection enumdirection = this.getOrientation();
        if (enumdirection == null) {
            return j2;
        }
        switch (enumdirection) {
            case NORTH: {
                return this.boundingBox.maxZ() - j2;
            }
            case SOUTH: {
                return this.boundingBox.minZ() + j2;
            }
            case WEST: 
            case EAST: {
                return this.boundingBox.minZ() + i2;
            }
        }
        return j2;
    }

    protected void placeBlock(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
        if (structureboundingbox.isInside(blockposition_mutableblockposition) && this.canBeReplaced(generatoraccessseed, i2, j2, k2, structureboundingbox)) {
            if (this.mirror != EnumBlockMirror.NONE) {
                iblockdata = iblockdata.mirror(this.mirror);
            }
            if (this.rotation != EnumBlockRotation.NONE) {
                iblockdata = iblockdata.rotate(this.rotation);
            }
            generatoraccessseed.setBlock(blockposition_mutableblockposition, iblockdata, 2);
            if (generatoraccessseed instanceof TransformerGeneratorAccess) {
                return;
            }
            Fluid fluid = generatoraccessseed.getFluidState(blockposition_mutableblockposition);
            if (!fluid.isEmpty()) {
                generatoraccessseed.scheduleTick((BlockPosition)blockposition_mutableblockposition, fluid.getType(), 0);
            }
            if (SHAPE_CHECK_BLOCKS.contains(iblockdata.getBlock())) {
                generatoraccessseed.getChunk(blockposition_mutableblockposition).markPosForPostprocessing(blockposition_mutableblockposition);
            }
        }
    }

    protected boolean placeCraftBlockEntity(WorldAccess worldAccess, BlockPosition position, CraftBlockEntityState<?> craftBlockEntityState, int i2) {
        if (worldAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
            return transformerAccess.setCraftBlock(position, craftBlockEntityState, i2);
        }
        boolean result = worldAccess.setBlock(position, craftBlockEntityState.getHandle(), i2);
        TileEntity tileEntity = worldAccess.getBlockEntity(position);
        if (tileEntity != null) {
            tileEntity.loadWithComponents(craftBlockEntityState.getSnapshotNBT(), worldAccess.registryAccess());
        }
        return result;
    }

    protected void placeCraftSpawner(WorldAccess worldAccess, BlockPosition position, EntityType entityType, int i2) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)CraftBlockStates.getBlockState((IWorldReader)worldAccess, position, Blocks.SPAWNER.defaultBlockState(), null);
        spawner.setSpawnedType(entityType);
        this.placeCraftBlockEntity(worldAccess, position, spawner, i2);
    }

    protected void setCraftLootTable(WorldAccess worldAccess, BlockPosition position, RandomSource randomSource, ResourceKey<LootTable> loottableKey) {
        TileEntity tileEntity = worldAccess.getBlockEntity(position);
        if (tileEntity instanceof TileEntityLootable) {
            TileEntityLootable tileEntityLootable = (TileEntityLootable)tileEntity;
            tileEntityLootable.setLootTable(loottableKey, randomSource.nextLong());
            if (worldAccess instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
                transformerAccess.setCraftBlock(position, (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)worldAccess, position, tileEntity.getBlockState(), tileEntityLootable.saveWithFullMetadata(worldAccess.registryAccess())), 3);
            }
        }
    }

    protected boolean canBeReplaced(IWorldReader iworldreader, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        return true;
    }

    protected IBlockData getBlock(IBlockAccess iblockaccess, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
        return !structureboundingbox.isInside(blockposition_mutableblockposition) ? Blocks.AIR.defaultBlockState() : iblockaccess.getBlockState(blockposition_mutableblockposition);
    }

    protected boolean isInterior(IWorldReader iworldreader, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2 + 1, k2);
        return !structureboundingbox.isInside(blockposition_mutableblockposition) ? false : blockposition_mutableblockposition.getY() < iworldreader.getHeight(HeightMap.Type.OCEAN_FLOOR_WG, blockposition_mutableblockposition.getX(), blockposition_mutableblockposition.getZ());
    }

    protected void generateAirBox(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    this.placeBlock(generatoraccessseed, Blocks.AIR.defaultBlockState(), l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void generateBox(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1, IBlockData iblockdata, IBlockData iblockdata1, boolean flag) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    if (flag && this.getBlock(generatoraccessseed, l1, k1, i22, structureboundingbox).isAir()) continue;
                    if (k1 != j2 && k1 != i1 && l1 != i2 && l1 != l2 && i22 != k2 && i22 != j1) {
                        this.placeBlock(generatoraccessseed, iblockdata1, l1, k1, i22, structureboundingbox);
                        continue;
                    }
                    this.placeBlock(generatoraccessseed, iblockdata, l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void generateBox(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, StructureBoundingBox structureboundingbox1, IBlockData iblockdata, IBlockData iblockdata1, boolean flag) {
        this.generateBox(generatoraccessseed, structureboundingbox, structureboundingbox1.minX(), structureboundingbox1.minY(), structureboundingbox1.minZ(), structureboundingbox1.maxX(), structureboundingbox1.maxY(), structureboundingbox1.maxZ(), iblockdata, iblockdata1, flag);
    }

    protected void generateBox(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1, boolean flag, RandomSource randomsource, StructurePieceBlockSelector structurepiece_structurepieceblockselector) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    if (flag && this.getBlock(generatoraccessseed, l1, k1, i22, structureboundingbox).isAir()) continue;
                    structurepiece_structurepieceblockselector.next(randomsource, l1, k1, i22, k1 == j2 || k1 == i1 || l1 == i2 || l1 == l2 || i22 == k2 || i22 == j1);
                    this.placeBlock(generatoraccessseed, structurepiece_structurepieceblockselector.getNext(), l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void generateBox(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, StructureBoundingBox structureboundingbox1, boolean flag, RandomSource randomsource, StructurePieceBlockSelector structurepiece_structurepieceblockselector) {
        this.generateBox(generatoraccessseed, structureboundingbox, structureboundingbox1.minX(), structureboundingbox1.minY(), structureboundingbox1.minZ(), structureboundingbox1.maxX(), structureboundingbox1.maxY(), structureboundingbox1.maxZ(), flag, randomsource, structurepiece_structurepieceblockselector);
    }

    protected void generateMaybeBox(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, float f2, int i2, int j2, int k2, int l2, int i1, int j1, IBlockData iblockdata, IBlockData iblockdata1, boolean flag, boolean flag1) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    if (!(randomsource.nextFloat() <= f2) || flag && this.getBlock(generatoraccessseed, l1, k1, i22, structureboundingbox).isAir() || flag1 && !this.isInterior(generatoraccessseed, l1, k1, i22, structureboundingbox)) continue;
                    if (k1 != j2 && k1 != i1 && l1 != i2 && l1 != l2 && i22 != k2 && i22 != j1) {
                        this.placeBlock(generatoraccessseed, iblockdata1, l1, k1, i22, structureboundingbox);
                        continue;
                    }
                    this.placeBlock(generatoraccessseed, iblockdata, l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void maybeGenerateBlock(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, float f2, int i2, int j2, int k2, IBlockData iblockdata) {
        if (randomsource.nextFloat() < f2) {
            this.placeBlock(generatoraccessseed, iblockdata, i2, j2, k2, structureboundingbox);
        }
    }

    protected void generateUpperHalfSphere(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1, IBlockData iblockdata, boolean flag) {
        float f2 = l2 - i2 + 1;
        float f1 = i1 - j2 + 1;
        float f22 = j1 - k2 + 1;
        float f3 = (float)i2 + f2 / 2.0f;
        float f4 = (float)k2 + f22 / 2.0f;
        for (int k1 = j2; k1 <= i1; ++k1) {
            float f5 = (float)(k1 - j2) / f1;
            for (int l1 = i2; l1 <= l2; ++l1) {
                float f6 = ((float)l1 - f3) / (f2 * 0.5f);
                for (int i22 = k2; i22 <= j1; ++i22) {
                    float f8;
                    float f7 = ((float)i22 - f4) / (f22 * 0.5f);
                    if (flag && this.getBlock(generatoraccessseed, l1, k1, i22, structureboundingbox).isAir() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.placeBlock(generatoraccessseed, iblockdata, l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void fillColumnDown(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
        if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
            while (this.isReplaceableByStructures(generatoraccessseed.getBlockState(blockposition_mutableblockposition)) && blockposition_mutableblockposition.getY() > generatoraccessseed.getMinBuildHeight() + 1) {
                generatoraccessseed.setBlock(blockposition_mutableblockposition, iblockdata, 2);
                blockposition_mutableblockposition.move(EnumDirection.DOWN);
            }
        }
    }

    protected boolean isReplaceableByStructures(IBlockData iblockdata) {
        return iblockdata.isAir() || iblockdata.liquid() || iblockdata.is(Blocks.GLOW_LICHEN) || iblockdata.is(Blocks.SEAGRASS) || iblockdata.is(Blocks.TALL_SEAGRASS);
    }

    protected boolean createChest(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, int i2, int j2, int k2, ResourceKey<LootTable> resourcekey) {
        return this.createChest(generatoraccessseed, structureboundingbox, randomsource, this.getWorldPos(i2, j2, k2), resourcekey, null);
    }

    public static IBlockData reorient(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = null;
        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection1);
            IBlockData iblockdata1 = iblockaccess.getBlockState(blockposition1);
            if (iblockdata1.is(Blocks.CHEST)) {
                return iblockdata;
            }
            if (!iblockdata1.isSolidRender(iblockaccess, blockposition1)) continue;
            if (enumdirection != null) {
                enumdirection = null;
                break;
            }
            enumdirection = enumdirection1;
        }
        if (enumdirection != null) {
            return (IBlockData)iblockdata.setValue(BlockFacingHorizontal.FACING, enumdirection.getOpposite());
        }
        EnumDirection enumdirection2 = iblockdata.getValue(BlockFacingHorizontal.FACING);
        BlockPosition blockposition2 = blockposition.relative(enumdirection2);
        if (iblockaccess.getBlockState(blockposition2).isSolidRender(iblockaccess, blockposition2)) {
            enumdirection2 = enumdirection2.getOpposite();
            blockposition2 = blockposition.relative(enumdirection2);
        }
        if (iblockaccess.getBlockState(blockposition2).isSolidRender(iblockaccess, blockposition2)) {
            enumdirection2 = enumdirection2.getClockWise();
            blockposition2 = blockposition.relative(enumdirection2);
        }
        if (iblockaccess.getBlockState(blockposition2).isSolidRender(iblockaccess, blockposition2)) {
            enumdirection2 = enumdirection2.getOpposite();
            blockposition.relative(enumdirection2);
        }
        return (IBlockData)iblockdata.setValue(BlockFacingHorizontal.FACING, enumdirection2);
    }

    protected boolean createChest(WorldAccess worldaccess, StructureBoundingBox structureboundingbox, RandomSource randomsource, BlockPosition blockposition, ResourceKey<LootTable> resourcekey, @Nullable IBlockData iblockdata) {
        if (structureboundingbox.isInside(blockposition) && !worldaccess.getBlockState(blockposition).is(Blocks.CHEST)) {
            if (iblockdata == null) {
                iblockdata = StructurePiece.reorient(worldaccess, blockposition, Blocks.CHEST.defaultBlockState());
            }
            CraftChest chestState = (CraftChest)CraftBlockStates.getBlockState((IWorldReader)worldaccess, blockposition, iblockdata, null);
            chestState.setLootTable(CraftLootTable.minecraftToBukkit(resourcekey));
            chestState.setSeed(randomsource.nextLong());
            this.placeCraftBlockEntity(worldaccess, blockposition, chestState, 2);
            return true;
        }
        return false;
    }

    protected boolean createDispenser(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, ResourceKey<LootTable> resourcekey) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
        if (structureboundingbox.isInside(blockposition_mutableblockposition) && !generatoraccessseed.getBlockState(blockposition_mutableblockposition).is(Blocks.DISPENSER)) {
            if (!this.canBeReplaced(generatoraccessseed, i2, j2, k2, structureboundingbox)) {
                return true;
            }
            IBlockData iblockdata = (IBlockData)Blocks.DISPENSER.defaultBlockState().setValue(BlockDispenser.FACING, enumdirection);
            if (this.mirror != EnumBlockMirror.NONE) {
                iblockdata = iblockdata.mirror(this.mirror);
            }
            if (this.rotation != EnumBlockRotation.NONE) {
                iblockdata = iblockdata.rotate(this.rotation);
            }
            CraftDispenser dispenserState = (CraftDispenser)CraftBlockStates.getBlockState((IWorldReader)generatoraccessseed, (BlockPosition)blockposition_mutableblockposition, iblockdata, null);
            dispenserState.setLootTable(CraftLootTable.minecraftToBukkit(resourcekey));
            dispenserState.setSeed(randomsource.nextLong());
            this.placeCraftBlockEntity(generatoraccessseed, blockposition_mutableblockposition, dispenserState, 2);
            return true;
        }
        return false;
    }

    public void move(int i2, int j2, int k2) {
        this.boundingBox.move(i2, j2, k2);
    }

    public static StructureBoundingBox createBoundingBox(Stream<StructurePiece> stream) {
        Stream<StructureBoundingBox> stream1 = stream.map(StructurePiece::getBoundingBox);
        Objects.requireNonNull(stream1);
        return StructureBoundingBox.encapsulatingBoxes(stream1::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> list, StructureBoundingBox structureboundingbox) {
        StructurePiece structurepiece;
        Iterator<StructurePiece> iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(structurepiece = iterator.next()).getBoundingBox().intersects(structureboundingbox));
        return structurepiece;
    }

    @Nullable
    public EnumDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@Nullable EnumDirection enumdirection) {
        this.orientation = enumdirection;
        if (enumdirection == null) {
            this.rotation = EnumBlockRotation.NONE;
            this.mirror = EnumBlockMirror.NONE;
        } else {
            switch (enumdirection) {
                case SOUTH: {
                    this.mirror = EnumBlockMirror.LEFT_RIGHT;
                    this.rotation = EnumBlockRotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = EnumBlockMirror.LEFT_RIGHT;
                    this.rotation = EnumBlockRotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = EnumBlockMirror.NONE;
                    this.rotation = EnumBlockRotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = EnumBlockMirror.NONE;
                    this.rotation = EnumBlockRotation.NONE;
                }
            }
        }
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public WorldGenFeatureStructurePieceType getType() {
        return this.type;
    }

    public static abstract class StructurePieceBlockSelector {
        protected IBlockData next = Blocks.AIR.defaultBlockState();

        public abstract void next(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public IBlockData getNext() {
            return this.next;
        }
    }
}

