/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R1.persistence.DirtyCraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R1.util.TransformerGeneratorAccess;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String INVALID_START_ID = "INVALID";
    public static final StructureStart INVALID_START = new StructureStart(null, new ChunkCoordIntPair(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Structure structure;
    private final PiecesContainer pieceContainer;
    private final ChunkCoordIntPair chunkPos;
    private int references;
    @Nullable
    private volatile StructureBoundingBox cachedBoundingBox;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public AsyncStructureGenerateEvent.Cause generationEventCause = AsyncStructureGenerateEvent.Cause.WORLD_GENERATION;

    public StructureStart(Structure structure, ChunkCoordIntPair chunkcoordintpair, int i2, PiecesContainer piecescontainer) {
        this.structure = structure;
        this.chunkPos = chunkcoordintpair;
        this.references = i2;
        this.pieceContainer = piecescontainer;
    }

    @Nullable
    public static StructureStart loadStaticStart(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound, long i2) {
        String s2 = nbttagcompound.getString("id");
        if (INVALID_START_ID.equals(s2)) {
            return INVALID_START;
        }
        IRegistry<Structure> iregistry = structurepieceserializationcontext.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Structure structure = iregistry.get(MinecraftKey.parse(s2));
        if (structure == null) {
            LOGGER.error("Unknown stucture id: {}", (Object)s2);
            return null;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbttagcompound.getInt("ChunkX"), nbttagcompound.getInt("ChunkZ"));
        int j2 = nbttagcompound.getInt("references");
        NBTTagList nbttaglist = nbttagcompound.getList("Children", 10);
        try {
            PiecesContainer piecescontainer = PiecesContainer.load(nbttaglist, structurepieceserializationcontext);
            if (structure instanceof OceanMonumentStructure) {
                piecescontainer = OceanMonumentStructure.regeneratePiecesAfterLoad(chunkcoordintpair, i2, piecescontainer);
            }
            return new StructureStart(structure, chunkcoordintpair, j2, piecescontainer);
        }
        catch (Exception exception) {
            LOGGER.error("Failed Start with id {}", (Object)s2, (Object)exception);
            return null;
        }
    }

    public StructureBoundingBox getBoundingBox() {
        StructureBoundingBox structureboundingbox = this.cachedBoundingBox;
        if (structureboundingbox == null) {
            this.cachedBoundingBox = structureboundingbox = this.structure.adjustBoundingBox(this.pieceContainer.calculateBoundingBox());
        }
        return structureboundingbox;
    }

    public void placeInChunk(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair) {
        List<StructurePiece> list = this.pieceContainer.pieces();
        if (!list.isEmpty()) {
            StructureBoundingBox structureboundingbox1 = list.get((int)0).boundingBox;
            BlockPosition blockposition = structureboundingbox1.getCenter();
            BlockPosition blockposition1 = new BlockPosition(blockposition.getX(), structureboundingbox1.minY(), blockposition.getZ());
            List<StructurePiece> pieces = list.stream().filter(piece -> piece.getBoundingBox().intersects(structureboundingbox)).toList();
            if (!pieces.isEmpty()) {
                TransformerGeneratorAccess transformerAccess = new TransformerGeneratorAccess();
                transformerAccess.setHandle(generatoraccessseed);
                transformerAccess.setStructureTransformer(new CraftStructureTransformer(this.generationEventCause, generatoraccessseed, structuremanager, this.structure, structureboundingbox, chunkcoordintpair));
                for (StructurePiece piece2 : pieces) {
                    piece2.postProcess(transformerAccess, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition1);
                }
                transformerAccess.getStructureTransformer().discard();
            }
            this.structure.afterPlace(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, this.pieceContainer);
        }
    }

    public NBTTagCompound createTag(StructurePieceSerializationContext structurepieceserializationcontext, ChunkCoordIntPair chunkcoordintpair) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("StructureBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        if (this.isValid()) {
            nbttagcompound.putString("id", structurepieceserializationcontext.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey(this.structure).toString());
            nbttagcompound.putInt("ChunkX", chunkcoordintpair.x);
            nbttagcompound.putInt("ChunkZ", chunkcoordintpair.z);
            nbttagcompound.putInt("references", this.references);
            nbttagcompound.put("Children", this.pieceContainer.save(structurepieceserializationcontext));
            return nbttagcompound;
        }
        nbttagcompound.putString("id", INVALID_START_ID);
        return nbttagcompound;
    }

    public boolean isValid() {
        return !this.pieceContainer.isEmpty();
    }

    public ChunkCoordIntPair getChunkPos() {
        return this.chunkPos;
    }

    public boolean canBeReferenced() {
        return this.references < this.getMaxReferences();
    }

    public void addReference() {
        ++this.references;
    }

    public int getReferences() {
        return this.references;
    }

    protected int getMaxReferences() {
        return 1;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public List<StructurePiece> getPieces() {
        return this.pieceContainer.pieces();
    }
}

