/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools.alias;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.Direct;
import net.minecraft.world.level.levelgen.structure.pools.alias.Random;
import net.minecraft.world.level.levelgen.structure.pools.alias.RandomGroup;

public interface PoolAliasBinding {
    public static final Codec<PoolAliasBinding> CODEC = BuiltInRegistries.POOL_ALIAS_BINDING_TYPE.byNameCodec().dispatch(PoolAliasBinding::codec, Function.identity());

    public void forEachResolved(RandomSource var1, BiConsumer<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> var2);

    public Stream<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> allTargets();

    public static Direct direct(String var0, String var1) {
        return PoolAliasBinding.direct(WorldGenFeaturePieces.createKey(var0), WorldGenFeaturePieces.createKey(var1));
    }

    public static Direct direct(ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var0, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var1) {
        return new Direct(var0, var1);
    }

    public static Random random(String var0, SimpleWeightedRandomList<String> var12) {
        SimpleWeightedRandomList.a var2 = SimpleWeightedRandomList.builder();
        var12.unwrap().forEach(var1 -> var2.add(WorldGenFeaturePieces.createKey((String)var1.data()), var1.getWeight().asInt()));
        return PoolAliasBinding.random(WorldGenFeaturePieces.createKey(var0), var2.build());
    }

    public static Random random(ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var0, SimpleWeightedRandomList<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> var1) {
        return new Random(var0, var1);
    }

    public static RandomGroup randomGroup(SimpleWeightedRandomList<List<PoolAliasBinding>> var0) {
        return new RandomGroup(var0);
    }

    public MapCodec<? extends PoolAliasBinding> codec();
}

