/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.SinglePieceStructure;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBrushableBlock;
import org.bukkit.craftbukkit.v1_21_R1.util.TransformerGeneratorAccess;

public class DesertPyramidStructure
extends SinglePieceStructure {
    public static final MapCodec<DesertPyramidStructure> CODEC = DesertPyramidStructure.simpleCodec(DesertPyramidStructure::new);

    public DesertPyramidStructure(Structure.c structure_c) {
        super(DesertPyramidPiece::new, 21, 21, structure_c);
    }

    @Override
    public void afterPlace(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, PiecesContainer piecescontainer) {
        ArraySetSorted set = ArraySetSorted.create(BaseBlockPosition::compareTo);
        for (StructurePiece structurepiece : piecescontainer.pieces()) {
            if (!(structurepiece instanceof DesertPyramidPiece)) continue;
            DesertPyramidPiece desertpyramidpiece = (DesertPyramidPiece)structurepiece;
            set.addAll(desertpyramidpiece.getPotentialSuspiciousSandWorldPositions());
            DesertPyramidStructure.placeSuspiciousSand(structureboundingbox, generatoraccessseed, desertpyramidpiece.getRandomCollapsedRoofPos());
        }
        ObjectArrayList objectarraylist = new ObjectArrayList(set.stream().toList());
        RandomSource randomsource1 = RandomSource.create(generatoraccessseed.getSeed()).forkPositional().at(piecescontainer.calculateBoundingBox().getCenter());
        SystemUtils.shuffle(objectarraylist, randomsource1);
        int i2 = Math.min(set.size(), randomsource1.nextInt(5, 8));
        for (BlockPosition blockposition : objectarraylist) {
            if (i2 > 0) {
                --i2;
                DesertPyramidStructure.placeSuspiciousSand(structureboundingbox, generatoraccessseed, blockposition);
                continue;
            }
            if (!structureboundingbox.isInside(blockposition)) continue;
            generatoraccessseed.setBlock(blockposition, Blocks.SAND.defaultBlockState(), 2);
        }
    }

    private static void placeSuspiciousSand(StructureBoundingBox structureboundingbox, GeneratorAccessSeed generatoraccessseed, BlockPosition blockposition) {
        if (structureboundingbox.isInside(blockposition)) {
            if (generatoraccessseed instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)generatoraccessseed;
                CraftBrushableBlock brushableState = (CraftBrushableBlock)CraftBlockStates.getBlockState((IWorldReader)generatoraccessseed, blockposition, Blocks.SUSPICIOUS_SAND.defaultBlockState(), null);
                brushableState.setLootTable(CraftLootTable.minecraftToBukkit(LootTables.DESERT_PYRAMID_ARCHAEOLOGY));
                brushableState.setSeed(blockposition.asLong());
                transformerAccess.setCraftBlock(blockposition, brushableState, 2);
                return;
            }
            generatoraccessseed.setBlock(blockposition, Blocks.SUSPICIOUS_SAND.defaultBlockState(), 2);
            generatoraccessseed.getBlockEntity(blockposition, TileEntityTypes.BRUSHABLE_BLOCK).ifPresent(brushableblockentity -> brushableblockentity.setLootTable(LootTables.DESERT_PYRAMID_ARCHAEOLOGY, blockposition.asLong()));
        }
    }

    @Override
    public StructureType<?> type() {
        return StructureType.DESERT_PYRAMID;
    }
}

