/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTables;

public class EndCityPieces {
    private static final int MAX_GEN_DEPTH = 8;
    static final b HOUSE_TOWER_GENERATOR = new b(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i2, a endcitypieces_a, BlockPosition blockposition, List<StructurePiece> list, RandomSource randomsource) {
            if (i2 > 8) {
                return false;
            }
            EnumBlockRotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            a endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, blockposition, "base_floor", enumblockrotation, true));
            int j2 = randomsource.nextInt(3);
            if (j2 == 0) {
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 4, -1), "base_roof", enumblockrotation, true));
            } else if (j2 == 1) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 0, -1), "second_floor_2", enumblockrotation, false));
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 8, -1), "second_roof", enumblockrotation, false));
                EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_GENERATOR, i2 + 1, endcitypieces_a1, null, list, randomsource);
            } else if (j2 == 2) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 0, -1), "second_floor_2", enumblockrotation, false));
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 4, -1), "third_floor_2", enumblockrotation, false));
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 8, -1), "third_roof", enumblockrotation, true));
                EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_GENERATOR, i2 + 1, endcitypieces_a1, null, list, randomsource);
            }
            return true;
        }
    };
    static final List<Tuple<EnumBlockRotation, BlockPosition>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.NONE, new BlockPosition(1, -1, 0)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_90, new BlockPosition(6, -1, 1)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.COUNTERCLOCKWISE_90, new BlockPosition(0, -1, 5)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_180, new BlockPosition(5, -1, 6))});
    static final b TOWER_GENERATOR = new b(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i2, a endcitypieces_a, BlockPosition blockposition, List<StructurePiece> list, RandomSource randomsource) {
            EnumBlockRotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            a endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPosition(3 + randomsource.nextInt(2), -3, 3 + randomsource.nextInt(2)), "tower_base", enumblockrotation, true));
            endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, 7, 0), "tower_piece", enumblockrotation, true));
            a endcitypieces_a2 = randomsource.nextInt(3) == 0 ? endcitypieces_a1 : null;
            int j2 = 1 + randomsource.nextInt(3);
            for (int k2 = 0; k2 < j2; ++k2) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, 4, 0), "tower_piece", enumblockrotation, true));
                if (k2 >= j2 - 1 || !randomsource.nextBoolean()) continue;
                endcitypieces_a2 = endcitypieces_a1;
            }
            if (endcitypieces_a2 != null) {
                for (Tuple<EnumBlockRotation, BlockPosition> tuple : TOWER_BRIDGES) {
                    if (!randomsource.nextBoolean()) continue;
                    a endcitypieces_a3 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a2, tuple.getB(), "bridge_end", enumblockrotation.getRotated(tuple.getA()), true));
                    EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_BRIDGE_GENERATOR, i2 + 1, endcitypieces_a3, null, list, randomsource);
                }
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 4, -1), "tower_top", enumblockrotation, true));
            } else {
                if (i2 != 7) {
                    return EndCityPieces.recursiveChildren(structuretemplatemanager, FAT_TOWER_GENERATOR, i2 + 1, endcitypieces_a1, null, list, randomsource);
                }
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-1, 4, -1), "tower_top", enumblockrotation, true));
            }
            return true;
        }
    };
    static final b TOWER_BRIDGE_GENERATOR = new b(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i2, a endcitypieces_a, BlockPosition blockposition, List<StructurePiece> list, RandomSource randomsource) {
            EnumBlockRotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            int j2 = randomsource.nextInt(4) + 1;
            a endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPosition(0, 0, -4), "bridge_piece", enumblockrotation, true));
            endcitypieces_a1.setGenDepth(-1);
            int b0 = 0;
            for (int k2 = 0; k2 < j2; ++k2) {
                if (randomsource.nextBoolean()) {
                    endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, b0, -4), "bridge_piece", enumblockrotation, true));
                    b0 = 0;
                    continue;
                }
                endcitypieces_a1 = randomsource.nextBoolean() ? EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, b0, -4), "bridge_steep_stairs", enumblockrotation, true)) : EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, b0, -8), "bridge_gentle_stairs", enumblockrotation, true));
                b0 = 4;
            }
            if (!this.shipCreated && randomsource.nextInt(10 - i2) == 0) {
                EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-8 + randomsource.nextInt(8), b0, -70 + randomsource.nextInt(10)), "ship", enumblockrotation, true));
                this.shipCreated = true;
            } else if (!EndCityPieces.recursiveChildren(structuretemplatemanager, HOUSE_TOWER_GENERATOR, i2 + 1, endcitypieces_a1, new BlockPosition(-3, b0 + 1, -11), list, randomsource)) {
                return false;
            }
            endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(4, b0, 0), "bridge_end", enumblockrotation.getRotated(EnumBlockRotation.CLOCKWISE_180), true));
            endcitypieces_a1.setGenDepth(-1);
            return true;
        }
    };
    static final List<Tuple<EnumBlockRotation, BlockPosition>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.NONE, new BlockPosition(4, -1, 0)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_90, new BlockPosition(12, -1, 4)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.COUNTERCLOCKWISE_90, new BlockPosition(0, -1, 8)), new Tuple<EnumBlockRotation, BlockPosition>(EnumBlockRotation.CLOCKWISE_180, new BlockPosition(8, -1, 12))});
    static final b FAT_TOWER_GENERATOR = new b(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(StructureTemplateManager structuretemplatemanager, int i2, a endcitypieces_a, BlockPosition blockposition, List<StructurePiece> list, RandomSource randomsource) {
            EnumBlockRotation enumblockrotation = endcitypieces_a.placeSettings().getRotation();
            a endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPosition(-3, 4, -3), "fat_tower_base", enumblockrotation, true));
            endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, 4, 0), "fat_tower_middle", enumblockrotation, true));
            for (int j2 = 0; j2 < 2 && randomsource.nextInt(3) != 0; ++j2) {
                endcitypieces_a1 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(0, 8, 0), "fat_tower_middle", enumblockrotation, true));
                for (Tuple<EnumBlockRotation, BlockPosition> tuple : FAT_TOWER_BRIDGES) {
                    if (!randomsource.nextBoolean()) continue;
                    a endcitypieces_a2 = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, tuple.getB(), "bridge_end", enumblockrotation.getRotated(tuple.getA()), true));
                    EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_BRIDGE_GENERATOR, i2 + 1, endcitypieces_a2, null, list, randomsource);
                }
            }
            EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a1, new BlockPosition(-2, 8, -2), "fat_tower_top", enumblockrotation, true));
            return true;
        }
    };

    static a addPiece(StructureTemplateManager structuretemplatemanager, a endcitypieces_a, BlockPosition blockposition, String s2, EnumBlockRotation enumblockrotation, boolean flag) {
        a endcitypieces_a1 = new a(structuretemplatemanager, s2, endcitypieces_a.templatePosition(), enumblockrotation, flag);
        BlockPosition blockposition1 = endcitypieces_a.template().calculateConnectedPosition(endcitypieces_a.placeSettings(), blockposition, endcitypieces_a1.placeSettings(), BlockPosition.ZERO);
        endcitypieces_a1.move(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
        return endcitypieces_a1;
    }

    public static void startHouseTower(StructureTemplateManager structuretemplatemanager, BlockPosition blockposition, EnumBlockRotation enumblockrotation, List<StructurePiece> list, RandomSource randomsource) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        a endcitypieces_a = EndCityPieces.addHelper(list, new a(structuretemplatemanager, "base_floor", blockposition, enumblockrotation, true));
        endcitypieces_a = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPosition(-1, 0, -1), "second_floor_1", enumblockrotation, false));
        endcitypieces_a = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPosition(-1, 4, -1), "third_floor_1", enumblockrotation, false));
        endcitypieces_a = EndCityPieces.addHelper(list, EndCityPieces.addPiece(structuretemplatemanager, endcitypieces_a, new BlockPosition(-1, 8, -1), "third_roof", enumblockrotation, true));
        EndCityPieces.recursiveChildren(structuretemplatemanager, TOWER_GENERATOR, 1, endcitypieces_a, null, list, randomsource);
    }

    static a addHelper(List<StructurePiece> list, a endcitypieces_a) {
        list.add(endcitypieces_a);
        return endcitypieces_a;
    }

    static boolean recursiveChildren(StructureTemplateManager structuretemplatemanager, b endcitypieces_b, int i2, a endcitypieces_a, BlockPosition blockposition, List<StructurePiece> list, RandomSource randomsource) {
        if (i2 > 8) {
            return false;
        }
        ArrayList list1 = Lists.newArrayList();
        if (endcitypieces_b.generate(structuretemplatemanager, i2, endcitypieces_a, blockposition, list1, randomsource)) {
            boolean flag = false;
            int j2 = randomsource.nextInt();
            for (StructurePiece structurepiece : list1) {
                structurepiece.setGenDepth(j2);
                StructurePiece structurepiece1 = StructurePiece.findCollisionPiece(list, structurepiece.getBoundingBox());
                if (structurepiece1 == null || structurepiece1.getGenDepth() == endcitypieces_a.getGenDepth()) continue;
                flag = true;
                break;
            }
            if (!flag) {
                list.addAll(list1);
                return true;
            }
        }
        return false;
    }

    public static class a
    extends DefinedStructurePiece {
        public a(StructureTemplateManager structuretemplatemanager, String s2, BlockPosition blockposition, EnumBlockRotation enumblockrotation, boolean flag) {
            super(WorldGenFeatureStructurePieceType.END_CITY_PIECE, 0, structuretemplatemanager, a.makeResourceLocation(s2), s2, a.makeSettings(flag, enumblockrotation), blockposition);
        }

        public a(StructureTemplateManager structuretemplatemanager, NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.END_CITY_PIECE, nbttagcompound, structuretemplatemanager, minecraftkey -> a.makeSettings(nbttagcompound.getBoolean("OW"), EnumBlockRotation.valueOf(nbttagcompound.getString("Rot"))));
        }

        private static DefinedStructureInfo makeSettings(boolean flag, EnumBlockRotation enumblockrotation) {
            DefinedStructureProcessorBlockIgnore definedstructureprocessorblockignore = flag ? DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK : DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR;
            return new DefinedStructureInfo().setIgnoreEntities(true).addProcessor(definedstructureprocessorblockignore).setRotation(enumblockrotation);
        }

        @Override
        protected MinecraftKey makeTemplateLocation() {
            return a.makeResourceLocation(this.templateName);
        }

        private static MinecraftKey makeResourceLocation(String s2) {
            return MinecraftKey.withDefaultNamespace("end_city/" + s2);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putString("Rot", this.placeSettings.getRotation().name());
            nbttagcompound.putBoolean("OW", this.placeSettings.getProcessors().get(0) == DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        }

        @Override
        protected void handleDataMarker(String s2, BlockPosition blockposition, WorldAccess worldaccess, RandomSource randomsource, StructureBoundingBox structureboundingbox) {
            if (s2.startsWith("Chest")) {
                BlockPosition blockposition1 = blockposition.below();
                if (structureboundingbox.isInside(blockposition1)) {
                    this.setCraftLootTable(worldaccess, blockposition1, randomsource, LootTables.END_CITY_TREASURE);
                }
            } else if (structureboundingbox.isInside(blockposition) && World.isInSpawnableBounds(blockposition)) {
                if (s2.startsWith("Sentry")) {
                    EntityShulker entityshulker = EntityTypes.SHULKER.create(worldaccess.getLevel());
                    if (entityshulker != null) {
                        entityshulker.setPos((double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5);
                        worldaccess.addFreshEntity(entityshulker);
                    }
                } else if (s2.startsWith("Elytra")) {
                    EntityItemFrame entityitemframe = new EntityItemFrame(worldaccess.getLevel(), blockposition, this.placeSettings.getRotation().rotate(EnumDirection.SOUTH));
                    entityitemframe.setItem(new ItemStack(Items.ELYTRA), false);
                    worldaccess.addFreshEntity(entityitemframe);
                }
            }
        }
    }

    private static interface b {
        public void init();

        public boolean generate(StructureTemplateManager var1, int var2, a var3, BlockPosition var4, List<StructurePiece> var5, RandomSource var6);
    }
}

