/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTables;

public class IglooPieces {
    public static final int GENERATION_HEIGHT = 90;
    static final MinecraftKey STRUCTURE_LOCATION_IGLOO = MinecraftKey.withDefaultNamespace("igloo/top");
    private static final MinecraftKey STRUCTURE_LOCATION_LADDER = MinecraftKey.withDefaultNamespace("igloo/middle");
    private static final MinecraftKey STRUCTURE_LOCATION_LABORATORY = MinecraftKey.withDefaultNamespace("igloo/bottom");
    static final Map<MinecraftKey, BlockPosition> PIVOTS = ImmutableMap.of((Object)STRUCTURE_LOCATION_IGLOO, (Object)new BlockPosition(3, 5, 5), (Object)STRUCTURE_LOCATION_LADDER, (Object)new BlockPosition(1, 3, 1), (Object)STRUCTURE_LOCATION_LABORATORY, (Object)new BlockPosition(3, 6, 7));
    static final Map<MinecraftKey, BlockPosition> OFFSETS = ImmutableMap.of((Object)STRUCTURE_LOCATION_IGLOO, (Object)BlockPosition.ZERO, (Object)STRUCTURE_LOCATION_LADDER, (Object)new BlockPosition(2, -3, 4), (Object)STRUCTURE_LOCATION_LABORATORY, (Object)new BlockPosition(0, -3, -2));

    public static void addPieces(StructureTemplateManager structuretemplatemanager, BlockPosition blockposition, EnumBlockRotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
        if (randomsource.nextDouble() < 0.5) {
            int i2 = randomsource.nextInt(8) + 4;
            structurepieceaccessor.addPiece(new a(structuretemplatemanager, STRUCTURE_LOCATION_LABORATORY, blockposition, enumblockrotation, i2 * 3));
            for (int j2 = 0; j2 < i2 - 1; ++j2) {
                structurepieceaccessor.addPiece(new a(structuretemplatemanager, STRUCTURE_LOCATION_LADDER, blockposition, enumblockrotation, j2 * 3));
            }
        }
        structurepieceaccessor.addPiece(new a(structuretemplatemanager, STRUCTURE_LOCATION_IGLOO, blockposition, enumblockrotation, 0));
    }

    public static class a
    extends DefinedStructurePiece {
        public a(StructureTemplateManager structuretemplatemanager, MinecraftKey minecraftkey, BlockPosition blockposition, EnumBlockRotation enumblockrotation, int i2) {
            super(WorldGenFeatureStructurePieceType.IGLOO, 0, structuretemplatemanager, minecraftkey, minecraftkey.toString(), a.makeSettings(enumblockrotation, minecraftkey), a.makePosition(minecraftkey, blockposition, i2));
        }

        public a(StructureTemplateManager structuretemplatemanager, NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.IGLOO, nbttagcompound, structuretemplatemanager, minecraftkey -> a.makeSettings(EnumBlockRotation.valueOf(nbttagcompound.getString("Rot")), minecraftkey));
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation enumblockrotation, MinecraftKey minecraftkey) {
            return new DefinedStructureInfo().setRotation(enumblockrotation).setMirror(EnumBlockMirror.NONE).setRotationPivot(PIVOTS.get(minecraftkey)).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        }

        private static BlockPosition makePosition(MinecraftKey minecraftkey, BlockPosition blockposition, int i2) {
            return blockposition.offset(OFFSETS.get(minecraftkey)).below(i2);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putString("Rot", this.placeSettings.getRotation().name());
        }

        @Override
        protected void handleDataMarker(String s2, BlockPosition blockposition, WorldAccess worldaccess, RandomSource randomsource, StructureBoundingBox structureboundingbox) {
            if ("chest".equals(s2)) {
                worldaccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 3);
                this.setCraftLootTable(worldaccess, blockposition.below(), randomsource, LootTables.IGLOO_CHEST);
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            BlockPosition blockposition4;
            IBlockData iblockdata;
            MinecraftKey minecraftkey = MinecraftKey.parse(this.templateName);
            DefinedStructureInfo definedstructureinfo = a.makeSettings(this.placeSettings.getRotation(), minecraftkey);
            BlockPosition blockposition1 = OFFSETS.get(minecraftkey);
            BlockPosition blockposition2 = this.templatePosition.offset(DefinedStructure.calculateRelativePosition(definedstructureinfo, new BlockPosition(3 - blockposition1.getX(), 0, -blockposition1.getZ())));
            int i2 = generatoraccessseed.getHeight(HeightMap.Type.WORLD_SURFACE_WG, blockposition2.getX(), blockposition2.getZ());
            BlockPosition blockposition3 = this.templatePosition;
            this.templatePosition = this.templatePosition.offset(0, i2 - 90 - 1, 0);
            super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
            if (minecraftkey.equals(STRUCTURE_LOCATION_IGLOO) && !(iblockdata = generatoraccessseed.getBlockState((blockposition4 = this.templatePosition.offset(DefinedStructure.calculateRelativePosition(definedstructureinfo, new BlockPosition(3, 0, 5)))).below())).isAir() && !iblockdata.is(Blocks.LADDER)) {
                generatoraccessseed.setBlock(blockposition4, Blocks.SNOW_BLOCK.defaultBlockState(), 3);
            }
            this.templatePosition = blockposition3;
        }
    }
}

