/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.entity.EntityType;
import org.slf4j.Logger;

public class MineshaftPieces {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_SHAFT_WIDTH = 3;
    private static final int DEFAULT_SHAFT_HEIGHT = 3;
    private static final int DEFAULT_SHAFT_LENGTH = 5;
    private static final int MAX_PILLAR_HEIGHT = 20;
    private static final int MAX_CHAIN_HEIGHT = 50;
    private static final int MAX_DEPTH = 8;
    public static final int MAGIC_START_Y = 50;

    private static c createRandomShaftPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, @Nullable EnumDirection enumdirection, int l2, MineshaftStructure.a mineshaftstructure_a) {
        int i1 = randomsource.nextInt(100);
        if (i1 >= 80) {
            StructureBoundingBox structureboundingbox = b.findCrossing(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection);
            if (structureboundingbox != null) {
                return new b(l2, structureboundingbox, enumdirection, mineshaftstructure_a);
            }
        } else if (i1 >= 70) {
            StructureBoundingBox structureboundingbox = e.findStairs(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection);
            if (structureboundingbox != null) {
                return new e(l2, structureboundingbox, enumdirection, mineshaftstructure_a);
            }
        } else {
            StructureBoundingBox structureboundingbox = a.findCorridorSize(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection);
            if (structureboundingbox != null) {
                return new a(l2, randomsource, structureboundingbox, enumdirection, mineshaftstructure_a);
            }
        }
        return null;
    }

    static c generateAndAddPiece(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
        if (l2 > 8) {
            return null;
        }
        if (Math.abs(i2 - structurepiece.getBoundingBox().minX()) <= 80 && Math.abs(k2 - structurepiece.getBoundingBox().minZ()) <= 80) {
            MineshaftStructure.a mineshaftstructure_a = ((c)structurepiece).type;
            c mineshaftpieces_c = MineshaftPieces.createRandomShaftPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2 + 1, mineshaftstructure_a);
            if (mineshaftpieces_c != null) {
                structurepieceaccessor.addPiece(mineshaftpieces_c);
                mineshaftpieces_c.addChildren(structurepiece, structurepieceaccessor, randomsource);
            }
            return mineshaftpieces_c;
        }
        return null;
    }

    public static class b
    extends c {
        private final EnumDirection direction;
        private final boolean isTwoFloored;

        public b(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CROSSING, nbttagcompound);
            this.isTwoFloored = nbttagcompound.getBoolean("tf");
            this.direction = EnumDirection.from2DDataValue(nbttagcompound.getInt("D"));
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("tf", this.isTwoFloored);
            nbttagcompound.putInt("D", this.direction.get2DDataValue());
        }

        public b(int i2, StructureBoundingBox structureboundingbox, @Nullable EnumDirection enumdirection, MineshaftStructure.a mineshaftstructure_a) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CROSSING, i2, mineshaftstructure_a, structureboundingbox);
            this.direction = enumdirection;
            this.isTwoFloored = structureboundingbox.getYSpan() > 3;
        }

        @Nullable
        public static StructureBoundingBox findCrossing(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection) {
            int b0 = randomsource.nextInt(4) == 0 ? 6 : 2;
            StructureBoundingBox structureboundingbox = switch (enumdirection) {
                default -> new StructureBoundingBox(-1, 0, -4, 3, b0, 0);
                case EnumDirection.SOUTH -> new StructureBoundingBox(-1, 0, 0, 3, b0, 4);
                case EnumDirection.WEST -> new StructureBoundingBox(-4, 0, -1, 0, b0, 3);
                case EnumDirection.EAST -> new StructureBoundingBox(0, 0, -1, 4, b0, 3);
            };
            structureboundingbox.move(i2, j2, k2);
            return structurepieceaccessor.findCollisionPiece(structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i2 = this.getGenDepth();
            switch (this.direction) {
                default: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.WEST, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.EAST, i2);
                    break;
                }
                case SOUTH: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.WEST, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.EAST, i2);
                    break;
                }
                case WEST: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.WEST, i2);
                    break;
                }
                case EAST: {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.EAST, i2);
                }
            }
            if (this.isTwoFloored) {
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                }
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() + 1, EnumDirection.WEST, i2);
                }
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() + 1, EnumDirection.EAST, i2);
                }
                if (randomsource.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                }
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                IBlockData iblockdata = this.type.getPlanksState();
                if (this.isTwoFloored) {
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.minY() + 3 - 1, this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.minY() + 3 - 1, this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.maxY() - 2, this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.maxY() - 2, this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3, this.boundingBox.minZ() + 1, this.boundingBox.maxX() - 1, this.boundingBox.minY() + 3, this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                } else {
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                }
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
                this.placeSupportPillar(generatoraccessseed, structureboundingbox, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
                int i2 = this.boundingBox.minY() - 1;
                for (int j2 = this.boundingBox.minX(); j2 <= this.boundingBox.maxX(); ++j2) {
                    for (int k2 = this.boundingBox.minZ(); k2 <= this.boundingBox.maxZ(); ++k2) {
                        this.setPlanksBlock(generatoraccessseed, structureboundingbox, iblockdata, j2, i2, k2);
                    }
                }
            }
        }

        private void placeSupportPillar(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2) {
            if (!this.getBlock(generatoraccessseed, i2, l2 + 1, k2, structureboundingbox).isAir()) {
                this.generateBox(generatoraccessseed, structureboundingbox, i2, j2, k2, i2, l2, k2, this.type.getPlanksState(), CAVE_AIR, false);
            }
        }
    }

    public static class e
    extends c {
        public e(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection, MineshaftStructure.a mineshaftstructure_a) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_STAIRS, i2, mineshaftstructure_a, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public e(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_STAIRS, nbttagcompound);
        }

        @Nullable
        public static StructureBoundingBox findStairs(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection) {
            StructureBoundingBox structureboundingbox = switch (enumdirection) {
                default -> new StructureBoundingBox(0, -5, -8, 2, 2, 0);
                case EnumDirection.SOUTH -> new StructureBoundingBox(0, -5, 0, 2, 2, 8);
                case EnumDirection.WEST -> new StructureBoundingBox(-8, -5, 0, 0, 2, 2);
                case EnumDirection.EAST -> new StructureBoundingBox(0, -5, 0, 8, 2, 2);
            };
            structureboundingbox.move(i2, j2, k2);
            return structurepieceaccessor.findCollisionPiece(structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i2 = this.getGenDepth();
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    default: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                        break;
                    }
                    case WEST: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ(), EnumDirection.WEST, i2);
                        break;
                    }
                    case EAST: {
                        MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), EnumDirection.EAST, i2);
                    }
                }
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 2, 7, 1, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 7, 2, 2, 8, CAVE_AIR, CAVE_AIR, false);
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 0, 5 - i2 - (i2 < 4 ? 1 : 0), 2 + i2, 2, 7 - i2, 2 + i2, CAVE_AIR, CAVE_AIR, false);
                }
            }
        }
    }

    public static class a
    extends c {
        private final boolean hasRails;
        private final boolean spiderCorridor;
        private boolean hasPlacedSpider;
        private final int numSections;

        public a(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CORRIDOR, nbttagcompound);
            this.hasRails = nbttagcompound.getBoolean("hr");
            this.spiderCorridor = nbttagcompound.getBoolean("sc");
            this.hasPlacedSpider = nbttagcompound.getBoolean("hps");
            this.numSections = nbttagcompound.getInt("Num");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("hr", this.hasRails);
            nbttagcompound.putBoolean("sc", this.spiderCorridor);
            nbttagcompound.putBoolean("hps", this.hasPlacedSpider);
            nbttagcompound.putInt("Num", this.numSections);
        }

        public a(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection, MineshaftStructure.a mineshaftstructure_a) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CORRIDOR, i2, mineshaftstructure_a, structureboundingbox);
            this.setOrientation(enumdirection);
            this.hasRails = randomsource.nextInt(3) == 0;
            this.spiderCorridor = !this.hasRails && randomsource.nextInt(23) == 0;
            this.numSections = this.getOrientation().getAxis() == EnumDirection.EnumAxis.Z ? structureboundingbox.getZSpan() / 5 : structureboundingbox.getXSpan() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static StructureBoundingBox findCorridorSize(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection) {
            int l2 = randomsource.nextInt(3) + 2;
            while (l2 > 0) {
                int i1 = l2 * 5;
                StructureBoundingBox structureboundingbox = switch (enumdirection) {
                    default -> new StructureBoundingBox(0, 0, -(i1 - 1), 2, 2, 0);
                    case EnumDirection.SOUTH -> new StructureBoundingBox(0, 0, 0, 2, 2, i1 - 1);
                    case EnumDirection.WEST -> new StructureBoundingBox(-(i1 - 1), 0, 0, 0, 2, 2);
                    case EnumDirection.EAST -> new StructureBoundingBox(0, 0, 0, i1 - 1, 2, 2);
                };
                structureboundingbox.move(i2, j2, k2);
                if (structurepieceaccessor.findCollisionPiece(structureboundingbox) == null) {
                    return structureboundingbox;
                }
                --l2;
            }
            return null;
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            block24: {
                int i2 = this.getGenDepth();
                int j2 = randomsource.nextInt(4);
                EnumDirection enumdirection = this.getOrientation();
                if (enumdirection != null) {
                    switch (enumdirection) {
                        default: {
                            if (j2 <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ() - 1, enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), EnumDirection.WEST, i2);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), EnumDirection.EAST, i2);
                            break;
                        }
                        case SOUTH: {
                            if (j2 <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() + 1, enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() - 3, EnumDirection.WEST, i2);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() - 3, EnumDirection.EAST, i2);
                            break;
                        }
                        case WEST: {
                            if (j2 <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX(), this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                            break;
                        }
                        case EAST: {
                            if (j2 <= 1) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ(), enumdirection, i2);
                                break;
                            }
                            if (j2 == 2) {
                                MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + randomsource.nextInt(3), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                        }
                    }
                }
                if (i2 >= 8) break block24;
                if (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.SOUTH) {
                    int l2 = this.boundingBox.minX() + 3;
                    while (l2 + 3 <= this.boundingBox.maxX()) {
                        int k2 = randomsource.nextInt(5);
                        if (k2 == 0) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, l2, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2 + 1);
                        } else if (k2 == 1) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, l2, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2 + 1);
                        }
                        l2 += 5;
                    }
                } else {
                    int l3 = this.boundingBox.minZ() + 3;
                    while (l3 + 3 <= this.boundingBox.maxZ()) {
                        int k3 = randomsource.nextInt(5);
                        if (k3 == 0) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY(), l3, EnumDirection.WEST, i2 + 1);
                        } else if (k3 == 1) {
                            MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY(), l3, EnumDirection.EAST, i2 + 1);
                        }
                        l3 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean createChest(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, int i2, int j2, int k2, ResourceKey<LootTable> resourcekey) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
            if (structureboundingbox.isInside(blockposition_mutableblockposition) && generatoraccessseed.getBlockState(blockposition_mutableblockposition).isAir() && !generatoraccessseed.getBlockState((BlockPosition)blockposition_mutableblockposition.below()).isAir()) {
                IBlockData iblockdata = (IBlockData)Blocks.RAIL.defaultBlockState().setValue(BlockMinecartTrack.SHAPE, randomsource.nextBoolean() ? BlockPropertyTrackPosition.NORTH_SOUTH : BlockPropertyTrackPosition.EAST_WEST);
                this.placeBlock(generatoraccessseed, iblockdata, i2, j2, k2, structureboundingbox);
                EntityMinecartChest entityminecartchest = new EntityMinecartChest(generatoraccessseed.getLevel(), (double)blockposition_mutableblockposition.getX() + 0.5, (double)blockposition_mutableblockposition.getY() + 0.5, (double)blockposition_mutableblockposition.getZ() + 0.5);
                entityminecartchest.setLootTable(resourcekey, randomsource.nextLong());
                generatoraccessseed.addFreshEntity(entityminecartchest);
                return true;
            }
            return false;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                int j2;
                int k2;
                boolean flag = false;
                boolean flag1 = true;
                boolean flag2 = false;
                boolean flag3 = true;
                int i2 = this.numSections * 5 - 1;
                IBlockData iblockdata = this.type.getPlanksState();
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 2, 1, i2, CAVE_AIR, CAVE_AIR, false);
                this.generateMaybeBox(generatoraccessseed, structureboundingbox, randomsource, 0.8f, 0, 2, 0, 2, 2, i2, CAVE_AIR, CAVE_AIR, false, false);
                if (this.spiderCorridor) {
                    this.generateMaybeBox(generatoraccessseed, structureboundingbox, randomsource, 0.6f, 0, 0, 0, 2, 1, i2, Blocks.COBWEB.defaultBlockState(), CAVE_AIR, false, true);
                }
                for (k2 = 0; k2 < this.numSections; ++k2) {
                    j2 = 2 + k2 * 5;
                    this.placeSupport(generatoraccessseed, structureboundingbox, 0, 0, j2, 2, 2, randomsource);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 0, 2, j2 - 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 2, 2, j2 - 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 0, 2, j2 + 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 2, 2, j2 + 1);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 0, 2, j2 - 2);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 2, 2, j2 - 2);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 0, 2, j2 + 2);
                    this.maybePlaceCobWeb(generatoraccessseed, structureboundingbox, randomsource, 0.05f, 2, 2, j2 + 2);
                    if (randomsource.nextInt(100) == 0) {
                        this.createChest(generatoraccessseed, structureboundingbox, randomsource, 2, 0, j2 - 1, LootTables.ABANDONED_MINESHAFT);
                    }
                    if (randomsource.nextInt(100) == 0) {
                        this.createChest(generatoraccessseed, structureboundingbox, randomsource, 0, 0, j2 + 1, LootTables.ABANDONED_MINESHAFT);
                    }
                    if (!this.spiderCorridor || this.hasPlacedSpider) continue;
                    boolean flag4 = true;
                    int l2 = j2 - 1 + randomsource.nextInt(3);
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(1, 0, l2);
                    if (!structureboundingbox.isInside(blockposition_mutableblockposition) || !this.isInterior(generatoraccessseed, 1, 0, l2, structureboundingbox)) continue;
                    this.hasPlacedSpider = true;
                    this.placeCraftSpawner(generatoraccessseed, blockposition_mutableblockposition, EntityType.CAVE_SPIDER, 2);
                }
                for (k2 = 0; k2 <= 2; ++k2) {
                    for (j2 = 0; j2 <= i2; ++j2) {
                        this.setPlanksBlock(generatoraccessseed, structureboundingbox, iblockdata, k2, -1, j2);
                    }
                }
                boolean flag5 = true;
                this.placeDoubleLowerOrUpperSupport(generatoraccessseed, structureboundingbox, 0, -1, 2);
                if (this.numSections > 1) {
                    j2 = i2 - 2;
                    this.placeDoubleLowerOrUpperSupport(generatoraccessseed, structureboundingbox, 0, -1, j2);
                }
                if (this.hasRails) {
                    IBlockData iblockdata1 = (IBlockData)Blocks.RAIL.defaultBlockState().setValue(BlockMinecartTrack.SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                    for (int i1 = 0; i1 <= i2; ++i1) {
                        IBlockData iblockdata2 = this.getBlock(generatoraccessseed, 1, -1, i1, structureboundingbox);
                        if (iblockdata2.isAir() || !iblockdata2.isSolidRender(generatoraccessseed, this.getWorldPos(1, -1, i1))) continue;
                        float f2 = this.isInterior(generatoraccessseed, 1, 0, i1, structureboundingbox) ? 0.7f : 0.9f;
                        this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, f2, 1, 0, i1, iblockdata1);
                    }
                }
            }
        }

        private void placeDoubleLowerOrUpperSupport(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2) {
            IBlockData iblockdata = this.type.getWoodState();
            IBlockData iblockdata1 = this.type.getPlanksState();
            if (this.getBlock(generatoraccessseed, i2, j2, k2, structureboundingbox).is(iblockdata1.getBlock())) {
                this.fillPillarDownOrChainUp(generatoraccessseed, iblockdata, i2, j2, k2, structureboundingbox);
            }
            if (this.getBlock(generatoraccessseed, i2 + 2, j2, k2, structureboundingbox).is(iblockdata1.getBlock())) {
                this.fillPillarDownOrChainUp(generatoraccessseed, iblockdata, i2 + 2, j2, k2, structureboundingbox);
            }
        }

        @Override
        protected void fillColumnDown(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
            if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
                int l2 = blockposition_mutableblockposition.getY();
                while (this.isReplaceableByStructures(generatoraccessseed.getBlockState(blockposition_mutableblockposition)) && blockposition_mutableblockposition.getY() > generatoraccessseed.getMinBuildHeight() + 1) {
                    blockposition_mutableblockposition.move(EnumDirection.DOWN);
                }
                if (this.canPlaceColumnOnTopOf(generatoraccessseed, blockposition_mutableblockposition, generatoraccessseed.getBlockState(blockposition_mutableblockposition))) {
                    while (blockposition_mutableblockposition.getY() < l2) {
                        blockposition_mutableblockposition.move(EnumDirection.UP);
                        generatoraccessseed.setBlock(blockposition_mutableblockposition, iblockdata, 2);
                    }
                }
            }
        }

        protected void fillPillarDownOrChainUp(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
            if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
                int l2 = blockposition_mutableblockposition.getY();
                int i1 = 1;
                boolean flag = true;
                boolean flag1 = true;
                while (flag || flag1) {
                    boolean flag2;
                    IBlockData iblockdata1;
                    if (flag) {
                        blockposition_mutableblockposition.setY(l2 - i1);
                        iblockdata1 = generatoraccessseed.getBlockState(blockposition_mutableblockposition);
                        boolean bl = flag2 = this.isReplaceableByStructures(iblockdata1) && !iblockdata1.is(Blocks.LAVA);
                        if (!flag2 && this.canPlaceColumnOnTopOf(generatoraccessseed, blockposition_mutableblockposition, iblockdata1)) {
                            a.fillColumnBetween(generatoraccessseed, iblockdata, blockposition_mutableblockposition, l2 - i1 + 1, l2);
                            return;
                        }
                        boolean bl2 = flag = i1 <= 20 && flag2 && blockposition_mutableblockposition.getY() > generatoraccessseed.getMinBuildHeight() + 1;
                    }
                    if (flag1) {
                        blockposition_mutableblockposition.setY(l2 + i1);
                        iblockdata1 = generatoraccessseed.getBlockState(blockposition_mutableblockposition);
                        flag2 = this.isReplaceableByStructures(iblockdata1);
                        if (!flag2 && this.canHangChainBelow(generatoraccessseed, blockposition_mutableblockposition, iblockdata1)) {
                            generatoraccessseed.setBlock(blockposition_mutableblockposition.setY(l2 + 1), this.type.getFenceState(), 2);
                            a.fillColumnBetween(generatoraccessseed, Blocks.CHAIN.defaultBlockState(), blockposition_mutableblockposition, l2 + 2, l2 + i1);
                            return;
                        }
                        flag1 = i1 <= 50 && flag2 && blockposition_mutableblockposition.getY() < generatoraccessseed.getMaxBuildHeight() - 1;
                    }
                    ++i1;
                }
            }
        }

        private static void fillColumnBetween(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2, int j2) {
            for (int k2 = i2; k2 < j2; ++k2) {
                generatoraccessseed.setBlock(blockposition_mutableblockposition.setY(k2), iblockdata, 2);
            }
        }

        private boolean canPlaceColumnOnTopOf(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
            return iblockdata.isFaceSturdy(iworldreader, blockposition, EnumDirection.UP);
        }

        private boolean canHangChainBelow(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
            return Block.canSupportCenter(iworldreader, blockposition, EnumDirection.DOWN) && !(iblockdata.getBlock() instanceof BlockFalling);
        }

        private void placeSupport(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, RandomSource randomsource) {
            if (this.isSupportingBox(generatoraccessseed, structureboundingbox, i2, i1, l2, k2)) {
                IBlockData iblockdata = this.type.getPlanksState();
                IBlockData iblockdata1 = this.type.getFenceState();
                this.generateBox(generatoraccessseed, structureboundingbox, i2, j2, k2, i2, l2 - 1, k2, (IBlockData)iblockdata1.setValue(BlockFence.WEST, true), CAVE_AIR, false);
                this.generateBox(generatoraccessseed, structureboundingbox, i1, j2, k2, i1, l2 - 1, k2, (IBlockData)iblockdata1.setValue(BlockFence.EAST, true), CAVE_AIR, false);
                if (randomsource.nextInt(4) == 0) {
                    this.generateBox(generatoraccessseed, structureboundingbox, i2, l2, k2, i2, l2, k2, iblockdata, CAVE_AIR, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, i1, l2, k2, i1, l2, k2, iblockdata, CAVE_AIR, false);
                } else {
                    this.generateBox(generatoraccessseed, structureboundingbox, i2, l2, k2, i1, l2, k2, iblockdata, CAVE_AIR, false);
                    this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.05f, i2 + 1, l2, k2 - 1, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.SOUTH));
                    this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.05f, i2 + 1, l2, k2 + 1, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.NORTH));
                }
            }
        }

        private void maybePlaceCobWeb(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, float f2, int i2, int j2, int k2) {
            if (this.isInterior(generatoraccessseed, i2, j2, k2, structureboundingbox) && randomsource.nextFloat() < f2 && this.hasSturdyNeighbours(generatoraccessseed, structureboundingbox, i2, j2, k2, 2)) {
                this.placeBlock(generatoraccessseed, Blocks.COBWEB.defaultBlockState(), i2, j2, k2, structureboundingbox);
            }
        }

        private boolean hasSturdyNeighbours(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2);
            int i1 = 0;
            for (EnumDirection enumdirection : EnumDirection.values()) {
                blockposition_mutableblockposition.move(enumdirection);
                if (structureboundingbox.isInside(blockposition_mutableblockposition) && generatoraccessseed.getBlockState(blockposition_mutableblockposition).isFaceSturdy(generatoraccessseed, blockposition_mutableblockposition, enumdirection.getOpposite()) && ++i1 >= l2) {
                    return true;
                }
                blockposition_mutableblockposition.move(enumdirection.getOpposite());
            }
            return false;
        }
    }

    private static abstract class c
    extends StructurePiece {
        protected MineshaftStructure.a type;

        public c(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, MineshaftStructure.a mineshaftstructure_a, StructureBoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i2, structureboundingbox);
            this.type = mineshaftstructure_a;
        }

        public c(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
            this.type = MineshaftStructure.a.byId(nbttagcompound.getInt("MST"));
        }

        @Override
        protected boolean canBeReplaced(IWorldReader iworldreader, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
            IBlockData iblockdata = this.getBlock(iworldreader, i2, j2, k2, structureboundingbox);
            return !iblockdata.is(this.type.getPlanksState().getBlock()) && !iblockdata.is(this.type.getWoodState().getBlock()) && !iblockdata.is(this.type.getFenceState().getBlock()) && !iblockdata.is(Blocks.CHAIN);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            nbttagcompound.putInt("MST", this.type.ordinal());
        }

        protected boolean isSupportingBox(IBlockAccess iblockaccess, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2) {
            for (int i1 = i2; i1 <= j2; ++i1) {
                if (!this.getBlock(iblockaccess, i1, k2 + 1, l2, structureboundingbox).isAir()) continue;
                return false;
            }
            return true;
        }

        protected boolean isInInvalidLocation(GeneratorAccess generatoraccess, StructureBoundingBox structureboundingbox) {
            int l1;
            int k1;
            int j1;
            int i1;
            int i2 = Math.max(this.boundingBox.minX() - 1, structureboundingbox.minX());
            int j2 = Math.max(this.boundingBox.minY() - 1, structureboundingbox.minY());
            int k2 = Math.max(this.boundingBox.minZ() - 1, structureboundingbox.minZ());
            int l2 = Math.min(this.boundingBox.maxX() + 1, structureboundingbox.maxX());
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition((i2 + l2) / 2, (j2 + (i1 = Math.min(this.boundingBox.maxY() + 1, structureboundingbox.maxY()))) / 2, (k2 + (j1 = Math.min(this.boundingBox.maxZ() + 1, structureboundingbox.maxZ()))) / 2);
            if (generatoraccess.getBiome(blockposition_mutableblockposition).is(BiomeTags.MINESHAFT_BLOCKING)) {
                return true;
            }
            for (k1 = i2; k1 <= l2; ++k1) {
                for (l1 = k2; l1 <= j1; ++l1) {
                    if (generatoraccess.getBlockState(blockposition_mutableblockposition.set(k1, j2, l1)).liquid()) {
                        return true;
                    }
                    if (!generatoraccess.getBlockState(blockposition_mutableblockposition.set(k1, i1, l1)).liquid()) continue;
                    return true;
                }
            }
            for (k1 = i2; k1 <= l2; ++k1) {
                for (l1 = j2; l1 <= i1; ++l1) {
                    if (generatoraccess.getBlockState(blockposition_mutableblockposition.set(k1, l1, k2)).liquid()) {
                        return true;
                    }
                    if (!generatoraccess.getBlockState(blockposition_mutableblockposition.set(k1, l1, j1)).liquid()) continue;
                    return true;
                }
            }
            for (k1 = k2; k1 <= j1; ++k1) {
                for (l1 = j2; l1 <= i1; ++l1) {
                    if (generatoraccess.getBlockState(blockposition_mutableblockposition.set(i2, l1, k1)).liquid()) {
                        return true;
                    }
                    if (!generatoraccess.getBlockState(blockposition_mutableblockposition.set(l2, l1, k1)).liquid()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void setPlanksBlock(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, IBlockData iblockdata, int i2, int j2, int k2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition;
            IBlockData iblockdata1;
            if (this.isInterior(generatoraccessseed, i2, j2, k2, structureboundingbox) && !(iblockdata1 = generatoraccessseed.getBlockState(blockposition_mutableblockposition = this.getWorldPos(i2, j2, k2))).isFaceSturdy(generatoraccessseed, blockposition_mutableblockposition, EnumDirection.UP)) {
                generatoraccessseed.setBlock(blockposition_mutableblockposition, iblockdata, 2);
            }
        }
    }

    public static class d
    extends c {
        private final List<StructureBoundingBox> childEntranceBoxes = Lists.newLinkedList();

        public d(int i2, RandomSource randomsource, int j2, int k2, MineshaftStructure.a mineshaftstructure_a) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_ROOM, i2, mineshaftstructure_a, new StructureBoundingBox(j2, 50, k2, j2 + 7 + randomsource.nextInt(6), 54 + randomsource.nextInt(6), k2 + 7 + randomsource.nextInt(6)));
            this.type = mineshaftstructure_a;
        }

        public d(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_ROOM, nbttagcompound);
            DataResult dataresult = StructureBoundingBox.CODEC.listOf().parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.getList("Entrances", 11));
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            Optional optional = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
            List<StructureBoundingBox> list = this.childEntranceBoxes;
            Objects.requireNonNull(this.childEntranceBoxes);
            optional.ifPresent(list::addAll);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            StructureBoundingBox structureboundingbox;
            c mineshaftpieces_c;
            int k2;
            int i2 = this.getGenDepth();
            int j2 = this.boundingBox.getYSpan() - 3 - 1;
            if (j2 <= 0) {
                j2 = 1;
            }
            for (k2 = 0; k2 < this.boundingBox.getXSpan() && (k2 += randomsource.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + k2, this.boundingBox.minY() + randomsource.nextInt(j2) + 1, this.boundingBox.minZ() - 1, EnumDirection.NORTH, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(structureboundingbox.minX(), structureboundingbox.minY(), this.boundingBox.minZ(), structureboundingbox.maxX(), structureboundingbox.maxY(), this.boundingBox.minZ() + 1));
            }
            for (k2 = 0; k2 < this.boundingBox.getXSpan() && (k2 += randomsource.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() + k2, this.boundingBox.minY() + randomsource.nextInt(j2) + 1, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(structureboundingbox.minX(), structureboundingbox.minY(), this.boundingBox.maxZ() - 1, structureboundingbox.maxX(), structureboundingbox.maxY(), this.boundingBox.maxZ()));
            }
            for (k2 = 0; k2 < this.boundingBox.getZSpan() && (k2 += randomsource.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + randomsource.nextInt(j2) + 1, this.boundingBox.minZ() + k2, EnumDirection.WEST, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(this.boundingBox.minX(), structureboundingbox.minY(), structureboundingbox.minZ(), this.boundingBox.minX() + 1, structureboundingbox.maxY(), structureboundingbox.maxZ()));
            }
            for (k2 = 0; k2 < this.boundingBox.getZSpan() && (k2 += randomsource.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); k2 += 4) {
                mineshaftpieces_c = MineshaftPieces.generateAndAddPiece(structurepiece, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + randomsource.nextInt(j2) + 1, this.boundingBox.minZ() + k2, EnumDirection.EAST, i2);
                if (mineshaftpieces_c == null) continue;
                structureboundingbox = mineshaftpieces_c.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(this.boundingBox.maxX() - 1, structureboundingbox.minY(), structureboundingbox.minZ(), this.boundingBox.maxX(), structureboundingbox.maxY(), structureboundingbox.maxZ()));
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            if (!this.isInInvalidLocation(generatoraccessseed, structureboundingbox)) {
                this.generateBox(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY() + 1, this.boundingBox.minZ(), this.boundingBox.maxX(), Math.min(this.boundingBox.minY() + 3, this.boundingBox.maxY()), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                for (StructureBoundingBox structureboundingbox1 : this.childEntranceBoxes) {
                    this.generateBox(generatoraccessseed, structureboundingbox, structureboundingbox1.minX(), structureboundingbox1.maxY() - 2, structureboundingbox1.minZ(), structureboundingbox1.maxX(), structureboundingbox1.maxY(), structureboundingbox1.maxZ(), CAVE_AIR, CAVE_AIR, false);
                }
                this.generateUpperHalfSphere(generatoraccessseed, structureboundingbox, this.boundingBox.minX(), this.boundingBox.minY() + 4, this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, false);
            }
        }

        @Override
        public void move(int i2, int j2, int k2) {
            super.move(i2, j2, k2);
            for (StructureBoundingBox structureboundingbox : this.childEntranceBoxes) {
                structureboundingbox.move(i2, j2, k2);
            }
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            DataResult dataresult = StructureBoundingBox.CODEC.listOf().encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.childEntranceBoxes);
            Logger logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("Entrances", (NBTBase)nbtbase));
        }
    }
}

