/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.entity.EntityType;

public class NetherFortressPieces {
    private static final int MAX_DEPTH = 30;
    private static final int LOWEST_Y_POSITION = 10;
    public static final int MAGIC_START_Y = 64;
    static final n[] BRIDGE_PIECE_WEIGHTS = new n[]{new n(c.class, 30, 0, true), new n(a.class, 10, 4), new n(o.class, 10, 4), new n(p.class, 10, 3), new n(l.class, 5, 2), new n(f.class, 5, 1)};
    static final n[] CASTLE_PIECE_WEIGHTS = new n[]{new n(i.class, 25, 0, true), new n(g.class, 15, 5), new n(j.class, 5, 10), new n(h.class, 5, 10), new n(d.class, 10, 3, true), new n(e.class, 7, 2), new n(k.class, 5, 2)};

    static m findAndCreateBridgePieceFactory(n netherfortresspieces_n, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
        Class<? extends m> oclass = netherfortresspieces_n.pieceClass;
        m object = null;
        if (oclass == c.class) {
            object = c.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == a.class) {
            object = a.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        } else if (oclass == o.class) {
            object = o.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        } else if (oclass == p.class) {
            object = p.createPiece(structurepieceaccessor, i2, j2, k2, l2, enumdirection);
        } else if (oclass == l.class) {
            object = l.createPiece(structurepieceaccessor, i2, j2, k2, l2, enumdirection);
        } else if (oclass == f.class) {
            object = f.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == i.class) {
            object = i.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        } else if (oclass == j.class) {
            object = j.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == h.class) {
            object = h.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == d.class) {
            object = d.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        } else if (oclass == e.class) {
            object = e.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        } else if (oclass == g.class) {
            object = g.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        } else if (oclass == k.class) {
            object = k.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        }
        return object;
    }

    private static class n {
        public final Class<? extends m> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;
        public final boolean allowInRow;

        public n(Class<? extends m> oclass, int i2, int j2, boolean flag) {
            this.pieceClass = oclass;
            this.weight = i2;
            this.maxPlaceCount = j2;
            this.allowInRow = flag;
        }

        public n(Class<? extends m> oclass, int i2, int j2) {
            this(oclass, i2, j2, false);
        }

        public boolean doPlace(int i2) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class c
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public c(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public c(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 1, 3, false);
        }

        public static c createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -3, 0, 5, 10, 19, enumdirection);
            return c.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new c(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 0, 4, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 0, 3, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 0, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 0, 4, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 13, 4, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 15, 4, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 2; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, 18 - j2, structureboundingbox);
                }
            }
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            IBlockData iblockdata1 = (IBlockData)iblockdata.setValue(BlockFence.EAST, true);
            IBlockData iblockdata2 = (IBlockData)iblockdata.setValue(BlockFence.WEST, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 1, 0, 4, 1, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 4, 0, 4, 4, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 14, 0, 4, 14, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 17, 0, 4, 17, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 4, 1, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 4, 4, 4, 4, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 14, 4, 4, 14, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 17, 4, 4, 17, iblockdata2, iblockdata2, false);
        }
    }

    public static class a
    extends m {
        private static final int WIDTH = 19;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public a(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        protected a(int i2, int j2, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, 0, StructurePiece.makeBoundingBox(i2, 64, j2, enumdirection, 19, 10, 19));
            this.setOrientation(enumdirection);
        }

        protected a(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
        }

        public a(NBTTagCompound nbttagcompound) {
            this(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 8, 3, false);
            this.generateChildLeft((q)structurepiece, structurepieceaccessor, randomsource, 3, 8, false);
            this.generateChildRight((q)structurepiece, structurepieceaccessor, randomsource, 3, 8, false);
        }

        public static a createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -8, -3, 0, 19, 10, 19, enumdirection);
            return a.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new a(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            int j2;
            int i2;
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 3, 0, 11, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 7, 18, 4, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 0, 10, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 8, 18, 7, 10, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 5, 0, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 5, 11, 7, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 0, 11, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 11, 11, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 7, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 7, 18, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 11, 7, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 11, 18, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 2, 0, 11, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 2, 13, 11, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 0, 0, 11, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 0, 15, 11, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (i2 = 7; i2 <= 11; ++i2) {
                for (j2 = 0; j2 <= 2; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, 18 - j2, structureboundingbox);
                }
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 7, 5, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 13, 2, 7, 18, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 7, 3, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 15, 0, 7, 18, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (i2 = 0; i2 <= 2; ++i2) {
                for (j2 = 7; j2 <= 11; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 18 - i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class o
    extends m {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 9;
        private static final int DEPTH = 7;

        public o(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public o(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 2, 0, false);
            this.generateChildLeft((q)structurepiece, structurepieceaccessor, randomsource, 0, 2, false);
            this.generateChildRight((q)structurepiece, structurepieceaccessor, randomsource, 0, 2, false);
        }

        public static o createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -2, 0, 0, 7, 9, 7, enumdirection);
            return o.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new o(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 6, 7, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 1, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 6, 1, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 0, 6, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 6, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 5, 0, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 0, 6, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 5, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 0, 4, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 5, 0, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 6, 4, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 6, 4, 5, 6, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 2, 0, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 2, 0, 5, 4, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 6, 2, 6, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 5, 2, 6, 5, 4, iblockdata1, iblockdata1, false);
            for (int i2 = 0; i2 <= 6; ++i2) {
                for (int j2 = 0; j2 <= 6; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class p
    extends m {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 7;

        public p(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public p(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildRight((q)structurepiece, structurepieceaccessor, randomsource, 6, 2, false);
        }

        public static p createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, int l2, EnumDirection enumdirection) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -2, 0, 0, 7, 11, 7, enumdirection);
            return p.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new p(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 6, 10, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 1, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 0, 6, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 1, 0, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 1, 6, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 6, 5, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 2, 0, 5, 4, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 3, 2, 6, 5, 2, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 3, 4, 6, 5, 4, iblockdata1, iblockdata1, false);
            this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 5, 2, 5, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 5, 4, 3, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 2, 5, 3, 4, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 2, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 5, 1, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 7, 1, 5, 7, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 8, 2, 6, 8, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 0, 4, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 5, 0, iblockdata, iblockdata, false);
            for (int i2 = 0; i2 <= 6; ++i2) {
                for (int j2 = 0; j2 <= 6; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class l
    extends m {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 8;
        private static final int DEPTH = 9;
        private boolean hasPlacedSpawner;

        public l(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public l(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, nbttagcompound);
            this.hasPlacedSpawner = nbttagcompound.getBoolean("Mob");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Mob", this.hasPlacedSpawner);
        }

        public static l createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, int l2, EnumDirection enumdirection) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -2, 0, 0, 7, 8, 9, enumdirection);
            return l.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new l(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition;
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 6, 7, 7, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 0, 0, 5, 1, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 1, 5, 2, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 2, 5, 3, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 3, 5, 4, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 0, 1, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 0, 5, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 2, 1, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, 2, 5, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 3, 0, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 5, 3, 6, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 8, 5, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true), 1, 6, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true), 5, 6, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true)).setValue(BlockFence.NORTH, true), 0, 6, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.NORTH, true), 6, 6, 3, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 4, 0, 6, 7, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 6, 4, 6, 6, 7, iblockdata1, iblockdata1, false);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true)).setValue(BlockFence.SOUTH, true), 0, 6, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.SOUTH, true), 6, 6, 8, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, 8, 5, 6, 8, iblockdata, iblockdata, false);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true), 1, 7, 8, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 7, 8, 4, 7, 8, iblockdata, iblockdata, false);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true), 5, 7, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true), 2, 8, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata, 3, 8, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true), 4, 8, 8, structureboundingbox);
            if (!this.hasPlacedSpawner && structureboundingbox.isInside(blockposition_mutableblockposition = this.getWorldPos(3, 5, 5))) {
                this.hasPlacedSpawner = true;
                this.placeCraftSpawner(generatoraccessseed, blockposition_mutableblockposition, EntityType.BLAZE, 2);
            }
            for (int i2 = 0; i2 <= 6; ++i2) {
                for (int j2 = 0; j2 <= 6; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class f
    extends m {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public f(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public f(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 5, 3, true);
        }

        public static f createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -5, -3, 0, 13, 14, 13, enumdirection);
            return f.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new f(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            int j2;
            int i2;
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 8, 0, 7, 8, 0, Blocks.NETHER_BRICK_FENCE.defaultBlockState(), Blocks.NETHER_BRICK_FENCE.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            for (i2 = 1; i2 <= 11; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, i2, 10, 0, i2, 11, 0, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, i2, 10, 12, i2, 11, 12, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 10, i2, 0, 11, i2, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 10, i2, 12, 11, i2, iblockdata1, iblockdata1, false);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, i2, structureboundingbox);
                if (i2 == 11) continue;
                this.placeBlock(generatoraccessseed, iblockdata, i2 + 1, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, i2 + 1, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 0, 13, i2 + 1, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 12, 13, i2 + 1, structureboundingbox);
            }
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 0, 13, 0, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.EAST, true), 0, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.WEST, true), 12, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.WEST, true), 12, 13, 0, structureboundingbox);
            for (i2 = 3; i2 <= 9; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 7, i2, 1, 8, i2, (IBlockData)iblockdata1.setValue(BlockFence.WEST, true), (IBlockData)iblockdata1.setValue(BlockFence.WEST, true), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 11, 7, i2, 11, 8, i2, (IBlockData)iblockdata1.setValue(BlockFence.EAST, true), (IBlockData)iblockdata1.setValue(BlockFence.EAST, true), false);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (i2 = 4; i2 <= 8; ++i2) {
                for (j2 = 0; j2 <= 2; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, 12 - j2, structureboundingbox);
                }
            }
            for (i2 = 0; i2 <= 2; ++i2) {
                for (j2 = 4; j2 <= 8; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - i2, -1, j2, structureboundingbox);
                }
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, 5, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 1, 6, 6, 4, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 6, 0, 6, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.LAVA.defaultBlockState(), 6, 5, 6, structureboundingbox);
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.getWorldPos(6, 5, 6);
            if (structureboundingbox.isInside(blockposition_mutableblockposition)) {
                generatoraccessseed.scheduleTick((BlockPosition)blockposition_mutableblockposition, FluidTypes.LAVA, 0);
            }
        }
    }

    public static class i
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public i(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public i(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 1, 0, true);
        }

        public static i createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, 0, 0, 5, 7, 5, enumdirection);
            return i.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new i(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 1, 0, 4, 1, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 3, 0, 4, 3, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 1, 4, 4, 1, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 3, 4, 4, 3, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class j
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public j(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.isNeedingChest = randomsource.nextInt(3) == 0;
        }

        public j(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, nbttagcompound);
            this.isNeedingChest = nbttagcompound.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildRight((q)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
        }

        public static j createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, 0, 0, 5, 7, 5, enumdirection);
            return j.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new j(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 1, 0, 4, 1, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 3, 0, 4, 3, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 4, 1, 4, 4, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 3, 4, 3, 4, 4, iblockdata, iblockdata, false);
            if (this.isNeedingChest && structureboundingbox.isInside(this.getWorldPos(1, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 1, 2, 3, LootTables.NETHER_BRIDGE);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class h
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public h(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.isNeedingChest = randomsource.nextInt(3) == 0;
        }

        public h(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, nbttagcompound);
            this.isNeedingChest = nbttagcompound.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildLeft((q)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
        }

        public static h createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, 0, 0, 5, 7, 5, enumdirection);
            return h.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new h(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 1, 4, 4, 1, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 3, 4, 4, 3, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 3, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 4, 1, 4, 4, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 3, 4, 3, 4, 4, iblockdata, iblockdata, false);
            if (this.isNeedingChest && structureboundingbox.isInside(this.getWorldPos(3, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 2, 3, LootTables.NETHER_BRIDGE);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class d
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 10;

        public d(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public d(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 1, 0, true);
        }

        public static d createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -7, 0, 5, 14, 10, enumdirection);
            return d.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new d(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            IBlockData iblockdata = (IBlockData)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            for (int i2 = 0; i2 <= 9; ++i2) {
                int j2 = Math.max(1, 7 - i2);
                int k2 = Math.min(Math.max(j2 + 5, 14 - i2), 13);
                int l2 = i2;
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, i2, 4, j2, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 1, j2 + 1, i2, 3, k2 - 1, i2, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
                if (i2 <= 6) {
                    this.placeBlock(generatoraccessseed, iblockdata, 1, j2 + 1, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 2, j2 + 1, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 3, j2 + 1, i2, structureboundingbox);
                }
                this.generateBox(generatoraccessseed, structureboundingbox, 0, k2, i2, 4, k2, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, j2 + 1, i2, 0, k2 - 1, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, j2 + 1, i2, 4, k2 - 1, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                if ((i2 & 1) == 0) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 0, j2 + 2, i2, 0, j2 + 3, i2, iblockdata1, iblockdata1, false);
                    this.generateBox(generatoraccessseed, structureboundingbox, 4, j2 + 2, i2, 4, j2 + 3, i2, iblockdata1, iblockdata1, false);
                }
                for (int i1 = 0; i1 <= 4; ++i1) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i1, -1, l2, structureboundingbox);
                }
            }
        }
    }

    public static class e
    extends m {
        private static final int WIDTH = 9;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 9;

        public e(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public e(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int b0 = 1;
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection == EnumDirection.WEST || enumdirection == EnumDirection.NORTH) {
                b0 = 5;
            }
            this.generateChildLeft((q)structurepiece, structurepieceaccessor, randomsource, 0, b0, randomsource.nextInt(8) > 0);
            this.generateChildRight((q)structurepiece, structurepieceaccessor, randomsource, 0, b0, randomsource.nextInt(8) > 0);
        }

        public static e createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -3, 0, 0, 9, 7, 9, enumdirection);
            return e.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new e(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 8, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 8, 5, 8, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 8, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 2, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 2, 0, 8, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 0, 1, 4, 0, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 3, 0, 7, 4, 0, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 8, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 4, 2, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 1, 4, 7, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 8, 7, 3, 8, iblockdata1, iblockdata1, false);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true)).setValue(BlockFence.SOUTH, true), 0, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.SOUTH, true), 8, 3, 8, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 6, 0, 3, 7, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 3, 6, 8, 3, 7, iblockdata, iblockdata, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 4, 0, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 3, 4, 8, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 6, 3, 5, 7, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 5, 1, 5, 5, iblockdata1, iblockdata1, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 4, 5, 7, 5, 5, iblockdata1, iblockdata1, false);
            for (int i2 = 0; i2 <= 5; ++i2) {
                for (int j2 = 0; j2 <= 8; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), j2, -1, i2, structureboundingbox);
                }
            }
        }
    }

    public static class g
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public g(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public g(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 1, 0, true);
            this.generateChildLeft((q)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
            this.generateChildRight((q)structurepiece, structurepieceaccessor, randomsource, 0, 1, true);
        }

        public static g createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, 0, 0, 5, 7, 5, enumdirection);
            return g.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new g(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int i2 = 0; i2 <= 4; ++i2) {
                for (int j2 = 0; j2 <= 4; ++j2) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, -1, j2, structureboundingbox);
                }
            }
        }
    }

    public static class k
    extends m {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public k(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public k(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 5, 3, true);
            this.generateChildForward((q)structurepiece, structurepieceaccessor, randomsource, 5, 11, true);
        }

        public static k createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -5, -3, 0, 13, 14, 13, enumdirection);
            return k.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new k(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            int i1;
            int k2;
            int j2;
            int i2;
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            IBlockData iblockdata2 = (IBlockData)iblockdata1.setValue(BlockFence.WEST, true);
            IBlockData iblockdata3 = (IBlockData)iblockdata1.setValue(BlockFence.EAST, true);
            for (i2 = 1; i2 <= 11; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, i2, 10, 0, i2, 11, 0, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, i2, 10, 12, i2, 11, 12, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 10, i2, 0, 11, i2, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 10, i2, 12, 11, i2, iblockdata1, iblockdata1, false);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), i2, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, i2, structureboundingbox);
                if (i2 == 11) continue;
                this.placeBlock(generatoraccessseed, iblockdata, i2 + 1, 13, 0, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, i2 + 1, 13, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 0, 13, i2 + 1, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata1, 12, 13, i2 + 1, structureboundingbox);
            }
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 0, 13, 0, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.EAST, true), 0, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.WEST, true), 12, 13, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.WEST, true), 12, 13, 0, structureboundingbox);
            for (i2 = 3; i2 <= 9; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 7, i2, 1, 8, i2, iblockdata2, iblockdata2, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 11, 7, i2, 11, 8, i2, iblockdata3, iblockdata3, false);
            }
            IBlockData iblockdata4 = (IBlockData)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
            for (j2 = 0; j2 <= 6; ++j2) {
                int l2 = j2 + 4;
                for (k2 = 5; k2 <= 7; ++k2) {
                    this.placeBlock(generatoraccessseed, iblockdata4, k2, 5 + j2, l2, structureboundingbox);
                }
                if (l2 >= 5 && l2 <= 8) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, l2, 7, j2 + 4, l2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                } else if (l2 >= 9 && l2 <= 10) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 5, 8, l2, 7, j2 + 4, l2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
                if (j2 < 1) continue;
                this.generateBox(generatoraccessseed, structureboundingbox, 5, 6 + j2, l2, 7, 9 + j2, l2, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            }
            for (j2 = 5; j2 <= 7; ++j2) {
                this.placeBlock(generatoraccessseed, iblockdata4, j2, 12, 11, structureboundingbox);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 6, 7, 5, 7, 7, iblockdata3, iblockdata3, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 7, 6, 7, 7, 7, 7, iblockdata2, iblockdata2, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 13, 12, 7, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 2, 3, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 9, 3, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 5, 4, 2, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 5, 2, 10, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 5, 9, 10, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 10, 5, 4, 10, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData iblockdata5 = (IBlockData)iblockdata4.setValue(BlockStairs.FACING, EnumDirection.EAST);
            IBlockData iblockdata6 = (IBlockData)iblockdata4.setValue(BlockStairs.FACING, EnumDirection.WEST);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata6, 4, 5, 10, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata5, 8, 5, 10, structureboundingbox);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 4, 4, 4, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 4, 4, 9, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 5, 4, 4, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 4, 9, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (k2 = 4; k2 <= 8; ++k2) {
                for (i1 = 0; i1 <= 2; ++i1) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k2, -1, i1, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k2, -1, 12 - i1, structureboundingbox);
                }
            }
            for (k2 = 0; k2 <= 2; ++k2) {
                for (i1 = 4; i1 <= 8; ++i1) {
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), k2, -1, i1, structureboundingbox);
                    this.fillColumnDown(generatoraccessseed, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - k2, -1, i1, structureboundingbox);
                }
            }
        }
    }

    private static abstract class m
    extends StructurePiece {
        protected m(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, StructureBoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i2, structureboundingbox);
        }

        public m(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
        }

        private int updatePieceWeight(List<n> list) {
            boolean flag = false;
            int i2 = 0;
            for (n netherfortresspieces_n : list) {
                if (netherfortresspieces_n.maxPlaceCount > 0 && netherfortresspieces_n.placeCount < netherfortresspieces_n.maxPlaceCount) {
                    flag = true;
                }
                i2 += netherfortresspieces_n.weight;
            }
            return flag ? i2 : -1;
        }

        private m generatePiece(q netherfortresspieces_q, List<n> list, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            int i1 = this.updatePieceWeight(list);
            boolean flag = i1 > 0 && l2 <= 30;
            int j1 = 0;
            block0: while (j1 < 5 && flag) {
                ++j1;
                int k1 = randomsource.nextInt(i1);
                for (n netherfortresspieces_n : list) {
                    if ((k1 -= netherfortresspieces_n.weight) >= 0) continue;
                    if (!netherfortresspieces_n.doPlace(l2) || netherfortresspieces_n == netherfortresspieces_q.previousPiece && !netherfortresspieces_n.allowInRow) continue block0;
                    m netherfortresspieces_m = NetherFortressPieces.findAndCreateBridgePieceFactory(netherfortresspieces_n, structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
                    if (netherfortresspieces_m == null) continue;
                    ++netherfortresspieces_n.placeCount;
                    netherfortresspieces_q.previousPiece = netherfortresspieces_n;
                    if (!netherfortresspieces_n.isValid()) {
                        list.remove(netherfortresspieces_n);
                    }
                    return netherfortresspieces_m;
                }
            }
            return b.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        }

        private StructurePiece generateAndAddPiece(q netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, @Nullable EnumDirection enumdirection, int l2, boolean flag) {
            if (Math.abs(i2 - netherfortresspieces_q.getBoundingBox().minX()) <= 112 && Math.abs(k2 - netherfortresspieces_q.getBoundingBox().minZ()) <= 112) {
                m netherfortresspieces_m;
                List<n> list = netherfortresspieces_q.availableBridgePieces;
                if (flag) {
                    list = netherfortresspieces_q.availableCastlePieces;
                }
                if ((netherfortresspieces_m = this.generatePiece(netherfortresspieces_q, list, structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2 + 1)) != null) {
                    structurepieceaccessor.addPiece(netherfortresspieces_m);
                    netherfortresspieces_q.pendingChildren.add(netherfortresspieces_m);
                }
                return netherfortresspieces_m;
            }
            return b.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        }

        @Nullable
        protected StructurePiece generateChildForward(q netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, boolean flag) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + i2, this.boundingBox.minY() + j2, this.boundingBox.minZ() - 1, enumdirection, this.getGenDepth(), flag);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + i2, this.boundingBox.minY() + j2, this.boundingBox.maxZ() + 1, enumdirection, this.getGenDepth(), flag);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + j2, this.boundingBox.minZ() + i2, enumdirection, this.getGenDepth(), flag);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + j2, this.boundingBox.minZ() + i2, enumdirection, this.getGenDepth(), flag);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateChildLeft(q netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, boolean flag) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.WEST, this.getGenDepth(), flag);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.WEST, this.getGenDepth(), flag);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth(), flag);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth(), flag);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateChildRight(q netherfortresspieces_q, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, boolean flag) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.EAST, this.getGenDepth(), flag);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.EAST, this.getGenDepth(), flag);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth(), flag);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(netherfortresspieces_q, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth(), flag);
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(StructureBoundingBox structureboundingbox) {
            return structureboundingbox != null && structureboundingbox.minY() > 10;
        }
    }

    public static class q
    extends a {
        public n previousPiece;
        public List<n> availableBridgePieces;
        public List<n> availableCastlePieces;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public q(RandomSource randomsource, int i2, int j2) {
            super(i2, j2, q.getRandomHorizontalDirection(randomsource));
            this.availableBridgePieces = Lists.newArrayList();
            for (n netherfortresspieces_n : BRIDGE_PIECE_WEIGHTS) {
                netherfortresspieces_n.placeCount = 0;
                this.availableBridgePieces.add(netherfortresspieces_n);
            }
            this.availableCastlePieces = Lists.newArrayList();
            for (n netherfortresspieces_n : CASTLE_PIECE_WEIGHTS) {
                netherfortresspieces_n.placeCount = 0;
                this.availableCastlePieces.add(netherfortresspieces_n);
            }
        }

        public q(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_START, nbttagcompound);
        }
    }

    public static class b
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 8;
        private final int selfSeed;

        public b(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.selfSeed = randomsource.nextInt();
        }

        public b(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, nbttagcompound);
            this.selfSeed = nbttagcompound.getInt("Seed");
        }

        public static b createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -3, 0, 5, 10, 8, enumdirection);
            return b.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new b(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putInt("Seed", this.selfSeed);
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            int i2;
            int k2;
            int j2;
            RandomSource randomsource1 = RandomSource.create(this.selfSeed);
            for (j2 = 0; j2 <= 4; ++j2) {
                for (k2 = 3; k2 <= 4; ++k2) {
                    i2 = randomsource1.nextInt(8);
                    this.generateBox(generatoraccessseed, structureboundingbox, j2, k2, 0, j2, k2, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
            j2 = randomsource1.nextInt(8);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 0, 0, 5, j2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            j2 = randomsource1.nextInt(8);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 0, 4, 5, j2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (j2 = 0; j2 <= 4; ++j2) {
                k2 = randomsource1.nextInt(5);
                this.generateBox(generatoraccessseed, structureboundingbox, j2, 2, 0, j2, 2, k2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            }
            for (j2 = 0; j2 <= 4; ++j2) {
                for (k2 = 0; k2 <= 1; ++k2) {
                    i2 = randomsource1.nextInt(3);
                    this.generateBox(generatoraccessseed, structureboundingbox, j2, k2, 0, j2, k2, i2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
        }
    }
}

