/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftChest;

public class OceanRuinPieces {
    static final DefinedStructureProcessor WARM_SUSPICIOUS_BLOCK_PROCESSOR = OceanRuinPieces.archyRuleProcessor(Blocks.SAND, Blocks.SUSPICIOUS_SAND, LootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY);
    static final DefinedStructureProcessor COLD_SUSPICIOUS_BLOCK_PROCESSOR = OceanRuinPieces.archyRuleProcessor(Blocks.GRAVEL, Blocks.SUSPICIOUS_GRAVEL, LootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY);
    private static final MinecraftKey[] WARM_RUINS = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/warm_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_8")};
    private static final MinecraftKey[] RUINS_BRICK = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/brick_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_8")};
    private static final MinecraftKey[] RUINS_CRACKED = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_8")};
    private static final MinecraftKey[] RUINS_MOSSY = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_8")};
    private static final MinecraftKey[] BIG_RUINS_BRICK = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_8")};
    private static final MinecraftKey[] BIG_RUINS_MOSSY = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_8")};
    private static final MinecraftKey[] BIG_RUINS_CRACKED = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_8")};
    private static final MinecraftKey[] BIG_WARM_RUINS = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_7")};

    private static DefinedStructureProcessor archyRuleProcessor(Block block, Block block1, ResourceKey<LootTable> resourcekey) {
        return new CappedProcessor(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(block), DefinedStructureTestTrue.INSTANCE, PosRuleTestTrue.INSTANCE, block1.defaultBlockState(), new AppendLoot(resourcekey)))), ConstantInt.of(5));
    }

    private static MinecraftKey getSmallWarmRuin(RandomSource randomsource) {
        return (MinecraftKey)SystemUtils.getRandom((Object[])WARM_RUINS, randomsource);
    }

    private static MinecraftKey getBigWarmRuin(RandomSource randomsource) {
        return (MinecraftKey)SystemUtils.getRandom((Object[])BIG_WARM_RUINS, randomsource);
    }

    public static void addPieces(StructureTemplateManager structuretemplatemanager, BlockPosition blockposition, EnumBlockRotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, OceanRuinStructure oceanruinstructure) {
        boolean flag = randomsource.nextFloat() <= oceanruinstructure.largeProbability;
        float f2 = flag ? 0.9f : 0.8f;
        OceanRuinPieces.addPiece(structuretemplatemanager, blockposition, enumblockrotation, structurepieceaccessor, randomsource, oceanruinstructure, flag, f2);
        if (flag && randomsource.nextFloat() <= oceanruinstructure.clusterProbability) {
            OceanRuinPieces.addClusterRuins(structuretemplatemanager, randomsource, enumblockrotation, blockposition, oceanruinstructure, structurepieceaccessor);
        }
    }

    private static void addClusterRuins(StructureTemplateManager structuretemplatemanager, RandomSource randomsource, EnumBlockRotation enumblockrotation, BlockPosition blockposition, OceanRuinStructure oceanruinstructure, StructurePieceAccessor structurepieceaccessor) {
        BlockPosition blockposition1 = new BlockPosition(blockposition.getX(), 90, blockposition.getZ());
        BlockPosition blockposition2 = DefinedStructure.transform(new BlockPosition(15, 0, 15), EnumBlockMirror.NONE, enumblockrotation, BlockPosition.ZERO).offset(blockposition1);
        StructureBoundingBox structureboundingbox = StructureBoundingBox.fromCorners(blockposition1, blockposition2);
        BlockPosition blockposition3 = new BlockPosition(Math.min(blockposition1.getX(), blockposition2.getX()), blockposition1.getY(), Math.min(blockposition1.getZ(), blockposition2.getZ()));
        List<BlockPosition> list = OceanRuinPieces.allPositions(randomsource, blockposition3);
        int i2 = MathHelper.nextInt(randomsource, 4, 8);
        for (int j2 = 0; j2 < i2; ++j2) {
            EnumBlockRotation enumblockrotation1;
            BlockPosition blockposition5;
            int k2;
            BlockPosition blockposition4;
            StructureBoundingBox structureboundingbox1;
            if (list.isEmpty() || (structureboundingbox1 = StructureBoundingBox.fromCorners(blockposition4 = list.remove(k2 = randomsource.nextInt(list.size())), blockposition5 = DefinedStructure.transform(new BlockPosition(5, 0, 6), EnumBlockMirror.NONE, enumblockrotation1 = EnumBlockRotation.getRandom(randomsource), BlockPosition.ZERO).offset(blockposition4))).intersects(structureboundingbox)) continue;
            OceanRuinPieces.addPiece(structuretemplatemanager, blockposition4, enumblockrotation1, structurepieceaccessor, randomsource, oceanruinstructure, false, 0.8f);
        }
    }

    private static List<BlockPosition> allPositions(RandomSource randomsource, BlockPosition blockposition) {
        ArrayList list = Lists.newArrayList();
        list.add(blockposition.offset(-16 + MathHelper.nextInt(randomsource, 1, 8), 0, 16 + MathHelper.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(-16 + MathHelper.nextInt(randomsource, 1, 8), 0, MathHelper.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(-16 + MathHelper.nextInt(randomsource, 1, 8), 0, -16 + MathHelper.nextInt(randomsource, 4, 8)));
        list.add(blockposition.offset(MathHelper.nextInt(randomsource, 1, 7), 0, 16 + MathHelper.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(MathHelper.nextInt(randomsource, 1, 7), 0, -16 + MathHelper.nextInt(randomsource, 4, 6)));
        list.add(blockposition.offset(16 + MathHelper.nextInt(randomsource, 1, 7), 0, 16 + MathHelper.nextInt(randomsource, 3, 8)));
        list.add(blockposition.offset(16 + MathHelper.nextInt(randomsource, 1, 7), 0, MathHelper.nextInt(randomsource, 1, 7)));
        list.add(blockposition.offset(16 + MathHelper.nextInt(randomsource, 1, 7), 0, -16 + MathHelper.nextInt(randomsource, 4, 8)));
        return list;
    }

    private static void addPiece(StructureTemplateManager structuretemplatemanager, BlockPosition blockposition, EnumBlockRotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, OceanRuinStructure oceanruinstructure, boolean flag, float f2) {
        switch (oceanruinstructure.biomeTemp) {
            default: {
                MinecraftKey minecraftkey = flag ? OceanRuinPieces.getBigWarmRuin(randomsource) : OceanRuinPieces.getSmallWarmRuin(randomsource);
                structurepieceaccessor.addPiece(new a(structuretemplatemanager, minecraftkey, blockposition, enumblockrotation, f2, oceanruinstructure.biomeTemp, flag));
                break;
            }
            case COLD: {
                MinecraftKey[] aminecraftkey = flag ? BIG_RUINS_BRICK : RUINS_BRICK;
                MinecraftKey[] aminecraftkey1 = flag ? BIG_RUINS_CRACKED : RUINS_CRACKED;
                MinecraftKey[] aminecraftkey2 = flag ? BIG_RUINS_MOSSY : RUINS_MOSSY;
                int i2 = randomsource.nextInt(aminecraftkey.length);
                structurepieceaccessor.addPiece(new a(structuretemplatemanager, aminecraftkey[i2], blockposition, enumblockrotation, f2, oceanruinstructure.biomeTemp, flag));
                structurepieceaccessor.addPiece(new a(structuretemplatemanager, aminecraftkey1[i2], blockposition, enumblockrotation, 0.7f, oceanruinstructure.biomeTemp, flag));
                structurepieceaccessor.addPiece(new a(structuretemplatemanager, aminecraftkey2[i2], blockposition, enumblockrotation, 0.5f, oceanruinstructure.biomeTemp, flag));
            }
        }
    }

    public static class a
    extends DefinedStructurePiece {
        private final OceanRuinStructure.a biomeType;
        private final float integrity;
        private final boolean isLarge;

        public a(StructureTemplateManager structuretemplatemanager, MinecraftKey minecraftkey, BlockPosition blockposition, EnumBlockRotation enumblockrotation, float f2, OceanRuinStructure.a oceanruinstructure_a, boolean flag) {
            super(WorldGenFeatureStructurePieceType.OCEAN_RUIN, 0, structuretemplatemanager, minecraftkey, minecraftkey.toString(), a.makeSettings(enumblockrotation, f2, oceanruinstructure_a), blockposition);
            this.integrity = f2;
            this.biomeType = oceanruinstructure_a;
            this.isLarge = flag;
        }

        private a(StructureTemplateManager structuretemplatemanager, NBTTagCompound nbttagcompound, EnumBlockRotation enumblockrotation, float f2, OceanRuinStructure.a oceanruinstructure_a, boolean flag) {
            super(WorldGenFeatureStructurePieceType.OCEAN_RUIN, nbttagcompound, structuretemplatemanager, minecraftkey -> a.makeSettings(enumblockrotation, f2, oceanruinstructure_a));
            this.integrity = f2;
            this.biomeType = oceanruinstructure_a;
            this.isLarge = flag;
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation enumblockrotation, float f2, OceanRuinStructure.a oceanruinstructure_a) {
            DefinedStructureProcessor definedstructureprocessor = oceanruinstructure_a == OceanRuinStructure.a.COLD ? COLD_SUSPICIOUS_BLOCK_PROCESSOR : WARM_SUSPICIOUS_BLOCK_PROCESSOR;
            return new DefinedStructureInfo().setRotation(enumblockrotation).setMirror(EnumBlockMirror.NONE).addProcessor(new DefinedStructureProcessorRotation(f2)).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR).addProcessor(definedstructureprocessor);
        }

        public static a create(StructureTemplateManager structuretemplatemanager, NBTTagCompound nbttagcompound) {
            EnumBlockRotation enumblockrotation = EnumBlockRotation.valueOf(nbttagcompound.getString("Rot"));
            float f2 = nbttagcompound.getFloat("Integrity");
            OceanRuinStructure.a oceanruinstructure_a = OceanRuinStructure.a.valueOf(nbttagcompound.getString("BiomeType"));
            boolean flag = nbttagcompound.getBoolean("IsLarge");
            return new a(structuretemplatemanager, nbttagcompound, enumblockrotation, f2, oceanruinstructure_a, flag);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putString("Rot", this.placeSettings.getRotation().name());
            nbttagcompound.putFloat("Integrity", this.integrity);
            nbttagcompound.putString("BiomeType", this.biomeType.toString());
            nbttagcompound.putBoolean("IsLarge", this.isLarge);
        }

        @Override
        protected void handleDataMarker(String s2, BlockPosition blockposition, WorldAccess worldaccess, RandomSource randomsource, StructureBoundingBox structureboundingbox) {
            EntityDrowned entitydrowned;
            if ("chest".equals(s2)) {
                CraftChest craftChest = (CraftChest)CraftBlockStates.getBlockState((IWorldReader)worldaccess, blockposition, (IBlockData)Blocks.CHEST.defaultBlockState().setValue(BlockChest.WATERLOGGED, worldaccess.getFluidState(blockposition).is(TagsFluid.WATER)), null);
                craftChest.setSeed(randomsource.nextLong());
                craftChest.setLootTable(CraftLootTable.minecraftToBukkit(this.isLarge ? LootTables.UNDERWATER_RUIN_BIG : LootTables.UNDERWATER_RUIN_SMALL));
                this.placeCraftBlockEntity(worldaccess, blockposition, craftChest, 2);
            } else if ("drowned".equals(s2) && (entitydrowned = EntityTypes.DROWNED.create(worldaccess.getLevel())) != null) {
                entitydrowned.setPersistenceRequired();
                entitydrowned.moveTo(blockposition, 0.0f, 0.0f);
                entitydrowned.finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(blockposition), EnumMobSpawn.STRUCTURE, null);
                worldaccess.addFreshEntityWithPassengers(entitydrowned);
                if (blockposition.getY() > worldaccess.getSeaLevel()) {
                    worldaccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 2);
                } else {
                    worldaccess.setBlock(blockposition, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            int i2 = generatoraccessseed.getHeight(HeightMap.Type.OCEAN_FLOOR_WG, this.templatePosition.getX(), this.templatePosition.getZ());
            this.templatePosition = new BlockPosition(this.templatePosition.getX(), i2, this.templatePosition.getZ());
            BlockPosition blockposition1 = DefinedStructure.transform(new BlockPosition(this.template.getSize().getX() - 1, 0, this.template.getSize().getZ() - 1), EnumBlockMirror.NONE, this.placeSettings.getRotation(), BlockPosition.ZERO).offset(this.templatePosition);
            this.templatePosition = new BlockPosition(this.templatePosition.getX(), this.getHeight(this.templatePosition, generatoraccessseed, blockposition1), this.templatePosition.getZ());
            super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
        }

        private int getHeight(BlockPosition blockposition, IBlockAccess iblockaccess, BlockPosition blockposition1) {
            int i2 = blockposition.getY();
            int j2 = 512;
            int k2 = i2 - 1;
            int l2 = 0;
            for (BlockPosition blockposition2 : BlockPosition.betweenClosed(blockposition, blockposition1)) {
                int i1 = blockposition2.getX();
                int j1 = blockposition2.getZ();
                int k1 = blockposition.getY() - 1;
                BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i1, k1, j1);
                IBlockData iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
                Fluid fluid = iblockaccess.getFluidState(blockposition_mutableblockposition);
                while ((iblockdata.isAir() || fluid.is(TagsFluid.WATER) || iblockdata.is(TagsBlock.ICE)) && k1 > iblockaccess.getMinBuildHeight() + 1) {
                    blockposition_mutableblockposition.set(i1, --k1, j1);
                    iblockdata = iblockaccess.getBlockState(blockposition_mutableblockposition);
                    fluid = iblockaccess.getFluidState(blockposition_mutableblockposition);
                }
                j2 = Math.min(j2, k1);
                if (k1 >= k2 - 2) continue;
                ++l2;
            }
            int l1 = Math.abs(blockposition.getX() - blockposition1.getX());
            if (k2 - j2 > 2 && l2 > l1 - 2) {
                i2 = j2 + 1;
            }
            return i2;
        }
    }
}

