/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class ShipwreckPieces {
    private static final int NUMBER_OF_BLOCKS_ALLOWED_IN_WORLD_GEN_REGION = 32;
    static final BlockPosition PIVOT = new BlockPosition(4, 0, 15);
    private static final MinecraftKey[] STRUCTURE_LOCATION_BEACHED = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("shipwreck/with_mast"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_full"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_fronthalf"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_backhalf"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_full"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_fronthalf"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_backhalf"), MinecraftKey.withDefaultNamespace("shipwreck/with_mast_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_full_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_fronthalf_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_backhalf_degraded")};
    private static final MinecraftKey[] STRUCTURE_LOCATION_OCEAN = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("shipwreck/with_mast"), MinecraftKey.withDefaultNamespace("shipwreck/upsidedown_full"), MinecraftKey.withDefaultNamespace("shipwreck/upsidedown_fronthalf"), MinecraftKey.withDefaultNamespace("shipwreck/upsidedown_backhalf"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_full"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_fronthalf"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_backhalf"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_full"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_fronthalf"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_backhalf"), MinecraftKey.withDefaultNamespace("shipwreck/with_mast_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/upsidedown_full_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/upsidedown_fronthalf_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/upsidedown_backhalf_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_full_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_fronthalf_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/sideways_backhalf_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_full_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_fronthalf_degraded"), MinecraftKey.withDefaultNamespace("shipwreck/rightsideup_backhalf_degraded")};
    static final Map<String, ResourceKey<LootTable>> MARKERS_TO_LOOT = Map.of("map_chest", LootTables.SHIPWRECK_MAP, "treasure_chest", LootTables.SHIPWRECK_TREASURE, "supply_chest", LootTables.SHIPWRECK_SUPPLY);

    public static a addRandomPiece(StructureTemplateManager structuretemplatemanager, BlockPosition blockposition, EnumBlockRotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, boolean flag) {
        MinecraftKey minecraftkey = (MinecraftKey)SystemUtils.getRandom((Object[])(flag ? STRUCTURE_LOCATION_BEACHED : STRUCTURE_LOCATION_OCEAN), randomsource);
        a shipwreckpieces_a = new a(structuretemplatemanager, minecraftkey, blockposition, enumblockrotation, flag);
        structurepieceaccessor.addPiece(shipwreckpieces_a);
        return shipwreckpieces_a;
    }

    public static class a
    extends DefinedStructurePiece {
        private final boolean isBeached;

        public a(StructureTemplateManager structuretemplatemanager, MinecraftKey minecraftkey, BlockPosition blockposition, EnumBlockRotation enumblockrotation, boolean flag) {
            super(WorldGenFeatureStructurePieceType.SHIPWRECK_PIECE, 0, structuretemplatemanager, minecraftkey, minecraftkey.toString(), a.makeSettings(enumblockrotation), blockposition);
            this.isBeached = flag;
        }

        public a(StructureTemplateManager structuretemplatemanager, NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.SHIPWRECK_PIECE, nbttagcompound, structuretemplatemanager, minecraftkey -> a.makeSettings(EnumBlockRotation.valueOf(nbttagcompound.getString("Rot"))));
            this.isBeached = nbttagcompound.getBoolean("isBeached");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("isBeached", this.isBeached);
            nbttagcompound.putString("Rot", this.placeSettings.getRotation().name());
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation enumblockrotation) {
            return new DefinedStructureInfo().setRotation(enumblockrotation).setMirror(EnumBlockMirror.NONE).setRotationPivot(PIVOT).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR);
        }

        @Override
        protected void handleDataMarker(String s2, BlockPosition blockposition, WorldAccess worldaccess, RandomSource randomsource, StructureBoundingBox structureboundingbox) {
            ResourceKey<LootTable> resourcekey = MARKERS_TO_LOOT.get(s2);
            if (resourcekey != null) {
                this.setCraftLootTable(worldaccess, blockposition.below(), randomsource, resourcekey);
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            if (this.isTooBigToFitInWorldGenRegion()) {
                super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
            } else {
                int i2 = generatoraccessseed.getMaxBuildHeight();
                int j2 = 0;
                BaseBlockPosition baseblockposition = this.template.getSize();
                HeightMap.Type heightmap_type = this.isBeached ? HeightMap.Type.WORLD_SURFACE_WG : HeightMap.Type.OCEAN_FLOOR_WG;
                int k2 = baseblockposition.getX() * baseblockposition.getZ();
                if (k2 == 0) {
                    j2 = generatoraccessseed.getHeight(heightmap_type, this.templatePosition.getX(), this.templatePosition.getZ());
                } else {
                    BlockPosition blockposition1 = this.templatePosition.offset(baseblockposition.getX() - 1, 0, baseblockposition.getZ() - 1);
                    for (BlockPosition blockposition2 : BlockPosition.betweenClosed(this.templatePosition, blockposition1)) {
                        int l2 = generatoraccessseed.getHeight(heightmap_type, blockposition2.getX(), blockposition2.getZ());
                        j2 += l2;
                        i2 = Math.min(i2, l2);
                    }
                    j2 /= k2;
                }
                this.adjustPositionHeight(this.isBeached ? this.calculateBeachedPosition(i2, randomsource) : j2);
                super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
            }
        }

        public boolean isTooBigToFitInWorldGenRegion() {
            BaseBlockPosition baseblockposition = this.template.getSize();
            return baseblockposition.getX() > 32 || baseblockposition.getY() > 32;
        }

        public int calculateBeachedPosition(int i2, RandomSource randomsource) {
            return i2 - this.template.getSize().getY() / 2 - randomsource.nextInt(3);
        }

        public void adjustPositionHeight(int i2) {
            this.templatePosition = new BlockPosition(this.templatePosition.getX(), i2, this.templatePosition.getZ());
        }
    }
}

