/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.entity.EntityType;

public class StrongholdPieces {
    private static final int SMALL_DOOR_WIDTH = 3;
    private static final int SMALL_DOOR_HEIGHT = 3;
    private static final int MAX_DEPTH = 50;
    private static final int LOWEST_Y_POSITION = 10;
    private static final boolean CHECK_AIR = true;
    public static final int MAGIC_START_Y = 64;
    private static final f[] STRONGHOLD_PIECE_WEIGHTS = new f[]{new f(n.class, 40, 0), new f(h.class, 5, 5), new f(d.class, 20, 0), new f(i.class, 20, 0), new f(j.class, 10, 6), new f(o.class, 5, 5), new f(l.class, 5, 5), new f(c.class, 5, 4), new f(a.class, 5, 4), new f(e.class, 10, 2){

        @Override
        public boolean doPlace(int i2) {
            return super.doPlace(i2) && i2 > 4;
        }
    }, new f(g.class, 20, 1){

        @Override
        public boolean doPlace(int i2) {
            return super.doPlace(i2) && i2 > 5;
        }
    }};
    private static List<f> currentPieces;
    static Class<? extends p> imposedPiece;
    private static int totalWeight;
    static final k SMOOTH_STONE_SELECTOR;

    public static void resetPieces() {
        currentPieces = Lists.newArrayList();
        for (f strongholdpieces_f : STRONGHOLD_PIECE_WEIGHTS) {
            strongholdpieces_f.placeCount = 0;
            currentPieces.add(strongholdpieces_f);
        }
        imposedPiece = null;
    }

    private static boolean updatePieceWeight() {
        boolean flag = false;
        totalWeight = 0;
        for (f strongholdpieces_f : currentPieces) {
            if (strongholdpieces_f.maxPlaceCount > 0 && strongholdpieces_f.placeCount < strongholdpieces_f.maxPlaceCount) {
                flag = true;
            }
            totalWeight += strongholdpieces_f.weight;
        }
        return flag;
    }

    private static p findAndCreatePieceFactory(Class<? extends p> oclass, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, @Nullable EnumDirection enumdirection, int l2) {
        p object = null;
        if (oclass == n.class) {
            object = n.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == h.class) {
            object = h.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == d.class) {
            object = d.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == i.class) {
            object = i.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == j.class) {
            object = j.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == o.class) {
            object = o.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == l.class) {
            object = l.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == c.class) {
            object = c.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == a.class) {
            object = a.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == e.class) {
            object = e.createPiece(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
        } else if (oclass == g.class) {
            object = g.createPiece(structurepieceaccessor, i2, j2, k2, enumdirection, l2);
        }
        return object;
    }

    private static p generatePieceFromSmallDoor(m strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
        if (!StrongholdPieces.updatePieceWeight()) {
            return null;
        }
        if (imposedPiece != null) {
            p strongholdpieces_p = StrongholdPieces.findAndCreatePieceFactory(imposedPiece, structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
            imposedPiece = null;
            if (strongholdpieces_p != null) {
                return strongholdpieces_p;
            }
        }
        int i1 = 0;
        block0: while (i1 < 5) {
            ++i1;
            int j1 = randomsource.nextInt(totalWeight);
            for (f strongholdpieces_f : currentPieces) {
                if ((j1 -= strongholdpieces_f.weight) >= 0) continue;
                if (!strongholdpieces_f.doPlace(l2) || strongholdpieces_f == strongholdpieces_m.previousPiece) continue block0;
                p strongholdpieces_p1 = StrongholdPieces.findAndCreatePieceFactory(strongholdpieces_f.pieceClass, structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2);
                if (strongholdpieces_p1 == null) continue;
                ++strongholdpieces_f.placeCount;
                strongholdpieces_m.previousPiece = strongholdpieces_f;
                if (!strongholdpieces_f.isValid()) {
                    currentPieces.remove(strongholdpieces_f);
                }
                return strongholdpieces_p1;
            }
        }
        StructureBoundingBox structureboundingbox = b.findPieceBox(structurepieceaccessor, randomsource, i2, j2, k2, enumdirection);
        if (structureboundingbox != null && structureboundingbox.minY() > 1) {
            return new b(l2, structureboundingbox, enumdirection);
        }
        return null;
    }

    static StructurePiece generateAndAddPiece(m strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, @Nullable EnumDirection enumdirection, int l2) {
        if (l2 > 50) {
            return null;
        }
        if (Math.abs(i2 - strongholdpieces_m.getBoundingBox().minX()) <= 112 && Math.abs(k2 - strongholdpieces_m.getBoundingBox().minZ()) <= 112) {
            p strongholdpieces_p = StrongholdPieces.generatePieceFromSmallDoor(strongholdpieces_m, structurepieceaccessor, randomsource, i2, j2, k2, enumdirection, l2 + 1);
            if (strongholdpieces_p != null) {
                structurepieceaccessor.addPiece(strongholdpieces_p);
                strongholdpieces_m.pendingChildren.add(strongholdpieces_p);
            }
            return strongholdpieces_p;
        }
        return null;
    }

    static {
        SMOOTH_STONE_SELECTOR = new k();
    }

    private static class f {
        public final Class<? extends p> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;

        public f(Class<? extends p> oclass, int i2, int j2) {
            this.pieceClass = oclass;
            this.weight = i2;
            this.maxPlaceCount = j2;
        }

        public boolean doPlace(int i2) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class n
    extends p {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private final boolean leftChild;
        private final boolean rightChild;

        public n(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.leftChild = randomsource.nextInt(2) == 0;
            this.rightChild = randomsource.nextInt(2) == 0;
        }

        public n(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT, nbttagcompound);
            this.leftChild = nbttagcompound.getBoolean("Left");
            this.rightChild = nbttagcompound.getBoolean("Right");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Left", this.leftChild);
            nbttagcompound.putBoolean("Right", this.rightChild);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            if (this.leftChild) {
                this.generateSmallDoorChildLeft((m)structurepiece, structurepieceaccessor, randomsource, 1, 2);
            }
            if (this.rightChild) {
                this.generateSmallDoorChildRight((m)structurepiece, structurepieceaccessor, randomsource, 1, 2);
            }
        }

        public static n createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, 7, enumdirection);
            return n.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new n(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 6, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, p.a.OPENING, 1, 1, 6);
            IBlockData iblockdata = (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.EAST);
            IBlockData iblockdata1 = (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.WEST);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 1, 2, 1, iblockdata);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 3, 2, 1, iblockdata1);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 1, 2, 5, iblockdata);
            this.maybeGenerateBlock(generatoraccessseed, structureboundingbox, randomsource, 0.1f, 3, 2, 5, iblockdata1);
            if (this.leftChild) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 2, 0, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightChild) {
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 2, 4, 3, 4, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class h
    extends p {
        protected static final int WIDTH = 9;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 11;

        public h(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PRISON_HALL, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public h(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PRISON_HALL, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static h createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 9, 5, 11, enumdirection);
            return h.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new h(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 8, 4, 10, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 10, 3, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 3, 1, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 3, 4, 3, 3, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 7, 4, 3, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 9, 4, 3, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            for (int i2 = 1; i2 <= 3; ++i2) {
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, i2, 4, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true)).setValue(BlockIronBars.EAST, true), 4, i2, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, i2, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true), 5, i2, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true), 6, i2, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true), 7, i2, 5, structureboundingbox);
            }
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, 3, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true), 4, 3, 8, structureboundingbox);
            IBlockData iblockdata = (IBlockData)Blocks.IRON_DOOR.defaultBlockState().setValue(BlockDoor.FACING, EnumDirection.WEST);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.IRON_DOOR.defaultBlockState().setValue(BlockDoor.FACING, EnumDirection.WEST)).setValue(BlockDoor.HALF, BlockPropertyDoubleBlockHalf.UPPER);
            this.placeBlock(generatoraccessseed, iblockdata, 4, 1, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata1, 4, 2, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata, 4, 1, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, iblockdata1, 4, 2, 8, structureboundingbox);
        }
    }

    public static class d
    extends q {
        public d(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LEFT_TURN, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public d(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LEFT_TURN, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.EAST) {
                this.generateSmallDoorChildRight((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            } else {
                this.generateSmallDoorChildLeft((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            }
        }

        public static d createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, 5, enumdirection);
            return d.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new d(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 4, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.EAST) {
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class i
    extends q {
        public i(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_RIGHT_TURN, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public i(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_RIGHT_TURN, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.EAST) {
                this.generateSmallDoorChildLeft((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            } else {
                this.generateSmallDoorChildRight((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
            }
        }

        public static i createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, 5, enumdirection);
            return i.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new i(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 4, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.EAST) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 1, 0, 3, 3, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 1, 4, 3, 3, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class j
    extends p {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 7;
        protected static final int DEPTH = 11;
        protected final int type;

        public j(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_ROOM_CROSSING, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.type = randomsource.nextInt(5);
        }

        public j(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_ROOM_CROSSING, nbttagcompound);
            this.type = nbttagcompound.getInt("Type");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putInt("Type", this.type);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 4, 1);
            this.generateSmallDoorChildLeft((m)structurepiece, structurepieceaccessor, randomsource, 1, 4);
            this.generateSmallDoorChildRight((m)structurepiece, structurepieceaccessor, randomsource, 1, 4);
        }

        public static j createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -4, -1, 0, 11, 7, 11, enumdirection);
            return j.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new j(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 10, 6, 10, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 4, 1, 0);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 10, 6, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 1, 4, 0, 3, 6, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 10, 1, 4, 10, 3, 6, CAVE_AIR, CAVE_AIR, false);
            switch (this.type) {
                case 0: {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.WEST), 4, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.EAST), 6, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.SOUTH), 5, 3, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.NORTH), 5, 3, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 4, 1, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 6, 1, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 5, 1, 6, structureboundingbox);
                    break;
                }
                case 1: {
                    for (int i2 = 0; i2 < 5; ++i2) {
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 1, 3 + i2, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 7, 1, 3 + i2, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i2, 1, 3, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3 + i2, 1, 7, structureboundingbox);
                    }
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 2, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 5, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.WATER.defaultBlockState(), 5, 4, 5, structureboundingbox);
                    break;
                }
                case 2: {
                    int i3;
                    for (i3 = 1; i3 <= 9; ++i3) {
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 1, 3, i3, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 9, 3, i3, structureboundingbox);
                    }
                    for (i3 = 1; i3 <= 9; ++i3) {
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), i3, 3, 1, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), i3, 3, 9, structureboundingbox);
                    }
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 1, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 4, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 5, 3, 6, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, 1, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, 3, 5, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, 3, 5, structureboundingbox);
                    for (i3 = 1; i3 <= 3; ++i3) {
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, i3, 4, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, i3, 4, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 4, i3, 6, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.COBBLESTONE.defaultBlockState(), 6, i3, 6, structureboundingbox);
                    }
                    this.placeBlock(generatoraccessseed, Blocks.WALL_TORCH.defaultBlockState(), 5, 3, 5, structureboundingbox);
                    for (i3 = 2; i3 <= 8; ++i3) {
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 2, 3, i3, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 3, 3, i3, structureboundingbox);
                        if (i3 <= 3 || i3 >= 7) {
                            this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 4, 3, i3, structureboundingbox);
                            this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 5, 3, i3, structureboundingbox);
                            this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 6, 3, i3, structureboundingbox);
                        }
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 7, 3, i3, structureboundingbox);
                        this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 8, 3, i3, structureboundingbox);
                    }
                    IBlockData iblockdata = (IBlockData)Blocks.LADDER.defaultBlockState().setValue(BlockLadder.FACING, EnumDirection.WEST);
                    this.placeBlock(generatoraccessseed, iblockdata, 9, 1, 3, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 9, 2, 3, structureboundingbox);
                    this.placeBlock(generatoraccessseed, iblockdata, 9, 3, 3, structureboundingbox);
                    this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 4, 8, LootTables.STRONGHOLD_CROSSING);
                }
            }
        }
    }

    public static class o
    extends p {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 8;

        public o(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public o(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STRAIGHT_STAIRS_DOWN, nbttagcompound);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static o createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -7, 0, 5, 11, 8, enumdirection);
            return o.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new o(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 10, 7, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, p.a.OPENING, 1, 1, 7);
            IBlockData iblockdata = (IBlockData)Blocks.COBBLESTONE_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
            for (int i2 = 0; i2 < 6; ++i2) {
                this.placeBlock(generatoraccessseed, iblockdata, 1, 6 - i2, 1 + i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, 2, 6 - i2, 1 + i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata, 3, 6 - i2, 1 + i2, structureboundingbox);
                if (i2 >= 5) continue;
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5 - i2, 1 + i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 5 - i2, 1 + i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 5 - i2, 1 + i2, structureboundingbox);
            }
        }
    }

    public static class l
    extends p {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 5;
        private final boolean isSource;

        public l(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, int j2, int k2, EnumDirection enumdirection) {
            super(worldgenfeaturestructurepiecetype, i2, l.makeBoundingBox(j2, 64, k2, enumdirection, 5, 11, 5));
            this.isSource = true;
            this.setOrientation(enumdirection);
            this.entryDoor = p.a.OPENING;
        }

        public l(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_STAIRS_DOWN, i2, structureboundingbox);
            this.isSource = false;
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public l(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
            this.isSource = nbttagcompound.getBoolean("Source");
        }

        public l(NBTTagCompound nbttagcompound) {
            this(WorldGenFeatureStructurePieceType.STRONGHOLD_STAIRS_DOWN, nbttagcompound);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Source", this.isSource);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            if (this.isSource) {
                imposedPiece = c.class;
            }
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static l createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -7, 0, 5, 11, 5, enumdirection);
            return l.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new l(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 10, 4, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 7, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, p.a.OPENING, 1, 1, 4);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 6, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 6, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 5, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 5, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 4, 3, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 3, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 3, 3, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 2, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 1, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), 1, 1, 3, structureboundingbox);
        }
    }

    public static class c
    extends p {
        protected static final int WIDTH = 10;
        protected static final int HEIGHT = 9;
        protected static final int DEPTH = 11;
        private final boolean leftLow;
        private final boolean leftHigh;
        private final boolean rightLow;
        private final boolean rightHigh;

        public c(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FIVE_CROSSING, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.leftLow = randomsource.nextBoolean();
            this.leftHigh = randomsource.nextBoolean();
            this.rightLow = randomsource.nextBoolean();
            this.rightHigh = randomsource.nextInt(3) > 0;
        }

        public c(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FIVE_CROSSING, nbttagcompound);
            this.leftLow = nbttagcompound.getBoolean("leftLow");
            this.leftHigh = nbttagcompound.getBoolean("leftHigh");
            this.rightLow = nbttagcompound.getBoolean("rightLow");
            this.rightHigh = nbttagcompound.getBoolean("rightHigh");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("leftLow", this.leftLow);
            nbttagcompound.putBoolean("leftHigh", this.leftHigh);
            nbttagcompound.putBoolean("rightLow", this.rightLow);
            nbttagcompound.putBoolean("rightHigh", this.rightHigh);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            int i2 = 3;
            int j2 = 5;
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection == EnumDirection.WEST || enumdirection == EnumDirection.NORTH) {
                i2 = 8 - i2;
                j2 = 8 - j2;
            }
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 5, 1);
            if (this.leftLow) {
                this.generateSmallDoorChildLeft((m)structurepiece, structurepieceaccessor, randomsource, i2, 1);
            }
            if (this.leftHigh) {
                this.generateSmallDoorChildLeft((m)structurepiece, structurepieceaccessor, randomsource, j2, 7);
            }
            if (this.rightLow) {
                this.generateSmallDoorChildRight((m)structurepiece, structurepieceaccessor, randomsource, i2, 1);
            }
            if (this.rightHigh) {
                this.generateSmallDoorChildRight((m)structurepiece, structurepieceaccessor, randomsource, j2, 7);
            }
        }

        public static c createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -4, -3, 0, 10, 9, 11, enumdirection);
            return c.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new c(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 9, 8, 10, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, 1, 0, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightLow) {
                this.generateBox(generatoraccessseed, structureboundingbox, 9, 3, 1, 9, 5, 3, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.leftHigh) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 5, 7, 0, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            if (this.rightHigh) {
                this.generateBox(generatoraccessseed, structureboundingbox, 9, 5, 7, 9, 7, 9, CAVE_AIR, CAVE_AIR, false);
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 1, 10, 7, 3, 10, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 2, 1, 8, 2, 6, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 5, 4, 4, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 1, 5, 8, 4, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 7, 3, 4, 9, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 5, 3, 3, 6, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 3, 4, 3, 3, 4, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 4, 6, 3, 4, 6, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 1, 7, 7, 1, 8, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 1, 9, 7, 1, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 2, 7, 7, 2, 7, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 7, 4, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 5, 7, 8, 5, 9, Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), Blocks.SMOOTH_STONE_SLAB.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 5, 5, 7, 7, 5, 9, (IBlockData)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(BlockStepAbstract.TYPE, BlockPropertySlabType.DOUBLE), (IBlockData)Blocks.SMOOTH_STONE_SLAB.defaultBlockState().setValue(BlockStepAbstract.TYPE, BlockPropertySlabType.DOUBLE), false);
            this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.SOUTH), 6, 5, 6, structureboundingbox);
        }
    }

    public static class a
    extends p {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 5;
        private static final int DEPTH = 7;
        private boolean hasPlacedChest;

        public a(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_CHEST_CORRIDOR, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
        }

        public a(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_CHEST_CORRIDOR, nbttagcompound);
            this.hasPlacedChest = nbttagcompound.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Chest", this.hasPlacedChest);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            this.generateSmallDoorChildForward((m)structurepiece, structurepieceaccessor, randomsource, 1, 1);
        }

        public static a createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, 7, enumdirection);
            return a.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new a(l2, randomsource, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 4, 4, 6, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 1, 1, 0);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, p.a.OPENING, 1, 1, 6);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 1, 2, 3, 1, 4, Blocks.STONE_BRICKS.defaultBlockState(), Blocks.STONE_BRICKS.defaultBlockState(), false);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 1, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 1, 5, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 2, structureboundingbox);
            this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 3, 2, 4, structureboundingbox);
            for (int i2 = 2; i2 <= 4; ++i2) {
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICK_SLAB.defaultBlockState(), 2, 1, i2, structureboundingbox);
            }
            if (!this.hasPlacedChest && structureboundingbox.isInside(this.getWorldPos(3, 2, 3))) {
                this.hasPlacedChest = true;
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 2, 3, LootTables.STRONGHOLD_CORRIDOR);
            }
        }
    }

    public static class e
    extends p {
        protected static final int WIDTH = 14;
        protected static final int HEIGHT = 6;
        protected static final int TALL_HEIGHT = 11;
        protected static final int DEPTH = 15;
        private final boolean isTall;

        public e(int i2, RandomSource randomsource, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LIBRARY, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.entryDoor = this.randomSmallDoor(randomsource);
            this.isTall = structureboundingbox.getYSpan() > 6;
        }

        public e(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_LIBRARY, nbttagcompound);
            this.isTall = nbttagcompound.getBoolean("Tall");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Tall", this.isTall);
        }

        public static e createPiece(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -4, -1, 0, 14, 11, 15, enumdirection);
            if (!(e.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null || e.isOkBox(structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -4, -1, 0, 14, 6, 15, enumdirection)) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null)) {
                return null;
            }
            return new e(l2, randomsource, structureboundingbox, enumdirection);
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            int i2;
            int b0 = 11;
            if (!this.isTall) {
                b0 = 6;
            }
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 13, b0 - 1, 14, true, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, this.entryDoor, 4, 1, 0);
            this.generateMaybeBox(generatoraccessseed, structureboundingbox, randomsource, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.COBWEB.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), false, false);
            boolean flag = true;
            boolean flag1 = true;
            for (i2 = 1; i2 <= 13; ++i2) {
                if ((i2 - 1) % 4 == 0) {
                    this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, i2, 1, 4, i2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(generatoraccessseed, structureboundingbox, 12, 1, i2, 12, 4, i2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.EAST), 2, 3, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.WEST), 11, 3, i2, structureboundingbox);
                    if (!this.isTall) continue;
                    this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, i2, 1, 9, i2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    this.generateBox(generatoraccessseed, structureboundingbox, 12, 6, i2, 12, 9, i2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                    continue;
                }
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, i2, 1, 4, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 1, i2, 12, 4, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                if (!this.isTall) continue;
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, i2, 1, 9, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 12, 6, i2, 12, 9, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            for (i2 = 3; i2 < 12; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 3, 1, i2, 4, 3, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 6, 1, i2, 7, 3, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 9, 1, i2, 10, 3, i2, Blocks.BOOKSHELF.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), false);
            }
            if (this.isTall) {
                this.generateBox(generatoraccessseed, structureboundingbox, 1, 5, 1, 3, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 10, 5, 1, 12, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 1, 9, 5, 2, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 5, 12, 9, 5, 13, Blocks.OAK_PLANKS.defaultBlockState(), Blocks.OAK_PLANKS.defaultBlockState(), false);
                this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 8, 5, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.OAK_PLANKS.defaultBlockState(), 9, 5, 10, structureboundingbox);
                IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
                IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
                this.generateBox(generatoraccessseed, structureboundingbox, 3, 6, 3, 3, 6, 11, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 10, 6, 3, 10, 6, 9, iblockdata1, iblockdata1, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 6, 2, 9, 6, 2, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 4, 6, 12, 7, 6, 12, iblockdata, iblockdata, false);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 3, 6, 2, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.EAST, true), 3, 6, 12, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.WEST, true), 10, 6, 2, structureboundingbox);
                for (int j2 = 0; j2 <= 2; ++j2) {
                    this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.WEST, true), 8 + j2, 6, 12 - j2, structureboundingbox);
                    if (j2 == 2) continue;
                    this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 8 + j2, 6, 11 - j2, structureboundingbox);
                }
                IBlockData iblockdata2 = (IBlockData)Blocks.LADDER.defaultBlockState().setValue(BlockLadder.FACING, EnumDirection.SOUTH);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 1, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 2, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 3, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 4, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 5, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 6, 13, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, 10, 7, 13, structureboundingbox);
                boolean flag2 = true;
                boolean flag3 = true;
                IBlockData iblockdata3 = (IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true);
                this.placeBlock(generatoraccessseed, iblockdata3, 6, 9, 7, structureboundingbox);
                IBlockData iblockdata4 = (IBlockData)Blocks.OAK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true);
                this.placeBlock(generatoraccessseed, iblockdata4, 7, 9, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata3, 6, 8, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata4, 7, 8, 7, structureboundingbox);
                IBlockData iblockdata5 = (IBlockData)((IBlockData)iblockdata1.setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
                this.placeBlock(generatoraccessseed, iblockdata5, 6, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata5, 7, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata3, 5, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata4, 8, 7, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)iblockdata3.setValue(BlockFence.NORTH, true), 6, 7, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)iblockdata3.setValue(BlockFence.SOUTH, true), 6, 7, 8, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)iblockdata4.setValue(BlockFence.NORTH, true), 7, 7, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, (IBlockData)iblockdata4.setValue(BlockFence.SOUTH, true), 7, 7, 8, structureboundingbox);
                IBlockData iblockdata6 = Blocks.TORCH.defaultBlockState();
                this.placeBlock(generatoraccessseed, iblockdata6, 5, 8, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 8, 8, 7, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 6, 8, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 6, 8, 8, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 7, 8, 6, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata6, 7, 8, 8, structureboundingbox);
            }
            this.createChest(generatoraccessseed, structureboundingbox, randomsource, 3, 3, 5, LootTables.STRONGHOLD_LIBRARY);
            if (this.isTall) {
                this.placeBlock(generatoraccessseed, CAVE_AIR, 12, 9, 1, structureboundingbox);
                this.createChest(generatoraccessseed, structureboundingbox, randomsource, 12, 8, 1, LootTables.STRONGHOLD_LIBRARY);
            }
        }
    }

    public static class g
    extends p {
        protected static final int WIDTH = 11;
        protected static final int HEIGHT = 8;
        protected static final int DEPTH = 16;
        private boolean hasPlacedSpawner;

        public g(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PORTAL_ROOM, i2, structureboundingbox);
            this.setOrientation(enumdirection);
        }

        public g(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_PORTAL_ROOM, nbttagcompound);
            this.hasPlacedSpawner = nbttagcompound.getBoolean("Mob");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putBoolean("Mob", this.hasPlacedSpawner);
        }

        @Override
        public void addChildren(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
            if (structurepiece != null) {
                ((m)structurepiece).portalRoomPiece = this;
            }
        }

        public static g createPiece(StructurePieceAccessor structurepieceaccessor, int i2, int j2, int k2, EnumDirection enumdirection, int l2) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -4, -1, 0, 11, 8, 16, enumdirection);
            return g.isOkBox(structureboundingbox) && structurepieceaccessor.findCollisionPiece(structureboundingbox) == null ? new g(l2, structureboundingbox, enumdirection) : null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition;
            int i2;
            this.generateBox(generatoraccessseed, structureboundingbox, 0, 0, 0, 10, 7, 15, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateSmallDoor(generatoraccessseed, randomsource, structureboundingbox, p.a.GRATES, 4, 1, 0);
            boolean flag = true;
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 6, 1, 1, 6, 14, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 6, 1, 9, 6, 14, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 1, 8, 6, 2, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 2, 6, 14, 8, 6, 14, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 1, 2, 1, 4, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 8, 1, 1, 9, 1, 4, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 1, 1, 1, 1, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 9, 1, 1, 9, 1, 3, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            this.generateBox(generatoraccessseed, structureboundingbox, 3, 1, 8, 7, 1, 12, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 9, 6, 1, 11, Blocks.LAVA.defaultBlockState(), Blocks.LAVA.defaultBlockState(), false);
            IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.NORTH, true)).setValue(BlockIronBars.SOUTH, true);
            IBlockData iblockdata1 = (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true)).setValue(BlockIronBars.EAST, true);
            for (i2 = 3; i2 < 14; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, 0, 3, i2, 0, 4, i2, iblockdata, iblockdata, false);
                this.generateBox(generatoraccessseed, structureboundingbox, 10, 3, i2, 10, 4, i2, iblockdata, iblockdata, false);
            }
            for (i2 = 2; i2 < 9; i2 += 2) {
                this.generateBox(generatoraccessseed, structureboundingbox, i2, 3, 15, i2, 4, 15, iblockdata1, iblockdata1, false);
            }
            IBlockData iblockdata2 = (IBlockData)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 1, 5, 6, 1, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 2, 6, 6, 2, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            this.generateBox(generatoraccessseed, structureboundingbox, 4, 3, 7, 6, 3, 7, false, randomsource, SMOOTH_STONE_SELECTOR);
            for (int j2 = 4; j2 <= 6; ++j2) {
                this.placeBlock(generatoraccessseed, iblockdata2, j2, 1, 4, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, j2, 2, 5, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata2, j2, 3, 6, structureboundingbox);
            }
            IBlockData iblockdata3 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.NORTH);
            IBlockData iblockdata4 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.SOUTH);
            IBlockData iblockdata5 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.EAST);
            IBlockData iblockdata6 = (IBlockData)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue(BlockEnderPortalFrame.FACING, EnumDirection.WEST);
            boolean flag1 = true;
            boolean[] aboolean = new boolean[12];
            for (int k2 = 0; k2 < aboolean.length; ++k2) {
                aboolean[k2] = randomsource.nextFloat() > 0.9f;
                flag1 &= aboolean[k2];
            }
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata3.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[0]), 4, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata3.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[1]), 5, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata3.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[2]), 6, 3, 8, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata4.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[3]), 4, 3, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata4.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[4]), 5, 3, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata4.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[5]), 6, 3, 12, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata5.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[6]), 3, 3, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata5.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[7]), 3, 3, 10, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata5.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[8]), 3, 3, 11, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata6.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[9]), 7, 3, 9, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata6.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[10]), 7, 3, 10, structureboundingbox);
            this.placeBlock(generatoraccessseed, (IBlockData)iblockdata6.setValue(BlockEnderPortalFrame.HAS_EYE, aboolean[11]), 7, 3, 11, structureboundingbox);
            if (flag1) {
                IBlockData iblockdata7 = Blocks.END_PORTAL.defaultBlockState();
                this.placeBlock(generatoraccessseed, iblockdata7, 4, 3, 9, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 5, 3, 9, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 6, 3, 9, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 4, 3, 10, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 5, 3, 10, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 6, 3, 10, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 4, 3, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 5, 3, 11, structureboundingbox);
                this.placeBlock(generatoraccessseed, iblockdata7, 6, 3, 11, structureboundingbox);
            }
            if (!this.hasPlacedSpawner && structureboundingbox.isInside(blockposition_mutableblockposition = this.getWorldPos(5, 3, 6))) {
                this.hasPlacedSpawner = true;
                this.placeCraftSpawner(generatoraccessseed, blockposition_mutableblockposition, EntityType.SILVERFISH, 2);
            }
        }
    }

    private static abstract class p
    extends StructurePiece {
        protected a entryDoor = a.OPENING;

        protected p(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, StructureBoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i2, structureboundingbox);
        }

        public p(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
            this.entryDoor = a.valueOf(nbttagcompound.getString("EntryDoor"));
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            nbttagcompound.putString("EntryDoor", this.entryDoor.name());
        }

        protected void generateSmallDoor(GeneratorAccessSeed generatoraccessseed, RandomSource randomsource, StructureBoundingBox structureboundingbox, a strongholdpieces_p_a, int i2, int j2, int k2) {
            switch (strongholdpieces_p_a.ordinal()) {
                case 0: {
                    this.generateBox(generatoraccessseed, structureboundingbox, i2, j2, k2, i2 + 3 - 1, j2 + 3 - 1, k2, CAVE_AIR, CAVE_AIR, false);
                    break;
                }
                case 1: {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 1, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 2, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 2, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 2, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.OAK_DOOR.defaultBlockState(), i2 + 1, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.OAK_DOOR.defaultBlockState().setValue(BlockDoor.HALF, BlockPropertyDoubleBlockHalf.UPPER), i2 + 1, j2 + 1, k2, structureboundingbox);
                    break;
                }
                case 2: {
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), i2 + 1, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), i2 + 1, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true), i2, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.WEST, true), i2, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true), i2, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true), i2 + 1, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)((IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true)).setValue(BlockIronBars.WEST, true), i2 + 2, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true), i2 + 2, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.IRON_BARS.defaultBlockState().setValue(BlockIronBars.EAST, true), i2 + 2, j2, k2, structureboundingbox);
                    break;
                }
                case 3: {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 1, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 2, j2 + 2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 2, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), i2 + 2, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.IRON_DOOR.defaultBlockState(), i2 + 1, j2, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.IRON_DOOR.defaultBlockState().setValue(BlockDoor.HALF, BlockPropertyDoubleBlockHalf.UPPER), i2 + 1, j2 + 1, k2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.STONE_BUTTON.defaultBlockState().setValue(BlockButtonAbstract.FACING, EnumDirection.NORTH), i2 + 2, j2 + 1, k2 + 1, structureboundingbox);
                    this.placeBlock(generatoraccessseed, (IBlockData)Blocks.STONE_BUTTON.defaultBlockState().setValue(BlockButtonAbstract.FACING, EnumDirection.SOUTH), i2 + 2, j2 + 1, k2 - 1, structureboundingbox);
                }
            }
        }

        protected a randomSmallDoor(RandomSource randomsource) {
            int i2 = randomsource.nextInt(5);
            switch (i2) {
                default: {
                    return a.OPENING;
                }
                case 2: {
                    return a.WOOD_DOOR;
                }
                case 3: {
                    return a.GRATES;
                }
                case 4: 
            }
            return a.IRON_DOOR;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildForward(m strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + i2, this.boundingBox.minY() + j2, this.boundingBox.minZ() - 1, enumdirection, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + i2, this.boundingBox.minY() + j2, this.boundingBox.maxZ() + 1, enumdirection, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + j2, this.boundingBox.minZ() + i2, enumdirection, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + j2, this.boundingBox.minZ() + i2, enumdirection, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildLeft(m strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.WEST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() - 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.WEST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateSmallDoorChildRight(m strongholdpieces_m, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2) {
            EnumDirection enumdirection = this.getOrientation();
            if (enumdirection != null) {
                switch (enumdirection) {
                    case NORTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.EAST, this.getGenDepth());
                    }
                    case SOUTH: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.maxX() + 1, this.boundingBox.minY() + i2, this.boundingBox.minZ() + j2, EnumDirection.EAST, this.getGenDepth());
                    }
                    case WEST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth());
                    }
                    case EAST: {
                        return StrongholdPieces.generateAndAddPiece(strongholdpieces_m, structurepieceaccessor, randomsource, this.boundingBox.minX() + j2, this.boundingBox.minY() + i2, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth());
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(StructureBoundingBox structureboundingbox) {
            return structureboundingbox != null && structureboundingbox.minY() > 10;
        }

        protected static enum a {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    public static class m
    extends l {
        public f previousPiece;
        @Nullable
        public g portalRoomPiece;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public m(RandomSource randomsource, int i2, int j2) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_START, 0, i2, j2, m.getRandomHorizontalDirection(randomsource));
        }

        public m(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_START, nbttagcompound);
        }

        @Override
        public BlockPosition getLocatorPosition() {
            return this.portalRoomPiece != null ? this.portalRoomPiece.getLocatorPosition() : super.getLocatorPosition();
        }
    }

    public static class b
    extends p {
        private final int steps;

        public b(int i2, StructureBoundingBox structureboundingbox, EnumDirection enumdirection) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FILLER_CORRIDOR, i2, structureboundingbox);
            this.setOrientation(enumdirection);
            this.steps = enumdirection != EnumDirection.NORTH && enumdirection != EnumDirection.SOUTH ? structureboundingbox.getXSpan() : structureboundingbox.getZSpan();
        }

        public b(NBTTagCompound nbttagcompound) {
            super(WorldGenFeatureStructurePieceType.STRONGHOLD_FILLER_CORRIDOR, nbttagcompound);
            this.steps = nbttagcompound.getInt("Steps");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, NBTTagCompound nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.putInt("Steps", this.steps);
        }

        public static StructureBoundingBox findPieceBox(StructurePieceAccessor structurepieceaccessor, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection) {
            boolean flag = true;
            StructureBoundingBox structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, 4, enumdirection);
            StructurePiece structurepiece = structurepieceaccessor.findCollisionPiece(structureboundingbox);
            if (structurepiece == null) {
                return null;
            }
            if (structurepiece.getBoundingBox().minY() == structureboundingbox.minY()) {
                for (int l2 = 2; l2 >= 1; --l2) {
                    structureboundingbox = StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, l2, enumdirection);
                    if (structurepiece.getBoundingBox().intersects(structureboundingbox)) continue;
                    return StructureBoundingBox.orientBox(i2, j2, k2, -1, -1, 0, 5, 5, l2 + 1, enumdirection);
                }
            }
            return null;
        }

        @Override
        public void postProcess(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, StructureBoundingBox structureboundingbox, ChunkCoordIntPair chunkcoordintpair, BlockPosition blockposition) {
            for (int i2 = 0; i2 < this.steps; ++i2) {
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 0, 0, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 0, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 0, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 0, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 4, 0, i2, structureboundingbox);
                for (int j2 = 1; j2 <= 3; ++j2) {
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 0, j2, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), 1, j2, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), 2, j2, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.CAVE_AIR.defaultBlockState(), 3, j2, i2, structureboundingbox);
                    this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 4, j2, i2, structureboundingbox);
                }
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 0, 4, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 1, 4, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 2, 4, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 3, 4, i2, structureboundingbox);
                this.placeBlock(generatoraccessseed, Blocks.STONE_BRICKS.defaultBlockState(), 4, 4, i2, structureboundingbox);
            }
        }
    }

    private static class k
    extends StructurePiece.StructurePieceBlockSelector {
        k() {
        }

        @Override
        public void next(RandomSource randomsource, int i2, int j2, int k2, boolean flag) {
            float f2;
            this.next = flag ? ((f2 = randomsource.nextFloat()) < 0.2f ? Blocks.CRACKED_STONE_BRICKS.defaultBlockState() : (f2 < 0.5f ? Blocks.MOSSY_STONE_BRICKS.defaultBlockState() : (f2 < 0.55f ? Blocks.INFESTED_STONE_BRICKS.defaultBlockState() : Blocks.STONE_BRICKS.defaultBlockState()))) : Blocks.CAVE_AIR.defaultBlockState();
        }
    }

    public static abstract class q
    extends p {
        protected static final int WIDTH = 5;
        protected static final int HEIGHT = 5;
        protected static final int DEPTH = 5;

        protected q(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, StructureBoundingBox structureboundingbox) {
            super(worldgenfeaturestructurepiecetype, i2, structureboundingbox);
        }

        public q(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
            super(worldgenfeaturestructurepiecetype, nbttagcompound);
        }
    }
}

