/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R1.util.TransformerGeneratorAccess;

public class DefinedStructure {
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    public final List<a> palettes = Lists.newArrayList();
    public final List<EntityInfo> entityInfoList = Lists.newArrayList();
    private BaseBlockPosition size;
    private String author = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public DefinedStructure() {
        this.size = BaseBlockPosition.ZERO;
    }

    public BaseBlockPosition getSize() {
        return this.size;
    }

    public void setAuthor(String s2) {
        this.author = s2;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(World world, BlockPosition blockposition, BaseBlockPosition baseblockposition, boolean flag, @Nullable Block block) {
        if (baseblockposition.getX() >= 1 && baseblockposition.getY() >= 1 && baseblockposition.getZ() >= 1) {
            BlockPosition blockposition1 = blockposition.offset(baseblockposition).offset(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPosition blockposition2 = new BlockPosition(Math.min(blockposition.getX(), blockposition1.getX()), Math.min(blockposition.getY(), blockposition1.getY()), Math.min(blockposition.getZ(), blockposition1.getZ()));
            BlockPosition blockposition3 = new BlockPosition(Math.max(blockposition.getX(), blockposition1.getX()), Math.max(blockposition.getY(), blockposition1.getY()), Math.max(blockposition.getZ(), blockposition1.getZ()));
            this.size = baseblockposition;
            for (BlockPosition blockposition4 : BlockPosition.betweenClosed(blockposition2, blockposition3)) {
                BlockPosition blockposition5 = blockposition4.subtract(blockposition2);
                IBlockData iblockdata = world.getBlockState(blockposition4);
                if (block != null && iblockdata.is(block)) continue;
                TileEntity tileentity = world.getBlockEntity(blockposition4);
                BlockInfo definedstructure_blockinfo = tileentity != null ? new BlockInfo(blockposition5, iblockdata, tileentity.saveWithId(world.registryAccess())) : new BlockInfo(blockposition5, iblockdata, null);
                DefinedStructure.addToLists(definedstructure_blockinfo, list, list1, list2);
            }
            List<BlockInfo> list3 = DefinedStructure.buildInfoList(list, list1, list2);
            this.palettes.clear();
            this.palettes.add(new a(list3));
            if (flag) {
                this.fillEntityList(world, blockposition2, blockposition3);
            } else {
                this.entityInfoList.clear();
            }
        }
    }

    private static void addToLists(BlockInfo definedstructure_blockinfo, List<BlockInfo> list, List<BlockInfo> list1, List<BlockInfo> list2) {
        if (definedstructure_blockinfo.nbt != null) {
            list1.add(definedstructure_blockinfo);
        } else if (!definedstructure_blockinfo.state.getBlock().hasDynamicShape() && definedstructure_blockinfo.state.isCollisionShapeFullBlock(BlockAccessAir.INSTANCE, BlockPosition.ZERO)) {
            list.add(definedstructure_blockinfo);
        } else {
            list2.add(definedstructure_blockinfo);
        }
    }

    private static List<BlockInfo> buildInfoList(List<BlockInfo> list, List<BlockInfo> list1, List<BlockInfo> list2) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getY()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getX()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getZ());
        list.sort(comparator);
        list2.sort(comparator);
        list1.sort(comparator);
        ArrayList list3 = Lists.newArrayList();
        list3.addAll(list);
        list3.addAll(list2);
        list3.addAll(list1);
        return list3;
    }

    private void fillEntityList(World world, BlockPosition blockposition, BlockPosition blockposition1) {
        List<Entity> list = world.getEntitiesOfClass(Entity.class, AxisAlignedBB.encapsulatingFullBlocks(blockposition, blockposition1), entity -> !(entity instanceof EntityHuman));
        this.entityInfoList.clear();
        for (Entity entity2 : list) {
            Vec3D vec3d = new Vec3D(entity2.getX() - (double)blockposition.getX(), entity2.getY() - (double)blockposition.getY(), entity2.getZ() - (double)blockposition.getZ());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity2.save(nbttagcompound);
            BlockPosition blockposition2 = entity2 instanceof EntityPainting ? ((EntityPainting)entity2).getPos().subtract(blockposition) : BlockPosition.containing(vec3d);
            this.entityInfoList.add(new EntityInfo(vec3d, blockposition2, nbttagcompound.copy()));
        }
    }

    public List<BlockInfo> filterBlocks(BlockPosition blockposition, DefinedStructureInfo definedstructureinfo, Block block) {
        return this.filterBlocks(blockposition, definedstructureinfo, block, true);
    }

    public ObjectArrayList<BlockInfo> filterBlocks(BlockPosition blockposition, DefinedStructureInfo definedstructureinfo, Block block, boolean flag) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        StructureBoundingBox structureboundingbox = definedstructureinfo.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return objectarraylist;
        }
        for (BlockInfo definedstructure_blockinfo : definedstructureinfo.getRandomPalette(this.palettes, blockposition).blocks(block)) {
            BlockPosition blockposition1;
            BlockPosition blockPosition = blockposition1 = flag ? DefinedStructure.calculateRelativePosition(definedstructureinfo, definedstructure_blockinfo.pos).offset(blockposition) : definedstructure_blockinfo.pos;
            if (structureboundingbox != null && !structureboundingbox.isInside(blockposition1)) continue;
            objectarraylist.add((Object)new BlockInfo(blockposition1, definedstructure_blockinfo.state.rotate(definedstructureinfo.getRotation()), definedstructure_blockinfo.nbt));
        }
        return objectarraylist;
    }

    public BlockPosition calculateConnectedPosition(DefinedStructureInfo definedstructureinfo, BlockPosition blockposition, DefinedStructureInfo definedstructureinfo1, BlockPosition blockposition1) {
        BlockPosition blockposition2 = DefinedStructure.calculateRelativePosition(definedstructureinfo, blockposition);
        BlockPosition blockposition3 = DefinedStructure.calculateRelativePosition(definedstructureinfo1, blockposition1);
        return blockposition2.subtract(blockposition3);
    }

    public static BlockPosition calculateRelativePosition(DefinedStructureInfo definedstructureinfo, BlockPosition blockposition) {
        return DefinedStructure.transform(blockposition, definedstructureinfo.getMirror(), definedstructureinfo.getRotation(), definedstructureinfo.getRotationPivot());
    }

    public boolean placeInWorld(WorldAccess worldaccess, BlockPosition blockposition, BlockPosition blockposition1, DefinedStructureInfo definedstructureinfo, RandomSource randomsource, int i2) {
        List<BlockInfo> list;
        if (this.palettes.isEmpty()) {
            return false;
        }
        WorldAccess wrappedAccess = worldaccess;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            worldaccess = transformerAccess.getHandle();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = definedstructureinfo.getRandomPalette(this.palettes, blockposition).blocks()).isEmpty() && (definedstructureinfo.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1)) {
            IBlockData iblockdata1;
            TileEntity tileentity;
            StructureBoundingBox structureboundingbox = definedstructureinfo.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(definedstructureinfo.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(definedstructureinfo.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int j2 = Integer.MAX_VALUE;
            int k2 = Integer.MAX_VALUE;
            int l2 = Integer.MAX_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            int k1 = Integer.MIN_VALUE;
            List<BlockInfo> list4 = DefinedStructure.processBlockInfos(worldaccess, blockposition, blockposition1, definedstructureinfo, list);
            for (BlockInfo definedstructure_blockinfo : list4) {
                BlockPosition blockposition2 = definedstructure_blockinfo.pos;
                if (structureboundingbox != null && !structureboundingbox.isInside(blockposition2)) continue;
                Fluid fluid = definedstructureinfo.shouldApplyWaterlogging() ? worldaccess.getFluidState(blockposition2) : null;
                IBlockData iblockdata = definedstructure_blockinfo.state.mirror(definedstructureinfo.getMirror()).rotate(definedstructureinfo.getRotation());
                if (definedstructure_blockinfo.nbt != null) {
                    tileentity = worldaccess.getBlockEntity(blockposition2);
                    Clearable.tryClear(tileentity);
                    worldaccess.setBlock(blockposition2, Blocks.BARRIER.defaultBlockState(), 20);
                }
                if (structureTransformer != null) {
                    NBTTagCompound nBTTagCompound;
                    CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)worldaccess, blockposition2, iblockdata, null);
                    if (definedstructure_blockinfo.nbt != null && craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                        entityState.loadData(definedstructure_blockinfo.nbt);
                        if (craftBlockState instanceof CraftLootable) {
                            CraftLootable craftLootable = (CraftLootable)craftBlockState;
                            craftLootable.setSeed(randomsource.nextLong());
                        }
                    }
                    craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                    iblockdata = craftBlockState.getHandle();
                    if (craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                        nBTTagCompound = craftBlockEntityState.getSnapshotNBT();
                    } else {
                        nBTTagCompound = null;
                    }
                    definedstructure_blockinfo = new BlockInfo(blockposition2, iblockdata, nBTTagCompound);
                }
                if (!worldaccess.setBlock(blockposition2, iblockdata, i2)) continue;
                j2 = Math.min(j2, blockposition2.getX());
                k2 = Math.min(k2, blockposition2.getY());
                l2 = Math.min(l2, blockposition2.getZ());
                i1 = Math.max(i1, blockposition2.getX());
                j1 = Math.max(j1, blockposition2.getY());
                k1 = Math.max(k1, blockposition2.getZ());
                list3.add(Pair.of((Object)blockposition2, (Object)definedstructure_blockinfo.nbt));
                if (definedstructure_blockinfo.nbt != null && (tileentity = worldaccess.getBlockEntity(blockposition2)) != null) {
                    if (structureTransformer == null && tileentity instanceof RandomizableContainer) {
                        definedstructure_blockinfo.nbt.putLong("LootTableSeed", randomsource.nextLong());
                    }
                    tileentity.loadWithComponents(definedstructure_blockinfo.nbt, worldaccess.registryAccess());
                }
                if (fluid == null) continue;
                if (iblockdata.getFluidState().isSource()) {
                    list2.add(blockposition2);
                    continue;
                }
                if (!(iblockdata.getBlock() instanceof IFluidContainer)) continue;
                ((IFluidContainer)((Object)iblockdata.getBlock())).placeLiquid(worldaccess, blockposition2, iblockdata, fluid);
                if (fluid.isSource()) continue;
                list1.add(blockposition2);
            }
            boolean flag = true;
            EnumDirection[] aenumdirection = new EnumDirection[]{EnumDirection.UP, EnumDirection.NORTH, EnumDirection.EAST, EnumDirection.SOUTH, EnumDirection.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator1 = list1.iterator();
                while (iterator1.hasNext()) {
                    Block block;
                    BlockPosition blockposition3 = (BlockPosition)iterator1.next();
                    Fluid fluid1 = worldaccess.getFluidState(blockposition3);
                    for (int l1 = 0; l1 < aenumdirection.length && !fluid1.isSource(); ++l1) {
                        BlockPosition blockposition4 = blockposition3.relative(aenumdirection[l1]);
                        Fluid fluid2 = worldaccess.getFluidState(blockposition4);
                        if (!fluid2.isSource() || list2.contains(blockposition4)) continue;
                        fluid1 = fluid2;
                    }
                    if (!fluid1.isSource() || !((block = (iblockdata1 = worldaccess.getBlockState(blockposition3)).getBlock()) instanceof IFluidContainer)) continue;
                    ((IFluidContainer)((Object)block)).placeLiquid(worldaccess, blockposition3, iblockdata1, fluid1);
                    flag = true;
                    iterator1.remove();
                }
            }
            if (j2 <= i1) {
                if (!definedstructureinfo.getKnownShape()) {
                    VoxelShapeBitSet voxelshapebitset = new VoxelShapeBitSet(i1 - j2 + 1, j1 - k2 + 1, k1 - l2 + 1);
                    int i22 = j2;
                    int j22 = k2;
                    int l1 = l2;
                    for (Pair pair : list3) {
                        BlockPosition blockposition5 = (BlockPosition)pair.getFirst();
                        voxelshapebitset.fill(blockposition5.getX() - i22, blockposition5.getY() - j22, blockposition5.getZ() - l1);
                    }
                    DefinedStructure.updateShapeAtEdge(worldaccess, i2, voxelshapebitset, i22, j22, l1);
                }
                for (Pair pair1 : list3) {
                    BlockPosition blockposition6 = (BlockPosition)pair1.getFirst();
                    if (!definedstructureinfo.getKnownShape()) {
                        IBlockData iblockdata2;
                        iblockdata1 = worldaccess.getBlockState(blockposition6);
                        if (iblockdata1 != (iblockdata2 = Block.updateFromNeighbourShapes(iblockdata1, worldaccess, blockposition6))) {
                            worldaccess.setBlock(blockposition6, iblockdata2, i2 & 0xFFFFFFFE | 0x10);
                        }
                        worldaccess.blockUpdated(blockposition6, iblockdata2.getBlock());
                    }
                    if (pair1.getSecond() == null || (tileentity = worldaccess.getBlockEntity(blockposition6)) == null) continue;
                    tileentity.setChanged();
                }
            }
            if (!definedstructureinfo.isIgnoreEntities()) {
                this.placeEntities(wrappedAccess, blockposition, definedstructureinfo.getMirror(), definedstructureinfo.getRotation(), definedstructureinfo.getRotationPivot(), structureboundingbox, definedstructureinfo.shouldFinalizeEntities());
            }
            return true;
        }
        return false;
    }

    public static void updateShapeAtEdge(GeneratorAccess generatoraccess, int i2, VoxelShapeDiscrete voxelshapediscrete, BlockPosition blockposition) {
        DefinedStructure.updateShapeAtEdge(generatoraccess, i2, voxelshapediscrete, blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    public static void updateShapeAtEdge(GeneratorAccess generatoraccess, int i2, VoxelShapeDiscrete voxelshapediscrete, int j2, int k2, int l2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
        voxelshapediscrete.forAllFaces((enumdirection, i1, j1, k1) -> {
            IBlockData iblockdata3;
            blockposition_mutableblockposition.set(j2 + i1, k2 + j1, l2 + k1);
            blockposition_mutableblockposition1.setWithOffset((BaseBlockPosition)blockposition_mutableblockposition, enumdirection);
            IBlockData iblockdata = generatoraccess.getBlockState(blockposition_mutableblockposition);
            IBlockData iblockdata1 = generatoraccess.getBlockState(blockposition_mutableblockposition1);
            IBlockData iblockdata2 = iblockdata.updateShape(enumdirection, iblockdata1, generatoraccess, blockposition_mutableblockposition, blockposition_mutableblockposition1);
            if (iblockdata != iblockdata2) {
                generatoraccess.setBlock(blockposition_mutableblockposition, iblockdata2, i2 & 0xFFFFFFFE);
            }
            if (iblockdata1 != (iblockdata3 = iblockdata1.updateShape(enumdirection.getOpposite(), iblockdata2, generatoraccess, blockposition_mutableblockposition1, blockposition_mutableblockposition))) {
                generatoraccess.setBlock(blockposition_mutableblockposition1, iblockdata3, i2 & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> processBlockInfos(WorldAccess worldaccess, BlockPosition blockposition, BlockPosition blockposition1, DefinedStructureInfo definedstructureinfo, List<BlockInfo> list) {
        ArrayList<BlockInfo> list1 = new ArrayList<BlockInfo>();
        List<BlockInfo> list2 = new ArrayList<BlockInfo>();
        for (BlockInfo definedstructure_blockinfo : list) {
            BlockPosition blockposition2 = DefinedStructure.calculateRelativePosition(definedstructureinfo, definedstructure_blockinfo.pos).offset(blockposition);
            BlockInfo definedstructure_blockinfo1 = new BlockInfo(blockposition2, definedstructure_blockinfo.state, definedstructure_blockinfo.nbt != null ? definedstructure_blockinfo.nbt.copy() : null);
            Iterator<DefinedStructureProcessor> iterator1 = definedstructureinfo.getProcessors().iterator();
            while (definedstructure_blockinfo1 != null && iterator1.hasNext()) {
                definedstructure_blockinfo1 = iterator1.next().processBlock(worldaccess, blockposition, blockposition1, definedstructure_blockinfo, definedstructure_blockinfo1, definedstructureinfo);
            }
            if (definedstructure_blockinfo1 == null) continue;
            list2.add(definedstructure_blockinfo1);
            list1.add(definedstructure_blockinfo);
        }
        for (DefinedStructureProcessor definedstructureprocessor : definedstructureinfo.getProcessors()) {
            list2 = definedstructureprocessor.finalizeProcessing(worldaccess, blockposition, blockposition1, list1, list2, definedstructureinfo);
        }
        return list2;
    }

    private void placeEntities(WorldAccess worldaccess, BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, BlockPosition blockposition1, @Nullable StructureBoundingBox structureboundingbox, boolean flag) {
        for (EntityInfo definedstructure_entityinfo : this.entityInfoList) {
            BlockPosition blockposition2 = DefinedStructure.transform(definedstructure_entityinfo.blockPos, enumblockmirror, enumblockrotation, blockposition1).offset(blockposition);
            if (structureboundingbox != null && !structureboundingbox.isInside(blockposition2)) continue;
            NBTTagCompound nbttagcompound = definedstructure_entityinfo.nbt.copy();
            Vec3D vec3d = DefinedStructure.transform(definedstructure_entityinfo.pos, enumblockmirror, enumblockrotation, blockposition1);
            Vec3D vec3d1 = vec3d.add(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.add(NBTTagDouble.valueOf(vec3d1.x));
            nbttaglist.add(NBTTagDouble.valueOf(vec3d1.y));
            nbttaglist.add(NBTTagDouble.valueOf(vec3d1.z));
            nbttagcompound.put("Pos", nbttaglist);
            nbttagcompound.remove("UUID");
            DefinedStructure.createEntityIgnoreException(worldaccess, nbttagcompound).ifPresent(entity -> {
                float f2 = entity.rotate(enumblockrotation);
                entity.moveTo(vec3d1.x, vec3d1.y, vec3d1.z, f2 += entity.mirror(enumblockmirror) - entity.getYRot(), entity.getXRot());
                if (flag && entity instanceof EntityInsentient) {
                    ((EntityInsentient)entity).finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(BlockPosition.containing(vec3d1)), EnumMobSpawn.STRUCTURE, null);
                }
                worldaccess.addFreshEntityWithPassengers((Entity)entity);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(WorldAccess worldaccess, NBTTagCompound nbttagcompound) {
        return EntityTypes.create(nbttagcompound, worldaccess.getLevel());
    }

    public BaseBlockPosition getSize(EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BaseBlockPosition(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPosition transform(BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, BlockPosition blockposition1) {
        int i2 = blockposition.getX();
        int j2 = blockposition.getY();
        int k2 = blockposition.getZ();
        boolean flag = true;
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                k2 = -k2;
                break;
            }
            case FRONT_BACK: {
                i2 = -i2;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l2 = blockposition1.getX();
        int i1 = blockposition1.getZ();
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPosition(l2 - i1 + k2, j2, l2 + i1 - i2);
            }
            case CLOCKWISE_90: {
                return new BlockPosition(l2 + i1 - k2, j2, i1 - l2 + i2);
            }
            case CLOCKWISE_180: {
                return new BlockPosition(l2 + l2 - i2, j2, i1 + i1 - k2);
            }
        }
        return flag ? new BlockPosition(i2, j2, k2) : blockposition;
    }

    public static Vec3D transform(Vec3D vec3d, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, BlockPosition blockposition) {
        double d0 = vec3d.x;
        double d1 = vec3d.y;
        double d2 = vec3d.z;
        boolean flag = true;
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i2 = blockposition.getX();
        int j2 = blockposition.getZ();
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3D((double)(i2 - j2) + d2, d1, (double)(i2 + j2 + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3D((double)(i2 + j2 + 1) - d2, d1, (double)(j2 - i2) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3D((double)(i2 + i2 + 1) - d0, d1, (double)(j2 + j2 + 1) - d2);
            }
        }
        return flag ? new Vec3D(d0, d1, d2) : vec3d;
    }

    public BlockPosition getZeroPositionWithTransform(BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation) {
        return DefinedStructure.getZeroPositionWithTransform(blockposition, enumblockmirror, enumblockrotation, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPosition getZeroPositionWithTransform(BlockPosition blockposition, EnumBlockMirror enumblockmirror, EnumBlockRotation enumblockrotation, int i2, int j2) {
        int k2 = enumblockmirror == EnumBlockMirror.FRONT_BACK ? --i2 : 0;
        int l2 = enumblockmirror == EnumBlockMirror.LEFT_RIGHT ? --j2 : 0;
        BlockPosition blockposition1 = blockposition;
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: {
                blockposition1 = blockposition.offset(l2, 0, i2 - k2);
                break;
            }
            case CLOCKWISE_90: {
                blockposition1 = blockposition.offset(j2 - l2, 0, k2);
                break;
            }
            case CLOCKWISE_180: {
                blockposition1 = blockposition.offset(i2 - k2, 0, j2 - l2);
                break;
            }
            case NONE: {
                blockposition1 = blockposition.offset(k2, 0, l2);
            }
        }
        return blockposition1;
    }

    public StructureBoundingBox getBoundingBox(DefinedStructureInfo definedstructureinfo, BlockPosition blockposition) {
        return this.getBoundingBox(blockposition, definedstructureinfo.getRotation(), definedstructureinfo.getRotationPivot(), definedstructureinfo.getMirror());
    }

    public StructureBoundingBox getBoundingBox(BlockPosition blockposition, EnumBlockRotation enumblockrotation, BlockPosition blockposition1, EnumBlockMirror enumblockmirror) {
        return DefinedStructure.getBoundingBox(blockposition, enumblockrotation, blockposition1, enumblockmirror, this.size);
    }

    @VisibleForTesting
    protected static StructureBoundingBox getBoundingBox(BlockPosition blockposition, EnumBlockRotation enumblockrotation, BlockPosition blockposition1, EnumBlockMirror enumblockmirror, BaseBlockPosition baseblockposition) {
        BaseBlockPosition baseblockposition1 = baseblockposition.offset(-1, -1, -1);
        BlockPosition blockposition2 = DefinedStructure.transform(BlockPosition.ZERO, enumblockmirror, enumblockrotation, blockposition1);
        BlockPosition blockposition3 = DefinedStructure.transform(BlockPosition.ZERO.offset(baseblockposition1), enumblockmirror, enumblockrotation, blockposition1);
        return StructureBoundingBox.fromCorners(blockposition2, blockposition3).move(blockposition);
    }

    public NBTTagCompound save(NBTTagCompound nbttagcompound) {
        if (this.palettes.isEmpty()) {
            nbttagcompound.put(BLOCKS_TAG, new NBTTagList());
            nbttagcompound.put(PALETTE_TAG, new NBTTagList());
        } else {
            ArrayList list = Lists.newArrayList();
            b definedstructure_b = new b();
            list.add(definedstructure_b);
            for (int i2 = 1; i2 < this.palettes.size(); ++i2) {
                list.add(new b());
            }
            NBTTagList nbttaglist = new NBTTagList();
            List<BlockInfo> list1 = this.palettes.get(0).blocks();
            for (int j2 = 0; j2 < list1.size(); ++j2) {
                BlockInfo definedstructure_blockinfo = list1.get(j2);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.put("pos", this.newIntegerList(definedstructure_blockinfo.pos.getX(), definedstructure_blockinfo.pos.getY(), definedstructure_blockinfo.pos.getZ()));
                int k2 = definedstructure_b.idFor(definedstructure_blockinfo.state);
                nbttagcompound1.putInt(BLOCK_TAG_STATE, k2);
                if (definedstructure_blockinfo.nbt != null) {
                    nbttagcompound1.put("nbt", definedstructure_blockinfo.nbt);
                }
                nbttaglist.add(nbttagcompound1);
                for (int l2 = 1; l2 < this.palettes.size(); ++l2) {
                    b definedstructure_b1 = (b)list.get(l2);
                    definedstructure_b1.addMapping(this.palettes.get((int)l2).blocks().get((int)j2).state, k2);
                }
            }
            nbttagcompound.put(BLOCKS_TAG, nbttaglist);
            if (list.size() == 1) {
                nbttaglist1 = new NBTTagList();
                for (IBlockData iblockdata : definedstructure_b) {
                    nbttaglist1.add(GameProfileSerializer.writeBlockState(iblockdata));
                }
                nbttagcompound.put(PALETTE_TAG, nbttaglist1);
            } else {
                nbttaglist1 = new NBTTagList();
                for (b definedstructure_b2 : list) {
                    NBTTagList nbttaglist2 = new NBTTagList();
                    for (IBlockData iblockdata1 : definedstructure_b2) {
                        nbttaglist2.add(GameProfileSerializer.writeBlockState(iblockdata1));
                    }
                    nbttaglist1.add(nbttaglist2);
                }
                nbttagcompound.put(PALETTE_LIST_TAG, nbttaglist1);
            }
        }
        NBTTagList nbttaglist3 = new NBTTagList();
        for (EntityInfo definedstructure_entityinfo : this.entityInfoList) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.put("pos", this.newDoubleList(definedstructure_entityinfo.pos.x, definedstructure_entityinfo.pos.y, definedstructure_entityinfo.pos.z));
            nbttagcompound2.put(ENTITY_TAG_BLOCKPOS, this.newIntegerList(definedstructure_entityinfo.blockPos.getX(), definedstructure_entityinfo.blockPos.getY(), definedstructure_entityinfo.blockPos.getZ()));
            if (definedstructure_entityinfo.nbt != null) {
                nbttagcompound2.put("nbt", definedstructure_entityinfo.nbt);
            }
            nbttaglist3.add(nbttagcompound2);
        }
        nbttagcompound.put(ENTITIES_TAG, nbttaglist3);
        nbttagcompound.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return GameProfileSerializer.addCurrentDataVersion(nbttagcompound);
    }

    public void load(HolderGetter<Block> holdergetter, NBTTagCompound nbttagcompound) {
        int i2;
        NBTTagList nbttaglist2;
        this.palettes.clear();
        this.entityInfoList.clear();
        NBTTagList nbttaglist = nbttagcompound.getList(SIZE_TAG, 3);
        this.size = new BaseBlockPosition(nbttaglist.getInt(0), nbttaglist.getInt(1), nbttaglist.getInt(2));
        NBTTagList nbttaglist1 = nbttagcompound.getList(BLOCKS_TAG, 10);
        if (nbttagcompound.contains(PALETTE_LIST_TAG, 9)) {
            nbttaglist2 = nbttagcompound.getList(PALETTE_LIST_TAG, 9);
            for (i2 = 0; i2 < nbttaglist2.size(); ++i2) {
                this.loadPalette(holdergetter, nbttaglist2.getList(i2), nbttaglist1);
            }
        } else {
            this.loadPalette(holdergetter, nbttagcompound.getList(PALETTE_TAG, 10), nbttaglist1);
        }
        nbttaglist2 = nbttagcompound.getList(ENTITIES_TAG, 10);
        for (i2 = 0; i2 < nbttaglist2.size(); ++i2) {
            NBTTagCompound nbttagcompound1 = nbttaglist2.getCompound(i2);
            NBTTagList nbttaglist3 = nbttagcompound1.getList("pos", 6);
            Vec3D vec3d = new Vec3D(nbttaglist3.getDouble(0), nbttaglist3.getDouble(1), nbttaglist3.getDouble(2));
            NBTTagList nbttaglist4 = nbttagcompound1.getList(ENTITY_TAG_BLOCKPOS, 3);
            BlockPosition blockposition = new BlockPosition(nbttaglist4.getInt(0), nbttaglist4.getInt(1), nbttaglist4.getInt(2));
            if (!nbttagcompound1.contains("nbt")) continue;
            NBTTagCompound nbttagcompound2 = nbttagcompound1.getCompound("nbt");
            this.entityInfoList.add(new EntityInfo(vec3d, blockposition, nbttagcompound2));
        }
        NBTBase base = nbttagcompound.get("BukkitValues");
        if (base instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)base);
        }
    }

    private void loadPalette(HolderGetter<Block> holdergetter, NBTTagList nbttaglist, NBTTagList nbttaglist1) {
        b definedstructure_b = new b();
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            definedstructure_b.addMapping(GameProfileSerializer.readBlockState(holdergetter, nbttaglist.getCompound(i2)), i2);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (int j2 = 0; j2 < nbttaglist1.size(); ++j2) {
            NBTTagCompound nbttagcompound = nbttaglist1.getCompound(j2);
            NBTTagList nbttaglist2 = nbttagcompound.getList("pos", 3);
            BlockPosition blockposition = new BlockPosition(nbttaglist2.getInt(0), nbttaglist2.getInt(1), nbttaglist2.getInt(2));
            IBlockData iblockdata = definedstructure_b.stateFor(nbttagcompound.getInt(BLOCK_TAG_STATE));
            NBTTagCompound nbttagcompound1 = nbttagcompound.contains("nbt") ? nbttagcompound.getCompound("nbt") : null;
            BlockInfo definedstructure_blockinfo = new BlockInfo(blockposition, iblockdata, nbttagcompound1);
            DefinedStructure.addToLists(definedstructure_blockinfo, list, list1, list2);
        }
        List<BlockInfo> list3 = DefinedStructure.buildInfoList(list, list1, list2);
        this.palettes.add(new a(list3));
    }

    private NBTTagList newIntegerList(int ... aint) {
        NBTTagList nbttaglist = new NBTTagList();
        int[] aint1 = aint;
        int i2 = aint.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            nbttaglist.add(NBTTagInt.valueOf(k2));
        }
        return nbttaglist;
    }

    private NBTTagList newDoubleList(double ... adouble) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = adouble;
        int i2 = adouble.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.valueOf(d0));
        }
        return nbttaglist;
    }

    public record BlockInfo(BlockPosition pos, IBlockData state, @Nullable NBTTagCompound nbt) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class a {
        private final List<BlockInfo> blocks;
        private final Map<Block, List<BlockInfo>> cache = Maps.newHashMap();

        a(List<BlockInfo> list) {
            this.blocks = list;
        }

        public List<BlockInfo> blocks() {
            return this.blocks;
        }

        public List<BlockInfo> blocks(Block block) {
            return this.cache.computeIfAbsent(block, block1 -> this.blocks.stream().filter(definedstructure_blockinfo -> definedstructure_blockinfo.state.is((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3D pos;
        public final BlockPosition blockPos;
        public final NBTTagCompound nbt;

        public EntityInfo(Vec3D vec3d, BlockPosition blockposition, NBTTagCompound nbttagcompound) {
            this.pos = vec3d;
            this.blockPos = blockposition;
            this.nbt = nbttagcompound;
        }
    }

    private static class b
    implements Iterable<IBlockData> {
        public static final IBlockData DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final RegistryBlockID<IBlockData> ids = new RegistryBlockID(16);
        private int lastId;

        b() {
        }

        public int idFor(IBlockData iblockdata) {
            int i2 = this.ids.getId(iblockdata);
            if (i2 == -1) {
                i2 = this.lastId++;
                this.ids.addMapping(iblockdata, i2);
            }
            return i2;
        }

        @Nullable
        public IBlockData stateFor(int i2) {
            IBlockData iblockdata = this.ids.byId(i2);
            return iblockdata == null ? DEFAULT_BLOCK_STATE : iblockdata;
        }

        @Override
        public Iterator<IBlockData> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockData iblockdata, int i2) {
            this.ids.addMapping(iblockdata, i2);
        }
    }
}

