/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;

public class LightEngineStorageSky
extends LightEngineStorage<a> {
    protected LightEngineStorageSky(ILightAccess var0) {
        super(EnumSkyBlock.SKY, var0, new a((Long2ObjectOpenHashMap<NibbleArray>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    protected int getLightValue(long var0) {
        return this.getLightValue(var0, false);
    }

    protected int getLightValue(long var0, boolean var2) {
        long var3 = SectionPosition.blockToSection(var0);
        int var5 = SectionPosition.y(var3);
        a var6 = var2 ? (a)this.updatingSectionData : (a)this.visibleSectionData;
        int var7 = var6.topSections.get(SectionPosition.getZeroNode(var3));
        if (var7 == var6.currentLowestY || var5 >= var7) {
            if (var2 && !this.lightOnInSection(var3)) {
                return 0;
            }
            return 15;
        }
        NibbleArray var8 = this.getDataLayer(var6, var3);
        if (var8 == null) {
            var0 = BlockPosition.getFlatIndex(var0);
            while (var8 == null) {
                if (++var5 >= var7) {
                    return 15;
                }
                var3 = SectionPosition.offset(var3, EnumDirection.UP);
                var8 = this.getDataLayer(var6, var3);
            }
        }
        return var8.get(SectionPosition.sectionRelative(BlockPosition.getX(var0)), SectionPosition.sectionRelative(BlockPosition.getY(var0)), SectionPosition.sectionRelative(BlockPosition.getZ(var0)));
    }

    @Override
    protected void onNodeAdded(long var0) {
        long var3;
        int var5;
        int var2 = SectionPosition.y(var0);
        if (((a)this.updatingSectionData).currentLowestY > var2) {
            ((a)this.updatingSectionData).currentLowestY = var2;
            ((a)this.updatingSectionData).topSections.defaultReturnValue(((a)this.updatingSectionData).currentLowestY);
        }
        if ((var5 = ((a)this.updatingSectionData).topSections.get(var3 = SectionPosition.getZeroNode(var0))) < var2 + 1) {
            ((a)this.updatingSectionData).topSections.put(var3, var2 + 1);
        }
    }

    @Override
    protected void onNodeRemoved(long var0) {
        long var2 = SectionPosition.getZeroNode(var0);
        int var4 = SectionPosition.y(var0);
        if (((a)this.updatingSectionData).topSections.get(var2) == var4 + 1) {
            long var5 = var0;
            while (!this.storingLightForSection(var5) && this.hasLightDataAtOrBelow(var4)) {
                --var4;
                var5 = SectionPosition.offset(var5, EnumDirection.DOWN);
            }
            if (this.storingLightForSection(var5)) {
                ((a)this.updatingSectionData).topSections.put(var2, var4 + 1);
            } else {
                ((a)this.updatingSectionData).topSections.remove(var2);
            }
        }
    }

    @Override
    protected NibbleArray createDataLayer(long var0) {
        NibbleArray var6;
        NibbleArray var2 = (NibbleArray)this.queuedSections.get(var0);
        if (var2 != null) {
            return var2;
        }
        int var3 = ((a)this.updatingSectionData).topSections.get(SectionPosition.getZeroNode(var0));
        if (var3 == ((a)this.updatingSectionData).currentLowestY || SectionPosition.y(var0) >= var3) {
            if (this.lightOnInSection(var0)) {
                return new NibbleArray(15);
            }
            return new NibbleArray();
        }
        long var4 = SectionPosition.offset(var0, EnumDirection.UP);
        while ((var6 = this.getDataLayer(var4, true)) == null) {
            var4 = SectionPosition.offset(var4, EnumDirection.UP);
        }
        return LightEngineStorageSky.repeatFirstLayer(var6);
    }

    private static NibbleArray repeatFirstLayer(NibbleArray var0) {
        if (var0.isDefinitelyHomogenous()) {
            return var0.copy();
        }
        byte[] var1 = var0.getData();
        byte[] var2 = new byte[2048];
        for (int var3 = 0; var3 < 16; ++var3) {
            System.arraycopy(var1, 0, var2, var3 * 128, 128);
        }
        return new NibbleArray(var2);
    }

    protected boolean hasLightDataAtOrBelow(int var0) {
        return var0 >= ((a)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long var0) {
        long var2 = SectionPosition.getZeroNode(var0);
        int var4 = ((a)this.updatingSectionData).topSections.get(var2);
        return var4 == ((a)this.updatingSectionData).currentLowestY || SectionPosition.y(var0) >= var4;
    }

    protected int getTopSectionY(long var0) {
        return ((a)this.updatingSectionData).topSections.get(var0);
    }

    protected int getBottomSectionY() {
        return ((a)this.updatingSectionData).currentLowestY;
    }

    protected static final class a
    extends LightEngineStorageArray<a> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public a(Long2ObjectOpenHashMap<NibbleArray> var0, Long2IntOpenHashMap var1, int var2) {
            super(var0);
            this.topSections = var1;
            var1.defaultReturnValue(var2);
            this.currentLowestY = var2;
        }

        @Override
        public a copy() {
            return new a((Long2ObjectOpenHashMap<NibbleArray>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }

        @Override
        public /* synthetic */ LightEngineStorageArray copy() {
            return this.copy();
        }
    }
}

