/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;

public abstract class FluidTypeFlowing
extends FluidType {
    public static final BlockStateBoolean FALLING = BlockProperties.FALLING;
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL_FLOWING;
    private static final int CACHE_SIZE = 200;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.a>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.a> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.a>(200){

            protected void rehash(int i2) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    private final Map<Fluid, VoxelShape> shapes = Maps.newIdentityHashMap();

    @Override
    protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> blockstatelist_a) {
        blockstatelist_a.add(FALLING);
    }

    @Override
    public Vec3D getFlow(IBlockAccess iblockaccess, BlockPosition blockposition, Fluid fluid) {
        double d0 = 0.0;
        double d1 = 0.0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection);
            Fluid fluid1 = iblockaccess.getFluidState(blockposition_mutableblockposition);
            if (!this.affectsFlow(fluid1)) continue;
            float f2 = fluid1.getOwnHeight();
            float f1 = 0.0f;
            if (f2 == 0.0f) {
                BaseBlockPosition blockposition1;
                Fluid fluid2;
                if (!iblockaccess.getBlockState(blockposition_mutableblockposition).blocksMotion() && this.affectsFlow(fluid2 = iblockaccess.getFluidState((BlockPosition)(blockposition1 = blockposition_mutableblockposition.below()))) && (f2 = fluid2.getOwnHeight()) > 0.0f) {
                    f1 = fluid.getOwnHeight() - (f2 - 0.8888889f);
                }
            } else if (f2 > 0.0f) {
                f1 = fluid.getOwnHeight() - f2;
            }
            if (f1 == 0.0f) continue;
            d0 += (double)((float)enumdirection.getStepX() * f1);
            d1 += (double)((float)enumdirection.getStepZ() * f1);
        }
        Vec3D vec3d = new Vec3D(d0, 0.0, d1);
        if (fluid.getValue(FALLING).booleanValue()) {
            for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                blockposition_mutableblockposition.setWithOffset((BaseBlockPosition)blockposition, enumdirection1);
                if (!this.isSolidFace(iblockaccess, blockposition_mutableblockposition, enumdirection1) && !this.isSolidFace(iblockaccess, (BlockPosition)blockposition_mutableblockposition.above(), enumdirection1)) continue;
                vec3d = vec3d.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3d.normalize();
    }

    private boolean affectsFlow(Fluid fluid) {
        return fluid.isEmpty() || fluid.getType().isSame(this);
    }

    protected boolean isSolidFace(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        IBlockData iblockdata = iblockaccess.getBlockState(blockposition);
        Fluid fluid = iblockaccess.getFluidState(blockposition);
        return fluid.getType().isSame(this) ? false : (enumdirection == EnumDirection.UP ? true : (iblockdata.getBlock() instanceof BlockIce ? false : iblockdata.isFaceSturdy(iblockaccess, blockposition, enumdirection)));
    }

    protected void spread(World world, BlockPosition blockposition, Fluid fluid) {
        if (!fluid.isEmpty()) {
            IBlockData iblockdata = world.getBlockState(blockposition);
            BlockPosition blockposition1 = blockposition.below();
            IBlockData iblockdata1 = world.getBlockState(blockposition1);
            Fluid fluid1 = this.getNewLiquid(world, blockposition1, iblockdata1);
            if (this.canSpreadTo(world, blockposition, iblockdata, EnumDirection.DOWN, blockposition1, iblockdata1, world.getFluidState(blockposition1), fluid1.getType())) {
                CraftBlock source = CraftBlock.at(world, blockposition);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, BlockFace.DOWN);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                this.spreadTo(world, blockposition1, iblockdata1, EnumDirection.DOWN, fluid1);
                if (this.sourceNeighborCount(world, blockposition) >= 3) {
                    this.spreadToSides(world, blockposition, fluid, iblockdata);
                }
            } else if (fluid.isSource() || !this.isWaterHole(world, fluid1.getType(), blockposition, iblockdata, blockposition1, iblockdata1)) {
                this.spreadToSides(world, blockposition, fluid, iblockdata);
            }
        }
    }

    private void spreadToSides(World world, BlockPosition blockposition, Fluid fluid, IBlockData iblockdata) {
        int i2 = fluid.getAmount() - this.getDropOff(world);
        if (fluid.getValue(FALLING).booleanValue()) {
            i2 = 7;
        }
        if (i2 > 0) {
            Map<EnumDirection, Fluid> map = this.getSpread(world, blockposition, iblockdata);
            for (Map.Entry<EnumDirection, Fluid> entry : map.entrySet()) {
                IBlockData iblockdata1;
                EnumDirection enumdirection = entry.getKey();
                Fluid fluid1 = entry.getValue();
                BlockPosition blockposition1 = blockposition.relative(enumdirection);
                if (!this.canSpreadTo(world, blockposition, iblockdata, enumdirection, blockposition1, iblockdata1 = world.getBlockState(blockposition1), world.getFluidState(blockposition1), fluid1.getType())) continue;
                CraftBlock source = CraftBlock.at(world, blockposition);
                BlockFromToEvent event = new BlockFromToEvent((org.bukkit.block.Block)source, CraftBlock.notchToBlockFace(enumdirection));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.spreadTo(world, blockposition1, iblockdata1, enumdirection, fluid1);
            }
        }
    }

    protected Fluid getNewLiquid(World world, BlockPosition blockposition, IBlockData iblockdata) {
        BlockPosition blockposition2;
        IBlockData iblockdata3;
        Fluid fluid2;
        int i2 = 0;
        int j2 = 0;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            IBlockData iblockdata1 = world.getBlockState(blockposition1);
            Fluid fluid = iblockdata1.getFluidState();
            if (!fluid.getType().isSame(this) || !this.canPassThroughWall(enumdirection, world, blockposition, iblockdata, blockposition1, iblockdata1)) continue;
            if (fluid.isSource()) {
                ++j2;
            }
            i2 = Math.max(i2, fluid.getAmount());
        }
        if (this.canConvertToSource(world) && j2 >= 2) {
            IBlockData iblockdata2 = world.getBlockState(blockposition.below());
            Fluid fluid1 = iblockdata2.getFluidState();
            if (iblockdata2.isSolid() || this.isSourceBlockOfThisType(fluid1)) {
                return this.getSource(false);
            }
        }
        if (!(fluid2 = (iblockdata3 = world.getBlockState(blockposition2 = blockposition.above())).getFluidState()).isEmpty() && fluid2.getType().isSame(this) && this.canPassThroughWall(EnumDirection.UP, world, blockposition, iblockdata, blockposition2, iblockdata3)) {
            return this.getFlowing(8, true);
        }
        int k2 = i2 - this.getDropOff(world);
        return k2 <= 0 ? FluidTypes.EMPTY.defaultFluidState() : this.getFlowing(k2, false);
    }

    private boolean canPassThroughWall(EnumDirection enumdirection, IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, BlockPosition blockposition1, IBlockData iblockdata1) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        boolean flag;
        Block.a block_a;
        Object2ByteLinkedOpenHashMap<Block.a> object2bytelinkedopenhashmap = !iblockdata.getBlock().hasDynamicShape() && !iblockdata1.getBlock().hasDynamicShape() ? OCCLUSION_CACHE.get() : null;
        if (object2bytelinkedopenhashmap != null) {
            block_a = new Block.a(iblockdata, iblockdata1, enumdirection);
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block_a);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            block_a = null;
        }
        boolean bl = flag = !VoxelShapes.mergedFaceOccludes(voxelshape = iblockdata.getCollisionShape(iblockaccess, blockposition), voxelshape1 = iblockdata1.getCollisionShape(iblockaccess, blockposition1), enumdirection);
        if (object2bytelinkedopenhashmap != null) {
            if (object2bytelinkedopenhashmap.size() == 200) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block_a, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    public abstract FluidType getFlowing();

    public Fluid getFlowing(int i2, boolean flag) {
        return (Fluid)((Fluid)this.getFlowing().defaultFluidState().setValue(LEVEL, i2)).setValue(FALLING, flag);
    }

    public abstract FluidType getSource();

    public Fluid getSource(boolean flag) {
        return (Fluid)this.getSource().defaultFluidState().setValue(FALLING, flag);
    }

    protected abstract boolean canConvertToSource(World var1);

    protected void spreadTo(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata, EnumDirection enumdirection, Fluid fluid) {
        if (iblockdata.getBlock() instanceof IFluidContainer) {
            ((IFluidContainer)((Object)iblockdata.getBlock())).placeLiquid(generatoraccess, blockposition, iblockdata, fluid);
        } else {
            if (!iblockdata.isAir()) {
                this.beforeDestroyingBlock(generatoraccess, blockposition, iblockdata);
            }
            generatoraccess.setBlock(blockposition, fluid.createLegacyBlock(), 3);
        }
    }

    protected abstract void beforeDestroyingBlock(GeneratorAccess var1, BlockPosition var2, IBlockData var3);

    private static short getCacheKey(BlockPosition blockposition, BlockPosition blockposition1) {
        int i2 = blockposition1.getX() - blockposition.getX();
        int j2 = blockposition1.getZ() - blockposition.getZ();
        return (short)((i2 + 128 & 0xFF) << 8 | j2 + 128 & 0xFF);
    }

    protected int getSlopeDistance(IWorldReader iworldreader, BlockPosition blockposition, int i2, EnumDirection enumdirection, IBlockData iblockdata, BlockPosition blockposition1, Short2ObjectMap<Pair<IBlockData, Fluid>> short2objectmap, Short2BooleanMap short2booleanmap) {
        int j2 = 1000;
        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            int k2;
            if (enumdirection1 == enumdirection) continue;
            BlockPosition blockposition2 = blockposition.relative(enumdirection1);
            short short0 = FluidTypeFlowing.getCacheKey(blockposition1, blockposition2);
            Pair pair = (Pair)short2objectmap.computeIfAbsent(short0, short1 -> {
                IBlockData iblockdata1 = iworldreader.getBlockState(blockposition2);
                return Pair.of((Object)iblockdata1, (Object)iblockdata1.getFluidState());
            });
            IBlockData iblockdata1 = (IBlockData)pair.getFirst();
            Fluid fluid = (Fluid)pair.getSecond();
            if (!this.canPassThrough(iworldreader, this.getFlowing(), blockposition, iblockdata, enumdirection1, blockposition2, iblockdata1, fluid)) continue;
            boolean flag = short2booleanmap.computeIfAbsent(short0, short1 -> {
                BlockPosition blockposition3 = blockposition2.below();
                IBlockData iblockdata2 = iworldreader.getBlockState(blockposition3);
                return this.isWaterHole(iworldreader, this.getFlowing(), blockposition2, iblockdata1, blockposition3, iblockdata2);
            });
            if (flag) {
                return i2;
            }
            if (i2 >= this.getSlopeFindDistance(iworldreader) || (k2 = this.getSlopeDistance(iworldreader, blockposition2, i2 + 1, enumdirection1.getOpposite(), iblockdata1, blockposition1, short2objectmap, short2booleanmap)) >= j2) continue;
            j2 = k2;
        }
        return j2;
    }

    private boolean isWaterHole(IBlockAccess iblockaccess, FluidType fluidtype, BlockPosition blockposition, IBlockData iblockdata, BlockPosition blockposition1, IBlockData iblockdata1) {
        return !this.canPassThroughWall(EnumDirection.DOWN, iblockaccess, blockposition, iblockdata, blockposition1, iblockdata1) ? false : (iblockdata1.getFluidState().getType().isSame(this) ? true : this.canHoldFluid(iblockaccess, blockposition1, iblockdata1, fluidtype));
    }

    private boolean canPassThrough(IBlockAccess iblockaccess, FluidType fluidtype, BlockPosition blockposition, IBlockData iblockdata, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, Fluid fluid) {
        return !this.isSourceBlockOfThisType(fluid) && this.canPassThroughWall(enumdirection, iblockaccess, blockposition, iblockdata, blockposition1, iblockdata1) && this.canHoldFluid(iblockaccess, blockposition1, iblockdata1, fluidtype);
    }

    private boolean isSourceBlockOfThisType(Fluid fluid) {
        return fluid.getType().isSame(this) && fluid.isSource();
    }

    protected abstract int getSlopeFindDistance(IWorldReader var1);

    private int sourceNeighborCount(IWorldReader iworldreader, BlockPosition blockposition) {
        int i2 = 0;
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            Fluid fluid = iworldreader.getFluidState(blockposition1);
            if (!this.isSourceBlockOfThisType(fluid)) continue;
            ++i2;
        }
        return i2;
    }

    protected Map<EnumDirection, Fluid> getSpread(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = 1000;
        EnumMap map = Maps.newEnumMap(EnumDirection.class);
        Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap short2booleanopenhashmap = new Short2BooleanOpenHashMap();
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition blockposition1 = blockposition.relative(enumdirection);
            short short0 = FluidTypeFlowing.getCacheKey(blockposition, blockposition1);
            Pair pair = (Pair)short2objectmap.computeIfAbsent(short0, short1 -> {
                IBlockData iblockdata1 = world.getBlockState(blockposition1);
                return Pair.of((Object)iblockdata1, (Object)iblockdata1.getFluidState());
            });
            IBlockData iblockdata1 = (IBlockData)pair.getFirst();
            Fluid fluid = (Fluid)pair.getSecond();
            Fluid fluid1 = this.getNewLiquid(world, blockposition1, iblockdata1);
            if (!this.canPassThrough(world, fluid1.getType(), blockposition, iblockdata, enumdirection, blockposition1, iblockdata1, fluid)) continue;
            BlockPosition blockposition2 = blockposition1.below();
            boolean flag = short2booleanopenhashmap.computeIfAbsent(short0, short1 -> {
                IBlockData iblockdata2 = world.getBlockState(blockposition2);
                return this.isWaterHole(world, this.getFlowing(), blockposition1, iblockdata1, blockposition2, iblockdata2);
            });
            int j2 = flag ? 0 : this.getSlopeDistance(world, blockposition1, 1, enumdirection.getOpposite(), iblockdata1, blockposition, (Short2ObjectMap<Pair<IBlockData, Fluid>>)short2objectmap, (Short2BooleanMap)short2booleanopenhashmap);
            if (j2 < i2) {
                map.clear();
            }
            if (j2 > i2) continue;
            map.put(enumdirection, fluid1);
            i2 = j2;
        }
        return map;
    }

    private boolean canHoldFluid(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, FluidType fluidtype) {
        Block block = iblockdata.getBlock();
        if (block instanceof IFluidContainer) {
            IFluidContainer ifluidcontainer = (IFluidContainer)((Object)block);
            return ifluidcontainer.canPlaceLiquid(null, iblockaccess, blockposition, iblockdata, fluidtype);
        }
        return !(block instanceof BlockDoor || iblockdata.is(TagsBlock.SIGNS) || iblockdata.is(Blocks.LADDER) || iblockdata.is(Blocks.SUGAR_CANE) || iblockdata.is(Blocks.BUBBLE_COLUMN)) ? (!(iblockdata.is(Blocks.NETHER_PORTAL) || iblockdata.is(Blocks.END_PORTAL) || iblockdata.is(Blocks.END_GATEWAY) || iblockdata.is(Blocks.STRUCTURE_VOID)) ? !iblockdata.blocksMotion() : false) : false;
    }

    protected boolean canSpreadTo(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, Fluid fluid, FluidType fluidtype) {
        return fluid.canBeReplacedWith(iblockaccess, blockposition1, fluidtype, enumdirection) && this.canPassThroughWall(enumdirection, iblockaccess, blockposition, iblockdata, blockposition1, iblockdata1) && this.canHoldFluid(iblockaccess, blockposition1, iblockdata1, fluidtype);
    }

    protected abstract int getDropOff(IWorldReader var1);

    protected int getSpreadDelay(World world, BlockPosition blockposition, Fluid fluid, Fluid fluid1) {
        return this.getTickDelay(world);
    }

    @Override
    public void tick(World world, BlockPosition blockposition, Fluid fluid) {
        if (!fluid.isSource()) {
            Fluid fluid1 = this.getNewLiquid(world, blockposition, world.getBlockState(blockposition));
            int i2 = this.getSpreadDelay(world, blockposition, fluid, fluid1);
            if (fluid1.isEmpty()) {
                fluid = fluid1;
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, blockposition, Blocks.AIR.defaultBlockState());
                if (event.isCancelled()) {
                    return;
                }
                world.setBlock(blockposition, ((CraftBlockData)event.getNewData()).getState(), 3);
            } else if (!fluid1.equals(fluid)) {
                fluid = fluid1;
                IBlockData iblockdata = fluid1.createLegacyBlock();
                FluidLevelChangeEvent event = CraftEventFactory.callFluidLevelChangeEvent(world, blockposition, iblockdata);
                if (event.isCancelled()) {
                    return;
                }
                world.setBlock(blockposition, ((CraftBlockData)event.getNewData()).getState(), 2);
                world.scheduleTick(blockposition, fluid1.getType(), i2);
                world.updateNeighborsAt(blockposition, iblockdata.getBlock());
            }
        }
        this.spread(world, blockposition, fluid);
    }

    protected static int getLegacyLevel(Fluid fluid) {
        return fluid.isSource() ? 0 : 8 - Math.min(fluid.getAmount(), 8) + (fluid.getValue(FALLING) != false ? 8 : 0);
    }

    private static boolean hasSameAbove(Fluid fluid, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return fluid.getType().isSame(iblockaccess.getFluidState(blockposition.above()).getType());
    }

    @Override
    public float getHeight(Fluid fluid, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return FluidTypeFlowing.hasSameAbove(fluid, iblockaccess, blockposition) ? 1.0f : fluid.getOwnHeight();
    }

    @Override
    public float getOwnHeight(Fluid fluid) {
        return (float)fluid.getAmount() / 9.0f;
    }

    @Override
    public abstract int getAmount(Fluid var1);

    @Override
    public VoxelShape getShape(Fluid fluid, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return fluid.getAmount() == 9 && FluidTypeFlowing.hasSameAbove(fluid, iblockaccess, blockposition) ? VoxelShapes.block() : this.shapes.computeIfAbsent(fluid, fluid1 -> VoxelShapes.box(0.0, 0.0, 0.0, 1.0, fluid1.getHeight(iblockaccess, blockposition), 1.0));
    }
}

