/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public abstract class FluidTypeLava
extends FluidTypeFlowing {
    public static final float MIN_LEVEL_CUTOFF = 0.44444445f;

    @Override
    public FluidType getFlowing() {
        return FluidTypes.FLOWING_LAVA;
    }

    @Override
    public FluidType getSource() {
        return FluidTypes.LAVA;
    }

    @Override
    public Item getBucket() {
        return Items.LAVA_BUCKET;
    }

    @Override
    public void animateTick(World world, BlockPosition blockposition, Fluid fluid, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.above();
        if (world.getBlockState(blockposition1).isAir() && !world.getBlockState(blockposition1).isSolidRender(world, blockposition1)) {
            if (randomsource.nextInt(100) == 0) {
                double d0 = (double)blockposition.getX() + randomsource.nextDouble();
                double d1 = (double)blockposition.getY() + 1.0;
                double d2 = (double)blockposition.getZ() + randomsource.nextDouble();
                world.addParticle(Particles.LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
                world.playLocalSound(d0, d1, d2, SoundEffects.LAVA_POP, SoundCategory.BLOCKS, 0.2f + randomsource.nextFloat() * 0.2f, 0.9f + randomsource.nextFloat() * 0.15f, false);
            }
            if (randomsource.nextInt(200) == 0) {
                world.playLocalSound(blockposition.getX(), blockposition.getY(), blockposition.getZ(), SoundEffects.LAVA_AMBIENT, SoundCategory.BLOCKS, 0.2f + randomsource.nextFloat() * 0.2f, 0.9f + randomsource.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public void randomTick(World world, BlockPosition blockposition, Fluid fluid, RandomSource randomsource) {
        block7: {
            if (!world.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block7;
            int i2 = randomsource.nextInt(3);
            if (i2 > 0) {
                BlockPosition blockposition1 = blockposition;
                for (int j2 = 0; j2 < i2; ++j2) {
                    if (!world.isLoaded(blockposition1 = blockposition1.offset(randomsource.nextInt(3) - 1, 1, randomsource.nextInt(3) - 1))) {
                        return;
                    }
                    IBlockData iblockdata = world.getBlockState(blockposition1);
                    if (iblockdata.isAir()) {
                        if (!this.hasFlammableNeighbours(world, blockposition1) || world.getBlockState(blockposition1).getBlock() != Blocks.FIRE && CraftEventFactory.callBlockIgniteEvent(world, blockposition1, blockposition).isCancelled()) continue;
                        world.setBlockAndUpdate(blockposition1, BlockFireAbstract.getState(world, blockposition1));
                        return;
                    }
                    if (!iblockdata.blocksMotion()) continue;
                    return;
                }
            } else {
                for (int k2 = 0; k2 < 3; ++k2) {
                    BlockPosition up;
                    BlockPosition blockposition2 = blockposition.offset(randomsource.nextInt(3) - 1, 0, randomsource.nextInt(3) - 1);
                    if (!world.isLoaded(blockposition2)) {
                        return;
                    }
                    if (!world.isEmptyBlock(blockposition2.above()) || !this.isFlammable(world, blockposition2) || world.getBlockState(up = blockposition2.above()).getBlock() != Blocks.FIRE && CraftEventFactory.callBlockIgniteEvent(world, up, blockposition).isCancelled()) continue;
                    world.setBlockAndUpdate(blockposition2.above(), BlockFireAbstract.getState(world, blockposition2));
                }
            }
        }
    }

    private boolean hasFlammableNeighbours(IWorldReader iworldreader, BlockPosition blockposition) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.isFlammable(iworldreader, blockposition.relative(enumdirection))) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(IWorldReader iworldreader, BlockPosition blockposition) {
        return blockposition.getY() >= iworldreader.getMinBuildHeight() && blockposition.getY() < iworldreader.getMaxBuildHeight() && !iworldreader.hasChunkAt(blockposition) ? false : iworldreader.getBlockState(blockposition).ignitedByLava();
    }

    @Override
    @Nullable
    public ParticleParam getDripParticle() {
        return Particles.DRIPPING_LAVA;
    }

    @Override
    protected void beforeDestroyingBlock(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        this.fizz(generatoraccess, blockposition);
    }

    @Override
    public int getSlopeFindDistance(IWorldReader iworldreader) {
        return iworldreader.dimensionType().ultraWarm() ? 4 : 2;
    }

    @Override
    public IBlockData createLegacyBlock(Fluid fluid) {
        return (IBlockData)Blocks.LAVA.defaultBlockState().setValue(BlockFluids.LEVEL, FluidTypeLava.getLegacyLevel(fluid));
    }

    @Override
    public boolean isSame(FluidType fluidtype) {
        return fluidtype == FluidTypes.LAVA || fluidtype == FluidTypes.FLOWING_LAVA;
    }

    @Override
    public int getDropOff(IWorldReader iworldreader) {
        return iworldreader.dimensionType().ultraWarm() ? 1 : 2;
    }

    @Override
    public boolean canBeReplacedWith(Fluid fluid, IBlockAccess iblockaccess, BlockPosition blockposition, FluidType fluidtype, EnumDirection enumdirection) {
        return fluid.getHeight(iblockaccess, blockposition) >= 0.44444445f && fluidtype.is(TagsFluid.WATER);
    }

    @Override
    public int getTickDelay(IWorldReader iworldreader) {
        return iworldreader.dimensionType().ultraWarm() ? 10 : 30;
    }

    @Override
    public int getSpreadDelay(World world, BlockPosition blockposition, Fluid fluid, Fluid fluid1) {
        int i2 = this.getTickDelay(world);
        if (!(fluid.isEmpty() || fluid1.isEmpty() || fluid.getValue(FALLING).booleanValue() || fluid1.getValue(FALLING).booleanValue() || !(fluid1.getHeight(world, blockposition) > fluid.getHeight(world, blockposition)) || world.getRandom().nextInt(4) == 0)) {
            i2 *= 4;
        }
        return i2;
    }

    private void fizz(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        generatoraccess.levelEvent(1501, blockposition, 0);
    }

    @Override
    protected boolean canConvertToSource(World world) {
        return world.getGameRules().getBoolean(GameRules.RULE_LAVA_SOURCE_CONVERSION);
    }

    @Override
    protected void spreadTo(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata, EnumDirection enumdirection, Fluid fluid) {
        if (enumdirection == EnumDirection.DOWN) {
            Fluid fluid1 = generatoraccess.getFluidState(blockposition);
            if (this.is(TagsFluid.LAVA) && fluid1.is(TagsFluid.WATER)) {
                if (iblockdata.getBlock() instanceof BlockFluids && !CraftEventFactory.handleBlockFormEvent((World)generatoraccess.getMinecraftWorld(), blockposition, Blocks.STONE.defaultBlockState(), 3)) {
                    return;
                }
                this.fizz(generatoraccess, blockposition);
                return;
            }
        }
        super.spreadTo(generatoraccess, blockposition, iblockdata, enumdirection, fluid);
    }

    @Override
    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return Optional.of(SoundEffects.BUCKET_FILL_LAVA);
    }

    public static class b
    extends FluidTypeLava {
        @Override
        public int getAmount(Fluid fluid) {
            return 8;
        }

        @Override
        public boolean isSource(Fluid fluid) {
            return true;
        }
    }

    public static class a
    extends FluidTypeLava {
        @Override
        protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> blockstatelist_a) {
            super.createFluidStateDefinition(blockstatelist_a);
            blockstatelist_a.add(LEVEL);
        }

        @Override
        public int getAmount(Fluid fluid) {
            return fluid.getValue(LEVEL);
        }

        @Override
        public boolean isSource(Fluid fluid) {
            return false;
        }
    }
}

