/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBase.f FRAME = (iblockdata, iblockaccess, blockposition) -> iblockdata.is(Blocks.OBSIDIAN);
    private static final float SAFE_TRAVEL_MAX_ENTITY_XY = 4.0f;
    private static final double SAFE_TRAVEL_MAX_VERTICAL_DELTA = 1.0;
    private final GeneratorAccess level;
    private final EnumDirection.EnumAxis axis;
    private final EnumDirection rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPosition bottomLeft;
    private int height;
    private final int width;
    BlockStateListPopulator blocks;

    public static Optional<BlockPortalShape> findEmptyPortalShape(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        return BlockPortalShape.findPortalShape(generatoraccess, blockposition, blockportalshape -> blockportalshape.isValid() && blockportalshape.numPortalBlocks == 0, enumdirection_enumaxis);
    }

    public static Optional<BlockPortalShape> findPortalShape(GeneratorAccess generatoraccess, BlockPosition blockposition, Predicate<BlockPortalShape> predicate, EnumDirection.EnumAxis enumdirection_enumaxis) {
        Optional<BlockPortalShape> optional = Optional.of(new BlockPortalShape(generatoraccess, blockposition, enumdirection_enumaxis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = enumdirection_enumaxis == EnumDirection.EnumAxis.X ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
        return Optional.of(new BlockPortalShape(generatoraccess, blockposition, enumdirection_enumaxis1)).filter(predicate);
    }

    public BlockPortalShape(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        this.blocks = new BlockStateListPopulator(generatoraccess.getMinecraftWorld());
        this.level = generatoraccess;
        this.axis = enumdirection_enumaxis;
        this.rightDir = enumdirection_enumaxis == EnumDirection.EnumAxis.X ? EnumDirection.WEST : EnumDirection.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(blockposition);
        if (this.bottomLeft == null) {
            this.bottomLeft = blockposition;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
    }

    @Nullable
    private BlockPosition calculateBottomLeft(BlockPosition blockposition) {
        int i2 = Math.max(this.level.getMinBuildHeight(), blockposition.getY() - 21);
        while (blockposition.getY() > i2 && BlockPortalShape.isEmpty(this.level.getBlockState(blockposition.below()))) {
            blockposition = blockposition.below();
        }
        EnumDirection enumdirection = this.rightDir.getOpposite();
        int j2 = this.getDistanceUntilEdgeAboveFrame(blockposition, enumdirection) - 1;
        return j2 < 0 ? null : blockposition.relative(enumdirection, j2);
    }

    private int calculateWidth() {
        int i2 = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i2 >= 2 && i2 <= 21 ? i2 : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            blockposition_mutableblockposition.set(blockposition).move(enumdirection, i2);
            IBlockData iblockdata = this.level.getBlockState(blockposition_mutableblockposition);
            if (!BlockPortalShape.isEmpty(iblockdata)) {
                if (!FRAME.test(iblockdata, this.level, blockposition_mutableblockposition)) break;
                this.blocks.setBlock(blockposition_mutableblockposition, iblockdata, 18);
                return i2;
            }
            IBlockData iblockdata1 = this.level.getBlockState(blockposition_mutableblockposition.move(EnumDirection.DOWN));
            if (!FRAME.test(iblockdata1, this.level, blockposition_mutableblockposition)) break;
            this.blocks.setBlock(blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int i2 = this.getDistanceUntilTop(blockposition_mutableblockposition);
        return i2 >= 3 && i2 <= 21 && this.hasTopFrame(blockposition_mutableblockposition, i2) ? i2 : 0;
    }

    private boolean hasTopFrame(BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2) {
        for (int j2 = 0; j2 < this.width; ++j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition_mutableblockposition.set(this.bottomLeft).move(EnumDirection.UP, i2).move(this.rightDir, j2);
            if (!FRAME.test(this.level.getBlockState(blockposition_mutableblockposition1), this.level, blockposition_mutableblockposition1)) {
                return false;
            }
            this.blocks.setBlock(blockposition_mutableblockposition1, this.level.getBlockState(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPosition.MutableBlockPosition blockposition_mutableblockposition) {
        for (int i2 = 0; i2 < 21; ++i2) {
            blockposition_mutableblockposition.set(this.bottomLeft).move(EnumDirection.UP, i2).move(this.rightDir, -1);
            if (!FRAME.test(this.level.getBlockState(blockposition_mutableblockposition), this.level, blockposition_mutableblockposition)) {
                return i2;
            }
            blockposition_mutableblockposition.set(this.bottomLeft).move(EnumDirection.UP, i2).move(this.rightDir, this.width);
            if (!FRAME.test(this.level.getBlockState(blockposition_mutableblockposition), this.level, blockposition_mutableblockposition)) {
                return i2;
            }
            for (int j2 = 0; j2 < this.width; ++j2) {
                blockposition_mutableblockposition.set(this.bottomLeft).move(EnumDirection.UP, i2).move(this.rightDir, j2);
                IBlockData iblockdata = this.level.getBlockState(blockposition_mutableblockposition);
                if (!BlockPortalShape.isEmpty(iblockdata)) {
                    return i2;
                }
                if (!iblockdata.is(Blocks.NETHER_PORTAL)) continue;
                ++this.numPortalBlocks;
            }
            this.blocks.setBlock(blockposition_mutableblockposition.set(this.bottomLeft).move(EnumDirection.UP, i2).move(this.rightDir, -1), this.level.getBlockState(blockposition_mutableblockposition), 18);
            this.blocks.setBlock(blockposition_mutableblockposition.set(this.bottomLeft).move(EnumDirection.UP, i2).move(this.rightDir, this.width), this.level.getBlockState(blockposition_mutableblockposition), 18);
        }
        return 21;
    }

    private static boolean isEmpty(IBlockData iblockdata) {
        return iblockdata.isAir() || iblockdata.is(TagsBlock.FIRE) || iblockdata.is(Blocks.NETHER_PORTAL);
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public boolean createPortalBlocks(net.minecraft.world.entity.Entity entity) {
        CraftWorld bworld = this.level.getMinecraftWorld().getWorld();
        IBlockData iblockdata = (IBlockData)Blocks.NETHER_PORTAL.defaultBlockState().setValue(BlockPortal.AXIS, this.axis);
        BlockPosition.betweenClosed(this.bottomLeft, this.bottomLeft.relative(EnumDirection.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(blockposition -> this.blocks.setBlock((BlockPosition)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.FIRE);
        this.level.getMinecraftWorld().getServer().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.betweenClosed(this.bottomLeft, this.bottomLeft.relative(EnumDirection.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(blockposition -> this.level.setBlock((BlockPosition)blockposition, iblockdata, 18));
        return true;
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vec3D getRelativePosition(BlockUtil.Rectangle blockutil_rectangle, EnumDirection.EnumAxis enumdirection_enumaxis, Vec3D vec3d, EntitySize entitysize) {
        EnumDirection.EnumAxis enumdirection_enumaxis1;
        double d3;
        double d2;
        double d0 = (double)blockutil_rectangle.axis1Size - (double)entitysize.width();
        double d1 = (double)blockutil_rectangle.axis2Size - (double)entitysize.height();
        BlockPosition blockposition = blockutil_rectangle.minCorner;
        if (d0 > 0.0) {
            d2 = (double)blockposition.get(enumdirection_enumaxis) + (double)entitysize.width() / 2.0;
            d3 = MathHelper.clamp(MathHelper.inverseLerp(vec3d.get(enumdirection_enumaxis) - d2, 0.0, d0), 0.0, 1.0);
        } else {
            d3 = 0.5;
        }
        if (d1 > 0.0) {
            enumdirection_enumaxis1 = EnumDirection.EnumAxis.Y;
            d2 = MathHelper.clamp(MathHelper.inverseLerp(vec3d.get(enumdirection_enumaxis1) - (double)blockposition.get(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d2 = 0.0;
        }
        enumdirection_enumaxis1 = enumdirection_enumaxis == EnumDirection.EnumAxis.X ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
        double d4 = vec3d.get(enumdirection_enumaxis1) - ((double)blockposition.get(enumdirection_enumaxis1) + 0.5);
        return new Vec3D(d3, d2, d4);
    }

    public static Vec3D findCollisionFreePosition(Vec3D vec3d, WorldServer worldserver, net.minecraft.world.entity.Entity entity, EntitySize entitysize) {
        if (entitysize.width() <= 4.0f && entitysize.height() <= 4.0f) {
            double d0 = (double)entitysize.height() / 2.0;
            Vec3D vec3d1 = vec3d.add(0.0, d0, 0.0);
            VoxelShape voxelshape = VoxelShapes.create(AxisAlignedBB.ofSize(vec3d1, entitysize.width(), 0.0, entitysize.width()).expandTowards(0.0, 1.0, 0.0).inflate(1.0E-6));
            Optional<Vec3D> optional = worldserver.findFreePosition(entity, voxelshape, vec3d1, entitysize.width(), entitysize.height(), entitysize.width());
            Optional<Vec3D> optional1 = optional.map(vec3d2 -> vec3d2.subtract(0.0, d0, 0.0));
            return optional1.orElse(vec3d);
        }
        return vec3d;
    }
}

