/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.BlockUtil;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalTravelAgent {
    public static final int TICKET_RADIUS = 3;
    private static final int NETHER_PORTAL_RADIUS = 16;
    private static final int OVERWORLD_PORTAL_RADIUS = 128;
    private static final int FRAME_HEIGHT = 5;
    private static final int FRAME_WIDTH = 4;
    private static final int FRAME_BOX = 3;
    private static final int FRAME_HEIGHT_START = -1;
    private static final int FRAME_HEIGHT_END = 4;
    private static final int FRAME_WIDTH_START = -1;
    private static final int FRAME_WIDTH_END = 3;
    private static final int FRAME_BOX_START = -1;
    private static final int FRAME_BOX_END = 2;
    private static final int NOTHING_FOUND = -1;
    private final WorldServer level;

    public PortalTravelAgent(WorldServer worldserver) {
        this.level = worldserver;
    }

    public Optional<BlockPosition> findClosestPortalPosition(BlockPosition blockposition, boolean flag, WorldBorder worldborder) {
        return this.findClosestPortalPosition(blockposition, worldborder, flag ? 16 : 128);
    }

    public Optional<BlockPosition> findClosestPortalPosition(BlockPosition blockposition, WorldBorder worldborder, int i2) {
        VillagePlace villageplace = this.level.getPoiManager();
        villageplace.ensureLoadedAndValid(this.level, blockposition, i2);
        Stream<BlockPosition> stream = villageplace.getInSquare(holder -> holder.is(PoiTypes.NETHER_PORTAL), blockposition, i2, VillagePlace.Occupancy.ANY).map(VillagePlaceRecord::getPos);
        Objects.requireNonNull(worldborder);
        return stream.filter(worldborder::isWithinBounds).filter(blockposition1 -> this.level.getBlockState((BlockPosition)blockposition1).hasProperty(BlockProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(blockposition1 -> blockposition1.distSqr(blockposition)).thenComparingInt(BaseBlockPosition::getY));
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        return this.createPortal(blockposition, enumdirection_enumaxis, null, 16);
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis, net.minecraft.world.entity.Entity entity, int createRadius) {
        int i1;
        int l2;
        int k2;
        int j2;
        EnumDirection enumdirection = EnumDirection.get(EnumDirection.EnumAxisDirection.POSITIVE, enumdirection_enumaxis);
        double d0 = -1.0;
        BlockPosition blockposition1 = null;
        double d1 = -1.0;
        BlockPosition blockposition2 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i2 = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        boolean flag = true;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.mutable();
        for (BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 : BlockPosition.spiralAround(blockposition, createRadius, EnumDirection.EAST, EnumDirection.SOUTH)) {
            j2 = Math.min(i2, this.level.getHeight(HeightMap.Type.MOTION_BLOCKING, blockposition_mutableblockposition1.getX(), blockposition_mutableblockposition1.getZ()));
            if (!worldborder.isWithinBounds(blockposition_mutableblockposition1) || !worldborder.isWithinBounds(blockposition_mutableblockposition1.move(enumdirection, 1))) continue;
            blockposition_mutableblockposition1.move(enumdirection.getOpposite(), 1);
            for (k2 = j2; k2 >= this.level.getMinBuildHeight(); --k2) {
                blockposition_mutableblockposition1.setY(k2);
                if (!this.canPortalReplaceBlock(blockposition_mutableblockposition1)) continue;
                l2 = k2;
                while (k2 > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(blockposition_mutableblockposition1.move(EnumDirection.DOWN))) {
                    --k2;
                }
                if (k2 + 4 > i2 || (i1 = l2 - k2) > 0 && i1 < 3) continue;
                blockposition_mutableblockposition1.setY(k2);
                if (!this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 0)) continue;
                double d2 = blockposition.distSqr(blockposition_mutableblockposition1);
                if (this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, -1) && this.canHostFrame(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockposition1 = blockposition_mutableblockposition1.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockposition2 = blockposition_mutableblockposition1.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockposition1 = blockposition2;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.level);
        if (d0 == -1.0) {
            int k1 = i2 - 9;
            int j1 = Math.max(this.level.getMinBuildHeight() - -1, 70);
            if (k1 < j1) {
                return Optional.empty();
            }
            blockposition1 = new BlockPosition(blockposition.getX() - enumdirection.getStepX() * 1, MathHelper.clamp(blockposition.getY(), j1, k1), blockposition.getZ() - enumdirection.getStepZ() * 1).immutable();
            blockposition1 = worldborder.clampToBounds(blockposition1);
            EnumDirection enumdirection1 = enumdirection.getClockWise();
            for (k2 = -1; k2 < 2; ++k2) {
                for (l2 = 0; l2 < 2; ++l2) {
                    for (i1 = -1; i1 < 3; ++i1) {
                        IBlockData iblockdata = i1 < 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                        blockposition_mutableblockposition.setWithOffset(blockposition1, l2 * enumdirection.getStepX() + k2 * enumdirection1.getStepX(), i1, l2 * enumdirection.getStepZ() + k2 * enumdirection1.getStepZ());
                        blockList.setBlock(blockposition_mutableblockposition, iblockdata, 3);
                    }
                }
            }
        }
        for (int j1 = -1; j1 < 3; ++j1) {
            for (int k1 = -1; k1 < 4; ++k1) {
                if (j1 != -1 && j1 != 2 && k1 != -1 && k1 != 3) continue;
                blockposition_mutableblockposition.setWithOffset(blockposition1, j1 * enumdirection.getStepX(), k1, j1 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
        }
        IBlockData iblockdata1 = (IBlockData)Blocks.NETHER_PORTAL.defaultBlockState().setValue(BlockPortal.AXIS, enumdirection_enumaxis);
        for (int k1 = 0; k1 < 2; ++k1) {
            for (j2 = 0; j2 < 3; ++j2) {
                blockposition_mutableblockposition.setWithOffset(blockposition1, k1 * enumdirection.getStepX(), j2, k1 * enumdirection.getStepZ());
                blockList.setBlock(blockposition_mutableblockposition, iblockdata1, 18);
            }
        }
        CraftWorld bworld = this.level.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new BlockUtil.Rectangle(blockposition1.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPosition.MutableBlockPosition blockposition_mutableblockposition) {
        IBlockData iblockdata = this.level.getBlockState(blockposition_mutableblockposition);
        return iblockdata.canBeReplaced() && iblockdata.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPosition blockposition, BlockPosition.MutableBlockPosition blockposition_mutableblockposition, EnumDirection enumdirection, int i2) {
        EnumDirection enumdirection1 = enumdirection.getClockWise();
        for (int j2 = -1; j2 < 3; ++j2) {
            for (int k2 = -1; k2 < 4; ++k2) {
                blockposition_mutableblockposition.setWithOffset(blockposition, enumdirection.getStepX() * j2 + enumdirection1.getStepX() * i2, k2, enumdirection.getStepZ() * j2 + enumdirection1.getStepZ() * i2);
                if (k2 < 0 && !this.level.getBlockState(blockposition_mutableblockposition).isSolid()) {
                    return false;
                }
                if (k2 < 0 || this.canPortalReplaceBlock(blockposition_mutableblockposition)) continue;
                return false;
            }
        }
        return true;
    }
}

