/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;

public interface NeighborUpdater {
    public static final EnumDirection[] UPDATE_ORDER = new EnumDirection[]{EnumDirection.WEST, EnumDirection.EAST, EnumDirection.DOWN, EnumDirection.UP, EnumDirection.NORTH, EnumDirection.SOUTH};

    public void shapeUpdate(EnumDirection var1, IBlockData var2, BlockPosition var3, BlockPosition var4, int var5, int var6);

    public void neighborChanged(BlockPosition var1, Block var2, BlockPosition var3);

    public void neighborChanged(IBlockData var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5);

    default public void updateNeighborsAtExceptFromFacing(BlockPosition blockposition, Block block, @Nullable EnumDirection enumdirection) {
        for (EnumDirection enumdirection1 : UPDATE_ORDER) {
            if (enumdirection1 == enumdirection) continue;
            this.neighborChanged(blockposition.relative(enumdirection1), block, blockposition);
        }
    }

    public static void executeShapeUpdate(GeneratorAccess generatoraccess, EnumDirection enumdirection, IBlockData iblockdata, BlockPosition blockposition, BlockPosition blockposition1, int i2, int j2) {
        IBlockData iblockdata1 = generatoraccess.getBlockState(blockposition);
        IBlockData iblockdata2 = iblockdata1.updateShape(enumdirection, iblockdata, generatoraccess, blockposition, blockposition1);
        Block.updateOrDestroy(iblockdata1, iblockdata2, generatoraccess, blockposition, i2, j2);
    }

    public static void executeUpdate(World world, IBlockData iblockdata, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        try {
            CraftWorld cworld = ((WorldServer)world).getWorld();
            if (cworld != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (BlockData)CraftBlockData.fromData(iblockdata), (org.bukkit.block.Block)CraftBlock.at(world, blockposition1));
                ((WorldServer)world).getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            iblockdata.handleNeighborChanged(world, blockposition, block, blockposition1, flag);
        }
        catch (StackOverflowError ex) {
            World.lastPhysicsProblem = new BlockPosition(blockposition);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception while updating neighbours");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("Block being updated");
            crashreportsystemdetails.setDetail("Source block type", () -> {
                try {
                    return String.format(Locale.ROOT, "ID #%s (%s // %s)", BuiltInRegistries.BLOCK.getKey(block), block.getDescriptionId(), block.getClass().getCanonicalName());
                }
                catch (Throwable throwable1) {
                    return "ID #" + String.valueOf(BuiltInRegistries.BLOCK.getKey(block));
                }
            });
            CrashReportSystemDetails.populateBlockDetails(crashreportsystemdetails, world, blockposition, iblockdata);
            throw new ReportedException(crashreport);
        }
    }
}

