/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAP_SIZE = 128;
    private static final int HALF_MAP_SIZE = 64;
    public static final int MAX_SCALE = 4;
    public static final int TRACKED_DECORATION_LIMIT = 256;
    private static final String FRAME_PREFIX = "frame-";
    public int centerX;
    public int centerZ;
    public ResourceKey<World> dimension;
    public boolean trackingPosition;
    public boolean unlimitedTracking;
    public byte scale;
    public byte[] colors = new byte[16384];
    public boolean locked;
    public final List<WorldMapHumanTracker> carriedBy = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> carriedByPlayers = Maps.newHashMap();
    private final Map<String, MapIconBanner> bannerMarkers = Maps.newHashMap();
    public final Map<String, MapIcon> decorations = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> frameMarkers = Maps.newHashMap();
    private int trackedDecorationCount;
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public MapId id;

    public static PersistentBase.a<WorldMap> factory() {
        return new PersistentBase.a<WorldMap>(() -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, WorldMap::load, DataFixTypes.SAVED_DATA_MAP_DATA);
    }

    private WorldMap(int i2, int j2, byte b0, boolean flag, boolean flag1, boolean flag2, ResourceKey<World> resourcekey) {
        this.scale = b0;
        this.centerX = i2;
        this.centerZ = j2;
        this.dimension = resourcekey;
        this.trackingPosition = flag;
        this.unlimitedTracking = flag1;
        this.locked = flag2;
        this.setDirty();
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
    }

    public static WorldMap createFresh(double d0, double d1, byte b0, boolean flag, boolean flag1, ResourceKey<World> resourcekey) {
        int i2 = 128 * (1 << b0);
        int j2 = MathHelper.floor((d0 + 64.0) / (double)i2);
        int k2 = MathHelper.floor((d1 + 64.0) / (double)i2);
        int l2 = j2 * i2 + i2 / 2 - 64;
        int i1 = k2 * i2 + i2 / 2 - 64;
        return new WorldMap(l2, i1, b0, flag, flag1, false, resourcekey);
    }

    public static WorldMap createForClient(byte b0, boolean flag, ResourceKey<World> resourcekey) {
        return new WorldMap(0, 0, b0, false, false, flag, resourcekey);
    }

    public static WorldMap load(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        DataResult<ResourceKey<World>> dataresult = DimensionManager.parseLegacy(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound.get("dimension")));
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        ResourceKey resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = nbttagcompound.getLong("UUIDLeast");
            long most = nbttagcompound.getLong("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().dimension();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(nbttagcompound.get("dimension")));
        });
        int i2 = nbttagcompound.getInt("xCenter");
        int j2 = nbttagcompound.getInt("zCenter");
        byte b0 = (byte)MathHelper.clamp(nbttagcompound.getByte("scale"), 0, 4);
        boolean flag = !nbttagcompound.contains("trackingPosition", 1) || nbttagcompound.getBoolean("trackingPosition");
        boolean flag1 = nbttagcompound.getBoolean("unlimitedTracking");
        boolean flag2 = nbttagcompound.getBoolean("locked");
        WorldMap worldmap = new WorldMap(i2, j2, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = nbttagcompound.getByteArray("colors");
        if (abyte.length == 16384) {
            worldmap.colors = abyte;
        }
        RegistryOps<NBTBase> registryops = holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE);
        List list = MapIconBanner.LIST_CODEC.parse(registryops, (Object)nbttagcompound.get("banners")).resultOrPartial(s2 -> LOGGER.warn("Failed to parse map banner: '{}'", s2)).orElse(List.of());
        for (MapIconBanner mapiconbanner : list) {
            worldmap.bannerMarkers.put(mapiconbanner.getId(), mapiconbanner);
            worldmap.addDecoration(mapiconbanner.getDecoration(), null, mapiconbanner.getId(), mapiconbanner.pos().getX(), mapiconbanner.pos().getZ(), 180.0, mapiconbanner.name().orElse(null));
        }
        NBTTagList nbttaglist = nbttagcompound.getList("frames", 10);
        for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
            WorldMapFrame worldmapframe = WorldMapFrame.load(nbttaglist.getCompound(k2));
            if (worldmapframe == null) continue;
            worldmap.frameMarkers.put(worldmapframe.getId(), worldmapframe);
            worldmap.addDecoration(MapDecorationTypes.FRAME, null, WorldMap.getFrameKey(worldmapframe.getEntityId()), worldmapframe.getPos().getX(), worldmapframe.getPos().getZ(), worldmapframe.getRotation(), null);
        }
        return worldmap;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        DataResult dataresult = MinecraftKey.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.dimension.location());
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.put("dimension", (NBTBase)nbtbase));
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().dimension() != this.dimension) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            nbttagcompound.putLong("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            nbttagcompound.putLong("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        nbttagcompound.putInt("xCenter", this.centerX);
        nbttagcompound.putInt("zCenter", this.centerZ);
        nbttagcompound.putByte("scale", this.scale);
        nbttagcompound.putByteArray("colors", this.colors);
        nbttagcompound.putBoolean("trackingPosition", this.trackingPosition);
        nbttagcompound.putBoolean("unlimitedTracking", this.unlimitedTracking);
        nbttagcompound.putBoolean("locked", this.locked);
        RegistryOps<NBTBase> registryops = holderlookup_a.createSerializationContext(DynamicOpsNBT.INSTANCE);
        nbttagcompound.put("banners", (NBTBase)MapIconBanner.LIST_CODEC.encodeStart(registryops, List.copyOf(this.bannerMarkers.values())).getOrThrow());
        NBTTagList nbttaglist = new NBTTagList();
        for (WorldMapFrame worldmapframe : this.frameMarkers.values()) {
            nbttaglist.add(worldmapframe.save());
        }
        nbttagcompound.put("frames", nbttaglist);
        return nbttagcompound;
    }

    public WorldMap locked() {
        WorldMap worldmap = new WorldMap(this.centerX, this.centerZ, this.scale, this.trackingPosition, this.unlimitedTracking, true, this.dimension);
        worldmap.bannerMarkers.putAll(this.bannerMarkers);
        worldmap.decorations.putAll(this.decorations);
        worldmap.trackedDecorationCount = this.trackedDecorationCount;
        System.arraycopy(this.colors, 0, worldmap.colors, 0, this.colors.length);
        worldmap.setDirty();
        return worldmap;
    }

    public WorldMap scaled() {
        return WorldMap.createFresh(this.centerX, this.centerZ, (byte)MathHelper.clamp(this.scale + 1, 0, 4), this.trackingPosition, this.unlimitedTracking, this.dimension);
    }

    private static Predicate<ItemStack> mapMatcher(ItemStack itemstack) {
        MapId mapid = itemstack.get(DataComponents.MAP_ID);
        return itemstack1 -> itemstack1 == itemstack ? true : itemstack1.is(itemstack.getItem()) && Objects.equals(mapid, itemstack1.get(DataComponents.MAP_ID));
    }

    public void tickCarriedBy(EntityHuman entityhuman, ItemStack itemstack) {
        if (!this.carriedByPlayers.containsKey(entityhuman)) {
            WorldMapHumanTracker worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.carriedByPlayers.put(entityhuman, worldmap_worldmaphumantracker);
            this.carriedBy.add(worldmap_worldmaphumantracker);
        }
        Predicate<ItemStack> predicate = WorldMap.mapMatcher(itemstack);
        if (!entityhuman.getInventory().contains(predicate)) {
            this.removeDecoration(entityhuman.getName().getString());
        }
        for (int i2 = 0; i2 < this.carriedBy.size(); ++i2) {
            WorldMapHumanTracker worldmap_worldmaphumantracker1 = this.carriedBy.get(i2);
            String s2 = worldmap_worldmaphumantracker1.player.getName().getString();
            if (!worldmap_worldmaphumantracker1.player.isRemoved() && (worldmap_worldmaphumantracker1.player.getInventory().contains(predicate) || itemstack.isFramed())) {
                if (itemstack.isFramed() || worldmap_worldmaphumantracker1.player.level().dimension() != this.dimension || !this.trackingPosition) continue;
                this.addDecoration(MapDecorationTypes.PLAYER, worldmap_worldmaphumantracker1.player.level(), s2, worldmap_worldmaphumantracker1.player.getX(), worldmap_worldmaphumantracker1.player.getZ(), worldmap_worldmaphumantracker1.player.getYRot(), null);
                continue;
            }
            this.carriedByPlayers.remove(worldmap_worldmaphumantracker1.player);
            this.carriedBy.remove(worldmap_worldmaphumantracker1);
            this.removeDecoration(s2);
        }
        if (itemstack.isFramed() && this.trackingPosition) {
            EntityItemFrame entityitemframe = itemstack.getFrame();
            BlockPosition blockposition = entityitemframe.getPos();
            WorldMapFrame worldmapframe = this.frameMarkers.get(WorldMapFrame.frameId(blockposition));
            if (worldmapframe != null && entityitemframe.getId() != worldmapframe.getEntityId() && this.frameMarkers.containsKey(worldmapframe.getId())) {
                this.removeDecoration(WorldMap.getFrameKey(worldmapframe.getEntityId()));
            }
            WorldMapFrame worldmapframe1 = new WorldMapFrame(blockposition, entityitemframe.getDirection().get2DDataValue() * 90, entityitemframe.getId());
            this.addDecoration(MapDecorationTypes.FRAME, entityhuman.level(), WorldMap.getFrameKey(entityitemframe.getId()), blockposition.getX(), blockposition.getZ(), entityitemframe.getDirection().get2DDataValue() * 90, null);
            this.frameMarkers.put(worldmapframe1.getId(), worldmapframe1);
        }
        MapDecorations mapdecorations = itemstack.getOrDefault(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY);
        if (!this.decorations.keySet().containsAll(mapdecorations.decorations().keySet())) {
            mapdecorations.decorations().forEach((s1, mapdecorations_a) -> {
                if (!this.decorations.containsKey(s1)) {
                    this.addDecoration(mapdecorations_a.type(), entityhuman.level(), (String)s1, mapdecorations_a.x(), mapdecorations_a.z(), mapdecorations_a.rotation(), null);
                }
            });
        }
    }

    private void removeDecoration(String s2) {
        MapIcon mapicon = this.decorations.remove(s2);
        if (mapicon != null && mapicon.type().value().trackCount()) {
            --this.trackedDecorationCount;
        }
        this.setDecorationsDirty();
    }

    public static void addTargetDecoration(ItemStack itemstack, BlockPosition blockposition, String s2, Holder<MapDecorationType> holder) {
        MapDecorations.a mapdecorations_a = new MapDecorations.a(holder, blockposition.getX(), blockposition.getZ(), 180.0f);
        itemstack.update(DataComponents.MAP_DECORATIONS, MapDecorations.EMPTY, mapdecorations -> mapdecorations.withDecoration(s2, mapdecorations_a));
        if (holder.value().hasMapColor()) {
            itemstack.set(DataComponents.MAP_COLOR, new MapItemColor(holder.value().mapColor()));
        }
    }

    private void addDecoration(Holder<MapDecorationType> holder, @Nullable GeneratorAccess generatoraccess, String s2, double d0, double d1, double d2, @Nullable IChatBaseComponent ichatbasecomponent) {
        MapIcon mapicon1;
        MapIcon mapicon;
        byte b2;
        int i2 = 1 << this.scale;
        float f2 = (float)(d0 - (double)this.centerX) / (float)i2;
        float f1 = (float)(d1 - (double)this.centerZ) / (float)i2;
        byte b0 = (byte)((double)(f2 * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        boolean flag = true;
        if (f2 >= -63.0f && f1 >= -63.0f && f2 <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((d2 += d2 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.dimension == World.NETHER && generatoraccess != null) {
                int j2 = (int)(generatoraccess.getLevelData().getDayTime() / 10L);
                b2 = (byte)(j2 * j2 * 34187121 + j2 * 121 >> 15 & 0xF);
            }
        } else {
            if (!holder.is(MapDecorationTypes.PLAYER)) {
                this.removeDecoration(s2);
                return;
            }
            boolean flag1 = true;
            if (Math.abs(f2) < 320.0f && Math.abs(f1) < 320.0f) {
                holder = MapDecorationTypes.PLAYER_OFF_MAP;
            } else {
                if (!this.unlimitedTracking) {
                    this.removeDecoration(s2);
                    return;
                }
                holder = MapDecorationTypes.PLAYER_OFF_LIMITS;
            }
            b2 = 0;
            if (f2 <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f2 >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        if (!(mapicon = new MapIcon(holder, b0, b1, b2, Optional.ofNullable(ichatbasecomponent))).equals(mapicon1 = this.decorations.put(s2, mapicon))) {
            if (mapicon1 != null && mapicon1.type().value().trackCount()) {
                --this.trackedDecorationCount;
            }
            if (holder.value().trackCount()) {
                ++this.trackedDecorationCount;
            }
            this.setDecorationsDirty();
        }
    }

    @Nullable
    public Packet<?> getUpdatePacket(MapId mapid, EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.carriedByPlayers.get(entityhuman);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.nextUpdatePacket(mapid);
    }

    public void setColorsDirty(int i2, int j2) {
        this.setDirty();
        for (WorldMapHumanTracker worldmap_worldmaphumantracker : this.carriedBy) {
            worldmap_worldmaphumantracker.markColorsDirty(i2, j2);
        }
    }

    public void setDecorationsDirty() {
        this.setDirty();
        this.carriedBy.forEach(WorldMapHumanTracker::markDecorationsDirty);
    }

    public WorldMapHumanTracker getHoldingPlayer(EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.carriedByPlayers.get(entityhuman);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.carriedByPlayers.put(entityhuman, worldmap_worldmaphumantracker);
            this.carriedBy.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean toggleBanner(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        double d0 = (double)blockposition.getX() + 0.5;
        double d1 = (double)blockposition.getZ() + 0.5;
        int i2 = 1 << this.scale;
        double d2 = (d0 - (double)this.centerX) / (double)i2;
        double d3 = (d1 - (double)this.centerZ) / (double)i2;
        boolean flag = true;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapiconbanner = MapIconBanner.fromWorld(generatoraccess, blockposition);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.bannerMarkers.remove(mapiconbanner.getId(), mapiconbanner)) {
                this.removeDecoration(mapiconbanner.getId());
                return true;
            }
            if (!this.isTrackedCountOverLimit(256)) {
                this.bannerMarkers.put(mapiconbanner.getId(), mapiconbanner);
                this.addDecoration(mapiconbanner.getDecoration(), generatoraccess, mapiconbanner.getId(), d0, d1, 180.0, mapiconbanner.name().orElse(null));
                return true;
            }
        }
        return false;
    }

    public void checkBanners(IBlockAccess iblockaccess, int i2, int j2) {
        Iterator<MapIconBanner> iterator = this.bannerMarkers.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapiconbanner1;
            MapIconBanner mapiconbanner = iterator.next();
            if (mapiconbanner.pos().getX() != i2 || mapiconbanner.pos().getZ() != j2 || mapiconbanner.equals(mapiconbanner1 = MapIconBanner.fromWorld(iblockaccess, mapiconbanner.pos()))) continue;
            iterator.remove();
            this.removeDecoration(mapiconbanner.getId());
        }
    }

    public Collection<MapIconBanner> getBanners() {
        return this.bannerMarkers.values();
    }

    public void removedFromFrame(BlockPosition blockposition, int i2) {
        this.removeDecoration(WorldMap.getFrameKey(i2));
        this.frameMarkers.remove(WorldMapFrame.frameId(blockposition));
    }

    public boolean updateColor(int i2, int j2, byte b0) {
        byte b1 = this.colors[i2 + j2 * 128];
        if (b1 != b0) {
            this.setColor(i2, j2, b0);
            return true;
        }
        return false;
    }

    public void setColor(int i2, int j2, byte b0) {
        this.colors[i2 + j2 * 128] = b0;
        this.setColorsDirty(i2, j2);
    }

    public boolean isExplorationMap() {
        MapIcon mapicon;
        Iterator<MapIcon> iterator = this.decorations.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(mapicon = iterator.next()).type().value().explorationMapElement());
        return true;
    }

    public void addClientSideDecorations(List<MapIcon> list) {
        this.decorations.clear();
        this.trackedDecorationCount = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MapIcon mapicon = list.get(i2);
            this.decorations.put("icon-" + i2, mapicon);
            if (!mapicon.type().value().trackCount()) continue;
            ++this.trackedDecorationCount;
        }
    }

    public Iterable<MapIcon> getDecorations() {
        return this.decorations.values();
    }

    public boolean isTrackedCountOverLimit(int i2) {
        return this.trackedDecorationCount >= i2;
    }

    private static String getFrameKey(int i2) {
        return FRAME_PREFIX + i2;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman player;
        private boolean dirtyData = true;
        private int minDirtyX;
        private int minDirtyY;
        private int maxDirtyX = 127;
        private int maxDirtyY = 127;
        private boolean dirtyDecorations = true;
        private int tick;
        public int step;

        WorldMapHumanTracker(EntityHuman entityhuman) {
            this.player = entityhuman;
        }

        private b createPatch(byte[] buffer) {
            int i2 = this.minDirtyX;
            int j2 = this.minDirtyY;
            int k2 = this.maxDirtyX + 1 - this.minDirtyX;
            int l2 = this.maxDirtyY + 1 - this.minDirtyY;
            byte[] abyte = new byte[k2 * l2];
            for (int i1 = 0; i1 < k2; ++i1) {
                for (int j1 = 0; j1 < l2; ++j1) {
                    abyte[i1 + j1 * k2] = buffer[i2 + i1 + (j2 + j1) * 128];
                }
            }
            return new b(i2, j2, k2, l2, abyte);
        }

        @Nullable
        Packet<?> nextUpdatePacket(MapId mapid) {
            ArrayList<MapIcon> collection;
            b worldmap_b;
            RenderData render = WorldMap.this.mapView.render((CraftPlayer)this.player.getBukkitEntity());
            if (this.dirtyData) {
                this.dirtyData = false;
                worldmap_b = this.createPatch(render.buffer);
            } else {
                worldmap_b = null;
            }
            if (this.tick++ % 5 == 0) {
                this.dirtyDecorations = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_b == null ? null : new PacketPlayOutMap(mapid, WorldMap.this.scale, WorldMap.this.locked, collection, worldmap_b);
        }

        void markColorsDirty(int i2, int j2) {
            if (this.dirtyData) {
                this.minDirtyX = Math.min(this.minDirtyX, i2);
                this.minDirtyY = Math.min(this.minDirtyY, j2);
                this.maxDirtyX = Math.max(this.maxDirtyX, i2);
                this.maxDirtyY = Math.max(this.maxDirtyY, j2);
            } else {
                this.dirtyData = true;
                this.minDirtyX = i2;
                this.minDirtyY = j2;
                this.maxDirtyX = i2;
                this.maxDirtyY = j2;
            }
        }

        private void markDecorationsDirty() {
            this.dirtyDecorations = true;
        }
    }

    public record b(int startX, int startY, int width, int height, byte[] mapColors) {
        public static final StreamCodec<ByteBuf, Optional<b>> STREAM_CODEC = StreamCodec.of(b::write, b::read);

        private static void write(ByteBuf bytebuf, Optional<b> optional) {
            if (optional.isPresent()) {
                b worldmap_b = optional.get();
                bytebuf.writeByte(worldmap_b.width);
                bytebuf.writeByte(worldmap_b.height);
                bytebuf.writeByte(worldmap_b.startX);
                bytebuf.writeByte(worldmap_b.startY);
                PacketDataSerializer.writeByteArray(bytebuf, worldmap_b.mapColors);
            } else {
                bytebuf.writeByte(0);
            }
        }

        private static Optional<b> read(ByteBuf bytebuf) {
            short short0 = bytebuf.readUnsignedByte();
            if (short0 > 0) {
                short short1 = bytebuf.readUnsignedByte();
                short short2 = bytebuf.readUnsignedByte();
                short short3 = bytebuf.readUnsignedByte();
                byte[] abyte = PacketDataSerializer.readByteArray(bytebuf);
                return Optional.of(new b(short2, short3, short0, short1, abyte));
            }
            return Optional.empty();
        }

        public void applyToMap(WorldMap worldmap) {
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int j2 = 0; j2 < this.height; ++j2) {
                    worldmap.setColor(this.startX + i2, this.startY + j2, this.mapColors[i2 + j2 * this.width]);
                }
            }
        }
    }
}

