/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();
    private static final String TAG_DATA = "Data";
    private static final PathMatcher NO_SYMLINKS_ALLOWED = path -> false;
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    private static final int UNCOMPRESSED_NBT_QUOTA = 0x6400000;
    private static final int DISK_SPACE_WARNING_THRESHOLD = 0x4000000;
    public final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public Convertable(Path path, Path path1, DirectoryValidator directoryvalidator, DataFixer datafixer) {
        this.fixerUpper = datafixer;
        try {
            FileUtils.createDirectoriesSafe(path);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.baseDir = path;
        this.backupDir = path1;
        this.worldDirValidator = directoryvalidator;
    }

    public static DirectoryValidator parseValidator(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                DirectoryValidator directoryvalidator;
                try (BufferedReader bufferedreader = Files.newBufferedReader(path);){
                    directoryvalidator = new DirectoryValidator(PathAllowList.readPlain(bufferedreader));
                }
                return directoryvalidator;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)exception);
            }
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static Convertable createDefault(Path path) {
        DirectoryValidator directoryvalidator = Convertable.parseValidator(path.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new Convertable(path, path.resolve("../backups"), directoryvalidator, DataConverterRegistry.getDataFixer());
    }

    public static WorldDataConfiguration readDataConfig(Dynamic<?> dynamic) {
        DataResult dataresult = WorldDataConfiguration.CODEC.parse(dynamic);
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public static WorldLoader.d getPackConfig(Dynamic<?> dynamic, ResourcePackRepository resourcepackrepository, boolean flag) {
        return new WorldLoader.d(resourcepackrepository, Convertable.readDataConfig(dynamic), flag, false);
    }

    public static LevelDataAndDimensions getLevelDataAndDimensions(Dynamic<?> dynamic, WorldDataConfiguration worlddataconfiguration, IRegistry<WorldDimension> iregistry, IRegistryCustom.Dimension iregistrycustom_dimension) {
        Dynamic<?> dynamic1 = RegistryOps.injectRegistryContext(dynamic, iregistrycustom_dimension);
        Dynamic dynamic2 = dynamic1.get("WorldGenSettings").orElseEmptyMap();
        GeneratorSettings generatorsettings = (GeneratorSettings)GeneratorSettings.CODEC.parse(dynamic2).getOrThrow();
        WorldSettings worldsettings = WorldSettings.parse(dynamic1, worlddataconfiguration);
        WorldDimensions.b worlddimensions_b = generatorsettings.dimensions().bake(iregistry);
        Lifecycle lifecycle = worlddimensions_b.lifecycle().add(iregistrycustom_dimension.allRegistriesLifecycle());
        WorldDataServer worlddataserver = WorldDataServer.parse(dynamic1, worldsettings, worlddimensions_b.specialWorldProperty(), generatorsettings.options(), lifecycle);
        worlddataserver.pdc = (NBTBase)dynamic1.getElement("BukkitValues", null);
        return new LevelDataAndDimensions(worlddataserver, worlddimensions_b);
    }

    public String getName() {
        return "Anvil";
    }

    public a findLevelCandidates() throws LevelStorageException {
        if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
            throw new LevelStorageException(IChatBaseComponent.translatable("selectWorld.load_folder_access"));
        }
        try {
            a convertable_a;
            try (Stream<Path> stream = Files.list(this.baseDir);){
                List<b> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(b::new).filter(convertable_b -> Files.isRegularFile(convertable_b.dataFile(), new LinkOption[0]) || Files.isRegularFile(convertable_b.oldDataFile(), new LinkOption[0])).toList();
                convertable_a = new a(list);
            }
            return convertable_a;
        }
        catch (IOException ioexception) {
            throw new LevelStorageException(IChatBaseComponent.translatable("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<WorldInfo>> loadLevelSummaries(a convertable_a) {
        ArrayList<CompletableFuture<WorldInfo>> list = new ArrayList<CompletableFuture<WorldInfo>>(convertable_a.levels.size());
        for (b convertable_b : convertable_a.levels) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = SessionLock.isLocked(convertable_b.path());
                }
                catch (Exception exception) {
                    LOGGER.warn("Failed to read {} lock", (Object)convertable_b.path(), (Object)exception);
                    return null;
                }
                try {
                    return this.readLevelSummary(convertable_b, flag);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.release();
                    System.gc();
                    String s2 = "Ran out of memory trying to read summary of world folder \"" + convertable_b.directoryName() + "\"";
                    LOGGER.error(LogUtils.FATAL_MARKER, s2);
                    OutOfMemoryError outofmemoryerror1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror1.initCause(outofmemoryerror);
                    CrashReport crashreport = CrashReport.forThrowable(outofmemoryerror1, s2);
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("World details");
                    crashreportsystemdetails.setDetail("Folder Name", convertable_b.directoryName());
                    try {
                        long i2 = Files.size(convertable_b.dataFile());
                        crashreportsystemdetails.setDetail("level.dat size", i2);
                    }
                    catch (IOException ioexception) {
                        crashreportsystemdetails.setDetailError("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, SystemUtils.backgroundExecutor()));
        }
        return SystemUtils.sequenceFailFastAndCancel(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    static NBTTagCompound readLevelDataTagRaw(Path path) throws IOException {
        return NBTCompressedStreamTools.readCompressed(path, NBTReadLimiter.create(0x6400000L));
    }

    static Dynamic<?> readLevelDataTagFixed(Path path, DataFixer datafixer) throws IOException {
        NBTTagCompound nbttagcompound = Convertable.readLevelDataTagRaw(path);
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound(TAG_DATA);
        int i2 = GameProfileSerializer.getDataVersion(nbttagcompound1, -1);
        Dynamic dynamic = DataFixTypes.LEVEL.updateToCurrentVersion(datafixer, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound1), i2);
        dynamic = dynamic.update("Player", dynamic1 -> DataFixTypes.PLAYER.updateToCurrentVersion(datafixer, dynamic1, i2));
        dynamic = dynamic.update("WorldGenSettings", dynamic1 -> DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(datafixer, dynamic1, i2));
        return dynamic;
    }

    private WorldInfo readLevelSummary(b convertable_b, boolean flag) {
        Path path = convertable_b.dataFile();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.worldDirValidator.validateSymlink(path)).isEmpty()) {
                    LOGGER.warn("{}", (Object)ContentValidationException.getMessage(path, list));
                    return new WorldInfo.c(convertable_b.directoryName(), convertable_b.iconFile());
                }
                NBTBase nbtbase = Convertable.readLightweightData(path);
                if (nbtbase instanceof NBTTagCompound) {
                    NBTTagCompound nbttagcompound = (NBTTagCompound)nbtbase;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.getCompound(TAG_DATA);
                    int i2 = GameProfileSerializer.getDataVersion(nbttagcompound1, -1);
                    Dynamic dynamic = DataFixTypes.LEVEL.updateToCurrentVersion(this.fixerUpper, new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)nbttagcompound1), i2);
                    return this.makeLevelSummary(dynamic, convertable_b, flag);
                }
                LOGGER.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                LOGGER.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new WorldInfo.b(convertable_b.directoryName(), convertable_b.iconFile(), Convertable.getFileModificationTime(convertable_b));
    }

    private static long getFileModificationTime(b convertable_b) {
        Instant instant = Convertable.getFileModificationTime(convertable_b.dataFile());
        if (instant == null) {
            instant = Convertable.getFileModificationTime(convertable_b.oldDataFile());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    @Nullable
    static Instant getFileModificationTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    WorldInfo makeLevelSummary(Dynamic<?> dynamic, b convertable_b, boolean flag) {
        LevelVersion levelversion = LevelVersion.parse(dynamic);
        int i2 = levelversion.levelDataVersion();
        if (i2 != 19132 && i2 != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i2));
        }
        boolean flag1 = i2 != this.getStorageVersion();
        Path path = convertable_b.iconFile();
        WorldDataConfiguration worlddataconfiguration = Convertable.readDataConfig(dynamic);
        WorldSettings worldsettings = WorldSettings.parse(dynamic, worlddataconfiguration);
        FeatureFlagSet featureflagset = Convertable.parseFeatureFlagsFromSummary(dynamic);
        boolean flag2 = FeatureFlags.isExperimental(featureflagset);
        return new WorldInfo(worldsettings, levelversion, convertable_b.directoryName(), flag1, flag, flag2, path);
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> dynamic) {
        Set<MinecraftKey> set = dynamic.get("enabled_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().map(MinecraftKey::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames(set, minecraftkey -> {});
    }

    @Nullable
    private static NBTBase readLightweightData(Path path) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "Player"), new FieldSelector(TAG_DATA, NBTTagCompound.TYPE, "WorldGenSettings"));
        NBTCompressedStreamTools.parseCompressed(path, (StreamTagVisitor)skipfields, NBTReadLimiter.create(0x6400000L));
        return skipfields.getResult();
    }

    public boolean isNewLevelIdAcceptable(String s2) {
        try {
            Path path = this.getLevelPath(s2);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean levelExists(String s2) {
        try {
            return Files.isDirectory(this.getLevelPath(s2), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path getLevelPath(String s2) {
        return this.baseDir.resolve(s2);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public ConversionSession validateAndCreateAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException, ContentValidationException {
        Path path = this.getLevelPath(s2);
        List<ForbiddenSymlinkInfo> list = this.worldDirValidator.validateDirectory(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new ConversionSession(s2, path, dimensionType);
    }

    public ConversionSession createAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException {
        Path path = this.getLevelPath(s2);
        return new ConversionSession(s2, path, dimensionType);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public static Path getStorageFolder(Path path, ResourceKey<WorldDimension> dimensionType) {
        if (dimensionType == WorldDimension.OVERWORLD) {
            return path;
        }
        if (dimensionType == WorldDimension.NETHER) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == WorldDimension.END) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.location().getNamespace()).resolve(dimensionType.location().getPath());
    }

    public record a(List<b> levels) implements Iterable<b>
    {
        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.levels.iterator();
        }
    }

    public record b(Path path) {
        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(SavedFile.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(SavedFile.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(LocalDateTime localdatetime) {
            Path path = this.path;
            String s2 = SavedFile.LEVEL_DATA_FILE.getId();
            return path.resolve(s2 + "_corrupted_" + localdatetime.format(FORMATTER));
        }

        public Path rawDataFile(LocalDateTime localdatetime) {
            Path path = this.path;
            String s2 = SavedFile.LEVEL_DATA_FILE.getId();
            return path.resolve(s2 + "_raw_" + localdatetime.format(FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(SavedFile.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(SavedFile.LOCK_FILE);
        }

        public Path resourcePath(SavedFile savedfile) {
            return this.path.resolve(savedfile.getId());
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock lock;
        public final b levelDirectory;
        private final String levelId;
        private final Map<SavedFile, Path> resources = Maps.newHashMap();
        public final ResourceKey<WorldDimension> dimensionType;

        ConversionSession(String s2, Path path, ResourceKey<WorldDimension> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.levelId = s2;
            this.levelDirectory = new b(path);
            this.lock = SessionLock.create(path);
        }

        public long estimateDiskSpace() {
            try {
                return Files.getFileStore(this.levelDirectory.path).getUsableSpace();
            }
            catch (Exception exception) {
                return Long.MAX_VALUE;
            }
        }

        public boolean checkForLowDiskSpace() {
            return this.estimateDiskSpace() < 0x4000000L;
        }

        public void safeClose() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)this.getLevelId(), (Object)ioexception);
            }
        }

        public Convertable parent() {
            return Convertable.this;
        }

        public b getLevelDirectory() {
            return this.levelDirectory;
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(SavedFile savedfile) {
            Map<SavedFile, Path> map = this.resources;
            b convertable_b = this.levelDirectory;
            Objects.requireNonNull(this.levelDirectory);
            return map.computeIfAbsent(savedfile, convertable_b::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<World> resourcekey) {
            return Convertable.getStorageFolder(this.levelDirectory.path(), this.dimensionType);
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage createPlayerStorage() {
            this.checkLock();
            return new WorldNBTStorage(this, Convertable.this.fixerUpper);
        }

        public WorldInfo getSummary(Dynamic<?> dynamic) {
            this.checkLock();
            return Convertable.this.makeLevelSummary(dynamic, this.levelDirectory, false);
        }

        public Dynamic<?> getDataTag() throws IOException {
            return this.getDataTag(false);
        }

        public Dynamic<?> getDataTagFallback() throws IOException {
            return this.getDataTag(true);
        }

        private Dynamic<?> getDataTag(boolean flag) throws IOException {
            this.checkLock();
            return Convertable.readLevelDataTagFixed(flag ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile(), Convertable.this.fixerUpper);
        }

        public void saveDataTag(IRegistryCustom iregistrycustom, SaveData savedata) {
            this.saveDataTag(iregistrycustom, savedata, null);
        }

        public void saveDataTag(IRegistryCustom iregistrycustom, SaveData savedata, @Nullable NBTTagCompound nbttagcompound) {
            NBTTagCompound nbttagcompound1 = savedata.createTag(iregistrycustom, nbttagcompound);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.put(Convertable.TAG_DATA, nbttagcompound1);
            this.saveLevelData(nbttagcompound2);
        }

        private void saveLevelData(NBTTagCompound nbttagcompound) {
            Path path = this.levelDirectory.path();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NBTCompressedStreamTools.writeCompressed(nbttagcompound, path1);
                Path path2 = this.levelDirectory.oldDataFile();
                Path path3 = this.levelDirectory.dataFile();
                SystemUtils.safeReplaceFile(path3, path1, path2);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> getIconFile() {
            return !this.lock.isValid() ? Optional.empty() : Optional.of(this.levelDirectory.iconFile());
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path path = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int i2 = 1; i2 <= 5; ++i2) {
                LOGGER.info("Attempt {}...", (Object)i2);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                LOGGER.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path path1, @Nullable IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(ConversionSession.this.levelDirectory.path())) {
                                ConversionSession.this.lock.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i2 >= 5) {
                        throw ioexception;
                    }
                    LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void renameLevel(String s2) throws IOException {
            this.modifyLevelDataWithoutDatafix(nbttagcompound -> nbttagcompound.putString("LevelName", s2.trim()));
        }

        public void renameAndDropPlayer(String s2) throws IOException {
            this.modifyLevelDataWithoutDatafix(nbttagcompound -> {
                nbttagcompound.putString("LevelName", s2.trim());
                nbttagcompound.remove("Player");
            });
        }

        private void modifyLevelDataWithoutDatafix(Consumer<NBTTagCompound> consumer) throws IOException {
            this.checkLock();
            NBTTagCompound nbttagcompound = Convertable.readLevelDataTagRaw(this.levelDirectory.dataFile());
            consumer.accept(nbttagcompound.getCompound(Convertable.TAG_DATA));
            this.saveLevelData(nbttagcompound);
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String s2 = LocalDateTime.now().format(FORMATTER);
            String s1 = s2 + "_" + this.levelId;
            Path path = Convertable.this.getBackupPath();
            try {
                FileUtils.createDirectoriesSafe(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtils.findAvailableName(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(ConversionSession.this.levelDirectory.path().relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean hasWorldData() {
            return Files.exists(this.levelDirectory.dataFile(), new LinkOption[0]) || Files.exists(this.levelDirectory.oldDataFile(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }

        public boolean restoreLevelDataFromOld() {
            return SystemUtils.safeReplaceOrMoveFile(this.levelDirectory.dataFile(), this.levelDirectory.oldDataFile(), this.levelDirectory.corruptedDataFile(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant getFileModificationTime(boolean flag) {
            return Convertable.getFileModificationTime(flag ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile());
        }
    }
}

