/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;

public class LootCollector {
    private final ProblemReporter reporter;
    private final LootContextParameterSet params;
    private final Optional<HolderGetter.a> resolver;
    private final Set<ResourceKey<?>> visitedElements;

    public LootCollector(ProblemReporter var0, LootContextParameterSet var1, HolderGetter.a var2) {
        this(var0, var1, Optional.of(var2), Set.of());
    }

    public LootCollector(ProblemReporter var0, LootContextParameterSet var1) {
        this(var0, var1, Optional.empty(), Set.of());
    }

    private LootCollector(ProblemReporter var0, LootContextParameterSet var1, Optional<HolderGetter.a> var2, Set<ResourceKey<?>> var3) {
        this.reporter = var0;
        this.params = var1;
        this.resolver = var2;
        this.visitedElements = var3;
    }

    public LootCollector forChild(String var0) {
        return new LootCollector(this.reporter.forChild(var0), this.params, this.resolver, this.visitedElements);
    }

    public LootCollector enterElement(String var0, ResourceKey<?> var1) {
        ImmutableSet var2 = ImmutableSet.builder().addAll(this.visitedElements).add(var1).build();
        return new LootCollector(this.reporter.forChild(var0), this.params, this.resolver, (Set<ResourceKey<?>>)var2);
    }

    public boolean hasVisitedElement(ResourceKey<?> var0) {
        return this.visitedElements.contains(var0);
    }

    public void reportProblem(String var0) {
        this.reporter.report(var0);
    }

    public void validateUser(LootItemUser var0) {
        this.params.validateUser(this, var0);
    }

    public HolderGetter.a resolver() {
        return this.resolver.orElseThrow(() -> new UnsupportedOperationException("References not allowed"));
    }

    public boolean allowsReferences() {
        return this.resolver.isPresent();
    }

    public LootCollector setParams(LootContextParameterSet var0) {
        return new LootCollector(this.reporter, var0, this.resolver, this.visitedElements);
    }

    public ProblemReporter reporter() {
        return this.reporter;
    }
}

