/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootTable EMPTY = new LootTable(LootContextParameterSets.EMPTY, Optional.empty(), List.of(), List.of());
    public static final LootContextParameterSet DEFAULT_PARAM_SET = LootContextParameterSets.ALL_PARAMS;
    public static final long RANDOMIZE_SEED = 0L;
    public static final Codec<LootTable> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootContextParameterSets.CODEC.lenientOptionalFieldOf("type", (Object)DEFAULT_PARAM_SET).forGetter(loottable -> loottable.paramSet), (App)MinecraftKey.CODEC.optionalFieldOf("random_sequence").forGetter(loottable -> loottable.randomSequence), (App)LootSelector.CODEC.listOf().optionalFieldOf("pools", List.of()).forGetter(loottable -> loottable.pools), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(loottable -> loottable.functions)).apply((Applicative)instance, LootTable::new));
    public static final Codec<Holder<LootTable>> CODEC = RegistryFileCodec.create(Registries.LOOT_TABLE, DIRECT_CODEC);
    private final LootContextParameterSet paramSet;
    private final Optional<MinecraftKey> randomSequence;
    private final List<LootSelector> pools;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;
    public CraftLootTable craftLootTable;

    LootTable(LootContextParameterSet lootcontextparameterset, Optional<MinecraftKey> optional, List<LootSelector> list, List<LootItemFunction> list1) {
        this.paramSet = lootcontextparameterset;
        this.randomSequence = optional;
        this.pools = list;
        this.functions = list1;
        this.compositeFunction = LootItemFunctions.compose(list1);
    }

    public static Consumer<ItemStack> createStackSplitter(WorldServer worldserver, Consumer<ItemStack> consumer) {
        return itemstack -> {
            if (itemstack.isItemEnabled(worldserver.enabledFeatures())) {
                if (itemstack.getCount() < itemstack.getMaxStackSize()) {
                    consumer.accept((ItemStack)itemstack);
                } else {
                    ItemStack itemstack1;
                    for (int i2 = itemstack.getCount(); i2 > 0; i2 -= itemstack1.getCount()) {
                        itemstack1 = itemstack.copyWithCount(Math.min(itemstack.getMaxStackSize(), i2));
                        consumer.accept(itemstack1);
                    }
                }
            }
        };
    }

    public void getRandomItemsRaw(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(new LootTableInfo.Builder(lootparams).create(this.randomSequence), consumer);
    }

    public void getRandomItemsRaw(LootTableInfo loottableinfo, Consumer<ItemStack> consumer) {
        LootTableInfo.c<LootTable> loottableinfo_c = LootTableInfo.createVisitedEntry(this);
        if (loottableinfo.pushVisitedElement(loottableinfo_c)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.decorate(this.compositeFunction, consumer, loottableinfo);
            for (LootSelector lootselector : this.pools) {
                lootselector.addRandomItems(consumer1, loottableinfo);
            }
            loottableinfo.popVisitedElement(loottableinfo_c);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootParams lootparams, long i2, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(new LootTableInfo.Builder(lootparams).withOptionalRandomSeed(i2).create(this.randomSequence), LootTable.createStackSplitter(lootparams.getLevel(), consumer));
    }

    public void getRandomItems(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(lootparams, LootTable.createStackSplitter(lootparams.getLevel(), consumer));
    }

    public void getRandomItems(LootTableInfo loottableinfo, Consumer<ItemStack> consumer) {
        this.getRandomItemsRaw(loottableinfo, LootTable.createStackSplitter(loottableinfo.getLevel(), consumer));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams lootparams, RandomSource randomsource) {
        return this.getRandomItems(new LootTableInfo.Builder(lootparams).withOptionalRandomSource(randomsource).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams lootparams, long i2) {
        return this.getRandomItems(new LootTableInfo.Builder(lootparams).withOptionalRandomSeed(i2).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams lootparams) {
        return this.getRandomItems(new LootTableInfo.Builder(lootparams).create(this.randomSequence));
    }

    private ObjectArrayList<ItemStack> getRandomItems(LootTableInfo loottableinfo) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Objects.requireNonNull(objectarraylist);
        this.getRandomItems(loottableinfo, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        return objectarraylist;
    }

    public LootContextParameterSet getParamSet() {
        return this.paramSet;
    }

    public void validate(LootCollector lootcollector) {
        int i2;
        for (i2 = 0; i2 < this.pools.size(); ++i2) {
            this.pools.get(i2).validate(lootcollector.forChild(".pools[" + i2 + "]"));
        }
        for (i2 = 0; i2 < this.functions.size(); ++i2) {
            this.functions.get(i2).validate(lootcollector.forChild(".functions[" + i2 + "]"));
        }
    }

    public void fill(IInventory iinventory, LootParams lootparams, long i2) {
        this.fillInventory(iinventory, lootparams, i2, false);
    }

    public void fillInventory(IInventory iinventory, LootParams lootparams, long i2, boolean plugin) {
        LootTableInfo loottableinfo = new LootTableInfo.Builder(lootparams).withOptionalRandomSeed(i2).create(this.randomSequence);
        ObjectArrayList objectarraylist = this.getRandomItems(loottableinfo);
        RandomSource randomsource = loottableinfo.getRandom();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, objectarraylist, plugin);
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.getAvailableSlots(iinventory, randomsource);
        this.shuffleAndSplitItems((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.isEmpty()) {
                iinventory.setItem(list.remove(list.size() - 1), ItemStack.EMPTY);
                continue;
            }
            iinventory.setItem(list.remove(list.size() - 1), itemstack);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> objectarraylist, int i2, RandomSource randomsource) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = objectarraylist.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            if (itemstack.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (i2 - objectarraylist.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list.remove(MathHelper.nextInt(randomsource, 0, list.size() - 1));
            int j2 = MathHelper.nextInt(randomsource, 1, itemstack1.getCount() / 2);
            ItemStack itemstack2 = itemstack1.split(j2);
            if (itemstack1.getCount() > 1 && randomsource.nextBoolean()) {
                list.add(itemstack1);
            } else {
                objectarraylist.add((Object)itemstack1);
            }
            if (itemstack2.getCount() > 1 && randomsource.nextBoolean()) {
                list.add(itemstack2);
                continue;
            }
            objectarraylist.add((Object)itemstack2);
        }
        objectarraylist.addAll((Collection)list);
        SystemUtils.shuffle(objectarraylist, randomsource);
    }

    private List<Integer> getAvailableSlots(IInventory iinventory, RandomSource randomsource) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i2 = 0; i2 < iinventory.getContainerSize(); ++i2) {
            if (!iinventory.getItem(i2).isEmpty()) continue;
            objectarraylist.add((Object)i2);
        }
        SystemUtils.shuffle(objectarraylist, randomsource);
        return objectarraylist;
    }

    public static a lootTable() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final ImmutableList.Builder<LootSelector> pools = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private LootContextParameterSet paramSet = DEFAULT_PARAM_SET;
        private Optional<MinecraftKey> randomSequence = Optional.empty();

        public a withPool(LootSelector.a lootselector_a) {
            this.pools.add((Object)lootselector_a.build());
            return this;
        }

        public a setParamSet(LootContextParameterSet lootcontextparameterset) {
            this.paramSet = lootcontextparameterset;
            return this;
        }

        public a setRandomSequence(MinecraftKey minecraftkey) {
            this.randomSequence = Optional.of(minecraftkey);
            return this;
        }

        @Override
        public a apply(LootItemFunction.a lootitemfunction_a) {
            this.functions.add((Object)lootitemfunction_a.build());
            return this;
        }

        @Override
        public a unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.randomSequence, (List<LootSelector>)this.pools.build(), (List<LootItemFunction>)this.functions.build());
        }
    }
}

