/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootEnchantLevel
extends LootItemFunctionConditional {
    public static final MapCodec<LootEnchantLevel> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootEnchantLevel.commonFields(var02).and(var02.group((App)NumberProviders.CODEC.fieldOf("levels").forGetter(var0 -> var0.levels), (App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).optionalFieldOf("options").forGetter(var0 -> var0.options))).apply((Applicative)var02, LootEnchantLevel::new));
    private final NumberProvider levels;
    private final Optional<HolderSet<Enchantment>> options;

    LootEnchantLevel(List<LootItemCondition> var0, NumberProvider var1, Optional<HolderSet<Enchantment>> var2) {
        super(var0);
        this.levels = var1;
        this.options = var2;
    }

    public LootItemFunctionType<LootEnchantLevel> getType() {
        return LootItemFunctions.ENCHANT_WITH_LEVELS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.levels.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        RandomSource var2 = var1.getRandom();
        IRegistryCustom var3 = var1.getLevel().registryAccess();
        return EnchantmentManager.enchantItem(var2, var0, this.levels.getInt(var1), var3, this.options);
    }

    public static a enchantWithLevels(HolderLookup.a var0, NumberProvider var1) {
        return new a(var1).fromOptions(var0.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.ON_RANDOM_LOOT));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NumberProvider levels;
        private Optional<HolderSet<Enchantment>> options = Optional.empty();

        public a(NumberProvider var0) {
            this.levels = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a fromOptions(HolderSet<Enchantment> var0) {
            this.options = Optional.of(var0);
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootEnchantLevel(this.getConditions(), this.levels, this.options);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

