/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;

public abstract class LootItemFunctionConditional
implements LootItemFunction {
    protected final List<LootItemCondition> predicates;
    private final Predicate<LootTableInfo> compositePredicates;

    protected LootItemFunctionConditional(List<LootItemCondition> var0) {
        this.predicates = var0;
        this.compositePredicates = SystemUtils.allOf(var0);
    }

    public abstract LootItemFunctionType<? extends LootItemFunctionConditional> getType();

    protected static <T extends LootItemFunctionConditional> Products.P1<RecordCodecBuilder.Mu<T>, List<LootItemCondition>> commonFields(RecordCodecBuilder.Instance<T> var02) {
        return var02.group((App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(var0 -> var0.predicates));
    }

    @Override
    public final ItemStack apply(ItemStack var0, LootTableInfo var1) {
        return this.compositePredicates.test(var1) ? this.run(var0, var1) : var0;
    }

    protected abstract ItemStack run(ItemStack var1, LootTableInfo var2);

    @Override
    public void validate(LootCollector var0) {
        LootItemFunction.super.validate(var0);
        for (int var1 = 0; var1 < this.predicates.size(); ++var1) {
            this.predicates.get(var1).validate(var0.forChild(".conditions[" + var1 + "]"));
        }
    }

    protected static a<?> simpleBuilder(Function<List<LootItemCondition>, LootItemFunction> var0) {
        return new b(var0);
    }

    @Override
    public /* synthetic */ Object apply(Object object, Object object2) {
        return this.apply((ItemStack)object, (LootTableInfo)object2);
    }

    static final class b
    extends a<b> {
        private final Function<List<LootItemCondition>, LootItemFunction> constructor;

        public b(Function<List<LootItemCondition>, LootItemFunction> var0) {
            this.constructor = var0;
        }

        @Override
        protected b getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return this.constructor.apply(this.getConditions());
        }

        @Override
        protected /* synthetic */ a getThis() {
            return this.getThis();
        }
    }

    public static abstract class a<T extends a<T>>
    implements LootItemFunction.a,
    LootItemConditionUser<T> {
        private final ImmutableList.Builder<LootItemCondition> conditions = ImmutableList.builder();

        @Override
        public T when(LootItemCondition.a var0) {
            this.conditions.add((Object)var0.build());
            return this.getThis();
        }

        @Override
        public final T unwrap() {
            return this.getThis();
        }

        protected abstract T getThis();

        protected List<LootItemCondition> getConditions() {
            return this.conditions.build();
        }

        @Override
        public /* synthetic */ LootItemConditionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemConditionUser when(LootItemCondition.a a2) {
            return this.when(a2);
        }
    }
}

