/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyState
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionCopyState> CODEC = RecordCodecBuilder.mapCodec(var02 -> LootItemFunctionCopyState.commonFields(var02).and(var02.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(var0 -> var0.block), (App)Codec.STRING.listOf().fieldOf("properties").forGetter(var0 -> var0.properties.stream().map(IBlockState::getName).toList()))).apply((Applicative)var02, LootItemFunctionCopyState::new));
    private final Holder<Block> block;
    private final Set<IBlockState<?>> properties;

    LootItemFunctionCopyState(List<LootItemCondition> var0, Holder<Block> var1, Set<IBlockState<?>> var2) {
        super(var0);
        this.block = var1;
        this.properties = var2;
    }

    private LootItemFunctionCopyState(List<LootItemCondition> var0, Holder<Block> var1, List<String> var2) {
        this(var0, var1, var2.stream().map(var1.value().getStateDefinition()::getProperty).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public LootItemFunctionType<LootItemFunctionCopyState> getType() {
        return LootItemFunctions.COPY_STATE;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.BLOCK_STATE);
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var12) {
        IBlockData var2 = var12.getParamOrNull(LootContextParameters.BLOCK_STATE);
        if (var2 != null) {
            var0.update(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY, var1 -> {
                for (IBlockState<?> var3 : this.properties) {
                    if (!var2.hasProperty(var3)) continue;
                    var1 = var1.with(var3, var2);
                }
                return var1;
            });
        }
        return var0;
    }

    public static a copyState(Block var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Holder<Block> block;
        private final ImmutableSet.Builder<IBlockState<?>> properties = ImmutableSet.builder();

        a(Block var0) {
            this.block = var0.builtInRegistryHolder();
        }

        public a copy(IBlockState<?> var0) {
            if (!this.block.value().getStateDefinition().getProperties().contains(var0)) {
                throw new IllegalStateException("Property " + String.valueOf(var0) + " is not present on block " + String.valueOf(this.block));
            }
            this.properties.add(var0);
            return this;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionCopyState(this.getConditions(), this.block, (Set<IBlockState<?>>)this.properties.build());
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

