/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;

public class SequenceFunction
implements LootItemFunction {
    public static final MapCodec<SequenceFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)LootItemFunctions.TYPED_CODEC.listOf().fieldOf("functions").forGetter(var0 -> var0.functions)).apply((Applicative)var02, SequenceFunction::new));
    public static final Codec<SequenceFunction> INLINE_CODEC = LootItemFunctions.TYPED_CODEC.listOf().xmap(SequenceFunction::new, var0 -> var0.functions);
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;

    private SequenceFunction(List<LootItemFunction> var0) {
        this.functions = var0;
        this.compositeFunction = LootItemFunctions.compose(var0);
    }

    public static SequenceFunction of(List<LootItemFunction> var0) {
        return new SequenceFunction(List.copyOf(var0));
    }

    @Override
    public ItemStack apply(ItemStack var0, LootTableInfo var1) {
        return this.compositeFunction.apply(var0, var1);
    }

    @Override
    public void validate(LootCollector var0) {
        LootItemFunction.super.validate(var0);
        for (int var1 = 0; var1 < this.functions.size(); ++var1) {
            this.functions.get(var1).validate(var0.forChild(".function[" + var1 + "]"));
        }
    }

    public LootItemFunctionType<SequenceFunction> getType() {
        return LootItemFunctions.SEQUENCE;
    }

    @Override
    public /* synthetic */ Object apply(Object object, Object object2) {
        return this.apply((ItemStack)object, (LootTableInfo)object2);
    }
}

