/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetFireworkExplosionFunction
extends LootItemFunctionConditional {
    public static final MapCodec<SetFireworkExplosionFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetFireworkExplosionFunction.commonFields(var02).and(var02.group((App)FireworkExplosion.a.CODEC.optionalFieldOf("shape").forGetter(var0 -> var0.shape), (App)FireworkExplosion.COLOR_LIST_CODEC.optionalFieldOf("colors").forGetter(var0 -> var0.colors), (App)FireworkExplosion.COLOR_LIST_CODEC.optionalFieldOf("fade_colors").forGetter(var0 -> var0.fadeColors), (App)Codec.BOOL.optionalFieldOf("trail").forGetter(var0 -> var0.trail), (App)Codec.BOOL.optionalFieldOf("twinkle").forGetter(var0 -> var0.twinkle))).apply((Applicative)var02, SetFireworkExplosionFunction::new));
    public static final FireworkExplosion DEFAULT_VALUE = new FireworkExplosion(FireworkExplosion.a.SMALL_BALL, IntList.of(), IntList.of(), false, false);
    final Optional<FireworkExplosion.a> shape;
    final Optional<IntList> colors;
    final Optional<IntList> fadeColors;
    final Optional<Boolean> trail;
    final Optional<Boolean> twinkle;

    public SetFireworkExplosionFunction(List<LootItemCondition> var0, Optional<FireworkExplosion.a> var1, Optional<IntList> var2, Optional<IntList> var3, Optional<Boolean> var4, Optional<Boolean> var5) {
        super(var0);
        this.shape = var1;
        this.colors = var2;
        this.fadeColors = var3;
        this.trail = var4;
        this.twinkle = var5;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        var0.update(DataComponents.FIREWORK_EXPLOSION, DEFAULT_VALUE, this::apply);
        return var0;
    }

    private FireworkExplosion apply(FireworkExplosion var0) {
        return new FireworkExplosion(this.shape.orElseGet(var0::shape), this.colors.orElseGet(var0::colors), this.fadeColors.orElseGet(var0::fadeColors), this.trail.orElseGet(var0::hasTrail), this.twinkle.orElseGet(var0::hasTwinkle));
    }

    public LootItemFunctionType<SetFireworkExplosionFunction> getType() {
        return LootItemFunctions.SET_FIREWORK_EXPLOSION;
    }
}

