/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetWrittenBookPagesFunction
extends LootItemFunctionConditional {
    public static final Codec<IChatBaseComponent> PAGE_CODEC = ComponentSerialization.CODEC.validate(var0 -> WrittenBookContent.CONTENT_CODEC.encodeStart((DynamicOps)JavaOps.INSTANCE, var0).map(var1 -> var0));
    public static final MapCodec<SetWrittenBookPagesFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetWrittenBookPagesFunction.commonFields(var02).and(var02.group((App)WrittenBookContent.pagesCodec(PAGE_CODEC).fieldOf("pages").forGetter(var0 -> var0.pages), (App)ListOperation.UNLIMITED_CODEC.forGetter(var0 -> var0.pageOperation))).apply((Applicative)var02, SetWrittenBookPagesFunction::new));
    private final List<Filterable<IChatBaseComponent>> pages;
    private final ListOperation pageOperation;

    protected SetWrittenBookPagesFunction(List<LootItemCondition> var0, List<Filterable<IChatBaseComponent>> var1, ListOperation var2) {
        super(var0);
        this.pages = var1;
        this.pageOperation = var2;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        var0.update(DataComponents.WRITTEN_BOOK_CONTENT, WrittenBookContent.EMPTY, this::apply);
        return var0;
    }

    @VisibleForTesting
    public WrittenBookContent apply(WrittenBookContent var0) {
        List<Filterable<IChatBaseComponent>> var1 = this.pageOperation.apply(var0.pages(), this.pages);
        return var0.withReplacedPages((List)var1);
    }

    public LootItemFunctionType<SetWrittenBookPagesFunction> getType() {
        return LootItemFunctions.SET_WRITTEN_BOOK_PAGES;
    }
}

