/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionSurvivesExplosion
implements LootItemCondition {
    private static final LootItemConditionSurvivesExplosion INSTANCE = new LootItemConditionSurvivesExplosion();
    public static final MapCodec<LootItemConditionSurvivesExplosion> CODEC = MapCodec.unit((Object)INSTANCE);

    private LootItemConditionSurvivesExplosion() {
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.SURVIVES_EXPLOSION;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.EXPLOSION_RADIUS);
    }

    @Override
    public boolean test(LootTableInfo loottableinfo) {
        Float ofloat = loottableinfo.getParamOrNull(LootContextParameters.EXPLOSION_RADIUS);
        if (ofloat != null) {
            RandomSource randomsource = loottableinfo.getRandom();
            float f2 = 1.0f / ofloat.floatValue();
            return randomsource.nextFloat() < f2;
        }
        return true;
    }

    public static LootItemCondition.a survivesExplosion() {
        return () -> INSTANCE;
    }
}

