/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;

public record PlayerScoreEntry(String owner, int value, @Nullable IChatBaseComponent display, @Nullable NumberFormat numberFormatOverride) {
    public boolean isHidden() {
        return this.owner.startsWith("#");
    }

    public IChatBaseComponent ownerName() {
        if (this.display != null) {
            return this.display;
        }
        return IChatBaseComponent.literal(this.owner());
    }

    public IChatMutableComponent formatValue(NumberFormat var0) {
        return Objects.requireNonNullElse(this.numberFormatOverride, var0).format(this.value);
    }
}

