/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;

public class ScoreboardScore
implements ReadOnlyScoreInfo {
    private static final String TAG_SCORE = "Score";
    private static final String TAG_LOCKED = "Locked";
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_FORMAT = "format";
    private int value;
    private boolean locked = true;
    @Nullable
    private IChatBaseComponent display;
    @Nullable
    private NumberFormat numberFormat;

    @Override
    public int value() {
        return this.value;
    }

    public void value(int var0) {
        this.value = var0;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean var0) {
        this.locked = var0;
    }

    @Nullable
    public IChatBaseComponent display() {
        return this.display;
    }

    public void display(@Nullable IChatBaseComponent var0) {
        this.display = var0;
    }

    @Override
    @Nullable
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat var0) {
        this.numberFormat = var0;
    }

    public NBTTagCompound write(HolderLookup.a var0) {
        NBTTagCompound var12 = new NBTTagCompound();
        var12.putInt(TAG_SCORE, this.value);
        var12.putBoolean(TAG_LOCKED, this.locked);
        if (this.display != null) {
            var12.putString(TAG_DISPLAY, IChatBaseComponent.ChatSerializer.toJson(this.display, var0));
        }
        if (this.numberFormat != null) {
            NumberFormatTypes.CODEC.encodeStart(var0.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)this.numberFormat).ifSuccess(var1 -> var12.put(TAG_FORMAT, (NBTBase)var1));
        }
        return var12;
    }

    public static ScoreboardScore read(NBTTagCompound var0, HolderLookup.a var12) {
        ScoreboardScore var2 = new ScoreboardScore();
        var2.value = var0.getInt(TAG_SCORE);
        var2.locked = var0.getBoolean(TAG_LOCKED);
        if (var0.contains(TAG_DISPLAY, 8)) {
            var2.display = IChatBaseComponent.ChatSerializer.fromJson(var0.getString(TAG_DISPLAY), var12);
        }
        if (var0.contains(TAG_FORMAT, 10)) {
            NumberFormatTypes.CODEC.parse(var12.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var0.get(TAG_FORMAT)).ifSuccess(var1 -> {
                var0.numberFormat = var1;
            });
        }
        return var2;
    }
}

